/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.formplugin.er.daily;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.assistant.er.util.ErReimburseSettingUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class ErReimburseSettingFormPlugin
extends AbstractBillPlugIn {
    private static final String HASCHANGE = "hasChange";
    private static final String REIMLEVELENTRY = "reimlevelentry";

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map<Long, DynamicObject> companyAndReimburse = null;
        Object reimlevelentry = null;
        RowMapper source = (RowMapper)e.getSource();
        RowMapper parent = source.getParent();
        reimlevelentry = parent != null ? parent.getSourceObj().get(REIMLEVELENTRY) : source.getSourceObj().get(REIMLEVELENTRY);
        if (reimlevelentry instanceof JSONArray) {
            JSONArray reimLevelEntry = reimlevelentry;
            companyAndReimburse = reimLevelEntry.stream().collect(Collectors.toMap(k -> ((JSONObject)k).getJSONObject("company").getLong("id"), v -> {
                Long companyId = ((JSONObject)v).getJSONObject("company").getLong("id");
                return BusinessDataServiceHelper.loadSingle((String)"er_reimburselevel", (String)"number", (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", (Long)companyId), QFilter.of((String)"number=? and enable='1'", (Object[])new Object[]{((JSONObject)v).getJSONObject("entryreimburselevel").getString("number")})});
            }));
        }
        Map searchResult = e.getSearchResult();
        for (Map.Entry item : searchResult.entrySet()) {
            if (!"entryreimburselevel".equals(((BasedataItem)item.getKey()).getFieldKey()) || companyAndReimburse == null) continue;
            List value = (List)item.getValue();
            value.clear();
            value.add(companyAndReimburse.get(((BasedataItem)item.getKey()).getOrgId()).getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        LinkedList<OrgInfo> orgs;
        List<OrgInfo> companys;
        DynamicObjectCollection orgEntrys = this.getModel().getEntryEntity("entryentity");
        if (!orgEntrys.isEmpty() && !(companys = this.getCompanys(orgs = this.getOrgs(orgEntrys))).isEmpty()) {
            int[] newRows;
            Map reimburseLevelMap = ErReimburseSettingUtil.getReimburseLevel((Long)((Long)this.getModel().getDataEntity().getPkValue()), companys.stream().map(OrgInfo::getOrgId).collect(Collectors.toList()));
            Iterator<OrgInfo> companyIter = companys.iterator();
            this.getModel().beginInit();
            this.getModel().deleteEntryData(REIMLEVELENTRY);
            for (int i : newRows = this.getModel().batchCreateNewEntryRow(REIMLEVELENTRY, companys.size())) {
                OrgInfo next = companyIter.next();
                this.getModel().setValue("company", (Object)next.getOrgId(), i);
                this.getModel().setValue("partjob", (Object)next.ispartjob(), i);
                Object reimburseLevel = reimburseLevelMap.get(next.getOrgId());
                if (reimburseLevel == null) continue;
                this.getModel().setValue("entryreimburselevel", reimburseLevel, i);
            }
            this.getModel().endInit();
            this.getView().updateView(REIMLEVELENTRY);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container reimlevelentry = (Container)this.getControl("advconap");
        reimlevelentry.setCollapse(false);
    }

    private List<OrgInfo> getCompanys(LinkedList<OrgInfo> orgs) {
        ArrayList<OrgInfo> companys = new ArrayList<OrgInfo>(orgs.size());
        orgs.forEach(org -> {
            Map companyByOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)org.getOrgId());
            Long companyId = companyByOrg.getOrDefault("id", 0L);
            OrgInfo orgInfo = new OrgInfo(companyId, org.ispartjob());
            if (!companys.contains(orgInfo)) {
                companys.add(orgInfo);
            }
        });
        return companys;
    }

    private LinkedList<OrgInfo> getOrgs(DynamicObjectCollection orgEntrys) {
        LinkedList<OrgInfo> orgs = new LinkedList<OrgInfo>();
        orgEntrys.forEach(entry -> {
            boolean ispartJob = entry.getBoolean("ispartjob");
            OrgInfo info = new OrgInfo(entry.getLong("dpt.id"), ispartJob);
            if (!ispartJob) {
                orgs.addFirst(info);
            } else {
                orgs.add(info);
            }
        });
        return orgs;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!"1".equals(this.getPageCache().get(HASCHANGE))) {
            e.setCheckDataChange(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObjectCollection reimburselevelentry;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource() instanceof Save && afterDoOperationEventArgs.getOperationResult().isSuccess() && !(reimburselevelentry = this.getModel().getDataEntity(true).getDynamicObjectCollection(REIMLEVELENTRY)).isEmpty() && "1".equals(this.getPageCache().get(HASCHANGE))) {
            ErReimburseSettingUtil.updateRelation((Long)((Long)this.getModel().getDataEntity().getPkValue()), (DynamicObjectCollection)reimburselevelentry);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("entryreimburselevel".equalsIgnoreCase(e.getProperty().getName())) {
            this.getPageCache().put(HASCHANGE, "1");
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (Boolean.FALSE.equals(this.getModel().getValue("partjob", rowIndex))) {
                this.getModel().setValue("reimburselevel", e.getChangeSet()[0].getNewValue());
            }
        }
    }

    private static class OrgInfo {
        private Long orgId;
        private boolean partjob;

        public OrgInfo(Long orgId, boolean ispartjob) {
            this.orgId = orgId;
            this.partjob = ispartjob;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public boolean ispartjob() {
            return this.partjob;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return ((OrgInfo)obj).getOrgId().equals(this.getOrgId());
        }

        public int hashCode() {
            return this.getOrgId().intValue();
        }
    }
}

