/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.formplugin.wbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class ProjectParamEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerBeforeF7SelectListener("projectkind");
        this.registerBeforeF7SelectListener("projpurbus");
        this.registerBeforeF7SelectListener("genpurbus");
    }

    private void registerBeforeF7SelectListener(String controlName) {
        BasedataEdit control = (BasedataEdit)this.getControl(controlName);
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control source = (Control)beforeF7SelectEvent.getSource();
        HashMap<String, String> billTypeToBizTypeFieldMap = new HashMap<String, String>(){
            {
                this.put("projpurbus", "projpurdoc");
                this.put("genpurbus", "genpurdoc");
            }
        };
        String sourceKey = source.getKey();
        if (StringUtils.equals((CharSequence)sourceKey, (CharSequence)"projectkind")) {
            QFilter qFilter = new QFilter("projectkind", "is not null", (Object)0L);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_projectparam", (String)"projectkind", (QFilter[])new QFilter[]{qFilter});
            if (CollectionUtils.isNotEmpty((Collection)query)) {
                List projectKindIdList = query.stream().map(x -> x.getLong("projectkind")).collect(Collectors.toList());
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "not in", projectKindIdList));
            }
        } else if (billTypeToBizTypeFieldMap.containsKey(sourceKey)) {
            this.handleBizTypeBeforeF7Select(beforeF7SelectEvent, sourceKey, (Map<String, String>)billTypeToBizTypeFieldMap);
        }
    }

    private void handleBizTypeBeforeF7Select(BeforeF7SelectEvent event, String sourceKey, Map<String, String> billTypeToBizTypeFieldMap) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue(billTypeToBizTypeFieldMap.get(sourceKey));
        Long billTypeId = billType == null ? null : (Long)billType.getPkValue();
        List<Long> bizTypeIds = ProjectParamEdit.getAllBizTypes("pm_purapplybill", billTypeId, "pm_billtypeparameter");
        if (bizTypeIds != null) {
            event.addCustomQFilter(new QFilter("id", "in", bizTypeIds));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null && changeSet.length > 0) {
            Object newValue = changeSet[0].getNewValue();
            HashMap<String, String> fieldMappings = new HashMap<String, String>(){
                {
                    this.put("projpurdoc", "projpurbus");
                    this.put("genpurdoc", "genpurbus");
                }
            };
            if (fieldMappings.containsKey(name)) {
                if (newValue != null) {
                    Long billTypeId = (Long)((DynamicObject)newValue).getPkValue();
                    Long defaultBizType = this.getDefaultBizType("pm_purapplybill", billTypeId, "pm_billtypeparameter");
                    this.getModel().setValue((String)fieldMappings.get(name), (Object)defaultBizType);
                } else {
                    this.getModel().setValue((String)fieldMappings.get(name), null);
                }
            }
        }
    }

    public Long getDefaultBizType(String formId, Long billTypeId, String paramFormId) {
        List<Long> enableBizTypeIds;
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((Object)billTypeId) || StringUtils.isBlank((CharSequence)paramFormId)) {
            return null;
        }
        Object bizTypes = ProjectParamEdit.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        ArrayList<Long> bizTypeList = new ArrayList<Long>();
        if (!StringUtils.isBlank((Object)bizTypes) && bizTypes instanceof DynamicObjectCollection) {
            ((DynamicObjectCollection)bizTypes).stream().forEach(dym -> {
                if (dym.getBoolean("isdefault")) {
                    bizTypeList.add(dym.getLong("biztypenumber.id"));
                }
            });
        }
        return (enableBizTypeIds = ProjectParamEdit.getEnableBaseDataIds("bd_biztype", bizTypeList)).size() > 0 ? enableBizTypeIds.get(0) : null;
    }

    public static List<Long> getAllBizTypes(String formId, Long billTypeId, String paramFormId) {
        if (StringUtils.isBlank((CharSequence)formId) || billTypeId == null || billTypeId == 0L || StringUtils.isBlank((CharSequence)paramFormId)) {
            return null;
        }
        Object bizTypes = ProjectParamEdit.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        List<Long> bizTypeList = new ArrayList<Long>();
        if (bizTypes != null && ((DynamicObjectCollection)bizTypes).size() > 0 && bizTypes instanceof DynamicObjectCollection) {
            bizTypeList = ((DynamicObjectCollection)bizTypes).stream().map(dym -> dym.getLong("biztypenumber.id")).collect(Collectors.toList());
        }
        return bizTypeList;
    }

    public static Object getBillTypeParameter(String formId, long billTypeId, String paramFormId, String propertyName) {
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((Object)billTypeId) || StringUtils.isBlank((CharSequence)paramFormId) || StringUtils.isBlank((CharSequence)propertyName)) {
            return null;
        }
        DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
        if (!StringUtils.isBlank((Object)billTypeParam)) {
            return billTypeParam.get(propertyName);
        }
        return null;
    }

    private static List<Long> getEnableBaseDataIds(String entityNo, List<Long> pks) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter pkFilter = new QFilter("id", "in", pks);
        ArrayList<Long> baseIDs = new ArrayList<Long>(16);
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)entityNo, (QFilter[])new QFilter[]{enableFilter, pkFilter});
        if (enableBaseDatas != null) {
            enableBaseDatas.keySet().forEach(id -> baseIDs.add((Long)id));
        }
        return baseIDs;
    }
}

