/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.assistant.helper.BeBank;
import kd.bd.assistant.helper.BeBankParams;
import kd.bd.assistant.helper.BeBankResponseEntity;
import kd.bd.assistant.plugin.helper.CountryHelper;
import kd.bd.assistant.plugin.util.DateUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class BeBankHelper {
    private static final Log logger = LogFactory.getLog(BeBankHelper.class);
    private static final String SEPARATOR_DOT = "\\.";
    private static final String SEPARATOR_LINE = "_";
    private static final String LOCK_KEY = "BeBankNameListPlugin.update";
    private static final String PROJECT_NAME = "bos-bd-formplugin";
    private static final String ENTITY_BEBANK = "bd_bebank";
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 180000;
    private static final Map<String, String> provinceMapping = new HashMap<String, String>();
    private static final Map<String, String> cityMapping = new HashMap<String, String>();

    public static Pair<String, Pair<Boolean, String>> downloadExecute() {
        DynamicObject[] adminList;
        try (DLock lock = DLock.create((String)LOCK_KEY);){
            if (!lock.tryLock()) {
                Pair pair = Pair.of((Object)ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u884c\u540d\u884c\u53f7\u66f4\u65b0, \u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BeBankNameListPlugin_45", (String)PROJECT_NAME, (Object[])new Object[0]), (Object)Pair.of((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5728\u7ebf\u66f4\u65b0\u5931\u8d25", (String)"BeBankNameListPlugin_44", (String)PROJECT_NAME, (Object[])new Object[0])));
                return pair;
            }
        }
        HashMap<String, Object> adminMap = new HashMap<String, Object>(10);
        HashMap<Object, Object> provinceMap = new HashMap<Object, Object>(10);
        DynamicObjectCollection bankList = QueryServiceHelper.query((String)ENTITY_BEBANK, (String)"id, union_number, city, bankcatename,number,isfromcloud", (QFilter[])new QFilter[]{QFilter.sqlExpress((String)"union_number", (String)"=", (String)"fnumber")});
        HashMap<String, DynamicObject> bankMap = new HashMap<String, DynamicObject>(bankList.size());
        for (DynamicObject obj : bankList) {
            bankMap.put(obj.getString("union_number"), obj);
        }
        DynamicObject countryObj = BusinessDataServiceHelper.loadSingle((String)"bd_country", (String)"id", (QFilter[])new QFilter[]{CountryHelper.getChinaFilter()});
        for (DynamicObject admin : adminList = BusinessDataServiceHelper.load((String)"bd_admindivision", (String)"id,fullname,parent", (QFilter[])new QFilter[]{new QFilter("level", "=", (Object)2), new QFilter("enable", "=", (Object)"1")})) {
            String adminFullName = admin.getString("fullname").trim();
            adminMap.put(BeBankHelper.getAdminKey(adminFullName), admin);
            provinceMap.put(admin.get("id"), admin.get("parent"));
        }
        Pair<String, Pair<Boolean, String>> result = null;
        Object bebankInterfaceParameter = SystemParamServiceHelper.getBillParameter((String)ENTITY_BEBANK, (String)"bebankinterfaceselect");
        Object bebankLoadParameter = SystemParamServiceHelper.getPublicParameter((String)"bebankloadurl");
        result = null != bebankInterfaceParameter && ((String)bebankInterfaceParameter).trim().equals("2") ? BeBankHelper.oldInterfaceDown(countryObj, bankMap, bebankLoadParameter, adminMap, provinceMap) : BeBankHelper.newInterfaceDown(countryObj, bankMap, bebankLoadParameter, adminMap, provinceMap);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<String, Pair<Boolean, String>> oldInterfaceDown(DynamicObject countryObj, Map<String, DynamicObject> bankMap, Object bebankLoadParameter, Map<String, Object> adminMap, Map<Object, Object> provinceMap) {
        String str;
        InputStream is = null;
        BufferedReader br = null;
        TreeSet<String> failedBeBankSet = new TreeSet<String>();
        ArrayList<DynamicObject> failUpdateRowList = new ArrayList<DynamicObject>(10);
        Set<String> numberSet = bankMap.keySet();
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(10);
        HashSet<String> nameSet = new HashSet<String>(10);
        Date currTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        StringBuilder exceptionMsg = new StringBuilder();
        long successNum = 0L;
        try {
            String url = "http://web20.kingdee.com/eb_cloud_cnaps/download?for=eb";
            CloseableHttpClient httpClient = HttpClients.createDefault();
            if (null != bebankLoadParameter && !((String)bebankLoadParameter).trim().equals("")) {
                url = (String)bebankLoadParameter;
            }
            HttpGet httpUrl = new HttpGet(url);
            httpUrl.setConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(180000).build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpUrl);
            HttpEntity entity = response.getEntity();
            is = entity.getContent();
            br = new BufferedReader(new InputStreamReader(is, "GBK"));
            String str2 = null;
            boolean existData = false;
            while ((str2 = br.readLine()) != null) {
                String replacedCityName;
                existData = true;
                String[] split = str2.split("\t");
                if (split.length < 7) continue;
                String unionNumber = split[0];
                String name = split[5];
                String bankCateName = split[1];
                if (unionNumber.equals("\"\u8054\u884c\u53f7\"") || !nameSet.add(name)) continue;
                String provinceStr = split[2].trim();
                String municipality = split[3].trim();
                String provincetxt = split[2].trim();
                String citytxt = split[3].trim();
                Object cityObj = BeBankHelper.getCity(adminMap, BeBankHelper.getAdminKey(provinceStr + SEPARATOR_LINE + municipality));
                if (cityObj == null && (replacedCityName = BeBankHelper.getCityName(provinceStr = BeBankHelper.getAdmin(provinceStr), municipality = BeBankHelper.getAdmin(municipality))) != null) {
                    cityObj = BeBankHelper.getCity(adminMap, replacedCityName);
                }
                if (cityObj == null && municipality.endsWith("\u81ea\u6cbb\u5dde")) {
                    municipality = municipality.substring(0, municipality.length() - 5);
                    cityObj = BeBankHelper.getCity(adminMap, provinceStr, municipality);
                }
                if (cityObj == null) {
                    failedBeBankSet.add(provinceStr + SEPARATOR_LINE + municipality);
                    DynamicObject bank = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BEBANK);
                    if (numberSet.contains(unionNumber)) {
                        bank.set("id", bankMap.get(unionNumber).get("id"));
                        boolean isFromCloud = bankMap.get(unionNumber).getBoolean("isfromcloud");
                        if (isFromCloud) {
                            bank.set("provincetxt", (Object)provincetxt);
                            bank.set("citytxt", (Object)citytxt);
                            bank.set("isfromcloud", (Object)"1");
                        }
                        failUpdateRowList.add(bank);
                    } else {
                        bank.set("id", (Object)DB.genLongId((String)ENTITY_BEBANK));
                        bank.set("enable", (Object)1);
                        bank.set("provincetxt", (Object)provincetxt);
                        bank.set("citytxt", (Object)citytxt);
                        rowList.add(bank);
                    }
                    bank.set("masterid", bank.get("id"));
                    bank.set("number", (Object)unionNumber);
                    bank.set("union_number", (Object)unionNumber);
                    bank.set("name", (Object)name);
                    bank.set("country", (Object)countryObj);
                    bank.set("status", (Object)"C");
                    bank.set("creator", (Object)userId);
                    bank.set("createtime", (Object)currTime);
                    bank.set("modifier", (Object)userId);
                    bank.set("modifytime", (Object)currTime);
                    bank.set("bankcatename", (Object)bankCateName);
                    bank.set("provincecloud", (Object)provincetxt);
                    bank.set("citycloud", (Object)citytxt);
                    bank.set("isoverdue", (Object)"0");
                    continue;
                }
                Object provinceObj = provinceMap.get(((DynamicObject)cityObj).getPkValue());
                if (numberSet.contains(unionNumber)) {
                    DynamicObject bank = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BEBANK);
                    bank.set("id", bankMap.get(unionNumber).get("id"));
                    bank.set("country", (Object)countryObj);
                    bank.set("name", (Object)name);
                    bank.set("city", cityObj);
                    bank.set("province", provinceObj);
                    bank.set("bankcatename", (Object)bankCateName);
                    bank.set("modifytime", (Object)currTime);
                    bank.set("modifier", (Object)userId);
                    bank.set("provincecloud", (Object)provincetxt);
                    bank.set("citycloud", (Object)citytxt);
                    bank.set("isoverdue", (Object)"0");
                    boolean isFromCloud = bankMap.get(unionNumber).getBoolean("isfromcloud");
                    if (isFromCloud) {
                        bank.set("provincetxt", (Object)provincetxt);
                        bank.set("citytxt", (Object)citytxt);
                        bank.set("isfromcloud", (Object)"1");
                    }
                    failUpdateRowList.add(bank);
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BEBANK);
                obj.set("number", (Object)unionNumber);
                obj.set("union_number", (Object)unionNumber);
                obj.set("name", (Object)name);
                obj.set("country", (Object)countryObj);
                obj.set("enable", (Object)1);
                obj.set("status", (Object)"C");
                obj.set("city", cityObj);
                obj.set("province", provinceObj);
                obj.set("creator", (Object)userId);
                obj.set("createtime", (Object)currTime);
                obj.set("modifier", (Object)userId);
                obj.set("modifytime", (Object)currTime);
                long id = DB.genLongId((String)ENTITY_BEBANK);
                obj.set("id", (Object)id);
                obj.set("masterid", (Object)id);
                obj.set("bankcatename", (Object)bankCateName);
                obj.set("provincecloud", (Object)provincetxt);
                obj.set("citycloud", (Object)citytxt);
                obj.set("provincetxt", (Object)provincetxt);
                obj.set("citytxt", (Object)citytxt);
                obj.set("isoverdue", (Object)"0");
                rowList.add(obj);
            }
            if (!existData) {
                exceptionMsg.append(ResManager.loadKDString((String)"\u7f51\u5740\u65e0\u6548\u672a\u80fd\u4e0b\u8f7d\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u516c\u5171\u53c2\u6570\u8bbe\u7f6e\u662f\u5426\u6709\u8bef", (String)"BeBankNameListPlugin_46", (String)PROJECT_NAME, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            exceptionMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        finally {
            try {
                if (null != br) {
                    br.close();
                }
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        rowList.addAll(BeBankHelper.getObjWithDb(failUpdateRowList));
        if (!rowList.isEmpty()) {
            int startIndex;
            int endIndex = rowList.size();
            do {
                TXHandle tx;
                block45: {
                    startIndex = Math.max(0, endIndex - 50000);
                    tx = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try {
                            DynamicObject[] dataArr = rowList.subList(startIndex, endIndex).toArray(new DynamicObject[0]);
                            endIndex = startIndex;
                            Object[] successObj = SaveServiceHelper.save((DynamicObject[])dataArr);
                            successNum += (long)successObj.length;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error((Throwable)e);
                            exceptionMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            if (tx == null) break;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break;
                            }
                            tx.close();
                            break;
                        }
                        if (tx == null) continue;
                        if (throwable == null) break block45;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (tx == null) throw throwable5;
                            if (throwable == null) {
                                tx.close();
                                throw throwable5;
                            }
                            try {
                                tx.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                    }
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            } while (startIndex != 0);
        }
        if (failedBeBankSet != null && failedBeBankSet.size() > 0) {
            logger.error(((Object)failedBeBankSet).toString());
        }
        if (exceptionMsg.length() == 0) {
            if (CollectionUtils.isNotEmpty(rowList)) {
                String str3 = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%s\u6761\u6570\u636e\u3002", (String)"BeBankNameListPlugin_35", (String)PROJECT_NAME, (Object[])new Object[0]), successNum);
                return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.TRUE, (Object)str3));
            }
            String str4 = ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u662f\u6700\u65b0\u6570\u636e\u3002", (String)"BeBankNameListPlugin_36", (String)PROJECT_NAME, (Object[])new Object[0]);
            return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.FALSE, (Object)str4));
        }
        if (successNum > 0L) {
            str = String.format(ResManager.loadKDString((String)"%s\u6761\u8bb0\u5f55\u5b8c\u6210\u5728\u7ebf\u66f4\u65b0\uff0c\u5176\u5b83\u672a\u66f4\u65b0\u6570\u636e\u5b58\u5728\u5f02\u5e38", (String)"BeBankNameListPlugin_42", (String)PROJECT_NAME, (Object[])new Object[0]), successNum);
            return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.FALSE, (Object)str));
        }
        str = ResManager.loadKDString((String)"\u5728\u7ebf\u66f4\u65b0\u5931\u8d25", (String)"BeBankNameListPlugin_44", (String)PROJECT_NAME, (Object[])new Object[0]);
        return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.FALSE, (Object)str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<String, Pair<Boolean, String>> newInterfaceDown(DynamicObject countryObj, Map<String, DynamicObject> bankMap, Object bebankLoadParameter, Map<String, Object> adminMap, Map<Object, Object> provinceMap) {
        String str;
        TreeSet failedBeBankSet = new TreeSet();
        ArrayList<DynamicObject> failUpdateRowList = new ArrayList<DynamicObject>(10);
        Set<String> numberSet = bankMap.keySet();
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(10);
        Date currTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        StringBuilder exceptionMsg = new StringBuilder();
        long successNum = 0L;
        String sinceDate = BeBankHelper.getStartDate();
        logger.info("[BeBankHelper]\u4ece\u94f6\u4f01\u65b0\u63a5\u53e3\u67e5\u8be2\u6570\u636e\u7684\u8d77\u59cb\u65f6\u95f4\uff1a{}", (Object)sinceDate);
        int pageNo = 1;
        int pageSize = 10000;
        try {
            do {
                String str2;
                String url = "http://web20.kingdee.com/eb_cloud_cnaps/api/branches?since=" + sinceDate + "&&pageNo=" + pageNo;
                if (null != bebankLoadParameter && !((String)bebankLoadParameter).trim().equals("")) {
                    url = (String)bebankLoadParameter + "/eb_cloud_cnaps/api/branches?since=" + sinceDate + "&&pageNo=" + pageNo;
                }
                if ((str2 = BeBankHelper.getHttpResponStr(url, bebankLoadParameter)) != null) {
                    BeBankResponseEntity jsonObject = (BeBankResponseEntity)JSONObject.parseObject((String)str2, BeBankResponseEntity.class);
                    if (jsonObject != null) {
                        List<BeBank> bebankList = jsonObject.data;
                        if (bebankList != null && bebankList.size() > 0) {
                            pageSize = bebankList.size();
                            long[] ids = DB.genLongIds((String)ENTITY_BEBANK, (int)bebankList.size());
                            int idIndex = 0;
                            for (BeBank beBankObj : bebankList) {
                                BeBankParams beBankParams = new BeBankParams(beBankObj.cnapNo, beBankObj.subBankName, beBankObj.bankName, beBankObj.province, beBankObj.city, beBankObj.province, beBankObj.city, countryObj, userId, currTime, beBankObj.isOverTime, beBankObj.endLifeCycle);
                                Map<String, DynamicObject> result = BeBankHelper.dealBeBankObj(beBankParams, adminMap, provinceMap, numberSet, bankMap, ids[idIndex]);
                                if (result.get("failUpdateRowList") != null) {
                                    failUpdateRowList.add(result.get("failUpdateRowList"));
                                }
                                if (result.get("rowList") != null) {
                                    rowList.add(result.get("rowList"));
                                }
                                ++idIndex;
                            }
                        } else {
                            pageSize = 0;
                        }
                    } else {
                        pageSize = 0;
                    }
                    rowList.addAll(BeBankHelper.getObjWithDb(failUpdateRowList));
                    if (rowList.size() > 0) {
                        int startIndex;
                        int endIndex = rowList.size();
                        do {
                            TXHandle tx;
                            block37: {
                                startIndex = Math.max(0, endIndex - 50000);
                                tx = TX.requiresNew();
                                Object object = null;
                                try {
                                    try {
                                        DynamicObject[] dataArr = rowList.subList(startIndex, endIndex).toArray(new DynamicObject[0]);
                                        endIndex = startIndex;
                                        Object[] successObj = SaveServiceHelper.save((DynamicObject[])dataArr);
                                        successNum += (long)successObj.length;
                                    }
                                    catch (Exception e) {
                                        tx.markRollback();
                                        logger.error("[BeBankHelper]\u6279\u91cf\u66f4\u65b0\u884c\u540d\u884c\u53f7\u6570\u636e\u5931\u8d25\u3002", (Throwable)e);
                                        logger.info("[BeBankHelper]\u6279\u91cf\u66f4\u65b0\u884c\u540d\u884c\u53f7\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u9875\u6570\uff1a{}", (Object)pageNo);
                                        exceptionMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                                        if (tx == null) break;
                                        if (object != null) {
                                            try {
                                                tx.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)object).addSuppressed(throwable);
                                            }
                                            break;
                                        }
                                        tx.close();
                                        break;
                                    }
                                    if (tx == null) continue;
                                    if (object == null) break block37;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        object = throwable;
                                        throw throwable;
                                    }
                                    catch (Throwable throwable2) {
                                        if (tx == null) throw throwable2;
                                        if (object == null) {
                                            tx.close();
                                            throw throwable2;
                                        }
                                        try {
                                            tx.close();
                                            throw throwable2;
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)object).addSuppressed(throwable3);
                                            throw throwable2;
                                        }
                                    }
                                }
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                continue;
                            }
                            tx.close();
                        } while (startIndex != 0);
                    }
                    rowList.clear();
                    failUpdateRowList.clear();
                    if (failedBeBankSet != null && failedBeBankSet.size() > 0) {
                        logger.error(((Object)failedBeBankSet).toString());
                        failedBeBankSet.clear();
                    }
                } else {
                    pageSize = 0;
                    if (pageNo == 1) {
                        exceptionMsg.append(ResManager.loadKDString((String)"\u7f51\u5740\u65e0\u6548\u672a\u80fd\u4e0b\u8f7d\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u516c\u5171\u53c2\u6570\u8bbe\u7f6e\u662f\u5426\u6709\u8bef", (String)"BeBankNameListPlugin_46", (String)PROJECT_NAME, (Object[])new Object[0]));
                    }
                }
                ++pageNo;
            } while (pageSize >= 10000);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            exceptionMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        if (exceptionMsg.length() == 0) {
            if (pageSize > 0) {
                str = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%s\u6761\u6570\u636e\u3002", (String)"BeBankNameListPlugin_35", (String)PROJECT_NAME, (Object[])new Object[0]), successNum);
                return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.TRUE, (Object)str));
            }
            str = ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u662f\u6700\u65b0\u6570\u636e\u3002", (String)"BeBankNameListPlugin_36", (String)PROJECT_NAME, (Object[])new Object[0]);
            return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.FALSE, (Object)str));
        }
        if (successNum > 0L) {
            str = String.format(ResManager.loadKDString((String)"%s\u6761\u8bb0\u5f55\u5b8c\u6210\u5728\u7ebf\u66f4\u65b0\uff0c\u5176\u5b83\u672a\u66f4\u65b0\u6570\u636e\u5b58\u5728\u5f02\u5e38", (String)"BeBankNameListPlugin_42", (String)PROJECT_NAME, (Object[])new Object[0]), successNum);
            return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.FALSE, (Object)str));
        }
        str = ResManager.loadKDString((String)"\u5728\u7ebf\u66f4\u65b0\u5931\u8d25", (String)"BeBankNameListPlugin_44", (String)PROJECT_NAME, (Object[])new Object[0]);
        return Pair.of((Object)exceptionMsg.toString(), (Object)Pair.of((Object)Boolean.FALSE, (Object)str));
    }

    private static String getStartDate() {
        Date onlineUpdateTime;
        DynamicObjectCollection onlineUpdateTimeDy = QueryServiceHelper.query((String)ENTITY_BEBANK, (String)"onlineupdatetime", (QFilter[])new QFilter[]{new QFilter("onlineupdatetime", "is not null", null)}, (String)"onlineupdatetime desc", (int)1);
        String defaultDate = "19700101";
        if (!ObjectUtils.isEmpty((Object)onlineUpdateTimeDy) && !ObjectUtils.isEmpty((Object)(onlineUpdateTime = ((DynamicObject)onlineUpdateTimeDy.get(0)).getDate("onlineupdatetime")))) {
            return DateUtils.getDateFormat((Date)onlineUpdateTime);
        }
        return defaultDate;
    }

    private static Map<String, DynamicObject> dealBeBankObj(BeBankParams beBankParams, Map<String, Object> adminMap, Map<Object, Object> provinceMap, Set<String> numberSet, Map<String, DynamicObject> bankMap, long id) {
        String replacedCityName;
        HashMap<String, DynamicObject> returnResult = new HashMap<String, DynamicObject>(2);
        DynamicObject countryObj = beBankParams.countryObj;
        long userId = beBankParams.userId;
        Date currTime = beBankParams.currTime;
        String unionNumber = beBankParams.unionNumber;
        String name = beBankParams.name;
        String bankCateName = beBankParams.bankCateName;
        String provinceStr = beBankParams.provinceStr;
        String municipality = beBankParams.municipality;
        String provincetxt = beBankParams.provinceTxt;
        String citytxt = beBankParams.cityTxt;
        String isOverDue = beBankParams.isOverDue;
        Date endLifeCycle = beBankParams.endLifeCycle;
        Object cityObj = BeBankHelper.getCity(adminMap, BeBankHelper.getAdminKey(provinceStr + SEPARATOR_LINE + municipality));
        if (cityObj == null && (replacedCityName = BeBankHelper.getCityName(provinceStr = BeBankHelper.getAdmin(provinceStr), municipality = BeBankHelper.getAdmin(municipality))) != null) {
            cityObj = BeBankHelper.getCity(adminMap, replacedCityName);
        }
        if (cityObj == null && municipality.endsWith("\u81ea\u6cbb\u5dde")) {
            municipality = municipality.substring(0, municipality.length() - 5);
            cityObj = BeBankHelper.getCity(adminMap, provinceStr, municipality);
        }
        Object provinceObj = null;
        if (cityObj != null) {
            provinceObj = provinceMap.get(((DynamicObject)cityObj).getPkValue());
        }
        DynamicObject bank = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BEBANK);
        if (numberSet.contains(unionNumber)) {
            bank.set("id", bankMap.get(unionNumber).get("id"));
            boolean isFromCloud = bankMap.get(unionNumber).getBoolean("isfromcloud");
            if (isFromCloud) {
                bank.set("provincetxt", (Object)provincetxt);
                bank.set("citytxt", (Object)citytxt);
                bank.set("isfromcloud", (Object)"1");
            }
            returnResult.put("failUpdateRowList", bank);
        } else {
            bank.set("id", (Object)id);
            bank.set("enable", (Object)1);
            bank.set("createtime", (Object)currTime);
            bank.set("creator", (Object)userId);
            bank.set("status", (Object)"C");
            bank.set("provincetxt", (Object)provincetxt);
            bank.set("citytxt", (Object)citytxt);
            bank.set("isfromcloud", (Object)"1");
            returnResult.put("rowList", bank);
        }
        bank.set("masterid", bank.get("id"));
        bank.set("onlineupdatetime", (Object)currTime);
        bank.set("number", (Object)unionNumber);
        bank.set("union_number", (Object)unionNumber);
        bank.set("name", (Object)name);
        bank.set("country", (Object)countryObj);
        bank.set("modifier", (Object)userId);
        bank.set("modifytime", (Object)currTime);
        bank.set("bankcatename", (Object)bankCateName);
        bank.set("provincecloud", (Object)provincetxt);
        bank.set("citycloud", (Object)citytxt);
        if (null != provinceObj) {
            bank.set("province", provinceObj);
        }
        if (null != cityObj) {
            bank.set("city", cityObj);
        }
        bank.set("isoverdue", (Object)isOverDue);
        bank.set("endlifecycle", (Object)endLifeCycle);
        return returnResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHttpResponStr(String url, Object bebankLoadParameter) {
        InputStream is = null;
        BufferedReader br = null;
        String str = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet httpUrl = new HttpGet(url);
            httpUrl.setConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(180000).build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpUrl);
            HttpEntity entity = response.getEntity();
            is = entity.getContent();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            str = br.readLine();
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        finally {
            try {
                if (null != br) {
                    br.close();
                }
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return str;
    }

    private static String getCityName(String provinceStr, String municipality) {
        String replacedCityName = null;
        if ("\u91cd\u5e86".equals(provinceStr)) {
            replacedCityName = "\u91cd\u5e86_\u4e07\u5dde";
        } else if ("\u5317\u4eac".equals(provinceStr)) {
            replacedCityName = "\u5317\u4eac_\u6d77\u6dc0";
        } else if ("\u5929\u6d25".equals(provinceStr)) {
            replacedCityName = "\u5929\u6d25_\u5357\u5f00";
        } else if ("\u4e0a\u6d77".equals(provinceStr)) {
            replacedCityName = "\u4e0a\u6d77_\u9ec4\u6d66";
        } else if ("\u5ef6\u8fb9".equals(municipality)) {
            replacedCityName = "\u5409\u6797_\u5ef6\u8fb9\u671d\u9c9c\u65cf";
        } else if ("\u601d\u8305".equals(municipality)) {
            replacedCityName = "\u4e91\u5357_\u666e\u6d31";
        } else if ("\u5de2\u6e56".equals(municipality)) {
            replacedCityName = "\u5b89\u5fbd_\u5408\u80a5";
        } else if ("\u9e70\u8c2d".equals(municipality)) {
            replacedCityName = "\u6c5f\u897f_\u9e70\u6f6d";
        } else if ("\u8944\u6a0a".equals(municipality)) {
            replacedCityName = "\u6e56\u5317_\u8944\u9633";
        } else if ("\u5409\u9996".equals(municipality)) {
            replacedCityName = "\u6e56\u5357_\u6e58\u897f";
        } else if ("\u682a\u5dde".equals(municipality)) {
            replacedCityName = "\u6e56\u5357_\u682a\u6d32";
        } else if ("\u56fe\u6728\u8212\u514b".equals(municipality)) {
            replacedCityName = "\u65b0\u7586_\u56fe\u6728\u8212";
        } else if ("\u83b1\u829c".equals(municipality)) {
            replacedCityName = "\u5c71\u4e1c_\u6d4e\u5357";
        }
        return replacedCityName;
    }

    private static List<DynamicObject> getObjWithDb(List<DynamicObject> rowList) {
        if (rowList == null || rowList.size() < 1) {
            return rowList;
        }
        MainEntityType entryType = EntityMetadataCache.getDataEntityType((String)rowList.get(0).getDataEntityType().getName());
        DynamicObject[] rowListFromDb = BusinessDataServiceHelper.load((Object[])rowList.stream().map(o -> o.get("id")).toArray(), (DynamicObjectType)entryType);
        Map rowListFromDbMap = Arrays.stream(rowListFromDb).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        Set fields = entryType.getFields().keySet();
        for (DynamicObject row : rowList) {
            if (!rowListFromDbMap.containsKey(row.get("id"))) continue;
            DynamicObject rowFromDb = (DynamicObject)rowListFromDbMap.get(row.get("id"));
            for (String field : fields) {
                try {
                    String updateStr;
                    IDataEntityProperty property;
                    Object updateObj = row.get(field);
                    if (updateObj == null || (property = (IDataEntityProperty)entryType.getFields().get(field)) instanceof TextProp && (updateStr = updateObj.toString()).isEmpty()) continue;
                    rowFromDb.set(field, updateObj);
                }
                catch (Exception e) {
                    logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return rowListFromDbMap.values().stream().collect(Collectors.toList());
    }

    private static String getAdmin(String str) {
        if (str.endsWith("\u5730\u533a")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("\u7701") || str.endsWith("\u5e02") || str.endsWith("\u76df")) {
            str = str.substring(0, str.length() - 1);
        } else if (str.length() > 2) {
            if (str.endsWith("\u5dde")) {
                if (str.endsWith("\u81ea\u6cbb\u5dde")) {
                    logger.info("\u5b58\u5728\u672a\u6620\u5c04\u7b80\u79f0\u7684\u81ea\u6cbb\u5dde\uff0c\u540d\u79f0\u4e3a\uff1a" + str + "\uff0c\u5982\u8981\u5173\u8054\u8bf7\u5168\u6587\u5339\u914d");
                } else {
                    str = str.substring(0, str.length() - 1);
                }
            } else if (str.endsWith("\u53bf")) {
                if (str.endsWith("\u81ea\u6cbb\u53bf")) {
                    logger.info("\u5b58\u5728\u672a\u6620\u5c04\u7b80\u79f0\u7684\u81ea\u6cbb\u53bf\uff0c\u540d\u79f0\u4e3a\uff1a" + str + "\uff0c\u5982\u8981\u5173\u8054\u8bf7\u5168\u6587\u5339\u914d");
                } else {
                    str = str.substring(0, str.length() - 1);
                }
            } else if (str.endsWith("\u533a")) {
                if (str.endsWith("\u65b0\u533a") || str.endsWith("\u6797\u533a")) {
                    logger.info("\u5b58\u5728\u672a\u6620\u5c04\u7b80\u79f0\u7684\u533a\uff0c\u540d\u79f0\u4e3a\uff1a" + str + "\uff0c\u5982\u8981\u5173\u8054\u8bf7\u5168\u6587\u5339\u914d");
                } else {
                    str = str.substring(0, str.length() - 1);
                }
            }
        }
        return str;
    }

    private static String getAdminKey(String adminFullName) {
        String[] adminArr;
        if (adminFullName.contains(SEPARATOR_LINE)) {
            adminArr = adminFullName.split(SEPARATOR_LINE);
        } else if (adminFullName.contains(SEPARATOR_DOT)) {
            adminArr = adminFullName.split(SEPARATOR_DOT);
        } else {
            return adminFullName;
        }
        if (adminArr.length < 2) {
            return adminFullName;
        }
        String province = adminArr[0];
        String city = adminArr[1];
        String replacedProvince = provinceMapping.get(province);
        String replacedCity = cityMapping.get(city);
        if (replacedProvince != null) {
            province = replacedProvince;
        }
        if (replacedCity != null) {
            city = replacedCity;
        }
        city = BeBankHelper.getAdmin(city);
        province = BeBankHelper.getAdmin(province);
        return province + SEPARATOR_LINE + city;
    }

    private static Object getCity(Map<String, Object> adminMap, String provinceStr, String municipality) {
        return BeBankHelper.getCity(adminMap, provinceStr + SEPARATOR_LINE + municipality);
    }

    private static Object getCity(Map<String, Object> adminMap, String fullNameStr) {
        return adminMap.get(fullNameStr);
    }

    static {
        provinceMapping.put("\u5185\u8499\u53e4\u81ea\u6cbb\u533a", "\u5185\u8499\u53e4");
        provinceMapping.put("\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a", "\u5b81\u590f");
        provinceMapping.put("\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", "\u5e7f\u897f");
        provinceMapping.put("\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", "\u65b0\u7586");
        provinceMapping.put("\u897f\u85cf\u81ea\u6cbb\u533a", "\u897f\u85cf");
        cityMapping.put("\u5927\u7406\u767d\u65cf\u81ea\u6cbb\u5dde", "\u5927\u7406");
        cityMapping.put("\u5fb7\u5b8f\u50a3\u65cf\u666f\u9887\u65cf\u81ea\u6cbb\u5dde", "\u5fb7\u5b8f");
        cityMapping.put("\u6012\u6c5f\u5088\u50f3\u65cf\u81ea\u6cbb\u5dde", "\u6012\u6c5f");
        cityMapping.put("\u6587\u5c71\u58ee\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", "\u6587\u5c71");
        cityMapping.put("\u695a\u96c4\u5f5d\u65cf\u81ea\u6cbb\u5dde", "\u695a\u96c4");
        cityMapping.put("\u7ea2\u6cb3\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u5dde", "\u7ea2\u6cb3");
        cityMapping.put("\u897f\u53cc\u7248\u7eb3\u50a3\u65cf\u81ea\u6cbb\u5dde", "\u897f\u53cc\u7248\u7eb3");
        cityMapping.put("\u8fea\u5e86\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u8fea\u5e86");
        cityMapping.put("\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde", "\u5ef6\u8fb9\u671d\u9c9c\u65cf");
        cityMapping.put("\u51c9\u5c71\u5f5d\u65cf\u81ea\u6cbb\u5dde", "\u51c9\u5c71");
        cityMapping.put("\u7518\u5b5c\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u7518\u5b5c");
        cityMapping.put("\u963f\u575d\u85cf\u65cf\u7f8c\u65cf\u81ea\u6cbb\u5dde", "\u963f\u575d");
        cityMapping.put("\u6069\u65bd\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", "\u6069\u65bd");
        cityMapping.put("\u4e34\u590f\u56de\u65cf\u81ea\u6cbb\u5dde", "\u4e34\u590f");
        cityMapping.put("\u7518\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u7518\u5357");
        cityMapping.put("\u9ed4\u4e1c\u5357\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u5dde", "\u9ed4\u4e1c\u5357");
        cityMapping.put("\u9ed4\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", "\u9ed4\u5357");
        cityMapping.put("\u9ed4\u897f\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", "\u9ed4\u897f\u5357");
        cityMapping.put("\u795e\u519c\u67b6\u6797\u533a", "\u795e\u519c\u67b6");
        cityMapping.put("\u4f0a\u7281\u54c8\u8428\u514b\u81ea\u6cbb\u5dde", "\u4f0a\u7281");
        cityMapping.put("\u535a\u5c14\u5854\u62c9\u8499\u53e4\u81ea\u6cbb\u5dde", "\u535a\u5c14\u5854\u62c9");
        cityMapping.put("\u5df4\u97f3\u90ed\u695e\u8499\u53e4\u81ea\u6cbb\u5dde", "\u5df4\u97f3\u90ed\u695e");
        cityMapping.put("\u660c\u5409\u56de\u65cf\u81ea\u6cbb\u5dde", "\u660c\u5409");
        cityMapping.put("\u679c\u6d1b\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u679c\u6d1b");
        cityMapping.put("\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u6d77\u5317");
        cityMapping.put("\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u6d77\u897f");
        cityMapping.put("\u7389\u6811\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u7389\u6811");
        cityMapping.put("\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u9ec4\u5357");
        cityMapping.put("\u6d77\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", "\u6d77\u5357\u85cf\u65cf");
        cityMapping.put("\u514b\u5b5c\u52d2\u82cf\u67ef\u5c14\u514b\u5b5c\u81ea\u6cbb\u5dde", "\u514b\u5b5c\u52d2\u82cf\u67ef\u5c14\u514b\u5b5c");
        cityMapping.put("\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", "\u6e58\u897f");
        cityMapping.put("\u6a1f\u6728\u53e3\u5cb8\u9547", "\u65e5\u5580\u5219");
        cityMapping.put("\u4e34\u590f\u53bf", "\u4e34\u590f");
        cityMapping.put("\u84df\u5dde\u533a", "\u84df\u53bf");
        cityMapping.put("\u56fe\u6728\u8212\u514b\u5e02", "\u56fe\u6728\u8212");
        cityMapping.put("\u5858\u6cbd\u533a\uff08\u6ee8\u6d77\u65b0\u533a\uff09", "\u6ee8\u6d77\u65b0\u533a");
        cityMapping.put("\u6c49\u6cbd\u533a\uff08\u6ee8\u6d77\u65b0\u533a\uff09", "\u6ee8\u6d77\u65b0\u533a");
        cityMapping.put("\u5927\u6e2f\u533a\uff08\u6ee8\u6d77\u65b0\u533a\uff09", "\u6ee8\u6d77\u65b0\u533a");
        cityMapping.put("\u767d\u6c99\u9ece\u65cf\u81ea\u6cbb\u53bf", "\u767d\u6c99");
        cityMapping.put("\u4fdd\u4ead\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", "\u4fdd\u4ead");
        cityMapping.put("\u660c\u6c5f\u9ece\u65cf\u81ea\u6cbb\u53bf", "\u660c\u6c5f");
        cityMapping.put("\u4e50\u4e1c\u9ece\u65cf\u81ea\u6cbb\u53bf", "\u4e50\u4e1c");
        cityMapping.put("\u9675\u6c34\u9ece\u65cf\u81ea\u6cbb\u53bf", "\u9675\u6c34");
        cityMapping.put("\u5f6d\u6c34\u82d7\u65cf\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", "\u5f6d\u6c34");
        cityMapping.put("\u743c\u4e2d\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", "\u743c\u4e2d");
        cityMapping.put("\u77f3\u67f1\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", "\u77f3\u67f1");
        cityMapping.put("\u79c0\u5c71\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", "\u79c0\u5c71");
        cityMapping.put("\u9149\u9633\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", "\u9149\u9633");
    }
}

