/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bd.assistant.plugin.model.TreeNodeModel;
import kd.bd.assistant.plugin.model.TreeNodeRefModel;
import kd.bd.assistant.plugin.model.TreeNodeTypeModel;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public abstract class AbstractFinTreeListPlugin
extends StandardTreeListPlugin {
    public static final int MAX_LEVEL = 99;
    private static final String ENTITY_NAME = "bos-bd-formplugin";
    protected static final Set<String> FORCE_REFRESH_TREE_OP_LIST = new LinkedHashSet<String>(Arrays.asList("kd.bos.form.operate.formop.Refresh", "kd.bos.form.operate.New"));
    public static final String KEY_FORECE_REFRESH = "key_forece_refresh";

    public void initialize() {
        super.initialize();
        this.checkNodeType();
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11", "flexpanel_treebtn"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opClzName = args.getSource().getClass().getName();
        if (FORCE_REFRESH_TREE_OP_LIST.contains(opClzName)) {
            this.forceRefreshTree(false);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode currNode = this.getNodeById(e.getNodeId());
        boolean forceRefreshNode = this.getPageCache().get(KEY_FORECE_REFRESH) != null;
        e.setChildNodes(this.loadChildTreeNode(currNode, forceRefreshNode));
        if (forceRefreshNode) {
            this.getPageCache().remove(KEY_FORECE_REFRESH);
        }
    }

    protected void forceRefreshTree(boolean refresh) {
        this.getPageCache().put(KEY_FORECE_REFRESH, "true");
        this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
        if (refresh) {
            this.getTreeListView().refresh();
        }
    }

    private List<TreeNode> loadChildTreeNode(TreeNode currNode, boolean discardCache) {
        List<TreeNode> childList;
        TreeNode root = this.getTreeModel().getRoot();
        TreeNodeModel treeNodeModel = new TreeNodeModel(currNode, root, this.getTreeNodeTypeList());
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty() && !discardCache) {
            childList = currNode.getChildren();
        } else if (TreeNodeTypeModel.LeafMode.LEAF == treeNodeModel.getLeafMode()) {
            childList = null;
        } else {
            List<TreeNode> childTreeNodeList;
            List<TreeNodeRefModel> list = this.loadTreeNodeList(treeNodeModel);
            childList = childTreeNodeList = this.transferTreeNodeList(treeNodeModel, list);
        }
        return childList;
    }

    protected List<TreeNode> getChildTreeNode(TreeNode node) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        if (node != null) {
            nodeList.add(node);
            List children = node.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                children.stream().filter(v -> null != v).forEach(o -> nodeList.addAll(this.getChildTreeNode((TreeNode)o)));
            }
        }
        return nodeList;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
        this.refreshBillList();
        TreeNode currNode = this.getNodeById(nodeId);
        List<TreeNode> allChildrenNode = this.getChildTreeNode(currNode);
        for (TreeNode childNode : allChildrenNode) {
            boolean isOpened = childNode.getIsOpened();
            if (!isOpened) continue;
            childNode.setIsOpened(false);
        }
        super.treeNodeClick(e);
    }

    public void expendTreeNode(TreeNodeEvent e) {
        super.expendTreeNode(e);
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(nodeId, 99);
        if (currNode != null) {
            currNode.setIsOpened(true);
            currNode.setExpend(true);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        TreeNode treeNode = this.getNodeById(e.getNodeId());
        TreeNodeModel nodeModel = new TreeNodeModel(treeNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        QFilter qFilter = this.getBillListFilter(nodeModel);
        e.addQFilter(qFilter);
    }

    protected abstract List<TreeNodeTypeModel> getTreeNodeTypeList();

    protected abstract List<TreeNodeRefModel> loadTreeNodeList(TreeNodeModel var1);

    protected abstract QFilter getBillListFilter(TreeNodeModel var1);

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.refresh();
    }

    private List<TreeNode> transferTreeNodeList(TreeNodeModel pNodeModel, List<TreeNodeRefModel> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return null;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(childList.size());
        for (TreeNodeRefModel treeNodeRef : childList) {
            boolean isLeaf;
            TreeNodeTypeModel childNodeType = treeNodeRef.getNodeType();
            TreeNode node = new TreeNode();
            String nodeID = pNodeModel.generateChildNodeId(treeNodeRef);
            String nodeName = treeNodeRef.getNodeName();
            node.setText(nodeName == null ? ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"AbstractFinTreeListPlugin_0", (String)ENTITY_NAME, (Object[])new Object[0]) : nodeName);
            node.setParentid(pNodeModel.getNodeId());
            node.setId(nodeID);
            boolean bl = isLeaf = childNodeType.getLeafMode() == TreeNodeTypeModel.LeafMode.LEAF || this.getNodeIsLeaf(treeNodeRef);
            if (!isLeaf) {
                node.setChildren(new ArrayList());
            }
            nodeList.add(node);
        }
        return nodeList;
    }

    protected TreeNodeModel getCurrentNodeModel() {
        TreeNode currNode = this.getCurrentNode();
        TreeNodeModel treeNodeModel = new TreeNodeModel(currNode, this.getTreeModel().getRoot(), this.getTreeNodeTypeList());
        return treeNodeModel;
    }

    protected TreeNode getCurrentNode() {
        Object currNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode currNode = this.getNodeById(currNodeId);
        return currNode;
    }

    protected TreeNode getNodeById(Object nodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode((String)nodeId, 99);
        return currNode;
    }

    protected boolean getNodeIsLeaf(TreeNodeRefModel nodeRefModel) {
        return false;
    }

    private void checkNodeType() {
        List<TreeNodeTypeModel> treeNodeTypeList = this.getTreeNodeTypeList();
        if (treeNodeTypeList == null) {
            throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFinTreeListPlugin_1", (String)ENTITY_NAME, (Object[])new Object[0])});
        }
        ArrayList<String> nameList = new ArrayList<String>(treeNodeTypeList.size());
        for (TreeNodeTypeModel typeModel : treeNodeTypeList) {
            String typeName = typeModel.getName();
            if (StringUtils.isEmpty((String)typeName)) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFinTreeListPlugin_2", (String)ENTITY_NAME, (Object[])new Object[0])});
            }
            if (typeName.contains("#") || typeName.contains("/")) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26:%1$s\u6216%2$s", (String)"AbstractFinTreeListPlugin_3", (String)ENTITY_NAME, (Object[])new Object[0]), "/", "#"});
            }
            if (nameList.contains(typeName)) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (String)"AbstractFinTreeListPlugin_4", (String)ENTITY_NAME, (Object[])new Object[0])});
            }
            if (typeModel.getParent() == null) {
                throw new KDException(BosErrorCode.beanNotOfRequiredType, new Object[]{ResManager.loadKDString((String)"\u7236\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a, \u5982\u679c\u4e3a\u4e00\u7ea7\u8282\u70b9, \u8bf7\u6307\u5b9a\u7236\u8282\u70b9\u4e3a:%s#ROOT", (String)"AbstractFinTreeListPlugin_5", (String)ENTITY_NAME, (Object[])new Object[0]), TreeNodeTypeModel.class.getName()});
            }
            nameList.add(typeName);
        }
    }
}

