/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kd.bd.assistant.helper.FinOpLogShowHelper;
import kd.bd.assistant.plugin.helper.BankCateHelper;
import kd.bd.assistant.plugin.helper.FinPicHelper;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FinOrgInfoEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String PATH_DEFTPIC = "/icons/pc/other/financial_institutions.png";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object finTypeId = this.getView().getFormShowParameter().getCustomParam("finTypeId");
        if (finTypeId != null) {
            this.getPageCache().remove("finTypeId");
            this.getModel().setValue("finorgtype", finTypeId);
        }
        this.refreshFinType(false);
        String logo = (String)this.getModel().getValue("logo");
        if (StringUtils.isNotEmpty((CharSequence)logo)) {
            this.getModel().setValue("logo", (Object)FinPicHelper.getRealPath((String)logo));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankCate = (BasedataEdit)this.getControl("bank_cate");
        bankCate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"showlog")) {
            Object number = this.getModel().getValue("number");
            FormShowParameter showPara = FinOpLogShowHelper.create("bd_finorginfo", number);
            this.getView().showForm(showPara);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject beBank;
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"finorgtype", (CharSequence)propName)) {
            this.refreshFinType(true);
        } else if (StringUtils.equals((CharSequence)"bank_cate", (CharSequence)propName)) {
            DynamicObject bankCate = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (bankCate != null) {
                String logo = bankCate.getString("logo");
                if (StringUtils.isNotEmpty((CharSequence)logo)) {
                    this.getModel().setValue("logo", (Object)FinPicHelper.getRealPath((String)logo));
                } else {
                    this.getModel().setValue("logo", null);
                }
            } else {
                this.getModel().setValue("logo", null);
            }
        } else if (StringUtils.equals((CharSequence)"bebank", (CharSequence)propName) && (beBank = (DynamicObject)this.getModel().getValue("bebank")) != null) {
            this.fillBankResData(beBank);
        }
    }

    private void refreshFinType(boolean forceClear) {
        DynamicObject typeObj = (DynamicObject)this.getModel().getValue("finorgtype");
        String type = typeObj == null ? null : typeObj.getString("type");
        this.getView().setVisible(Boolean.TRUE, new String[]{"parent"});
        this.getModel().setValue("parent", null);
        Consumer<Tuple> showCsm = control -> {
            this.getView().setVisible(Boolean.TRUE, new String[]{((FieldEdit)control.item1).getKey()});
            ((FieldEdit)control.item1).setMustInput(((Boolean)control.item2).booleanValue());
        };
        Consumer<Tuple> hideAndClearCsm = control -> {
            this.getView().setVisible(Boolean.FALSE, new String[]{((FieldEdit)control.item1).getKey()});
            if (forceClear) {
                this.getModel().setValue(((FieldEdit)control.item1).getKey(), null);
            }
            ((FieldEdit)control.item1).setMustInput(false);
        };
        List<Tuple<FieldEdit, Boolean>> bankControls = Arrays.asList(Tuple.create((Object)this.getControl("name_eng"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("bank_cate"), (Object)Boolean.TRUE), Tuple.create((Object)this.getControl("simple_name"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("union_number"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("swift_code"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("other_code"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("routingnum"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("address_eng"), (Object)Boolean.FALSE));
        List<Tuple<FieldEdit, Boolean>> chControls = Collections.singletonList(Tuple.create((Object)this.getControl("org"), (Object)Boolean.TRUE));
        List<Tuple<FieldEdit, Boolean>> compControls = Collections.singletonList(Tuple.create((Object)this.getControl("org"), (Object)Boolean.FALSE));
        List<Tuple<FieldEdit, Boolean>> otherControls = Arrays.asList(Tuple.create((Object)this.getControl("simple_name"), (Object)Boolean.FALSE), Tuple.create((Object)this.getControl("org_number"), (Object)Boolean.FALSE));
        if ("0".equals(type)) {
            Stream.concat(chControls.stream(), otherControls.stream()).filter(this.excludeControl(bankControls)).forEach(hideAndClearCsm);
            bankControls.forEach(showCsm);
        } else if ("1".equals(type)) {
            Stream.concat(bankControls.stream(), otherControls.stream()).filter(this.excludeControl(chControls)).forEach(hideAndClearCsm);
            chControls.forEach(showCsm);
        } else if ("3".equals(type)) {
            Stream.concat(bankControls.stream(), otherControls.stream()).filter(this.excludeControl(compControls)).forEach(hideAndClearCsm);
            compControls.forEach(showCsm);
        } else if ("2".equals(type) || "4".equals(type)) {
            Stream.concat(bankControls.stream(), chControls.stream()).filter(this.excludeControl(otherControls)).forEach(hideAndClearCsm);
            otherControls.forEach(showCsm);
            if ("4".equals(type)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bank_cate"});
            }
        } else {
            Stream.concat(bankControls.stream(), Stream.concat(chControls.stream(), otherControls.stream())).forEach(hideAndClearCsm);
        }
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            if (type != null && !"0".equals(type)) {
                this.getModel().setValue("logo", (Object)FinPicHelper.getRealPath((String)PATH_DEFTPIC));
            } else {
                this.getModel().setValue("logo", null);
            }
        }
    }

    private Predicate<Tuple<FieldEdit, Boolean>> excludeControl(List<Tuple<FieldEdit, Boolean>> excludeControlList) {
        return o -> {
            for (Tuple chControl : excludeControlList) {
                if (!((FieldEdit)chControl.item1).equals(o.item1)) continue;
                return false;
            }
            return true;
        };
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        if ("parent".equals(propName)) {
            DynamicObject typeObj = (DynamicObject)this.getModel().getValue("finorgtype");
            QFilter filter = new QFilter("finorgtype", "=", typeObj.getPkValue());
            ListShowParameter listShowPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowPara.getListFilterParameter().setFilter(filter);
            listShowPara.setCustomParam("finType", typeObj.getPkValue());
        }
    }

    private void fillBankResData(DynamicObject bebank) {
        bebank = BusinessDataServiceHelper.loadSingle((Object)bebank.getPkValue(), (String)"bd_bebank");
        this.fillCommonResData(bebank);
        IDataModel model = this.getModel();
        model.setValue("name_eng", (Object)bebank.getString("name_eng"));
        model.setValue("union_number", (Object)bebank.getString("union_number"));
        model.setValue("swift_code", (Object)bebank.getString("swift_code"));
        model.setValue("routingnum", (Object)bebank.getString("routingnum"));
        model.setValue("address_eng", (Object)bebank.getString("address_eng"));
        model.setValue("other_code", (Object)bebank.getString("other_code"));
        String unionNumber = bebank.getString("union_number");
        String name = bebank.getString("name");
        DynamicObject bankCate = BankCateHelper.findBankCate((String)name, (String)unionNumber);
        model.setValue("bank_cate", (Object)bankCate);
        if (bankCate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u94f6\u884c\u7c7b\u522b, \u8bf7\u624b\u52a8\u6dfb\u52a0", (String)"FinOrgInfoEditPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillCommonResData(DynamicObject resData) {
        IDataModel model = this.getModel();
        model.setValue("name", (Object)resData.getLocaleString("name").getLocaleValue());
        model.setValue("address", (Object)resData.getString("address"));
        model.setValue("telephone", (Object)resData.getString("telephone"));
        model.setValue("fax", (Object)resData.getString("fax"));
        DynamicObject province = resData.getDynamicObject("province");
        DynamicObject city = resData.getDynamicObject("city");
        DynamicObject country = resData.getDynamicObject("country");
        model.setValue("country", country != null ? country.getPkValue() : null);
        model.setValue("province", province != null ? province.getPkValue() : null);
        model.setValue("city", city != null ? city.getPkValue() : null);
    }
}

