/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.assistant.helper.OrgHelper;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections.CollectionUtils;

public class NetBankAcctEditPlugin
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initControlEvi();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String entityId = model.getDataEntityType().getName();
        DynamicObject currentOrg = model.getDataEntity().getDynamicObject("company");
        if (null == currentOrg) {
            long currUserId = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            List<Long> authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId(currUserId, null, entityId, "47156aff000000ac");
            if (CollectionUtils.isNotEmpty(authorizedBankOrgId)) {
                if (authorizedBankOrgId.contains(orgId)) {
                    model.setValue("company", (Object)orgId);
                } else {
                    model.setValue("company", (Object)authorizedBankOrgId.get(0));
                }
            }
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"company"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "company": {
                model.setValue("bankacct", null);
                break;
            }
        }
    }

    private void initControlEvi() {
        BasedataEdit bankAcctF7 = (BasedataEdit)this.getControl("bankacct");
        bankAcctF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            DynamicObject onlineBankAcct = this.getModel().getDataEntity();
            DynamicObject org = onlineBankAcct.getDynamicObject("company");
            if (null == org) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7", (String)"NetBankAcctEditPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            }
            qFilters.add(new QFilter("isopenbank", "=", (Object)Boolean.TRUE));
            qFilters.add(new QFilter("company", "in", org.getPkValue()));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getListFilterParameter().setQFilters(qFilters);
        });
        BasedataEdit companyF7 = (BasedataEdit)this.getControl("company");
        String appId = this.getView().getFormShowParameter().getAppId();
        List<Long> authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId(Long.valueOf(RequestContext.get().getUserId()), appId, "bd_netbankacct", "47150e89000000ac");
        companyF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCustomParam("range", (Object)authorizedBankOrgId);
        });
    }
}

