/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import java.util.Comparator;
import java.util.EventObject;
import kd.bd.assistant.plugin.util.BOMVersionUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BOMVersionEditPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String KEY_MATER = "material";
    private static final String KEY_RULE = "bomversionrule";
    private static final String KEY_RULEENTRY = "entryentity";
    private static final String KEY_VERSION = "version";
    private static final String KEY_BD_BOMVERSIONRULE = "bd_bomversionrule";
    private static final String KEY_BUILDVERSION = "buildversion";
    private static final String KEY_ECNBILLNO = "ecnbillno";

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_RULE)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
            DynamicObject mater = (DynamicObject)this.getModel().getValue(KEY_MATER);
            if (org == null || mater == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u548c\u7269\u6599\u3002", (String)"BOMVersionEditPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rule = (BasedataEdit)this.getView().getControl(KEY_RULE);
        if (rule != null) {
            rule.addAfterF7SelectListener((AfterF7SelectListener)this);
            rule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"createorg"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_MATER});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_RULE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnbuildversion"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"createorg"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_MATER});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_RULE});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnbuildversion"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) && result.isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"createorg"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_MATER});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_RULE});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnbuildversion"});
        } else if (StringUtils.equals((CharSequence)KEY_BUILDVERSION, (CharSequence)key) && result.isSuccess()) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
            DynamicObject mater = (DynamicObject)this.getModel().getValue(KEY_MATER);
            DynamicObject rule = (DynamicObject)this.getModel().getValue(KEY_RULE);
            if (org == null || mater == null || rule == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\uff0c\u7269\u6599\u548c\u7248\u672c\u89c4\u5219\u3002", (String)"BOMVersionEditPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            String version = BOMVersionUtil.getAutoVersion(org.getPkValue(), mater.getPkValue(), rule.getPkValue(), "A");
            if (version == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7248\u672c\u89c4\u5219\u4e0b\u7684\u6240\u6709\u7248\u672c\u5728\u7ec4\u7ec7\uff1a%1$s\u3001\u7269\u6599\uff1a%2$s\u4e0b\u90fd\u5df2\u5b58\u5728\u3002", (String)"BOMVersionEditPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), org.getString("name"), mater.getString("number")));
                return;
            }
            this.getModel().setValue("name", (Object)version);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u7248\u672c\u6210\u529f\u3002", (String)"BOMVersionEditPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        String ecnbillno = (String)model.getValue(KEY_ECNBILLNO);
        if (ecnbillno != null && !"".equals(ecnbillno)) {
            model.setValue(KEY_ECNBILLNO, null);
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit ruleData;
        if (e.getSource() instanceof BasedataEdit && (ruleData = (BasedataEdit)e.getSource()).getKey().equals(KEY_RULE) && this.getModel().getValue(KEY_RULE) instanceof DynamicObject) {
            DynamicObject ruleCache = (DynamicObject)this.getModel().getValue(KEY_RULE);
            if (ruleCache == null) {
                return;
            }
            DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleCache.getPkValue(), (String)KEY_BD_BOMVERSIONRULE, (String)"entryentity.version, entryentity.seq");
            DynamicObject org = (DynamicObject)this.getModel().getValue("createorg");
            DynamicObject mater = (DynamicObject)this.getModel().getValue(KEY_MATER);
            if (org == null || mater == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u548c\u7269\u6599\u3002", (String)"BOMVersionEditPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean flag = false;
            DynamicObjectCollection ruleentry = rule.getDynamicObjectCollection(KEY_RULEENTRY);
            ruleentry.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject d1, DynamicObject d2) {
                    int diff = d1.getInt("seq") - d2.getInt("seq");
                    return diff;
                }
            });
            for (int i = 0; i < ruleentry.size(); ++i) {
                String version = ((DynamicObject)ruleentry.get(i)).getString(KEY_VERSION);
                if (BOMVersionUtil.isQuoteVersion(org.getPkValue(), mater.getPkValue(), version, "A").booleanValue()) continue;
                this.getModel().setValue("name", (Object)version);
                flag = true;
                break;
            }
            if (!flag.booleanValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7248\u672c\u89c4\u5219\u4e0b\u7684\u6240\u6709\u7248\u672c\u5728\u7ec4\u7ec7\uff1a%1$s\u3001\u7269\u6599\uff1a%2$s\u4e0b\u90fd\u5df2\u5b58\u5728\u3002", (String)"BOMVersionEditPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), org.getString("name"), mater.getString("number")));
                return;
            }
        }
    }
}

