/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.bom.VersionRuleBusiness;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class VersionRuleDefaultSetPlugin
extends AbstractBillPlugIn {
    private static final String BTNOK = "btnok";
    private static final String KEY_ISDEFAULTA = "isdefault";
    private static final String KEY_ISDEFAULTB = "isdefaultroute";
    private static final String KEY_ISDEFAULTC = "isdefaultprograme";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        String ruleid = parameterParams.get("ruleid").toString();
        DynamicObject versionRule = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(ruleid), (String)"bd_bomversionrule_new", (String)"multype,isdefault,isdefaultroute,isdefaultprograme");
        String multype = versionRule.getString("multype");
        Set multypes = Arrays.stream(multype.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        this.getView().setEnable(Boolean.valueOf(multypes.contains("A")), new String[]{KEY_ISDEFAULTA});
        this.getView().setEnable(Boolean.valueOf(multypes.contains("B")), new String[]{KEY_ISDEFAULTB});
        this.getView().setEnable(Boolean.valueOf(multypes.contains("C")), new String[]{KEY_ISDEFAULTC});
        this.getModel().setValue(KEY_ISDEFAULTA, (Object)versionRule.getBoolean(KEY_ISDEFAULTA));
        this.getModel().setValue(KEY_ISDEFAULTB, (Object)versionRule.getBoolean(KEY_ISDEFAULTB));
        this.getModel().setValue(KEY_ISDEFAULTC, (Object)versionRule.getBoolean(KEY_ISDEFAULTC));
        this.getView().updateView(KEY_ISDEFAULTA);
        this.getView().updateView(KEY_ISDEFAULTB);
        this.getView().updateView(KEY_ISDEFAULTC);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            if (!this.checkModifyPermission()) {
                String checkMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7248\u672c\u89c4\u5219\u4fee\u6539\u7684\u6743\u9650\u3002", (String)"VersionRuleDefaultSetPlugin_01", (String)"bd-assistant-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(checkMsg);
                return;
            }
            boolean isDefaultA = (Boolean)this.getModel().getValue(KEY_ISDEFAULTA);
            boolean isDefaultB = (Boolean)this.getModel().getValue(KEY_ISDEFAULTB);
            boolean isDefaultC = (Boolean)this.getModel().getValue(KEY_ISDEFAULTC);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map parameterParams = parameter.getCustomParams();
            String ruleid = parameterParams.get("ruleid").toString();
            String rulenumber = parameterParams.get("rulenumber").toString();
            String checkMsg = new VersionRuleBusiness().checkHasOtherDefault(Long.valueOf(Long.parseLong(ruleid)), rulenumber, isDefaultA, isDefaultB, isDefaultC);
            if (!StringUtils.isEmpty((String)checkMsg)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("checkOk", (IFormPlugin)this);
                this.getView().showConfirm(checkMsg, MessageBoxOptions.YesNo, listener);
                return;
            }
            this.updateData();
        }
    }

    private boolean checkModifyPermission() {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        return PermissionServiceHelper.hasPermission((Long)userID, (String)"bd_bomversionrule_new", (String)"4715a0df000000ac");
    }

    private void updateData() {
        boolean isDefaultA = (Boolean)this.getModel().getValue(KEY_ISDEFAULTA);
        boolean isDefaultB = (Boolean)this.getModel().getValue(KEY_ISDEFAULTB);
        boolean isDefaultC = (Boolean)this.getModel().getValue(KEY_ISDEFAULTC);
        VersionRuleBusiness business = new VersionRuleBusiness();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        String ruleid = parameterParams.get("ruleid").toString();
        String checkMsg = business.updateDefault(Long.valueOf(Long.parseLong(ruleid)), isDefaultA, isDefaultB, isDefaultC);
        if (!StringUtils.isEmpty((String)checkMsg)) {
            this.getView().showTipNotification(checkMsg);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("isupdate", "true");
        this.getView().returnDataToParent(params);
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("checkOk".equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            this.updateData();
        }
    }
}

