/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ExpItemRelOrgCopyPlugin
extends AbstractFormPlugin {
    private static final String SOURCEORG = "sourceorg";
    private static final String ENTRY_ORGRELATE = "orgentry";
    private static final String ENTRY_ORG = "org";
    private static final String ENTRY_ADMIN_ORG = "admin";
    private static final String COPY_TYPE = "copytype";
    private static final String TYPE_COVER = "cover";
    private static final String TYPE_UNION = "union";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lab_add", "bar_save"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object sourceOrg = this.getView().getFormShowParameter().getCustomParam(SOURCEORG);
        if (sourceOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5173\u8054\u7ec4\u7ec7\u83b7\u53d6\u5931\u8d25", (String)"ExpItemRelOrgCopyPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue(SOURCEORG, sourceOrg);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"saverelation")) {
            DynamicObject sourceOrg = (DynamicObject)this.getModel().getValue(SOURCEORG);
            String copyType = (String)this.getModel().getValue(COPY_TYPE);
            if (sourceOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6e90\u5173\u8054\u7ec4\u7ec7", (String)"ExpItemRelOrgCopyPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection relatedOrgEntry = this.getModel().getEntryEntity(ENTRY_ORGRELATE);
            if (relatedOrgEntry.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8981\u5173\u8054\u7684\u90e8\u95e8", (String)"ExpItemRelOrgCopyPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] relations = BusinessDataServiceHelper.load((String)"bd_expitemreldept", (String)"expenseitem, relorg", (QFilter[])new QFilter("relorg", "=", sourceOrg.getPkValue()).toArray());
            HashSet<Object> expItemIds = new HashSet<Object>(relations.length);
            for (DynamicObject relation : relations) {
                DynamicObject expItem = relation.getDynamicObject("expenseitem");
                expItemIds.add(expItem.getPkValue());
            }
            Set orgSet = relatedOrgEntry.stream().filter(v -> v.getDynamicObject(ENTRY_ORG) != null).map(v -> v.getDynamicObject(ENTRY_ORG)).collect(Collectors.toSet());
            Set orgIdSet = relatedOrgEntry.stream().filter(v -> v.getDynamicObject(ENTRY_ORG) != null).map(v -> v.getDynamicObject(ENTRY_ORG).getPkValue()).collect(Collectors.toSet());
            if (StringUtils.equals((CharSequence)copyType, (CharSequence)TYPE_COVER)) {
                DeleteServiceHelper.delete((String)"bd_expitemreldept", (QFilter[])new QFilter("relorg", "in", orgIdSet).toArray());
            } else {
                QFilter unionFilter = new QFilter("relorg", "in", orgIdSet);
                unionFilter.and("expenseitem", "in", expItemIds);
                DeleteServiceHelper.delete((String)"bd_expitemreldept", (QFilter[])unionFilter.toArray());
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_expitemreldept");
            ArrayList<DynamicObject> copedRelation = new ArrayList<DynamicObject>();
            for (DynamicObject org : orgSet) {
                for (DynamicObject relation : relations) {
                    DynamicObject newRelation = BusinessDataServiceHelper.newDynamicObject((String)"bd_expitemreldept");
                    newRelation.set("relorg", (Object)org);
                    newRelation.set("expenseitem", (Object)relation.getDynamicObject("expenseitem"));
                    copedRelation.add(newRelation);
                }
            }
            if (!copedRelation.isEmpty()) {
                HashMap returnData = new HashMap(relatedOrgEntry.size());
                relatedOrgEntry.stream().filter(v -> v != null).forEach(v -> returnData.put(v.getDynamicObject(ENTRY_ORG).getPkValue(), v.getDynamicObject(ENTRY_ADMIN_ORG).getPkValue()));
                this.getPageCache().put("returndata", SerializationUtils.serializeToBase64(returnData));
                type.setDBRouteKey(DBRoute.basedata.getRouteKey());
                SaveServiceHelper.save((IDataEntityType)type, (Object[])copedRelation.toArray());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f", (String)"ExpItemRelOrgCopyPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        Object sourseOrg = this.getModel().getValue(SOURCEORG);
        if (sourseOrg == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addrelorg")) {
            ListShowParameter orgList = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)true);
            ListFilterParameter orgParam = new ListFilterParameter();
            QFilter orgFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            orgParam.setFilter(orgFilter);
            orgList.setListFilterParameter(orgParam);
            orgList.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addorgs"));
            this.getView().showForm((FormShowParameter)orgList);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String orgMapString = this.getPageCache().get("returndata");
        if (StringUtils.isNotBlank((CharSequence)orgMapString)) {
            Map returnData = (Map)SerializationUtils.deSerializeFromBase64((String)orgMapString);
            this.getView().returnDataToParent((Object)returnData);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"addorgs")) {
            DynamicObject sourceOrg = (DynamicObject)this.getModel().getValue(SOURCEORG);
            ListSelectedRowCollection orgListData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (orgListData != null && !orgListData.isEmpty()) {
                Set addOrgs = orgListData.stream().filter(v -> v.getPrimaryKeyValue() != null).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                DynamicObjectCollection orgEntry = this.getModel().getEntryEntity(ENTRY_ORGRELATE);
                Set relatedOrgIds = orgEntry.stream().filter(v -> v.getDynamicObject(ENTRY_ORG) != null).map(v -> v.getDynamicObject(ENTRY_ORG).getPkValue()).collect(Collectors.toSet());
                addOrgs.removeAll(relatedOrgIds);
                if (sourceOrg != null) {
                    addOrgs.remove(sourceOrg.getPkValue());
                }
                if (addOrgs.isEmpty()) {
                    return;
                }
                int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ORGRELATE, addOrgs.size());
                QFilter orgFilter = new QFilter("view", "=", (Object)1L);
                orgFilter.and(new QFilter("org.id", "in", addOrgs));
                DynamicObject[] adminOrgDyms = BusinessDataServiceHelper.load((String)"bos_adminorg_structure", (String)"org,number,name,fullname,isfreeze", (QFilter[])orgFilter.toArray());
                List<DynamicObject> orgList = Arrays.asList(adminOrgDyms);
                Iterator<DynamicObject> it = orgList.iterator();
                for (int rowIndex : rows) {
                    if (!it.hasNext()) continue;
                    DynamicObject adminOrg = it.next();
                    this.getModel().setValue(ENTRY_ADMIN_ORG, adminOrg.getPkValue(), rowIndex);
                    DynamicObject org = adminOrg.getDynamicObject(ENTRY_ORG);
                    if (org == null) continue;
                    this.getModel().setValue(ENTRY_ORG, org.getPkValue(), rowIndex);
                }
            }
        }
    }
}

