/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.taxc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxusemapPlugin
extends AbstractBillPlugIn {
    private static final String BASEDATATYPE = "basedatatype";
    private static final String BASEDATAVALUES = "basedatavalues";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit basedataidEdit = (TextEdit)this.getView().getControl(BASEDATAVALUES);
        basedataidEdit.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BASEDATATYPE)) {
            this.getView().getModel().setValue(BASEDATAVALUES, null);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BASEDATAVALUES)) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue(BASEDATATYPE);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"TaxusemapPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            String entity = dynamicObject.getString("number");
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38", (String)"TaxusemapPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            showParameter.setFormId(formConfig.getF7ListFormId());
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(false);
            showParameter.setMultiSelect(true);
            showParameter.setLookUp(true);
            showParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            showParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            showParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectBasedataValue");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas;
        if (StringUtils.equalsIgnoreCase((CharSequence)"selectBasedataValue", (CharSequence)closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)(listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            StringBuilder values = new StringBuilder();
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("bd_taxusemapbase");
            this.getModel().deleteEntryData("bd_taxusemapbase");
            for (ListSelectedRow row : listDatas) {
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                int index = this.getModel().createNewEntryRow("bd_taxusemapbase", dynamicObject);
                this.getModel().setValue("basedatavalueid", row.getPrimaryKeyValue(), index);
                this.getModel().setValue("basedatanumber", (Object)row.getNumber(), index);
                this.getModel().setValue("basedatavalue", (Object)row.getName(), index);
                values.append(row.getName()).append(",");
            }
            if (!ObjectUtils.isEmpty((Object)values.toString()) && values.toString().endsWith(",")) {
                this.getModel().setValue(BASEDATAVALUES, (Object)values.substring(0, values.lastIndexOf(",")));
            } else {
                this.getModel().setValue(BASEDATAVALUES, (Object)values.toString());
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (!ObjectUtils.isEmpty((Object)e.getSourceData()) && e.getSourceData() instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)e.getSourceData();
            JSONObject type = jsonObject.getJSONObject(BASEDATATYPE);
            String baseDataTpye = type.getString("number");
            JSONArray basevalue = jsonObject.getJSONArray("bd_taxusemapbase");
            for (Object object : basevalue) {
                JSONObject row = (JSONObject)object;
                String basedatanumber = row.getString("basedatanumber");
                DynamicObjectCollection baseDataTpyes = QueryServiceHelper.query((String)baseDataTpye, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)basedatanumber)});
                if (!ObjectUtils.isEmpty((Object)baseDataTpyes) && baseDataTpyes.size() > 0) {
                    DynamicObject dynamicObject = (DynamicObject)baseDataTpyes.get(0);
                    row.put("basedatavalueid", (Object)dynamicObject.getLong("id"));
                    continue;
                }
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u67e5\u4e0d\u5230\u6570\u636e\u3002", (String)"TaxusemapPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), basedatanumber));
            }
        }
    }
}

