/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orgview.costcenter.CostCenterTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class CostCenterSourceMapDeletePlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(CostCenterSourceMapDeletePlugin.class);
    private static final String ENTITY_COSTCENTERSOURCE_MAP = "bos_costcentersourcemap";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length == 0) {
                    return;
                }
                for (ExtendedDataEntity data : dataEntities) {
                    this.checkUseData(data);
                }
            }

            private void checkUseData(ExtendedDataEntity data) {
                DynamicObject dataEntity = data.getDataEntity();
                DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                if (costCenter == null) {
                    return;
                }
                Date effectDate = dataEntity.getDate("effectdate");
                long costCenterId = costCenter.getLong("id");
                QFilter costCenterQFilter = new QFilter("entry.ecostcenter", "=", (Object)costCenterId);
                QFilter bookDateQFilter = new QFilter("bookdate", ">=", (Object)effectDate);
                QFilter bizDateQFilter = new QFilter("bizdate", ">=", (Object)effectDate);
                boolean isExistCostRecord = false;
                if ("1".equals(CostCenterTreeUtils.getCadBgParamForString("checkCostRecordReference", "0"))) {
                    isExistCostRecord = QueryServiceHelper.exists((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                }
                costCenterQFilter = new QFilter("entryentity.ecostcenter", "=", (Object)costCenterId);
                boolean isExistCostAdjust = QueryServiceHelper.exists((String)"cal_costadjust_subentity", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                costCenterQFilter = new QFilter("costcenter", "=", (Object)costCenterId);
                boolean isExistCostObject = QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                boolean isExistPlan = QueryServiceHelper.exists((String)"cad_plannedoutputbill", (QFilter[])new QFilter[]{costCenterQFilter, bizDateQFilter});
                boolean isExistFact = QueryServiceHelper.exists((String)"cad_factnedoutputbill", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                boolean isExistResource = QueryServiceHelper.exists((String)"sca_resourceuse", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                boolean isExistMat = QueryServiceHelper.exists((String)"aca_matusecollect", (QFilter[])new QFilter[]{costCenterQFilter, bookDateQFilter});
                if (isExistCostRecord || isExistCostAdjust || isExistCostObject || isExistPlan || isExistFact || isExistResource || isExistMat) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CostCenterSourceMapDeletePlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("sourcetype");
        fieldKeys.add("costcenter");
        fieldKeys.add("effectdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            long id = dataEntity.getLong("id");
            idList.add(id);
            this.clearCacheData(dataEntity);
        }
        if (idList.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", idList);
            DeleteServiceHelper.delete((String)ENTITY_COSTCENTERSOURCE_MAP, (QFilter[])new QFilter[]{qFilter});
        }
    }

    private void clearCacheData(DynamicObject dataEntity) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (entryEntity == null) {
            return;
        }
        String cacheKey = "";
        for (DynamicObject entry : entryEntity) {
            try {
                Long sourceDataId = (Long)entry.get("sourcedata.id");
                String sourceType = (String)entry.get("sourcetype");
                cacheKey = sourceDataId + "@" + sourceType;
                AppCache.get((String)"macc").remove("costcenter:" + cacheKey);
            }
            catch (Exception ex) {
                logger.error("cacheKey\uff1a{} \u6e05\u7a7a\u7f13\u5b58\u5931\u8d25\uff1a{}\uff0c", (Object)cacheKey, (Object)ex.getMessage());
            }
        }
    }
}

