/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ConfigTrackHelper {
    public static final String ENTITY_SM_SALORDER = "sm_salorder";

    public static Set<Long> getMaterialBySalOrder(Long configCodeId, Long trackNumId) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(configCodeId)) {
            filter.and(new QFilter("billentry.configuredcode", "=", (Object)configCodeId));
        }
        if (!CadEmptyUtils.isEmpty(trackNumId)) {
            filter.and(new QFilter("billentry.tracknumber", "=", (Object)trackNumId));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)ENTITY_SM_SALORDER, (String)"billentry.material.masterid as material", (QFilter[])new QFilter[]{filter});
        HashSet<Long> materials = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long material = order.getLong("material");
            if (CadEmptyUtils.isEmpty(material)) continue;
            materials.add(material);
        }
        return materials;
    }

    public static Set<Long> getConfigCodeIds(Set<Long> materials) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(materials)) {
            filter.and(new QFilter("billentry.material.masterid", "in", materials));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)ENTITY_SM_SALORDER, (String)"billentry.configuredcode as configuredcode", (QFilter[])new QFilter[]{filter});
        HashSet<Long> configuredCodes = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long configuredCode = order.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty(configuredCode)) continue;
            configuredCodes.add(configuredCode);
        }
        return configuredCodes;
    }

    public static Set<Long> getTrackNumIds(Set<Long> materials) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(materials)) {
            filter.and(new QFilter("billentry.material.masterid", "in", materials));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)ENTITY_SM_SALORDER, (String)"billentry.tracknumber as tracknumber", (QFilter[])new QFilter[]{filter});
        HashSet<Long> trackNumbers = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long trackNumber = order.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty(trackNumber)) continue;
            trackNumbers.add(trackNumber);
        }
        return trackNumbers;
    }

    public static Set<Long> getTrackNumIds(Long configCode) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(configCode)) {
            filter.and(new QFilter("billentry.configuredcode", "=", (Object)configCode));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)ENTITY_SM_SALORDER, (String)"billentry.tracknumber as tracknumber", (QFilter[])new QFilter[]{filter});
        HashSet<Long> trackNumbers = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long trackNumber = order.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty(trackNumber)) continue;
            trackNumbers.add(trackNumber);
        }
        return trackNumbers;
    }

    public static Set<Long> getTrackNumIds(Long materialId, Long configCode) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(materialId)) {
            filter.and(new QFilter("billentry.material.masterid", "=", (Object)materialId));
        }
        if (!CadEmptyUtils.isEmpty(configCode)) {
            filter.and(new QFilter("billentry.configuredcode", "=", (Object)configCode));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)ENTITY_SM_SALORDER, (String)"billentry.tracknumber as tracknumber", (QFilter[])new QFilter[]{filter});
        HashSet<Long> trackNumbers = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long trackNumber = order.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty(trackNumber)) continue;
            trackNumbers.add(trackNumber);
        }
        return trackNumbers;
    }

    public static Set<Long> getConfigCodeIds(Long materialId, Long trackNumId) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(materialId)) {
            filter.and(new QFilter("billentry.material.masterid", "=", (Object)materialId));
        }
        if (!CadEmptyUtils.isEmpty(trackNumId)) {
            filter.and(new QFilter("billentry.tracknumber", "=", (Object)trackNumId));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)ENTITY_SM_SALORDER, (String)"billentry.configuredcode as configuredcode", (QFilter[])new QFilter[]{filter});
        HashSet<Long> configuredCodes = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long configuredCode = order.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty(configuredCode)) continue;
            configuredCodes.add(configuredCode);
        }
        return configuredCodes;
    }

    public static Long getConfigCodeId(Long trackNumId) {
        DynamicObject order;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(trackNumId)) {
            filter.and(new QFilter("billentry.tracknumber", "=", (Object)trackNumId));
        }
        if ((order = QueryServiceHelper.queryOne((String)ENTITY_SM_SALORDER, (String)"billentry.configuredcode as configuredcode", (QFilter[])new QFilter[]{filter})) == null) {
            return 0L;
        }
        return order.getLong("configuredcode");
    }

    public static void setConfigValueByTrack(IFormView view, IDataModel model, Integer index) {
        model.beginInit();
        if (index == null) {
            DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber");
            Long trackNumId = tracknumber == null ? 0L : tracknumber.getLong("id");
            Long configCodeId = ConfigTrackHelper.getConfigCodeId(trackNumId);
            model.setValue("configuredcode", (Object)(configCodeId == 0L ? null : configCodeId));
            view.updateView("configuredcode");
        } else {
            DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber", index.intValue());
            Long trackNumId = tracknumber == null ? 0L : tracknumber.getLong("id");
            Long configCodeId = ConfigTrackHelper.getConfigCodeId(trackNumId);
            model.setValue("configuredcode", (Object)(configCodeId == 0L ? null : configCodeId), index.intValue());
            view.updateView("configuredcode", index.intValue());
        }
        model.endInit();
    }

    public static void setTrackValueByConfig(IFormView view, IDataModel model, Integer index) {
        model.beginInit();
        if (index == null) {
            DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber");
            DynamicObject configuredcode = (DynamicObject)model.getValue("configuredcode");
            Long configCodeId = configuredcode == null ? 0L : configuredcode.getLong("id");
            Long curTrackNumId = tracknumber == null ? 0L : tracknumber.getLong("id");
            Set<Long> trackNumIds = ConfigTrackHelper.getTrackNumIds(configCodeId);
            if (trackNumIds.contains(curTrackNumId)) {
                return;
            }
            model.setValue("tracknumber", null);
            view.updateView("tracknumber");
        } else {
            DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber", index.intValue());
            DynamicObject configuredcode = (DynamicObject)model.getValue("configuredcode", index.intValue());
            Long configCodeId = configuredcode == null ? 0L : configuredcode.getLong("id");
            Long curTrackNumId = tracknumber == null ? 0L : tracknumber.getLong("id");
            Set<Long> trackNumIds = ConfigTrackHelper.getTrackNumIds(configCodeId);
            if (trackNumIds.contains(curTrackNumId)) {
                return;
            }
            model.setValue("tracknumber", null, index.intValue());
            view.updateView("tracknumber", index.intValue());
        }
        model.endInit();
    }

    public static void setConfigTrackValueByMat(IFormView view, IDataModel model, Integer index, Long material, Long curConfigCodeId) {
        Set<Long> configCodeIds = ConfigTrackHelper.getConfigCodeIds(Collections.singleton(material));
        if (configCodeIds.contains(curConfigCodeId)) {
            return;
        }
        if (index == null) {
            model.setValue("configuredcode", null);
            model.setValue("tracknumber", null);
            view.updateView("configuredcode");
            view.updateView("tracknumber");
        } else {
            model.setValue("configuredcode", null, index.intValue());
            model.setValue("tracknumber", null, index.intValue());
            view.updateView("configuredcode", index.intValue());
            view.updateView("tracknumber", index.intValue());
        }
    }
}

