/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bd.macc.common.helper.OrgHelper;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FilterHelper {
    public static void initFilterGrid(IFormView view, String entityNumber, String filterGridName) {
        MainEntityType mainEntityData = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityTypeUtil help = new EntityTypeUtil();
        List cols = help.getFilterColumns((IDataEntityType)mainEntityData);
        FilterGrid filterGrid = (FilterGrid)view.getControl(filterGridName);
        filterGrid.setEntityNumber(mainEntityData.getName());
        filterGrid.setFilterColumns(cols);
        view.updateView(filterGridName);
    }

    public static FilterCondition getFilterCondition(IFormView view, String filterGridapName) {
        FilterGrid filterGrid = (FilterGrid)view.getControl(filterGridapName);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        return filterCondition;
    }

    public static String saveFilter(FilterCondition filterCondition) {
        String filter = "";
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filter;
    }

    public static FilterCondition loadFilter(String saveFilter) {
        if (StringUtils.isBlank((CharSequence)saveFilter)) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)saveFilter, FilterCondition.class);
    }

    public static Set<Long> getEnabledCostAccount(String appNum) {
        List<Long> currAccountOrg = OrgHelper.getCurrAccountOrg();
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter orgQf = new QFilter("org", "in", currAccountOrg);
        QFilter qfEnabled = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        qfEnabled.and(new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE));
        QFilter[] filters = new QFilter[]{qfAppNum, qfEnabled, orgQf};
        DynamicObjectCollection startStdcost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount", (QFilter[])filters);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        startStdcost.forEach(p -> orgIds.add(p.getLong("entryentity.costaccount")));
        return orgIds;
    }
}

