/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bd.pbd.SupplierGradeModel;
import kd.bd.pbd.mservice.api.PbdSupplierGradeService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PbdSupplierGradeServiceImp
implements PbdSupplierGradeService {
    public HashMap<String, Object> synchroSupplierGrade(ArrayList<HashMap<String, Object>> gradeModels) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("success", Boolean.TRUE);
        if (gradeModels.size() > 0) {
            HashMap<String, HashMap<String, Object>> supplierGradeModelsMap = new HashMap<String, HashMap<String, Object>>(12);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            for (HashMap<String, Object> supplierGradeModel : gradeModels) {
                supplierGradeModelsMap.put(this.bulidKey(String.valueOf(supplierGradeModel.get("createorg_id")), String.valueOf(supplierGradeModel.get("bdsupplier_id")), String.valueOf(supplierGradeModel.get("category_id"))), supplierGradeModel);
                qFilters.add(new QFilter("createorg", "=", supplierGradeModel.get("createorg_id")).and(new QFilter("bdsupplier", "=", supplierGradeModel.get("bdsupplier_id")).and(new QFilter("category", "=", supplierGradeModel.get("category_id")))));
            }
            if (qFilters.size() > 0 && supplierGradeModelsMap.size() > 0) {
                QFilter qFilter = (QFilter)qFilters.get(0);
                for (int i = 1; i < qFilters.size(); ++i) {
                    qFilter.or((QFilter)qFilters.get(i));
                }
                this.updateExistSupGradeAndRemoveExistSup(supplierGradeModelsMap, qFilter);
                HashMap<String, Object> saveResult = this.saveSupplierNoExistGrade(supplierGradeModelsMap);
                return saveResult;
            }
        } else {
            BizLog.log((String)" saveSupplierNoExistGrade supplierGradeModelsMap is nul ");
        }
        return result;
    }

    public DynamicObjectCollection querySupplierGrade(Long supplierId, List<Long> orgs) {
        if (Objects.isNull(supplierId) || CollectionUtils.isEmpty(orgs)) {
            BizLog.log((String)"querySupplierGrade supplierId is null or orgs is empty");
            return null;
        }
        QFilter qFilter = new QFilter("bdsupplier", "=", (Object)supplierId);
        qFilter.and(new QFilter("createorg", "in", orgs));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection bd_suppliergrade = QueryServiceHelper.query((String)"bd_suppliergrade", (String)"id,bdsupplier,createorg,category,evagrade,datetimefrom,datetimeto,sourcetype,source,modifytime,enable", (QFilter[])new QFilter[]{qFilter});
        return bd_suppliergrade;
    }

    public void updateExistSupGradeAndRemoveExistSup(HashMap<String, HashMap<String, Object>> supplierGradeModelsMap, QFilter qFilter) {
        DynamicObject[] bd_suppliergrades = BusinessDataServiceHelper.load((String)"bd_suppliergrade", (String)"id,createorg,enable,status,category,bdsupplier,datetimefrom,datetimeto,source,sourcetype,evagrade,modifytime", (QFilter[])new QFilter[]{qFilter});
        if (Objects.nonNull(bd_suppliergrades) && bd_suppliergrades.length > 0) {
            for (DynamicObject bd_suppliergrade : bd_suppliergrades) {
                long createorg = bd_suppliergrade.getLong("createorg.id");
                long bdsupplier = bd_suppliergrade.getLong("bdsupplier.id");
                long category = bd_suppliergrade.getLong("category.id");
                HashMap<String, Object> supplierGradeModel = supplierGradeModelsMap.get(this.bulidKey(String.valueOf(createorg), String.valueOf(bdsupplier), String.valueOf(category)));
                bd_suppliergrade.set("enable", (Object)"1");
                bd_suppliergrade.set("datetimefrom", supplierGradeModel.get("datetimefrom"));
                bd_suppliergrade.set("datetimeto", supplierGradeModel.get("datetimeto"));
                bd_suppliergrade.set("source", supplierGradeModel.get("source"));
                bd_suppliergrade.set("sourcetype", supplierGradeModel.get("sourcetype"));
                bd_suppliergrade.set("evagrade", supplierGradeModel.get("evagrade_id"));
                bd_suppliergrade.set("modifytime", (Object)TimeServiceHelper.now());
                supplierGradeModelsMap.remove(this.bulidKey(String.valueOf(createorg), String.valueOf(bdsupplier), String.valueOf(category)));
            }
            SaveServiceHelper.update((DynamicObject[])bd_suppliergrades);
        } else {
            BizLog.log((String)" updateExistSupGradeAndRemoveExistSup bd_suppliergrades is null");
        }
    }

    public HashMap<String, Object> saveSupplierNoExistGrade(HashMap<String, HashMap<String, Object>> supplierGradeModelsMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("success", Boolean.TRUE);
        if (supplierGradeModelsMap.size() > 0) {
            ArrayList<DynamicObject> suppliergrades = new ArrayList<DynamicObject>(12);
            for (HashMap<String, Object> value : supplierGradeModelsMap.values()) {
                DynamicObject suppliergrade = BusinessDataServiceHelper.newDynamicObject((String)"bd_suppliergrade");
                suppliergrade.set("createorg_id", value.get("createorg_id"));
                suppliergrade.set("useorg_id", value.get("useorg_id"));
                suppliergrade.set("enable", (Object)"1");
                suppliergrade.set("datetimefrom", value.get("datetimefrom"));
                suppliergrade.set("datetimeto", value.get("datetimeto"));
                suppliergrade.set("source", value.get("source"));
                suppliergrade.set("sourcetype", value.get("sourcetype"));
                suppliergrade.set("evagrade_id", value.get("evagrade_id"));
                suppliergrade.set("bdsupplier_id", value.get("bdsupplier_id"));
                suppliergrade.set("bdsupplier", value.get("bdsupplier_id"));
                suppliergrade.set("category_id", value.get("category_id"));
                suppliergrade.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"bd_suppliergrade", (DynamicObject)suppliergrade, (String)suppliergrade.getString("createorg")));
                suppliergrade.set("status", (Object)"C");
                suppliergrade.set("modifytime", (Object)TimeServiceHelper.now());
                suppliergrade.set("ctrlstrategy", (Object)"7");
                suppliergrades.add(suppliergrade);
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bd_suppliergrade", (DynamicObject[])suppliergrades.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                result.put("success", Boolean.FALSE);
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadResFormat((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u5206\u7ea7\u4fe1\u606f\u5931\u8d25\uff1a%1", (String)"PbdSupplierGradeServiceImp_01", (String)"bd-pbd-mservice", (Object[])new Object[]{operationResult.getMessage()}));
                for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo()) {
                    sb.append(iOperateInfo.getMessage());
                }
                result.put("message", sb.toString());
                DeleteServiceHelper.delete((String)"bd_suppliergrade", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)operationResult.getSuccessPkIds())});
            }
        } else {
            BizLog.log((String)" saveSupplierNoExistGrade supplierGradeModelsMap is null ");
        }
        return result;
    }

    public DynamicObjectCollection queryGrade(Long orgid, Long bdsupplierid, String entity) {
        QFilter qFilter = new QFilter("createorg.id", "=", (Object)orgid);
        qFilter.and(new QFilter("bdsupplier.id", "=", (Object)bdsupplierid));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entity, (String)"category as entry_category,evagrade as entry_evagrade,datetimefrom as entry_datetimefrom,datetimeto as entry_datetimeto,enable as entry_enable,sourcetype as entry_sourcetype,source as entry_source,modifytime as entry_modifytime", (QFilter[])new QFilter[]{qFilter});
        return dynamicObjects;
    }

    public List<SupplierGradeModel> queryHistoryGrade(Long orgid, Long bdsupplierid) {
        QFilter qFilter = new QFilter("org.id", "=", (Object)orgid);
        qFilter.and(new QFilter("bdsupplier.id", "=", (Object)bdsupplierid));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        Date today = TimeServiceHelper.now();
        Date twoYearsBefore = KDDateUtils.addYears((Date)today, (int)-2);
        qFilter.and(new QFilter("createtime", ">=", (Object)twoYearsBefore));
        qFilter.and(new QFilter("createtime", "<=", (Object)today));
        DynamicObjectCollection bd_suppliergrade_enter = QueryServiceHelper.query((String)"bd_suppliergrade_enter", (String)"createtime,billno as entryold_source,entryentity,entryentity.category as entryold_category,entryentity.evagrade as entryold_evagrade,entryentity.datetimefrom as entryold_datetimefrom,entryentity.datetimeto as entryold_datetimeto", (QFilter[])new QFilter[]{qFilter});
        List<SupplierGradeModel> supplierGradeModels = this.bulidSupplierGradeEntryModels(bd_suppliergrade_enter);
        QFilter scorptQFilter = new QFilter("org.id", "=", (Object)orgid);
        scorptQFilter.and(new QFilter("supplier.id", "=", (Object)bdsupplierid));
        scorptQFilter.and(new QFilter("bizstatus", "=", (Object)"G"));
        scorptQFilter.and(new QFilter("scheme.synsupgrade", "=", (Object)Boolean.TRUE));
        scorptQFilter.and(new QFilter("createtime", ">=", (Object)twoYearsBefore));
        scorptQFilter.and(new QFilter("createtime", "<=", (Object)today));
        DynamicObjectCollection srm_scorerpt = QueryServiceHelper.query((String)"srm_scorerpt", (String)"createtime,billno,datetimefrom,datetimeto,auditgrade,category", (QFilter[])new QFilter[]{scorptQFilter});
        List<SupplierGradeModel> rptSupplierGradeModels = this.bulidRptSupplierGradeEntryModels(srm_scorerpt);
        supplierGradeModels.addAll(rptSupplierGradeModels);
        QFilter groupScorptQFilter = new QFilter("org.id", "=", (Object)orgid);
        groupScorptQFilter.and(new QFilter("supplier.id", "=", (Object)bdsupplierid));
        groupScorptQFilter.and(new QFilter("createtime", ">=", (Object)twoYearsBefore));
        groupScorptQFilter.and(new QFilter("createtime", "<=", (Object)today));
        DynamicObjectCollection srm_groupscorerpt = QueryServiceHelper.query((String)"srm_groupscorerpt", (String)"createtime,groupevaplanno,billno,groupevagrade,category", (QFilter[])new QFilter[]{groupScorptQFilter});
        List<SupplierGradeModel> groupRptSupplierGradeModels = this.bulidGroupRptSupplierGradeEntryModels(srm_groupscorerpt);
        supplierGradeModels.addAll(groupRptSupplierGradeModels);
        return supplierGradeModels;
    }

    public List<SupplierGradeModel> bulidSupplierGradeEntryModels(DynamicObjectCollection bd_suppliergrade_oldenter) {
        ArrayList<SupplierGradeModel> supplierGradeModels = new ArrayList<SupplierGradeModel>(12);
        for (DynamicObject dynamicObject : bd_suppliergrade_oldenter) {
            SupplierGradeModel supplierGradeModel = new SupplierGradeModel();
            supplierGradeModel.setCategoryid(dynamicObject.getLong("entryold_category"));
            supplierGradeModel.setSource(dynamicObject.getString("entryold_source"));
            supplierGradeModel.setDateto(dynamicObject.getDate("entryold_datetimeto"));
            supplierGradeModel.setDateform(dynamicObject.getDate("entryold_datetimefrom"));
            supplierGradeModel.setEvalGradeid(dynamicObject.getLong("entryold_evagrade"));
            supplierGradeModel.setSourcetype("A");
            supplierGradeModels.add(supplierGradeModel);
        }
        return supplierGradeModels;
    }

    public List<SupplierGradeModel> bulidRptSupplierGradeEntryModels(DynamicObjectCollection bd_suppliergrade_oldenter) {
        ArrayList<SupplierGradeModel> supplierGradeModels = new ArrayList<SupplierGradeModel>(12);
        for (DynamicObject dynamicObject : bd_suppliergrade_oldenter) {
            SupplierGradeModel supplierGradeModel = new SupplierGradeModel();
            supplierGradeModel.setCategoryid(dynamicObject.getLong("category"));
            supplierGradeModel.setSource(dynamicObject.getString("billno"));
            supplierGradeModel.setDateto(dynamicObject.getDate("datetimeto"));
            supplierGradeModel.setDateform(dynamicObject.getDate("datetimefrom"));
            supplierGradeModel.setEvalGradeid(dynamicObject.getLong("auditgrade"));
            supplierGradeModel.setSourcetype("B");
            supplierGradeModels.add(supplierGradeModel);
        }
        return supplierGradeModels;
    }

    public List<SupplierGradeModel> bulidGroupRptSupplierGradeEntryModels(DynamicObjectCollection groupEvaRpts) {
        ArrayList<SupplierGradeModel> supplierGradeModels = new ArrayList<SupplierGradeModel>(12);
        for (DynamicObject groupEvaRpt : groupEvaRpts) {
            SupplierGradeModel supplierGradeModel = new SupplierGradeModel();
            supplierGradeModel.setCategoryid(groupEvaRpt.getLong("category"));
            supplierGradeModel.setSource(groupEvaRpt.getString("billno"));
            supplierGradeModel.setDateto(this.getSourceGroupEvaPlanDateTime(groupEvaRpt.getString("groupevaplanno"), "datetimeto"));
            supplierGradeModel.setDateform(this.getSourceGroupEvaPlanDateTime(groupEvaRpt.getString("groupevaplanno"), "datetimefrom"));
            supplierGradeModel.setEvalGradeid(groupEvaRpt.getLong("groupevagrade"));
            supplierGradeModel.setSourcetype("B");
            supplierGradeModels.add(supplierGradeModel);
        }
        return supplierGradeModels;
    }

    private Date getSourceGroupEvaPlanDateTime(String groupevaplanno, String dateTimeField) {
        DynamicObject srm_groupevaplan = QueryServiceHelper.queryOne((String)"srm_groupevaplan", (String)dateTimeField, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)groupevaplanno)});
        return srm_groupevaplan.getDate(dateTimeField);
    }

    public Object propMapGradeModel(String prop, SupplierGradeModel supplierGradeModel) {
        if (Objects.isNull(supplierGradeModel)) {
            return null;
        }
        switch (prop) {
            case "entryold_category": {
                return supplierGradeModel.getCategoryid();
            }
            case "entryold_source": {
                return supplierGradeModel.getSource();
            }
            case "entryold_datetimeto": {
                return supplierGradeModel.getDateto();
            }
            case "entryold_datetimefrom": {
                return supplierGradeModel.getDateform();
            }
            case "entryold_evagrade": {
                return supplierGradeModel.getEvalGradeid();
            }
            case "entryold_sourcetype": {
                return supplierGradeModel.getSourcetype();
            }
        }
        return null;
    }

    public String bulidKey(String createorg, String bdsupplier, String category) {
        return createorg + "_" + bdsupplier + "_" + category;
    }
}

