/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.mservice;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.pbd.mservice.CategoryParam;
import kd.bd.pbd.mservice.CategoryParamWrapper;
import kd.bd.pbd.mservice.IStrategyResultService;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PurchaseOrgResultService
implements IStrategyResultService {
    private static Log log = LogFactory.getLog(PurchaseOrgResultService.class);
    private static final String CLASS_TYPE = "classtype";

    @Override
    public void dealMatchResult(String resultKey, List<CategoryParam> infos, CategoryParamWrapper wrapper, Map<String, Map<String, Object>> centralPurchaseMap, boolean isPublic) {
        if (wrapper != null) {
            this.dealUnCentralResult(resultKey, infos, wrapper, centralPurchaseMap);
            Map<String, Map<String, Object>> resultMap = wrapper.getResultMap();
            if (resultMap != null && !resultMap.containsKey(resultKey)) {
                this.matchPurchaseResult(resultKey, infos, wrapper, centralPurchaseMap);
            }
        }
    }

    private void dealUnCentralResult(String key, List<CategoryParam> infos, CategoryParamWrapper wrapper, Map<String, Map<String, Object>> queryResult) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CLASS_TYPE, "2");
        if (infos != null && key != null) {
            Iterator<CategoryParam> iterator = infos.iterator();
            String[] split = key.split("-");
            if (split.length != 2) {
                return;
            }
            log.info("\u5f85\u5339\u914d\u4fe1\u606f", (Object)SerializationUtils.toJsonString((Object)split));
            while (iterator.hasNext()) {
                CategoryParam cparam = iterator.next();
                String baseDataType = this.getBaseDataType(wrapper, cparam.getParam());
                Map<String, Object> param1 = cparam.getParam();
                if (param1 == null) continue;
                CategoryParam dealInfo = new CategoryParam();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.putAll(cparam.getParam());
                Object orgId = param.get("orgId");
                param.put(wrapper.getProperty(), split[1]);
                param.put("baseDataType", baseDataType);
                param.put("orgId", 0L);
                param.remove("bizType");
                dealInfo.setParam(param);
                String uniqueKey = wrapper.buildUniqueKey(dealInfo);
                Map<String, Object> result = queryResult.get(uniqueKey);
                if (result == null || !StringUtils.isNotBlank((Object)result.get(CLASS_TYPE)) || !"2".equals(result.get(CLASS_TYPE))) continue;
                String resultUniqueKey = wrapper.buildUniqueKey(cparam);
                map.putAll(result);
                if (result.containsKey("orgId")) {
                    map.put("orgId", orgId);
                }
                wrapper.getResultMap().put(resultUniqueKey, map);
                iterator.remove();
            }
        }
    }

    private String getBaseDataType(CategoryParamWrapper wrapper, Map<String, Object> param) {
        String baseDataType = String.valueOf(param.get("baseDataType"));
        Map<String, String> extPropertyMap = wrapper.getExtPropertyMap();
        if (extPropertyMap != null && "category.id".equals(extPropertyMap.get(wrapper.getProperty())) && "2".equals(baseDataType)) {
            baseDataType = "1";
        }
        return baseDataType;
    }

    private void matchPurchaseResult(String key, List<CategoryParam> infos, CategoryParamWrapper wrapper, Map<String, Map<String, Object>> centralPurchaseMap) {
        if (infos != null && key != null) {
            String[] split = key.split("-");
            if (split.length != 2) {
                return;
            }
            Iterator<CategoryParam> iterator1 = infos.iterator();
            String baseDataId = null;
            while (iterator1.hasNext()) {
                CategoryParam info = iterator1.next();
                Map<String, Map<String, Object>> map = this.doPatchPurchaseOrg(info, baseDataId = String.valueOf(split[1]), centralPurchaseMap, wrapper);
                if (map == null || map.size() <= 0) continue;
                wrapper.getResultMap().putAll(map);
                iterator1.remove();
            }
        }
    }

    private Map<String, Map<String, Object>> doPatchPurchaseOrg(CategoryParam info, Object baseDataId, Map<String, Map<String, Object>> centralPurchaseMap, CategoryParamWrapper wrapper) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        if (centralPurchaseMap != null && centralPurchaseMap.size() > 0) {
            CategoryParam dealInfo = new CategoryParam();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.putAll(info.getParam());
            dealInfo.setParam(param);
            String baseDataType = this.getBaseDataType(wrapper, param);
            param.put(wrapper.getProperty(), baseDataId);
            param.put("baseDataType", baseDataType);
            String paramKey = wrapper.buildUniqueKey(dealInfo);
            Map<String, Object> aLong = centralPurchaseMap.get(paramKey);
            if (aLong == null) {
                param.put("orgId", 0L);
                paramKey = wrapper.buildUniqueKey(dealInfo);
                aLong = centralPurchaseMap.get(paramKey);
                if (aLong == null) {
                    param.put("orgId", info.getParam().get("orgId"));
                    param.put("bizType", "1");
                    paramKey = wrapper.buildUniqueKey(dealInfo);
                    aLong = centralPurchaseMap.get(paramKey);
                    if (aLong == null) {
                        param.put("orgId", 0L);
                        paramKey = wrapper.buildUniqueKey(dealInfo);
                        aLong = centralPurchaseMap.get(paramKey);
                    }
                }
            }
            if (aLong != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.putAll(aLong);
                resultMap.put(wrapper.buildUniqueKey(info), map);
            }
        }
        return resultMap;
    }
}

