/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.pojo.Pair;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.MoveDirectEnum;
import kd.bd.sbd.enums.SnStatusEnum;
import kd.bd.sbd.utils.IDGenerator;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SnMainFileProcessor {
    private static final char SPLIT = '.';
    private String KEY_MainEntry;
    private String KEY_BillSnEntry;
    private String KEY_MATERIAL;
    private String KEY_SN;
    private String KEY_SNID;
    private String LOTNUMBER = "lotnumber";
    private Map<Object, List<Object>> billMainMap = new HashMap<Object, List<Object>>();
    private static Set<String> inOutPropSet = new HashSet<String>(5){
        {
            this.add("srcsupplier");
            this.add("stockdate");
            this.add("suppliersn");
            this.add("descustomer");
            this.add("shipmentdate");
        }
    };

    public List<Map<Long, Pair>> querySnMainFiles(List<Object> pks, SnStatusEnum status) {
        if (pks == null || pks.size() == 0) {
            return new ArrayList<Map<Long, Pair>>();
        }
        QFilter filter1 = new QFilter("nowinvaccid", "in", (Object)pks.toArray());
        QFilter filter2 = new QFilter("snmainfile.snstatus", "=", (Object)status.getValue());
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bd_snmovetrack", (String)"snmainfile as id,snmainfile.number as number,snmainfile.material as material,nowinvaccid", (QFilter[])new QFilter[]{filter1, filter2});
        HashMap<Pair, Long> map = new HashMap<Pair, Long>();
        for (DynamicObject entity : doc) {
            Pair pair = new Pair(entity.getLong("id"), entity.getString("number"));
            map.put(pair, entity.getLong("nowinvaccid"));
        }
        ArrayList<Map<Long, Pair>> arrays = new ArrayList<Map<Long, Pair>>(map.size());
        for (Map.Entry mapEntry : map.entrySet()) {
            HashMap one = new HashMap();
            one.put(mapEntry.getValue(), mapEntry.getKey());
            arrays.add(one);
        }
        return arrays;
    }

    public void updateInvaccPk(Map<Long, List<Long>> result, DynamicObject[] dataEntities) {
        DynamicObject entity;
        QFilter filter;
        DynamicObject[] moveDcs4Bill;
        this.KEY_MainEntry = "billentry";
        this.KEY_BillSnEntry = "subentryentity";
        this.KEY_SN = "serialid";
        this.KEY_MATERIAL = "material";
        List<DynamicObject> toDealEntity = this.getEnableSnEntities(dataEntities, this.KEY_MATERIAL);
        HashMap<Long, ArrayList<DynamicObject>> moveMap = null;
        Iterator<DynamicObject> iterator = toDealEntity.iterator();
        while (iterator.hasNext() && (moveDcs4Bill = BusinessDataServiceHelper.load((String)"bd_snmovetrack", (String)"id,movedirect,snmainfile,srcinvaccid,nowinvaccid", (QFilter[])new QFilter[]{filter = new QFilter("billid", "=", (entity = iterator.next()).getPkValue())})) != null && moveDcs4Bill.length >= 1) {
            moveMap = new HashMap<Long, ArrayList<DynamicObject>>(moveDcs4Bill.length);
            for (DynamicObject dynamicObject : moveDcs4Bill) {
                Long mainPk = dynamicObject.getLong("snmainfile_id");
                ArrayList<DynamicObject> moves = (ArrayList<DynamicObject>)moveMap.get(mainPk);
                if (moves == null) {
                    moves = new ArrayList<DynamicObject>();
                    moves.add(dynamicObject);
                    moveMap.put(mainPk, moves);
                    continue;
                }
                moves.add(dynamicObject);
            }
            DynamicObject[] mainDcs = BusinessDataServiceHelper.load((Object[])moveMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"));
            HashMap<Long, DynamicObject> mainMap = new HashMap<Long, DynamicObject>(mainDcs.length);
            for (DynamicObject main : mainDcs) {
                mainMap.put(main.getLong("id"), main);
            }
            DynamicObjectCollection entry = entity.getDynamicObjectCollection(this.KEY_MainEntry);
            for (DynamicObject row : entry) {
                Long snPk;
                long entryPk = row.getLong("id");
                List<Long> ids = result.get(entryPk);
                if (ids == null) continue;
                if (ids.size() == 1) {
                    for (DynamicObject sn : row.getDynamicObjectCollection(this.KEY_BillSnEntry)) {
                        snPk = sn.getLong(this.KEY_SN + "_id");
                        ((List)moveMap.get(snPk)).forEach(p -> p.set("nowinvaccid", ids.get(0)));
                        ((DynamicObject)mainMap.get(snPk)).set("nowinvaccid", (Object)ids.get(0));
                    }
                    continue;
                }
                if (ids.size() != 2) continue;
                for (DynamicObject sn : row.getDynamicObjectCollection(this.KEY_BillSnEntry)) {
                    snPk = sn.getLong(this.KEY_SN + "_id");
                    for (DynamicObject move3 : (List)moveMap.get(snPk)) {
                        if (move3.getString("movedirect").equals(MoveDirectEnum.DES.getValue())) {
                            move3.set("nowinvaccid", (Object)ids.get(0));
                            ((DynamicObject)mainMap.get(snPk)).set("nowinvaccid", (Object)ids.get(0));
                            continue;
                        }
                        move3.set("nowinvaccid", (Object)ids.get(1));
                        ((DynamicObject)mainMap.get(snPk)).set("nowinvaccid", (Object)ids.get(1));
                    }
                }
            }
            TXHandle tXHandle = TX.requiresNew((String)"sbd_saveSnMoveInvaccId");
            Throwable throwable = null;
            try {
                try {
                    SaveServiceHelper.save((DynamicObject[])moveDcs4Bill);
                    SaveServiceHelper.save((DynamicObject[])mainDcs);
                }
                catch (Throwable e) {
                    tXHandle.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tXHandle == null) continue;
                if (throwable != null) {
                    try {
                        tXHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tXHandle.close();
            }
        }
    }

    public DynamicObject[] saveSnMainFile(List<Map<String, Object>> mainFields, String materialKey, String snKey, String auxpty, String mainEntryKey, String billSnEntryKey, DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length < 1) {
            return null;
        }
        this.KEY_MainEntry = mainEntryKey;
        this.KEY_BillSnEntry = billSnEntryKey;
        this.KEY_MATERIAL = materialKey;
        this.KEY_SN = snKey;
        ArrayList<DynamicObject> snArrays = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> snNewArrays = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> snMoveArrays = new ArrayList<DynamicObject>();
        Map<String, String> movePropMapping = this.buildPropMapping(mainFields);
        this.checkPropIsNull(this.KEY_MATERIAL);
        this.checkPropIsNull(this.KEY_SN);
        this.KEY_SNID = movePropMapping.get("snid");
        if (this.KEY_SNID == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u4fdd\u5b58\u5e76\u66f4\u65b0\u670d\u52a1\u914d\u7f6e\u9519\u8bef\uff1a\u5e8f\u5217\u53f7ID \u5b57\u6bb5\u672a\u914d\u7f6e\u6620\u5c04\u5b57\u6bb5\u3002", (String)"SnMainFileProcessor_0", (String)"bd-sbd-business", (Object[])new Object[0]));
        }
        this.KEY_SNID = this.KEY_SNID.substring(this.KEY_SNID.lastIndexOf(46) + 1);
        String billNo = movePropMapping.get("billno");
        Map<String, DynamicObject> toDealEntityMap = this.getEnableSnEntities(dataEntities, billNo, this.KEY_MATERIAL);
        if (toDealEntityMap.size() < 1) {
            return null;
        }
        Map<String, DynamicObject> snMatMap = this.buildSnMatMap(toDealEntityMap, this.KEY_MATERIAL, this.KEY_SN);
        DynamicObject material = null;
        DynamicObject billEntity = null;
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"sbd_saveSnMainFile");){
            IDGenerator idGenerator = new IDGenerator();
            for (Map.Entry<String, DynamicObject> toDealEntityMapEntry : toDealEntityMap.entrySet()) {
                billEntity = toDealEntityMapEntry.getValue();
                Map<String, Set<Object>> result = this.toDeleteSnMainFile(billEntity.getPkValue(), true);
                Set<Object> toDelMainPks = result.get("bd_snmainfile");
                if (toDelMainPks == null) {
                    toDelMainPks = new HashSet<Object>();
                }
                Set<Object> snmainfiles = result.get("snmainfile");
                for (DynamicObject row : billEntity.getDynamicObjectCollection(this.KEY_MainEntry)) {
                    material = row.getDynamicObject(this.KEY_MATERIAL);
                    if (!material.getBoolean("enableserial")) continue;
                    for (DynamicObject snRow : row.getDynamicObjectCollection(this.KEY_BillSnEntry)) {
                        String snNum = snRow.getString(this.KEY_SN);
                        if (snNum == null) continue;
                        DynamicObject moveEntity = BusinessDataServiceHelper.newDynamicObject((String)"bd_snmovetrack");
                        this.setEntityData(movePropMapping, moveEntity, billEntity, row, snRow);
                        this.setMoveDirect(moveEntity, movePropMapping, billEntity, row);
                        DynamicObject snMainFileEntity = snMatMap.get(material.get("masterid_id") + snNum);
                        if (snMainFileEntity == null) {
                            snMainFileEntity = BusinessDataServiceHelper.newDynamicObject((String)"bd_snmainfile");
                            snMainFileEntity.set("id", (Object)idGenerator.getGlobalId());
                            snMainFileEntity.set("number", (Object)snNum);
                            snMainFileEntity.set("material", material.get("masterid_id"));
                            snMainFileEntity.set("status", (Object)"C");
                            snMainFileEntity.set(this.LOTNUMBER, row.get(this.LOTNUMBER));
                            snMainFileEntity.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
                            snNewArrays.add(snMainFileEntity);
                        } else {
                            String msg;
                            snArrays.add(snMainFileEntity);
                            this.delUpdateSnMainFiles(snmainfiles, snMainFileEntity);
                            if (!this.billMainMap.get(billEntity.getPkValue()).contains(snMainFileEntity.getPkValue()) && StringUtils.isNotEmpty((String)(msg = this.checkSnCanUse(moveEntity, snMainFileEntity)))) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7b2c%2$s\u884c\uff0c\u5e8f\u5217\u53f7%3$s,\u4e0d\u5141\u8bb8\u4f7f\u7528", (String)"SnMainFileProcessor_1", (String)"bd-sbd-business", (Object[])new Object[0]), billEntity.getString(billNo), row.getInt("seq"), snNum));
                            }
                            toDelMainPks.remove(snMainFileEntity.getPkValue());
                        }
                        moveEntity.set("snmainfile", snMainFileEntity.get("id"));
                        moveEntity.set("billid", billEntity.getPkValue());
                        moveEntity.set("billentity", (Object)billEntity.getDataEntityType().getName());
                        for (String col : this.getRestoreCols()) {
                            Object value = moveEntity.get(col);
                            if (inOutPropSet.contains(col) && ObjectUtils.isEmpty((Object)value)) continue;
                            snMainFileEntity.set(col, moveEntity.get(col));
                        }
                        snMoveArrays.add(moveEntity);
                        snRow.set(this.KEY_SNID, snMainFileEntity.get("id"));
                    }
                }
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"), (Object[])toDelMainPks.toArray());
                if (snmainfiles != null && snmainfiles.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"), (Object[])snmainfiles.toArray());
                }
                if (result.get("bd_snmovetrack") == null) continue;
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack"), (Object[])result.get("bd_snmovetrack").toArray());
            }
            SaveServiceHelper.save((DynamicObject[])snArrays.toArray(new DynamicObject[snArrays.size()]));
            SaveServiceHelper.save((DynamicObject[])snNewArrays.toArray(new DynamicObject[snNewArrays.size()]));
            SaveServiceHelper.save((DynamicObject[])snMoveArrays.toArray(new DynamicObject[snMoveArrays.size()]));
            DynamicObject[] dynamicObjectArray = dataEntities;
            return dynamicObjectArray;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void delUpdateSnMainFiles(Set<Object> snmainfiles, DynamicObject snMainFileEntity) {
        if (snmainfiles == null) {
            return;
        }
        Iterator<Object> iter = snmainfiles.iterator();
        while (iter.hasNext()) {
            DynamicObject main = (DynamicObject)iter.next();
            if (main.getLong("id") != snMainFileEntity.getLong("id")) continue;
            iter.remove();
        }
    }

    public void deleteSnMainFile(List<Object> billPks) {
        if (billPks == null || billPks.size() < 1) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"sbd_deleteSnMainFile");){
            try {
                for (Object entity : billPks) {
                    this.toDeleteSnMainFile(entity, false);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public Map<String, Set<Object>> toDeleteSnMainFile(Object billId, boolean isUpdate) {
        QFilter filter = new QFilter("billid", "=", billId);
        DynamicObject[] moveDcs4Bill = BusinessDataServiceHelper.load((String)"bd_snmovetrack", (String)"id,snmainfile", (QFilter[])new QFilter[]{filter});
        if (moveDcs4Bill == null || moveDcs4Bill.length < 1) {
            return new HashMap<String, Set<Object>>();
        }
        HashSet<Object> movePks = new HashSet<Object>(moveDcs4Bill.length);
        HashSet<Object> snMainPks = new HashSet<Object>(moveDcs4Bill.length);
        for (DynamicObject dd : moveDcs4Bill) {
            movePks.add(dd.getPkValue());
            snMainPks.add(dd.get("snmainfile_id"));
        }
        filter = new QFilter("snmainfile", "in", (Object)snMainPks.toArray());
        DynamicObject[] moveDcs4Main = BusinessDataServiceHelper.load((String)"bd_snmovetrack", (String)("movedirect,snmainfile,movedate," + this.getSelectors()), (QFilter[])new QFilter[]{filter});
        DynamicObject[] snMainFiles = null;
        if (moveDcs4Bill.length != moveDcs4Main.length) {
            HashMap<Long, DynamicObject> map4main = new HashMap<Long, DynamicObject>();
            HashSet<Long> toModifyPks = new HashSet<Long>();
            for (DynamicObject move : moveDcs4Main) {
                if (movePks.contains(move.get("id"))) continue;
                long mainPk = move.getLong("snmainfile.id");
                DynamicObject result = map4main.put(mainPk, move);
                toModifyPks.add(mainPk);
                if (result == null || result.getDate("movedate").compareTo(move.getDate("movedate")) <= 0) continue;
                map4main.put(mainPk, result);
            }
            if (map4main.size() > 0) {
                snMainFiles = BusinessDataServiceHelper.load((Object[])map4main.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"));
                for (DynamicObject main : snMainFiles) {
                    long pk = main.getLong("id");
                    DynamicObject data4Move = (DynamicObject)map4main.get(pk);
                    for (String col : this.getRestoreCols()) {
                        Object value = data4Move.get(col);
                        if (data4Move.getString("movedirect").equals(MoveDirectEnum.SRC.getValue()) && ObjectUtils.isEmpty((Object)value)) continue;
                        main.set(col, data4Move.get(col));
                    }
                    MoveDirectEnum moveDc = MoveDirectEnum.getMoveDirectEnumByValue((String)data4Move.getString("movedirect"));
                    if (moveDc == MoveDirectEnum.DES) {
                        main.set("snstatus", (Object)SnStatusEnum.HASOUT.getValue());
                        continue;
                    }
                    if (moveDc != MoveDirectEnum.SRC) continue;
                    main.set("snstatus", (Object)SnStatusEnum.HASIN.getValue());
                }
            }
            snMainPks.removeAll(toModifyPks);
        }
        HashMap<String, Set<Object>> result = new HashMap<String, Set<Object>>();
        result.put("bd_snmainfile", snMainPks);
        result.put("bd_snmovetrack", movePks);
        if (snMainFiles != null) {
            HashSet<DynamicObject> mains = new HashSet<DynamicObject>(snMainFiles.length);
            for (DynamicObject dd : snMainFiles) {
                mains.add(dd);
            }
            result.put("snmainfile", mains);
        }
        if (!isUpdate) {
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"), (Object[])snMainPks.toArray());
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_snmovetrack"), (Object[])movePks.toArray());
            if (snMainFiles != null) {
                SaveServiceHelper.save((DynamicObject[])snMainFiles);
            }
        }
        return result;
    }

    public void dealSnStatus(DynamicObject[] dataEntities, Map<String, String> propMap) {
        ArrayList<Object> snPks = new ArrayList<Object>();
        String snProp = propMap.get("snId");
        for (DynamicObject dynamicObject : dataEntities) {
            for (DynamicObject row : dynamicObject.getDynamicObjectCollection(propMap.get("mainEntryKey"))) {
                DynamicObject snRow;
                Object value;
                Iterator iterator = row.getDynamicObjectCollection(propMap.get("snEntryKey")).iterator();
                while (iterator.hasNext() && (value = this.getSnPks(snRow = (DynamicObject)iterator.next(), snProp)) != null && !StringUtils.isEmpty((String)value.toString().trim())) {
                    snPks.add(value);
                }
            }
        }
        if (snPks.size() > 0) {
            DynamicObject[] snMainFile = this.getSnMainFile(snPks);
            ArrayList<DynamicObject> toUpdateFiles = new ArrayList<DynamicObject>();
            HashMap<Object, DynamicObject> fileMap = new HashMap<Object, DynamicObject>(snMainFile.length);
            for (DynamicObject file : snMainFile) {
                fileMap.put(file.getPkValue(), file);
            }
            for (DynamicObject entity : dataEntities) {
                for (DynamicObject row : entity.getDynamicObjectCollection(propMap.get("mainEntryKey"))) {
                    for (DynamicObject snRow : row.getDynamicObjectCollection(propMap.get("snEntryKey"))) {
                        DynamicObject file = (DynamicObject)fileMap.get(this.getSnPks(snRow, snProp));
                        if (file == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u64a4\u6d88\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"SnMainFileProcessor_4", (String)"bd-sbd-business", (Object[])new Object[0]));
                        }
                        toUpdateFiles.add(this.setSnStatus4Data(file, propMap.get("operation")));
                    }
                }
            }
            try (TXHandle tXHandle = TX.requiresNew((String)"sbd_saveSnMainFile");){
                try {
                    SaveServiceHelper.save((DynamicObject[])toUpdateFiles.toArray(new DynamicObject[toUpdateFiles.size()]));
                }
                catch (Throwable e) {
                    tXHandle.markRollback();
                    throw e;
                }
            }
        }
    }

    private Object getSnPks(DynamicObject snRow, String snProp) {
        Object value = snRow.get(snProp);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getPkValue();
        }
        return value;
    }

    private String checkSnCanUse(DynamicObject moveEntity, DynamicObject snMainFileEntity) {
        MoveDirectEnum moveEnum = MoveDirectEnum.getMoveDirectEnumByValue((String)moveEntity.getString("movedirect"));
        String snStatusValue = snMainFileEntity.getString("snstatus");
        if (StringUtils.isEmpty((String)snStatusValue)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SnStatusEnum snEnum = SnStatusEnum.getSnStatusEnumByValue((String)snStatusValue);
        switch (snEnum) {
            case HASIN: {
                if (MoveDirectEnum.SRC != moveEnum) break;
                sb.append(ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u7b26\u5408\u8981\u6c42", (String)"SnMainFileProcessor_5", (String)"bd-sbd-business", (Object[])new Object[0]));
                break;
            }
            case HASOUT: {
                if (MoveDirectEnum.DES != moveEnum) break;
                sb.append(ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u7b26\u5408\u8981\u6c42", (String)"SnMainFileProcessor_5", (String)"bd-sbd-business", (Object[])new Object[0]));
                break;
            }
            case TOIN: 
            case TOOUT: {
                sb.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u88ab\u5176\u4ed6\u5355\u636e\u4f7f\u7528", (String)"SnMainFileProcessor_6", (String)"bd-sbd-business", (Object[])new Object[0]));
            }
        }
        return sb.toString();
    }

    private void checkPropIsNull(String prop) {
        if (StringUtils.isEmpty((String)prop)) {
            throw new KDBizException(this.buildMsg(prop));
        }
    }

    private Map<String, String> buildPropMapping(List<Map<String, Object>> Fields) {
        HashMap<String, String> propMapping = new HashMap<String, String>(Fields.size());
        for (Map<String, Object> map : Fields) {
            String billFieldKey = (String)map.get("currentmetadatakey");
            String lotFieldKey = (String)map.get("metadatakey");
            propMapping.put(lotFieldKey, billFieldKey);
        }
        return propMapping;
    }

    private DynamicObject[] getSnMainFilesByNums(List<String> snNums) {
        QFilter filter = new QFilter("number", "in", (Object)snNums.toArray());
        return BusinessDataServiceHelper.load((String)"bd_snmainfile", (String)this.getSelectors(), (QFilter[])new QFilter[]{filter});
    }

    private String getSelectors() {
        StringBuilder sb = new StringBuilder("id,number,material,snstatus");
        for (String str : this.getRestoreCols()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private Map<String, DynamicObject> buildSnMatMap(Map<String, DynamicObject> toDealEntityMap, String matProp, String snProp) {
        DynamicObject material = null;
        HashMap<String, DynamicObject> snMatMap = new HashMap<String, DynamicObject>();
        ArrayList<String> snNums = new ArrayList<String>();
        for (DynamicObject entity : toDealEntityMap.values()) {
            ArrayList<Object> mainPks = new ArrayList<Object>();
            for (DynamicObject row : entity.getDynamicObjectCollection(this.KEY_MainEntry)) {
                material = row.getDynamicObject(matProp);
                if (!material.getBoolean("enableserial")) continue;
                for (DynamicObject snRow : row.getDynamicObjectCollection(this.KEY_BillSnEntry)) {
                    snNums.add(snRow.getString(snProp));
                }
                for (DynamicObject main : this.getSnMainFilesByNums(snNums)) {
                    snMatMap.put(main.getString("material.masterid") + main.getString("number"), main);
                    mainPks.add(main.getPkValue());
                }
            }
            this.billMainMap.put(entity.getPkValue(), mainPks);
        }
        return snMatMap;
    }

    private DynamicObject setSnStatus4Data(DynamicObject snMainFile, String operation) {
        snMainFile.set("snstatus", (Object)operation);
        return snMainFile;
    }

    private void setMoveDirect(DynamicObject snEntity, Map<String, String> propMapping, DynamicObject entity, DynamicObject row) {
        String bizdirection = this.getDirection(entity);
        if ("0".equals(bizdirection)) {
            snEntity.set("movedirect", (Object)MoveDirectEnum.SRC.getValue());
        } else {
            snEntity.set("movedirect", (Object)MoveDirectEnum.DES.getValue());
        }
    }

    private boolean isException(DynamicObject entity) {
        return entity.getDataEntityType().getName().equals("im_transinbill") || entity.getDataEntityType().getName().equals("im_transoutbill");
    }

    private String buildMsg(String prop) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5b57\u6bb5\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u5e8f\u5217\u53f7\u4fdd\u5b58\u670d\u52a1\u53c2\u6570\u914d\u7f6e\u3002", (String)"SnMainFileProcessor_7", (String)"bd-sbd-business", (Object[])new Object[0]), prop);
    }

    private void setEntityData(Map<String, String> propMapping, DynamicObject toDelaEntity, DynamicObject entity, DynamicObject mainEntry, DynamicObject snEntry) {
        for (Map.Entry<String, String> propMappingEntry : propMapping.entrySet()) {
            String key = propMappingEntry.getKey();
            String prop = propMappingEntry.getValue();
            if (prop.indexOf(46) == -1) {
                toDelaEntity.set(key, entity.get(prop));
                continue;
            }
            if (prop.indexOf(this.KEY_BillSnEntry) == -1) {
                Object value = null;
                if (key.equals("material")) {
                    prop = prop.substring(prop.indexOf(46) + 1) + ".masterid_id";
                    value = mainEntry.get(prop);
                } else {
                    value = mainEntry.get(prop.substring(prop.indexOf(46) + 1));
                }
                toDelaEntity.set(key, value);
                continue;
            }
            int index = prop.indexOf(46, prop.indexOf(46) + 1);
            if (index == -1) {
                throw new KDBizException(this.buildMsg(prop));
            }
            toDelaEntity.set(key, snEntry.get(prop.substring(index + 1)));
        }
    }

    private Map<String, DynamicObject> getEnableSnEntities(DynamicObject[] dataEntities, String number, String matProp) {
        HashMap<String, DynamicObject> snMatMap = new HashMap<String, DynamicObject>();
        for (DynamicObject entity : dataEntities) {
            if (!this.isEnableSerial(entity, matProp)) continue;
            snMatMap.put(entity.getString(number), entity);
        }
        return snMatMap;
    }

    private List<DynamicObject> getEnableSnEntities(DynamicObject[] dataEntities, String matProp) {
        ArrayList<DynamicObject> arrays = new ArrayList<DynamicObject>();
        for (DynamicObject entity : dataEntities) {
            if (!this.isEnableSerial(entity, matProp)) continue;
            arrays.add(entity);
        }
        return arrays;
    }

    private boolean isEnableSerial(DynamicObject entity, String matProp) {
        DynamicObjectCollection entry = entity.getDynamicObjectCollection(this.KEY_MainEntry);
        for (DynamicObject row : entry) {
            if (!row.getDynamicObject(matProp).getBoolean("enableserial")) continue;
            return true;
        }
        return false;
    }

    private String[] getRestoreCols() {
        return new String[]{"lot", "srcsupplier", "stockdate", "suppliersn", "descustomer", "shipmentdate", "keeporg", "warehouse", "location", "dept", "user", "bizhappendate", "comment", "auxpty"};
    }

    private DynamicObject[] getSnMainFile(List<Object> snPks) {
        return BusinessDataServiceHelper.load((Object[])snPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_snmainfile"));
    }

    private String getDirection(DynamicObject dataEntity) {
        if (dataEntity.getDataEntityType().getName().equals("im_materialreqbill") || dataEntity.getDataEntityType().getName().equals("im_initbill") || dataEntity.getDataEntityType().getName().equals("im_transapply")) {
            return "0";
        }
        DynamicObject invscheme = dataEntity.getDynamicObject("invscheme");
        if (invscheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u4e8b\u52a1", (String)"SnMainFileProcessor_8", (String)"bd-sbd-business", (Object[])new Object[0]));
        }
        invscheme = BusinessDataServiceHelper.loadSingle((Object)invscheme.getPkValue(), (String)"im_invscheme");
        DynamicObject transceiverType = invscheme.getDynamicObject("transceivertype");
        String bizdirection = transceiverType.getString("bizdirection");
        return bizdirection;
    }
}

