/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.utils.MaterialStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasedataController;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MaterialBizInfoFilterController
extends AbstractBasedataController {
    private static final long serialVersionUID = 2521256675346809721L;
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String ENTITY_CUSTOMER = "bd_customer";
    public static final String ENTITY_SUPPLIER = "bd_supplier";
    public static final String ENTITY_MATERIAL = "bd_material";
    public static final String ENTITY_GROUPDETAIL = "groupdetail";
    public static final String ENTITY_GROUPSTANDARD = "groupstandard";
    public static final String ENTITY_GROUP = "group";
    public static final String PROP_ID = "id";
    public static final String PROP_STANDARD = "standard";
    public static final String PROP_PARENT = "parent";
    public static final String PROP_GROUP = "group";
    public static final String PROP_SUPPLIER = "supplier";
    public static final String PROP_CUSTOMER = "customer";
    public static final String PROP_MATERIAL = "material";
    public static final String PROP_LONGNUMBER = "longnumber";
    public static final String PROP_PURPOSE = "purpose";
    public static final String CP_GROUPSTANDARD = "groupStandard";
    private static final String MASTERID = "masterid";
    public static final String ISSHOWALLNOORG = "isShowAllNoOrg";
    public static final String ISSHOWALLNOORG_TRUE = "true";
    public static final String DEFGROUPSTANDARD = "730148448254487552";
    public static final String BASEDATA_FUZZY = "FUZZY";

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        ListShowParameter listShowParameter = event.getListShowParameter();
        String entityNumber = listShowParameter.getBillFormId();
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        String masterDataEntity = FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId();
        QFilter filter = this.genRefreshFilter(ROOTNODEID, masterDataEntity, listShowParameter);
        if (filter == null) {
            return;
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        List listFilters = listShowParameter.getListFilterParameter().getQFilters();
        qfilters.addAll(listFilters);
        qfilters.add(filter);
        ORM orm = ORM.create();
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), masterDataEntity, PROP_ID, qfilters.toArray(new QFilter[0]), null);){
            for (Row row : ds) {
                if (row.getLong(PROP_ID) == null) continue;
                ids.add(row.getLong(PROP_ID));
            }
        }
        QFilter qf = new QFilter(PROP_ID, "in", ids);
        event.addQFilter(qf);
    }

    private QFilter genRefreshFilter(String nodeId, String entityNumber, ListShowParameter param) {
        String entity = ENTITY_MATERIAL;
        String selectfield = "";
        if (entity.equals(ENTITY_MATERIAL)) {
            selectfield = PROP_MATERIAL;
        }
        QFilter qFilter = null;
        String defGroupStandard = this.getDefGroupStandard(param, entity);
        Set<Long> useOrgs = this.getCreateOrgs(param, entity, defGroupStandard);
        String alias = BusinessDataServiceHelper.newDynamicObject((String)entity).getDataEntityType().getAlias();
        Set groupOrgs = new HashSet();
        Set groupStandards = new HashSet<Long>();
        if (!useOrgs.isEmpty()) {
            groupOrgs = MaterialStandardUtils.getGroupOrgId((String)entityNumber, useOrgs);
            groupStandards = MaterialStandardUtils.getGroupStandard((String)entity, useOrgs, (boolean)true);
        }
        if (groupStandards == null || groupStandards.size() == 0) {
            groupStandards = new HashSet(1);
            groupStandards.add(Long.valueOf(DEFGROUPSTANDARD));
        }
        StringBuilder useTable = new StringBuilder();
        useTable.append(" right join ").append(alias).append(ENTITY_GROUPDETAIL).append(" ur on ur.f").append(selectfield).append("id = ").append(entityNumber).append(".f").append(MASTERID);
        ArrayList<Long> paramList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)defGroupStandard)) {
            useTable.append(" and ur.fstandardId = ? ");
            paramList.add(Long.valueOf(defGroupStandard));
        } else {
            useTable.append(" and ur.fstandardId in ( ");
            for (int i = 0; i < groupStandards.size(); ++i) {
                if (i == 0) {
                    useTable.append('?');
                    continue;
                }
                useTable.append(",?");
            }
            useTable.append(" ) ");
            paramList.addAll(groupStandards);
        }
        String isShowAllNoOrg = (String)param.getCustomParam(ISSHOWALLNOORG);
        if (!ISSHOWALLNOORG_TRUE.equals(isShowAllNoOrg)) {
            StringBuilder useOrgStr = new StringBuilder();
            if (groupOrgs != null && groupOrgs.size() >= 1) {
                for (Long useOrg : groupOrgs) {
                    if (StringUtils.isBlank((CharSequence)useOrgStr)) {
                        useOrgStr.append(useOrg);
                        continue;
                    }
                    useOrgStr.append(',').append(useOrg);
                }
                if (StringUtils.isNotBlank((CharSequence)useOrgStr)) {
                    useTable.append(" and  ur.fcreateorgId in ( ").append((CharSequence)useOrgStr).append(')');
                }
            }
        }
        qFilter = QFilter.joinSQL((String)entityNumber, (String)useTable.toString(), (Object[])paramList.toArray(new Object[0]));
        return qFilter;
    }

    private String getDefGroupStandard(ListShowParameter param, String entity) {
        String defGroupStandard = "";
        if (!param.isLookUp()) {
            return defGroupStandard;
        }
        if (param.getCustomParam(CP_GROUPSTANDARD) != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam(CP_GROUPSTANDARD).toString())) {
            defGroupStandard = param.getCustomParam(CP_GROUPSTANDARD).toString();
            boolean exists = QueryServiceHelper.exists((String)(entity + ENTITY_GROUPSTANDARD), (Object)defGroupStandard);
            if (!exists) {
                defGroupStandard = "";
            }
        }
        return defGroupStandard;
    }

    private Set<Long> getCreateOrgs(ListShowParameter param, String entity, String defGroupStandard) {
        String createOrg = null;
        HashSet<Long> createOrgs = null;
        if (param.isLookUp()) {
            long createOrgId;
            Map customParams = param.getCustomParams();
            List creates = (List)customParams.get("useOrgs");
            if (creates != null && !creates.isEmpty()) {
                createOrgs = new HashSet(creates);
            }
            if (StringUtils.isBlank((CharSequence)(createOrg = (String)customParams.get("useOrg"))) && (createOrgId = param.getUseOrgId()) != 0L) {
                createOrg = createOrgId + "";
            }
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                String groupStandard = null;
                groupStandard = StringUtils.isBlank((CharSequence)defGroupStandard) ? DEFGROUPSTANDARD : defGroupStandard;
                if (StringUtils.isNotBlank((CharSequence)defGroupStandard)) {
                    DynamicObject standard = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(groupStandard), (String)"bd_materialgroupstandard", (String)"createorg");
                    createOrg = standard.getDynamicObject("createorg").getPkValue().toString();
                }
            }
        }
        if (createOrgs == null || createOrgs.isEmpty()) {
            createOrgs = new HashSet<Long>();
            if (StringUtils.isBlank(createOrg)) {
                return createOrgs;
            }
            createOrgs.add(Long.valueOf(createOrg));
        }
        return createOrgs;
    }
}

