/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bd.sbd.formplugin.MaterialMftInfoWarehouseHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MasterBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class MaterialMftInfoPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MasterBasedataEdit materialEdit = (MasterBasedataEdit)this.getView().getControl("masterid");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit mftunitEdit = (UnitEdit)this.getView().getControl("mftunit");
        mftunitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit outwarehouseEdit = (BasedataEdit)this.getView().getControl("outwarehouse");
        outwarehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouseEdit = (BasedataEdit)this.getView().getControl("warehouse");
        warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit supplyorgEdit = (BasedataEdit)this.getView().getControl("supplyorgunitid");
        supplyorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inwarorg = (BasedataEdit)this.getView().getControl("inwarorg");
        inwarorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inwarehouse = (BasedataEdit)this.getView().getControl("inwarehouse");
        inwarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit location = (BasedataEdit)this.getView().getControl("location");
        location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit minBatchUnit = (UnitEdit)this.getView().getControl("minbatchunit");
        minBatchUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inwarelocation = (BasedataEdit)this.getView().getControl("inwarelocation");
        inwarelocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit outwarelocation = (BasedataEdit)this.getView().getControl("outwarelocation");
        outwarelocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bomversionrule = (BasedataEdit)this.getView().getControl("bomversionrule");
        bomversionrule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if ("queryversion".equals(key)) {
            RequestContext requestContext = RequestContext.get();
            long userID = Long.parseLong(requestContext.getUserId());
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)"pdm_manuversion", (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.valueOf(((DynamicObject)this.getModel().getValue("createorg")).getPkValue().toString()))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7:[%s]\u7684\u751f\u4ea7\u7248\u672c\u67e5\u770b\u6743\u9650\u3002", (String)"MaterialMftInfoPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue("createorg")).get("name")));
                return;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pdm_manuversion", (boolean)false);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("createorg.id", "=", ((DynamicObject)this.getModel().getValue("createorg")).getPkValue()));
            filters.add(new QFilter("material.id", "=", this.getModel().getDataEntity().getPkValue()));
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"masterid", (CharSequence)fieldKey)) {
            QFilter enableproductFilter = new QFilter("enableproduct", "=", (Object)Boolean.TRUE);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter auditFilter = new QFilter("status", "=", (Object)"C");
            QFilter configFilter = new QFilter("configproperties", "<>", (Object)"3");
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)(createOrg != null ? Long.parseLong(createOrg.getPkValue().toString()) : 0L));
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(enableproductFilter, enableFilter, auditFilter, orgIdFilter, configFilter));
        } else if (StringUtils.equals((CharSequence)"outwarehouse", (CharSequence)fieldKey)) {
            if (this.checkFieldValueNull("outstorageunit")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8c03\u51fa\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MaterialMftInfoPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject outstorageunit = (DynamicObject)this.getModel().getValue("outstorageunit");
            QFilter orgFilter = new QFilter("org.id", "=", outstorageunit.getPkValue());
            QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"B");
            QFilter startstatusFilter = new QFilter("startstatus", "=", (Object)"B");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection col = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{orgFilter, initstatusFilter, startstatusFilter, enableFilter});
            ArrayList<Object> obj = new ArrayList<Object>(col.size());
            for (int i = 0; i < col.size(); ++i) {
                obj.add(((DynamicObject)col.get(i)).get("warehouse.id"));
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", obj));
        } else if (StringUtils.equals((CharSequence)"warehouse", (CharSequence)fieldKey)) {
            if (this.checkFieldValueNull("supplyorgunitid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u8d27\u7ec4\u7ec7\u3002", (String)"MaterialMftInfoPlugin_5", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject supplyorgunitid = (DynamicObject)this.getModel().getValue("supplyorgunitid");
            QFilter orgFilter = new QFilter("org.id", "=", supplyorgunitid.getPkValue());
            QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"B");
            QFilter startstatusFilter = new QFilter("startstatus", "=", (Object)"B");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection col = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{orgFilter, initstatusFilter, startstatusFilter, enableFilter});
            ArrayList<Object> obj = new ArrayList<Object>(col.size());
            for (int i = 0; i < col.size(); ++i) {
                obj.add(((DynamicObject)col.get(i)).get("warehouse.id"));
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", obj));
        } else if (StringUtils.equals((CharSequence)"mftunit", (CharSequence)fieldKey)) {
            if (this.checkFieldValueNull("masterid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialMftInfoPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject matDO = (DynamicObject)this.getModel().getValue("masterid");
            DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
            Long mid = matDO.getLong("id");
            Long buid = baseunitDO.getLong("id");
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1", (Boolean)Boolean.FALSE);
            QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
            showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
        } else if (StringUtils.equals((CharSequence)"supplyorgunitid", (CharSequence)fieldKey)) {
            if (this.getModel().getValue("createorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u4fe1\u606f\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"MaterialMftInfoPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            DynamicObject obj = (DynamicObject)this.getModel().getValue("createorg");
            List idList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)((Long)obj.getPkValue()));
            if (idList.isEmpty() || idList.size() == 1 && idList.contains(obj.getPkValue())) {
                return;
            }
            if (obj.getBoolean("fisinventory")) {
                idList.add((Long)obj.getPkValue());
            }
            showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
        } else if (StringUtils.equals((CharSequence)"inwarorg", (CharSequence)fieldKey)) {
            List<Long> inwareOrgFilter;
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
            if (createorg != null && !(inwareOrgFilter = this.getInwareOrgFilter((Long)createorg.getPkValue())).isEmpty()) {
                showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", inwareOrgFilter));
            }
        } else if (StringUtils.equals((CharSequence)"inwarehouse", (CharSequence)fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("inwarorg");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"MaterialMftInfoPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long[] warehouseids = MaterialMftInfoWarehouseHelper.getAllWarehouseIDs(Long.parseLong(org.getPkValue().toString()));
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", (Object)warehouseids);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else if (StringUtils.equals((CharSequence)"location", (CharSequence)fieldKey)) {
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
            if (warehouse != null) {
                this.setLocationFilter(warehouse.getLong("id"), e);
            }
        } else if (StringUtils.equals((CharSequence)"inwarelocation", (CharSequence)fieldKey)) {
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("inwarehouse");
            if (warehouse != null) {
                this.setLocationFilter(warehouse.getLong("id"), e);
            }
        } else if (StringUtils.equals((CharSequence)"outwarelocation", (CharSequence)fieldKey)) {
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("outwarehouse");
            if (warehouse != null) {
                this.setLocationFilter(warehouse.getLong("id"), e);
            }
        } else if (StringUtils.equals((CharSequence)"bomversionrule", (CharSequence)fieldKey)) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("multype", "like", (Object)"%A%");
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else if (StringUtils.equals((CharSequence)"minbatchunit", (CharSequence)fieldKey)) {
            if (this.checkFieldValueNull("masterid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialMftInfoPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (this.checkFieldValueNull("mftunit")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5f53\u524d\u7269\u6599\u7684\u751f\u4ea7\u8ba1\u91cf\u5355\u4f4d\u662f\u5426\u6b63\u786e\u3002", (String)"MaterialMftInfoPlugin_6", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long mid = ((DynamicObject)this.getModel().getValue("masterid")).getLong("id");
            Long buid = ((DynamicObject)this.getModel().getValue("mftunit")).getLong("id");
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1", (Boolean)Boolean.TRUE);
            QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
            showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
        }
    }

    private boolean checkFieldValueNull(String fieldname) {
        Object value = this.getModel().getValue(fieldname);
        if (value != null) {
            String valuestr;
            if (value instanceof DynamicObject) {
                DynamicObject doValue = (DynamicObject)value;
                return doValue.getLong("id") <= 0L;
            }
            return value instanceof String && (StringUtils.isEmpty((CharSequence)(valuestr = (String)value)) || StringUtils.equalsIgnoreCase((CharSequence)valuestr, (CharSequence)"none"));
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "masterid": {
                this.change4material(newObj);
                break;
            }
            case "warehouse": {
                this.change4Stock(newObj, "location");
                break;
            }
            case "inwarehouse": {
                this.change4Stock(newObj, "inwarelocation");
                break;
            }
            case "outwarehouse": {
                this.change4Stock(newObj, "outwarelocation");
                break;
            }
            case "supplyorgunitid": {
                this.change4StockOrg(newObj, "warehouse");
                break;
            }
            case "inwarorg": {
                this.change4StockOrg(newObj, "inwarehouse");
                break;
            }
            case "outstorageunit": {
                this.change4StockOrg(newObj, "outwarehouse");
                break;
            }
            case "considerminbatch": {
                this.change4ninbatch(newObj);
            }
        }
    }

    private void change4ninbatch(Object newValue) {
        if (newValue instanceof Boolean) {
            Boolean considerminbatch = (Boolean)newValue;
            if (considerminbatch.booleanValue()) {
                TextEdit edit = (TextEdit)this.getView().getControl("minbatchnum");
                edit.setMustInput(true);
                UnitEdit editmin = (UnitEdit)this.getView().getControl("minbatchunit");
                editmin.setMustInput(true);
            } else {
                TextEdit edit = (TextEdit)this.getView().getControl("minbatchnum");
                edit.setMustInput(false);
                UnitEdit editmin = (UnitEdit)this.getView().getControl("minbatchunit");
                editmin.setMustInput(false);
            }
        }
    }

    private void change4material(Object newObj) {
        if (newObj == null) {
            this.getModel().setValue("minbatchunit", null);
            this.getModel().setValue("mftunit", null);
            this.getModel().setValue("name", null);
            this.getModel().setValue("number", null);
        } else {
            DynamicObject mate = (DynamicObject)newObj;
            DynamicObject baseunit = mate.getDynamicObject("baseunit");
            if (baseunit != null) {
                this.getModel().setValue("minbatchunit", baseunit.get("id"));
                this.getModel().setValue("mftunit", baseunit.get("id"));
                this.getModel().setValue("name", mate.get("name"));
                this.getModel().setValue("number", mate.get("number"));
            }
        }
    }

    private void change4Stock(Object newValue, String locationField) {
        if (newValue != null) {
            long warehouseId = (Long)((DynamicObject)newValue).getPkValue();
            DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouseId, (String)"bd_warehouse");
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getModel().setValue(locationField, null);
            if (isopenlocation) {
                this.getView().setEnable(Boolean.TRUE, new String[]{locationField});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{locationField});
            }
        } else {
            this.getModel().setValue(locationField, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{locationField});
        }
    }

    private void change4StockOrg(Object newValue, String stockfield) {
        this.getModel().setValue(stockfield, null);
    }

    private List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (this.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    private boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    public void afterCreateNewData(EventObject e) {
        this.lockLocation();
        this.getDefaultBOMRuleVer();
    }

    public void afterBindData(EventObject e) {
        this.lockLocation();
        if (this.getModel().getValue("masterid") != null) {
            DynamicObject masterid = (DynamicObject)this.getModel().getValue("masterid");
            this.getModel().setValue("material", (Object)((Long)masterid.getPkValue()));
            this.getModel().setDataChanged(false);
        }
    }

    private void lockLocation() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"location", "inwarelocation", "outwarelocation"});
    }

    private void setLocationFilter(Long orgid, BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>();
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : col) {
            DynamicObject location = dynamicObject.getDynamicObject("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        if (!locationList.isEmpty()) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", locationList);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void getDefaultBOMRuleVer() {
        QFilter qFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bomversionrule_new", (String)"id", (QFilter[])qFilter.toArray());
        if (rule != null) {
            this.getModel().setValue("bomversionrule", rule.getPkValue());
        }
    }
}

