/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.StatusEnum;
import kd.bd.sbd.servicehelper.BDServiceHelper;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.MasterBasedataEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialPurInfoPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String CHARACTERISTIC = "3";
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final Map<String, String> qtyKeyMap = new HashMap<String, String>(){
        {
            this.put("maxbillqty", "maxbillbaseqty");
            this.put("minbillqty", "minbillbaseqty");
            this.put("packingqty", "packingbaseqty");
        }
    };

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("masterid") != null) {
            DynamicObject masterid = (DynamicObject)this.getModel().getValue("masterid");
            this.getModel().setValue("material", (Object)((Long)masterid.getPkValue()));
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MasterBasedataEdit materialEdit = (MasterBasedataEdit)this.getView().getControl("masterid");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit purUnitEdit = (UnitEdit)this.getView().getControl("purchaseunit");
        purUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit purPriceUnitEdit = (UnitEdit)this.getView().getControl("purchasepriceunit");
        purPriceUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "masterid": {
                this.change4material(newValue);
                break;
            }
            case "iscontrolqty": {
                this.change4IsControlQty(newValue);
                break;
            }
            case "iscontrolday": {
                this.change4IsControlDay(newValue);
                break;
            }
            case "packingqty": 
            case "minbillqty": 
            case "maxbillqty": {
                this.change4Qty(key, newValue, oldValue);
                break;
            }
            case "purchaseunit": {
                this.changePurUnit(key, newValue, oldValue);
                break;
            }
        }
    }

    private void changePurUnit(String key, Object newValue, Object oldValue) {
        if (newValue instanceof DynamicObject) {
            Object masterid = this.getModel().getValue("masterid");
            Object baseUnit = this.getModel().getValue("baseunit");
            if (baseUnit != null && masterid != null) {
                for (Map.Entry<String, String> entry : qtyKeyMap.entrySet()) {
                    String qtyField = entry.getKey();
                    BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyField);
                    DynamicObject unit = (DynamicObject)newValue;
                    BigDecimal convertSrcQty = qty.setScale(this.getPrecision(unit), this.getPrecisionType(unit));
                    this.getModel().setValue(qtyField, (Object)convertSrcQty);
                }
            }
        }
    }

    private void change4Qty(String key, Object newValue, Object oldValue) {
        Object masterid = this.getModel().getValue("masterid");
        Object baseUnit = this.getModel().getValue("baseunit");
        Object purUnit = this.getModel().getValue("purchaseunit");
        if (masterid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialPurInfoPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (newValue != null && baseUnit != null && masterid != null && purUnit != null) {
            BigDecimal targetQty = BaseDataServiceHelper.getDesmuCount((Long)((Long)((DynamicObject)masterid).getPkValue()), (Long)((Long)((DynamicObject)purUnit).getPkValue()), (BigDecimal)((BigDecimal)newValue), (Long)((Long)((DynamicObject)baseUnit).getPkValue()));
            try {
                this.getModel().setValue(qtyKeyMap.get(key), (Object)targetQty);
            }
            catch (KDBizException e) {
                this.getModel().setValue(key, oldValue);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "masterid": {
                QFilter purMaterialFilter = new QFilter("enablepur", "=", (Object)Boolean.TRUE);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter auditFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                QFilter configPropertiesFilter = new QFilter("configproperties", "!=", (Object)CHARACTERISTIC);
                DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
                QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)(createOrg != null ? Long.parseLong(createOrg.getPkValue().toString()) : 0L));
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(purMaterialFilter);
                list.add(enableFilter);
                list.add(auditFilter);
                list.add(configPropertiesFilter);
                list.add(orgIdFilter);
                showParameter.getListFilterParameter().getQFilters().addAll(list);
                break;
            }
            case "purchaseunit": {
                if (this.getModel().getValue("masterid") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialPurInfoPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject matDO = (DynamicObject)this.getModel().getValue("masterid");
                DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
                Long mid = matDO.getLong("id");
                Long buid = baseunitDO.getLong("id");
                List fixconunitlist = BDServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1");
                QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
                showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
                break;
            }
            case "purchasepriceunit": {
                if (this.getModel().getValue("masterid") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MaterialPurInfoPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject matDO = (DynamicObject)this.getModel().getValue("masterid");
                DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
                Long mid = matDO.getLong("id");
                Long buid = baseunitDO.getLong("id");
                List fixconunitlist = BDServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"");
                QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
                showParameter.getListFilterParameter().getQFilters().add(fixconFilter);
                break;
            }
        }
    }

    private void change4material(Object newValue) {
        IDataModel bill = this.getModel();
        if (newValue == null) {
            bill.setValue("purchaseunit", null);
            bill.setValue("purchasepriceunit", null);
            bill.setValue("material", null);
            bill.setValue("baseunit", null);
        } else {
            Long materialid = (Long)((DynamicObject)newValue).getPkValue();
            bill.setValue("material", (Object)materialid);
            DynamicObject baseUnit = ((DynamicObject)newValue).getDynamicObject("baseunit");
            if (baseUnit != null) {
                Long baseUnitID = (Long)baseUnit.getPkValue();
                bill.setValue("purchaseunit", (Object)baseUnitID);
                bill.setValue("purchasepriceunit", (Object)baseUnitID);
                bill.setValue("baseunit", (Object)baseUnitID);
            }
        }
        bill.setValue("maxbillbaseqty", (Object)BigDecimal.ZERO);
        bill.setValue("maxbillqty", (Object)BigDecimal.ZERO);
        bill.setValue("minbillbaseqty", (Object)BigDecimal.ZERO);
        bill.setValue("minbillqty", (Object)BigDecimal.ZERO);
        bill.setValue("packingbaseqty", (Object)BigDecimal.ZERO);
        bill.setValue("packingqty", (Object)BigDecimal.ZERO);
    }

    private void change4IsControlQty(Object newValue) {
        boolean IsControlQty;
        IDataModel bill = this.getModel();
        if (newValue instanceof Boolean && !(IsControlQty = ((Boolean)newValue).booleanValue())) {
            bill.setValue("receiveratedown", (Object)BigDecimal.ZERO);
            bill.setValue("receiverateup", (Object)BigDecimal.ZERO);
        }
    }

    private void change4IsControlDay(Object newValue) {
        boolean IsControlDay;
        IDataModel bill = this.getModel();
        if (newValue instanceof Boolean && !(IsControlDay = ((Boolean)newValue).booleanValue())) {
            bill.setValue("receivedayup", (Object)0);
            bill.setValue("receivedaydown", (Object)0);
        }
    }

    private int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    private int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }
}

