/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SelectFieldList
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener {
    public static final String FormId_SelectField = "bd_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    private static final String CacheKey_SelectedNodeIds = "nodeids";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            TreeNode tn = this.getTreeNode();
            TreeNode cur = tn.getTreeNode(currNodeId, 10);
            if (cur != null && cur.getChildren() != null && cur.getChildren().size() > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8282\u70b9\u3002", (String)"SelectFieldList_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                currNodeId = this.buildReallyTreeNodeId(currNodeId, tn);
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        TreeNode tn = this.getTreeNode();
        currNodeId = this.buildCurTreeNodeId(currNodeId, tn);
        this.getPageCache().put("nodeids", currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        TreeNode tn = this.getTreeNode();
        TreeNode cur = tn.getTreeNode(currNodeId, 10);
        if (cur != null && cur.getChildren() != null && cur.getChildren().size() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8282\u70b9\u3002", (String)"SelectFieldList_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        }
        currNodeId = this.buildCurTreeNodeId(currNodeId, tn);
        currNodeId = this.buildReallyTreeNodeId(currNodeId, tn);
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put("nodeids", cacheNodeIds);
    }

    private String buildCurTreeNodeId(String currNodeId, TreeNode tn) {
        int endIndex = currNodeId.indexOf(46);
        if (endIndex > 0) {
            String nodeKey = currNodeId.substring(0, endIndex);
            String parentNodeId = tn.getTreeNode(nodeKey, 10).getParentid();
            currNodeId = parentNodeId + "." + currNodeId;
        }
        return currNodeId;
    }

    private String buildReallyTreeNodeId(String currNodeId, TreeNode tn) {
        if (currNodeId.indexOf(46) < 0) {
            String parentNodeId = tn.getTreeNode(currNodeId, 10).getParentid();
            currNodeId = parentNodeId + "." + currNodeId;
        }
        return currNodeId;
    }

    private TreeNode getTreeNode() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getView().getFormShowParameter().getCustomParams().get(CustParamKey_TreeNodes).toString(), TreeNode.class);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
            String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
            if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
                this.getPageCache().put("nodeids", cacheNodeIds);
                String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (String nodeId : arr) {
                    TreeNode node = rootNode.getTreeNode(nodeId, 5);
                    if (node == null) continue;
                    selectedNodes.add(node);
                }
                if (selectedNodes.size() > 0) {
                    tree.checkNodes(selectedNodes);
                }
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"SelectFieldList_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }
}

