/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class WarehouseFormPlugin
extends AbstractBasePlugIn
implements IDataModelChangeListener {
    private static final String algoKey = WarehouseFormPlugin.class.getName();
    private static final String ISOPENLOCATION_CHANGE = "isopenlocationchange";
    private static final String ENTRYFLEXID = "advconap";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isopenlocation = Boolean.parseBoolean(this.getModel().getValue("isopenlocation").toString());
        this.getView().setEnable(Boolean.valueOf(isopenlocation), new String[]{ENTRYFLEXID});
        BasedataEdit location = (BasedataEdit)this.getControl("location");
        location.setMustInput(isopenlocation);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnaddrow", "btndelrow"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int index = valueSet[0].getRowIndex();
        switch (propName) {
            case "isopenlocation": {
                this.isOpenLocationChange(newValue);
                break;
            }
            case "location": {
                this.isLocationChange(oldValue, index);
                break;
            }
        }
    }

    private void isLocationChange(Object oldValue, int index) {
        if (oldValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject location = (DynamicObject)oldValue;
        QFilter locationFilter = new QFilter("location", "=", location.getPkValue());
        DataSet invDataSet = this.getInvDataSet(locationFilter);
        if (invDataSet.hasNext()) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u7f16\u8f91\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4ed3\u4f4d\u5df2\u6709\u5e93\u5b58\uff0c\u8bf7\u6d88\u8017\u540e\u91cd\u8bd5\u3002", (String)"WarehouseFormPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            this.notifyMsg(msg, true);
            model.beginInit();
            model.setValue("location", location.getPkValue(), index);
            model.endInit();
            view.updateView("location", index);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            int[] index = e.getRowIndexs();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i : index) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                long id = dynamicObject.getLong("id");
                if (id == 0L) continue;
                list.add(i);
            }
            Integer[] idx = list.toArray(new Integer[0]);
            DataSet invDataSet = this.checkLocationInv(idx);
            if (invDataSet == null) {
                return;
            }
            if (invDataSet.hasNext()) {
                e.setCancel(true);
                if (index.length == 1) {
                    String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4ed3\u4f4d\u5df2\u6709\u5e93\u5b58\uff0c\u8bf7\u6d88\u8017\u540e\u91cd\u8bd5\u3002", (String)"WarehouseFormPlugin_5", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                    this.notifyMsg(msg, true);
                } else {
                    this.notifyLocationMsg(invDataSet, true);
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObjectCollection locationEntry;
        boolean isopenlocation;
        super.afterDeleteRow(e);
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName()) && (isopenlocation = Boolean.parseBoolean(this.getModel().getValue("isopenlocation").toString())) && (locationEntry = this.getModel().getEntryEntity("entryentity")) != null && locationEntry.size() < 1) {
            this.getModel().createNewEntryRow("entryentity");
        }
    }

    private DataSet checkLocationInv(Integer[] index) {
        DynamicObjectCollection locationEntry = this.getModel().getEntryEntity("entryentity");
        if (locationEntry == null || locationEntry.size() == 0) {
            return null;
        }
        ArrayList<Object> locationIds = new ArrayList<Object>(16);
        for (Integer i : index) {
            DynamicObject entry = (DynamicObject)locationEntry.get(i.intValue());
            DynamicObject location = (DynamicObject)entry.get("location");
            if (location == null) continue;
            locationIds.add(location.getPkValue());
        }
        QFilter locationFilter = new QFilter("location", "in", locationIds);
        DataSet invDataSet = this.getInvDataSet(locationFilter);
        return invDataSet;
    }

    private void isOpenLocationChange(Object newValue) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BasedataEdit location = (BasedataEdit)this.getControl("location");
        boolean isOpenLocation = Boolean.parseBoolean(newValue.toString());
        DynamicObjectCollection locationEntry = this.getModel().getEntryEntity("entryentity");
        if (isOpenLocation) {
            this.setLocationEnable(false);
            String warehouseNum = (String)model.getValue("number");
            Object masterid = model.getValue("masterid");
            QFilter warehouseFilter = new QFilter("number", "=", (Object)warehouseNum).and("masterid", "=", masterid);
            DynamicObject warehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])warehouseFilter.toArray());
            if (warehouse == null) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5f00\u542f\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u5148\u4fdd\u5b58\u4ed3\u5e93\u3002", (String)"WarehouseFormPlugin_8", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                this.notifyMsg(msg, false);
                return;
            }
            DataSet invDataSet = this.getInvDataSet(new QFilter("location", "=", (Object)0), warehouse.getPkValue());
            if (invDataSet.hasNext()) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5f00\u542f\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4ed3\u5e93\u5df2\u6709\u5e93\u5b58\uff0c\u8bf7\u6d88\u8017\u540e\u91cd\u8bd5\u3002", (String)"WarehouseFormPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
                this.notifyMsg(msg, false);
                return;
            }
            view.setEnable(Boolean.TRUE, new String[]{ENTRYFLEXID});
            if (locationEntry == null || locationEntry.size() == 0) {
                model.createNewEntryRow("entryentity");
            }
            location.setMustInput(true);
        } else {
            this.setLocationEnable(true);
            HashSet<Integer> emptyRows = new HashSet<Integer>(16);
            List<Long> locationIds = this.getLocationIds(emptyRows);
            QFilter locationFilter = new QFilter("location", "in", locationIds);
            DataSet invDataSet = this.getInvDataSet(locationFilter);
            if (invDataSet.hasNext()) {
                this.notifyLocationMsg(invDataSet, false);
                return;
            }
            location.setMustInput(false);
            view.setEnable(Boolean.FALSE, new String[]{ENTRYFLEXID});
            if (!emptyRows.isEmpty()) {
                this.getModel().deleteEntryRows("entryentity", emptyRows.stream().mapToInt(i -> i).toArray());
            }
            if ((locationEntry = this.getModel().getEntryEntity("entryentity")) != null && locationEntry.size() > 0) {
                view.showConfirm(ResManager.loadKDString((String)"\u4e0d\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\u5c06\u6e05\u7a7a\u4ed3\u4f4d\u5206\u5f55,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"WarehouseFormPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ISOPENLOCATION_CHANGE, (IFormPlugin)this));
                return;
            }
        }
    }

    private void setLocationEnable(boolean enable) {
        DynamicObjectCollection locationEntry = this.getModel().getEntryEntity("entryentity");
        int rowCount = locationEntry.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"location"});
        }
    }

    private void notifyMsg(String msg, boolean isOpenLocation) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        view.showErrorNotification(msg);
        model.beginInit();
        model.setValue("isopenlocation", (Object)isOpenLocation);
        model.endInit();
        view.updateView("isopenlocation");
    }

    private void notifyLocationMsg(DataSet invDataSet, boolean delete) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection locationEntry = model.getEntryEntity("entryentity");
        Map<Long, String> locationMap = this.getLocationMap(invDataSet);
        if (locationMap.isEmpty()) {
            return;
        }
        String alertMsg = this.getMsgByLocationMap(locationMap);
        if (locationEntry != null && locationEntry.size() == 1) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5173\u95ed\u4ed3\u4f4d\u7ba1\u7406\uff0c\u4ed3\u4f4d\u5df2\u6709\u5e93\u5b58\uff0c\u8bf7\u6d88\u8017\u540e\u91cd\u8bd5\u3002", (String)"WarehouseFormPlugin_7", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        } else {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5173\u95ed\u4ed3\u4f4d\u7ba1\u7406\uff0c", (String)"WarehouseFormPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            if (delete) {
                msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u4ed3\u4f4d\u7ba1\u7406\uff0c", (String)"WarehouseFormPlugin_6", (String)"bd-sbd-formplugin", (Object[])new Object[0]);
            }
            view.showMessage(String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u4ed3\u4f4d\u5df2\u6709\u5e93\u5b58\uff0c\u8bf7\u6d88\u8017\u540e\u91cd\u8bd5\u3002", (String)"WarehouseFormPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]), msg + locationMap.size()), alertMsg, null);
        }
        model.beginInit();
        model.setValue("isopenlocation", (Object)Boolean.TRUE);
        model.endInit();
        view.updateView("isopenlocation");
    }

    private String getMsgByLocationMap(Map<Long, String> locationMap) {
        StringBuilder alertMsg = new StringBuilder();
        for (Map.Entry<Long, String> entry : locationMap.entrySet()) {
            String msg = entry.getValue();
            if (alertMsg.length() > 0) {
                alertMsg.append("\n");
            }
            alertMsg.append(msg);
        }
        return alertMsg.toString();
    }

    private Map<Long, String> getLocationMap(DataSet invDataSet) {
        HashMap<Long, String> locationMap = new HashMap<Long, String>(16);
        while (invDataSet.hasNext()) {
            Row row = invDataSet.next();
            Long locationId = row.getLong("location");
            String location = row.getString("location.number");
            String locationName = row.getString("location.name");
            String msg = location + " " + locationName;
            locationMap.put(locationId, msg);
        }
        return locationMap;
    }

    private DataSet getInvDataSet(QFilter locationFilter) {
        Object masterid;
        IDataModel model = this.getModel();
        String warehouseNum = (String)model.getValue("number");
        QFilter warehouseFilter = new QFilter("number", "=", (Object)warehouseNum).and("masterid", "=", masterid = model.getValue("masterid"));
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])warehouseFilter.toArray());
        if (warehouse == null) {
            DataSet emptyDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)"id", (QFilter[])new QFilter("1", "!=", (Object)1).toArray(), null);
            return emptyDataSet;
        }
        QFilter qtyFilter = new QFilter("baseqty", "!=", (Object)0);
        qtyFilter.or("qty", "!=", (Object)0);
        qtyFilter.or("qty2nd", "!=", (Object)0);
        QFilter filter = new QFilter("warehouse", "=", warehouse.getPkValue());
        filter.and(qtyFilter).and(locationFilter);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)"location.number,location.name,location", (QFilter[])filter.toArray(), null);
        return queryDataSet;
    }

    private DataSet getInvDataSet(QFilter locationFilter, Object wareHousePk) {
        QFilter qtyFilter = new QFilter("baseqty", "!=", (Object)0);
        qtyFilter.or("qty", "!=", (Object)0);
        qtyFilter.or("qty2nd", "!=", (Object)0);
        QFilter filter = new QFilter("warehouse", "=", wareHousePk);
        filter.and(qtyFilter).and(locationFilter);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_inv_realbalance", (String)"location.number,location.name,location", (QFilter[])filter.toArray(), null);
        return queryDataSet;
    }

    private List<Long> getLocationIds(Set<Integer> emptyRows) {
        ArrayList<Long> locationIds = new ArrayList<Long>(16);
        DynamicObjectCollection locationEntry = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < locationEntry.size(); ++i) {
            DynamicObject location = ((DynamicObject)locationEntry.get(i)).getDynamicObject("location");
            if (location != null) {
                locationIds.add((Long)location.getPkValue());
                continue;
            }
            emptyRows.add(i);
        }
        return locationIds;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if (ISOPENLOCATION_CHANGE.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().deleteEntryData("entryentity");
            } else {
                this.getModel().setValue("isopenlocation", (Object)Boolean.TRUE);
                this.setLocationEnable(Boolean.TRUE);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if ("new".equalsIgnoreCase(op.getOperateKey())) {
            String entity = op.getEntityId();
            this.checkCreateOrg(entity, (EventObject)e);
        }
    }

    private void checkCreateOrg(String entity, EventObject event) {
        int checkPermission;
        DynamicObject createOrgDym = (DynamicObject)this.getModel().getValue("createOrg");
        if (createOrgDym == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"WarehouseFormPluginNoCreateOrg", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            this.setCancelByEvent(event);
            return;
        }
        String userId = RequestContext.get().getUserId();
        long useOrgId = createOrgDym.getLong("id");
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entity);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                appid = met.getAppId();
            }
        }
        if ((checkPermission = PermissionServiceHelper.checkPermission((long)Long.parseLong(userId), (String)"DIM_ORG", (long)useOrgId, (String)appid, (String)entity, (String)"47156aff000000ac")) != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u7981\u6b62\u64cd\u4f5c\u3002", (String)"WarehouseFormPluginCannotOp", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            this.setCancelByEvent(event);
            return;
        }
        List createOrgs = BaseDataServiceHelper.getCreateOrgList((String)entity, (String)appid);
        if (createOrgs.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6743\u521b\u5efa%1$s\u7684\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u529f\u80fd\u6743\u9650\u6216\u8005\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"WarehouseFormPluginCannotCreate", (String)"bd-sbd-formplugin", (Object[])new Object[0]), met.getDisplayName()));
            this.setCancelByEvent(event);
            return;
        }
        if (!createOrgs.contains(useOrgId) && createOrgs.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u521b\u5efa\u57fa\u7840\u6570\u636e\u3002", (String)"WarehouseFormPluginCannotCreBData", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            this.setCancelByEvent(event);
            return;
        }
    }

    private void setCancelByEvent(EventObject event) {
        if (event instanceof BeforeDoOperationEventArgs) {
            BeforeDoOperationEventArgs eventObj = (BeforeDoOperationEventArgs)event;
            eventObj.setCancel(true);
        }
    }
}

