/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.dataconfig;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;

public class DataChangeEditPlugin
extends AbstractBillPlugIn {
    private static final String[] SELECT_FIELDS = new String[]{"id", "param", "entryentity.mustinput", "classpath", "appid", "servicename", "methodname", "entryentity.enabled", "entryentity.editenabled", "entryentity.submitenabled", "entryentity.auditenabled", "entryentity.vinit", "entryentity.vnew", "entryentity.vedit", "entryentity.vview", "entryentity.vsubmit", "entryentity.vaudit", "entryentity.fieldkey", "entryentity.defaultfuncparam", "entryentity.sysmustinput"};
    private static final String DATA_ENTITY = "msplan_dataconfig";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_MUSTINPUT = "mustinput";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_EDITENABLED = "editenabled";
    private static final String KEY_SUBMITENABLED = "submitenabled";
    private static final String KEY_AUDITENABLED = "auditenabled";
    private static final String KEY_VNEW = "vnew";
    private static final String KEY_VEDIT = "vedit";
    private static final String KEY_VVIEW = "vview";
    private static final String KEY_VSUBMIT = "vsubmit";
    private static final String KEY_VAUDIT = "vaudit";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String SAVE = "save";
    private static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";

    public void afterBindData(EventObject e) {
        BillOperationStatus billOperationStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        this.loadDataConfig(billOperationStatus);
    }

    private void loadDataConfig(BillOperationStatus billOperationStatus) {
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        QFilter qfEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qfLayoutSolution = new QFilter("layoutsolution", "=", (Object)this.getLayoutSolution());
        QFilter[] qfArr = new QFilter[]{qfStatus, qfEnable, qfLayoutSolution};
        if (!QueryServiceHelper.exists((String)DATA_ENTITY, (QFilter[])qfArr)) {
            return;
        }
        DynamicObject[] dyArr = BusinessDataServiceHelper.load((String)DATA_ENTITY, (String)StringUtils.join((Object[])SELECT_FIELDS, (String)","), (QFilter[])qfArr, (String)"modifytime asc");
        DynamicObject obj = null;
        for (DynamicObject dy : dyArr) {
            boolean flag;
            if (!dy.getString("classpath").isEmpty() && !(flag = ((Boolean)DispatchServiceHelper.invokeService((String)dy.getString("classpath"), (String)dy.getString("appid"), (String)dy.getString("servicename"), (String)dy.getString("methodname"), (Object[])new Object[0])).booleanValue())) continue;
            obj = dy;
        }
        if (obj == null) {
            return;
        }
        DynamicProperty mustInputKey = obj.getDynamicObjectCollection(ENTRY_ENTITY).getDynamicObjectType().getProperty(KEY_MUSTINPUT);
        DynamicProperty nameKey = obj.getDynamicObjectCollection(ENTRY_ENTITY).getDynamicObjectType().getProperty(KEY_FIELDKEY);
        for (DynamicObject entry : obj.getDynamicObjectCollection(ENTRY_ENTITY)) {
            String keyName = entry.getString((IDataEntityProperty)nameKey);
            if (entry.getBoolean((IDataEntityProperty)mustInputKey)) {
                this.setMustInput(keyName);
            }
            this.setVisibleAndEnable(entry, keyName, billOperationStatus);
        }
    }

    private void setVisibleAndEnable(DynamicObject entry, String keyName, BillOperationStatus billOperationStatus) {
        switch (billOperationStatus) {
            case ADDNEW: {
                this.setVisible(entry, keyName, KEY_VNEW);
                this.setEnable(entry, keyName, KEY_ENABLED);
                break;
            }
            case EDIT: {
                this.setVisible(entry, keyName, KEY_VEDIT);
                this.setEnable(entry, keyName, KEY_EDITENABLED);
                break;
            }
            case VIEW: {
                this.setVisible(entry, keyName, KEY_VVIEW);
                break;
            }
            case SUBMIT: {
                this.setVisible(entry, keyName, KEY_VSUBMIT);
                this.setEnable(entry, keyName, KEY_SUBMITENABLED);
                break;
            }
            case AUDIT: {
                this.setVisible(entry, keyName, KEY_VAUDIT);
                this.setEnable(entry, keyName, KEY_AUDITENABLED);
                break;
            }
        }
    }

    private void setEnable(DynamicObject entry, String keyName, String colName) {
        if (entry.getBoolean(colName)) {
            this.setEnable(keyName, false);
        } else {
            this.setEnable(keyName, true);
        }
    }

    private void setVisible(DynamicObject entry, String keyName, String colName) {
        if (entry.getBoolean(colName)) {
            this.setVisible(keyName, true);
        } else {
            this.setVisible(keyName, false);
        }
    }

    private void setMustInput(String key) {
        FieldEdit cellEdit = (FieldEdit)this.getView().getControl(key);
        if (cellEdit != null) {
            cellEdit.setMustInput(true);
        }
    }

    private void setVisible(String key, boolean isVisible) {
        FieldEdit cellEdit = (FieldEdit)this.getView().getControl(key);
        if (cellEdit != null) {
            cellEdit.setVisible("", isVisible);
        }
    }

    private void setEnable(String key, boolean isEnable) {
        FieldEdit cellEdit = (FieldEdit)this.getView().getControl(key);
        if (cellEdit != null) {
            this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{key});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": {
                operate.getOption().setVariableValue("layoutsolution", this.getLayoutSolution());
                break;
            }
            case "submit": {
                operate.getOption().setVariableValue("layoutsolution", this.getLayoutSolution());
                break;
            }
        }
    }

    private String getLayoutSolution() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String name = this.getModel().getDataEntityType().getName();
        List layouts = null;
        layouts = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId), new QFilter("modeltype", "=", (Object)"BaseFormModel")}) ? BillTypeServiceHelper.getBillLayoutByFormId((String)name, (String)"BaseFormModel") : BillTypeServiceHelper.getBillLayoutByFormId((String)name);
        List collect = layouts.stream().filter(obj -> formId.equals(obj.get("number"))).map(obj -> obj.get("id")).collect(Collectors.toList());
        return collect.get(0).toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": {
                this.loadDataConfig(BillOperationStatus.EDIT);
                break;
            }
            case "submit": {
                this.loadDataConfig(BillOperationStatus.SUBMIT);
                break;
            }
            case "unsubmit": {
                this.loadDataConfig(BillOperationStatus.EDIT);
                break;
            }
            case "audit": {
                this.loadDataConfig(BillOperationStatus.AUDIT);
                break;
            }
            case "unaudit": {
                this.loadDataConfig(BillOperationStatus.EDIT);
                break;
            }
        }
    }
}

