/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.qmc;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bd.sbd.consts.Inspect_cfgConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.util.CollectionUtils;

public class InspectCfgBillPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "masterid", "supplier", "inspecttype");
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        switch (sourceID) {
            case "masterid": {
                qFilters.add(new QFilter("enableinspect", "=", (Object)"1"));
                qFilters.add(new QFilter("configproperties", "!=", (Object)"3"));
                break;
            }
            case "supplier": {
                qFilters.add(new QFilter("type", "!=", (Object)"4"));
                break;
            }
            case "inspecttype": {
                HashSet<Long> selectedIdSet = new HashSet<Long>();
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject entryObj : entryentity) {
                    Long inspecttype = entryObj.getLong("inspecttype.id");
                    selectedIdSet.add(inspecttype);
                }
                qFilters.add(new QFilter("id", "not in", selectedIdSet));
                qFilters.add(new QFilter("domain", "=", (Object)"8"));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("nocheckflag".equals(propName)) {
            this.setNoCheckPanel();
        } else if ("inspecttype".equals(propName)) {
            for (ChangeData changeData : changeSet) {
                Object newValue = changeData.getNewValue();
                if (Inspect_cfgConst.QCP_FLG.equals(newValue)) continue;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("nocheckflag", (Object)Boolean.FALSE, rowIndex);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        List allRefs;
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (!pkValue.equals(0L) && CollectionUtils.isNotEmpty((Collection)(allRefs = BaseDataRefrenceHelper.getAllRefs((BasedataEntityType)((BasedataEntityType)dataEntity.getDataEntityType()), (Object)pkValue)))) {
            view.setEnable(Boolean.FALSE, new String[]{"masterid"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setNoCheckPanel();
        IDataModel model = this.getModel();
        if (model.getValue("masterid") != null) {
            DynamicObject masterid = (DynamicObject)model.getValue("masterid");
            model.setValue("material", masterid.getPkValue());
            model.setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        switch (op.getOperateKey()) {
            case "submit": {
                IDataModel model = this.getModel();
                DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
                Boolean noCheckFlg = Boolean.FALSE;
                DynamicObjectCollection qcpEntrys = model.getEntryEntity("entryqcp");
                long qcpCount = qcpEntrys.stream().filter(x -> null != x.get("supplier")).count();
                for (int i = 0; i < entryEntity.size(); ++i) {
                    noCheckFlg = ((DynamicObject)entryEntity.get(i)).getBoolean("nocheckflag");
                    if (!noCheckFlg.booleanValue() || 0L != qcpCount) continue;
                    model.setValue("nocheckflag", (Object)Boolean.FALSE, i);
                }
                this.getView().updateView("entryentity");
                break;
            }
            case "deleteentryfns": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                Long inspecttypeId = rowEntity.getLong("inspecttype_id");
                if (!Inspect_cfgConst.QCP_FLG.equals(inspecttypeId)) break;
                this.getModel().deleteEntryData("entryqcp");
                this.setNoCheckPanel();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        switch (op.getOperateKey()) {
            case "unsubmit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "deleteentryfns": {
                this.setNoCheckPanel();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            IDataModel model = this.getModel();
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                model.deleteEntryData("entryqcp");
            } else {
                model.setValue("nocheckflg", (Object)Boolean.TRUE);
            }
            this.getView().invokeOperation("save");
            this.setTabsState(null);
        }
    }

    private void setTabsState(String checkedFlag) {
        HashMap<String, String> tabMap = new HashMap<String, String>(1);
        tabMap.put("qcpflg", "qcpinspect");
        HashMap<String, String> entryMap = new HashMap<String, String>(1);
        entryMap.put("qcpinspect", "entryqcp");
        if (null == checkedFlag) {
            tabMap.forEach((flgName, tabName) -> this.setTabState((String)tabName, (String)flgName, (String)entryMap.get(tabName)));
        } else {
            String tabName2 = (String)tabMap.get(checkedFlag);
            this.setTabState(tabName2, checkedFlag, (String)entryMap.get(tabName2));
        }
        this.activeTab();
    }

    private void setTabState(String tabName, String flgName, String entryName) {
        int rowCount;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Boolean isCheck = (Boolean)model.getValue(flgName);
        if (isCheck.booleanValue() && (rowCount = model.getEntryRowCount(entryName)) < 1) {
            model.createNewEntryRow(entryName);
        }
        view.setVisible(isCheck, new String[]{tabName});
        view.setVisible(isCheck, new String[]{entryName});
    }

    private void activeTab() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List<String> flgList = Arrays.asList("qcpflg", "finishflg");
        List<String> tabList = Arrays.asList("qcpinspect", "finishinspect");
        int size = flgList.size();
        for (int i = 0; i < size; ++i) {
            Boolean isCheck = (Boolean)model.getValue(flgList.get(i));
            if (!isCheck.booleanValue()) continue;
            Tab tab = (Tab)view.getControl("tabap");
            tab.activeTab(tabList.get(i));
            return;
        }
    }

    private void setNoCheckPanel() {
        DynamicObject entryObj;
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        boolean isNoCheck = false;
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext() && !(isNoCheck = (entryObj = (DynamicObject)iterator.next()).getBoolean("nocheckflag"))) {
        }
        if (isNoCheck) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nocheckentrypanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nocheckentrypanel"});
        }
    }
}

