/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.sn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class SnParameteEditPlugein
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(SnParameteEditPlugein.class);
    private static final List<String> snmovetrackFixCols = Arrays.asList("invorg", "remark", "snmainfileid", "handlestatus");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"relcolumn"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("relcolumn".equals(key)) {
            String sourcebilltype = "sbs_billsnrelation";
            MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)sourcebilltype);
            PropTreeBuildOption ops = new PropTreeBuildOption();
            try {
                appBillMainType = (MainEntityType)appBillMainType.clone();
                DataEntityPropertyCollection entry = appBillMainType.getProperties();
                for (IDataEntityProperty dataEntityPropEntry : entry) {
                    if (!"entryentity".equals(dataEntityPropEntry.getName())) continue;
                    DynamicObjectType propertyType = ((EntryProp)dataEntityPropEntry).getDynamicCollectionItemPropertyType();
                    DataEntityPropertyCollection properties = propertyType.getProperties();
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext()) {
                        IDataEntityProperty next2 = (IDataEntityProperty)iterator.next();
                        for (String snmovetrackFixCol : snmovetrackFixCols) {
                            if (!snmovetrackFixCol.equals(next2.getName())) continue;
                            iterator.remove();
                        }
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                log.error("clone\u5e8f\u5217\u53f7\u914d\u7f6e\u5173\u8054\u8868tree node\u5931\u8d25", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"clone\u5e8f\u5217\u53f7\u914d\u7f6e\u5173\u8054\u8868tree node\u5931\u8d25\u3002", (String)"SnParameteEditPlugein_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            }
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)appBillMainType, (PropTreeBuildOption)ops);
            List children = srcBillNode.getChildren();
            children.removeIf(next -> "billhead".equals(next.getId()));
            this.showSelectFieldForm(srcBillNode, "relcolumn", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"SnParameteEditPlugein_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void showSelectFieldForm(TreeNode billNode, String fieldCtrlKey, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        IDataModel model = this.getModel();
        if (returnData == null) {
            return;
        }
        if ("relcolumn".equals(actionId)) {
            model.setValue("relcolumn", returnData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("sncheckrange".equals(propName)) {
            if (newValue == null) {
                return;
            }
            String sncheckrange = newValue.toString();
            if (sncheckrange.contains("3") && !sncheckrange.contains("2")) {
                this.getModel().setValue("sncheckrange", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6279\u53f7\u5fc5\u987b\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"SnMainFilePlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.queryEntityData();
        }
    }

    private void queryEntityData() {
        DynamicObject[] snseqs = BusinessDataServiceHelper.load((String)"bd_sndimension", (String)"snseq", null);
        ArrayList<Integer> snseq = new ArrayList<Integer>(snseqs.length);
        for (int i = 0; i < snseqs.length; ++i) {
            int sns = (Integer)snseqs[i].get("snseq");
            snseq.add(sns);
        }
        int max = (Integer)Collections.max(snseq);
        this.getModel().setValue("snseq", (Object)(max + 1));
    }
}

