/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.translate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;

public abstract class AbstractFormTranslator {
    protected final IDataModel model;
    protected final String langName;

    protected AbstractFormTranslator(IDataModel model, String langName) {
        this.model = model;
        this.langName = langName;
    }

    protected String getBillEntity(DynamicObject srcObj) {
        return srcObj.getString("srcbillobj.number");
    }

    public void entryToEntryTranslate(String entryKey, String billEntityKey, String fieldkey, String displayKey) {
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            Object src = this.model.getValue(billEntityKey, i);
            String billEntity = "";
            if (src != null) {
                if (src instanceof DynamicObject) {
                    billEntity = this.getBillEntity((DynamicObject)src);
                } else if (src instanceof String) {
                    billEntity = (String)src;
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)billEntity)) continue;
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
            this.bindEntryColNames(i, billEntityType, fieldkey, displayKey);
        }
    }

    public void headToSubEntryTranslate(String billEntity, String entryKey, String subEntryKey, String fieldkey, String displayKey) {
        if (StringUtils.isEmpty((CharSequence)billEntity)) {
            return;
        }
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.subEntryFieldTranslate(entryKey, subEntryKey, i, billEntity, fieldkey, displayKey);
        }
    }

    public void entryToSubEntryTranslate(String entryKey, String billEntityKey, String subEntryKey, String fieldkey, String displayKey) {
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            DynamicObject srcObj = (DynamicObject)this.model.getValue(billEntityKey, i);
            if (srcObj == null) continue;
            this.subEntryFieldTranslate(entryKey, subEntryKey, i, this.getBillEntity(srcObj), fieldkey, displayKey);
        }
    }

    public void entryFieldTranslate(String entryKey, String billEntity, String key, String displayKey) {
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        int count = this.model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            this.bindEntryColNames(i, billEntityType, key, displayKey);
        }
    }

    public void subEntryFieldTranslate(String entryKey, String subEntryKey, int entryIndex, String billEntity, String key, String displayKey) {
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
        int count = ((DynamicObject)this.model.getEntryEntity(entryKey).get(entryIndex)).getDynamicObjectCollection(subEntryKey).size();
        for (int i = 0; i < count; ++i) {
            this.bindSubColNames(i, entryIndex, billEntityType, key, displayKey);
        }
    }

    private void bindEntryColNames(int index, MainEntityType billEntityType, String key, String displayKey) {
        String sourceColName;
        String sourceValue = String.valueOf(this.model.getValue(key, index));
        if (billEntityType != null && StringUtils.isNotBlank((CharSequence)sourceValue) && StringUtils.isNotBlank((CharSequence)(sourceColName = this.doTranslate(this.langName, billEntityType, sourceValue)))) {
            this.model.setValue(displayKey, (Object)sourceColName, index);
        }
    }

    private void bindSubColNames(int index, int entryIndex, MainEntityType billEntityType, String key, String displayKey) {
        String sourceValue = String.valueOf(this.model.getValue(key, index, entryIndex));
        if (billEntityType != null && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = this.doTranslate(this.langName, billEntityType, sourceValue);
            this.model.setValue(displayKey, (Object)sourceColName, index, entryIndex);
        }
    }

    private String doTranslate(String langName, MainEntityType dt, String sourceValue) {
        String translate = this.translate(langName, dt, sourceValue);
        int translateSize = this.translateSize();
        if (translate != null && translate.length() >= translateSize) {
            translate = translate.substring(0, translateSize - 4) + "...";
        }
        return translate;
    }

    protected int translateSize() {
        return 1024;
    }

    protected abstract String translate(String var1, MainEntityType var2, String var3);
}

