/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PbdGoodClassSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PbdGoodClassSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("fullname");
        fieldKeys.add("level");
        fieldKeys.add("name");
        fieldKeys.add("number");
        fieldKeys.add("parent");
        fieldKeys.add("commenttemp");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        QFilter qFilter = new QFilter("alluse", "=", (Object)"1");
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject comTemp = QueryServiceHelper.queryOne((String)"pmm_commenttemplate", (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getLong("commenttemp") != 0L || 3 != dynamicObject.getInt("level")) continue;
            dynamicObject.set("commenttemp", (Object)comTemp.getLong("id"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> levelOneDynList = new ArrayList<DynamicObject>(e.getDataEntities().length);
        ArrayList<DynamicObject> levelTwoDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> levelThreeDynList = new ArrayList<DynamicObject>(16);
        HashMap<Long, String> dynIdAndFullNameMap = new HashMap<Long, String>(e.getDataEntities().length);
        for (DynamicObject dynamicObject : dataEntities) {
            String level = dynamicObject.getString("level");
            dynIdAndFullNameMap.put(dynamicObject.getLong("id"), dynamicObject.getString("fullname"));
            if ("1".equals(level)) {
                levelOneDynList.add(dynamicObject);
                continue;
            }
            if ("2".equals(level)) {
                levelTwoDynList.add(dynamicObject);
                continue;
            }
            if (!"3".equals(level)) continue;
            levelThreeDynList.add(dynamicObject);
        }
        if (!levelOneDynList.isEmpty()) {
            this.setChildDynFullText(levelOneDynList, levelTwoDynList, dynIdAndFullNameMap);
        }
        if (!levelTwoDynList.isEmpty()) {
            this.setChildDynFullText(levelTwoDynList, levelThreeDynList, dynIdAndFullNameMap);
        }
        log.info("@@@PbdGoodClassSaveOp:\u4e09\u7ea7\u5206\u7c7b\uff1a" + SerializationUtils.toJsonString(levelThreeDynList));
        this.updateGoodCatLongNumber(levelThreeDynList);
    }

    private void setChildDynFullText(List<DynamicObject> parentDynList, List<DynamicObject> childDynList, Map<Long, String> dynIdAndFullNameMap) {
        DynamicObject[] childDynArray;
        ArrayList<Long> parentDynPkIds = new ArrayList<Long>(parentDynList.size() << 2);
        for (DynamicObject parentDyn : parentDynList) {
            parentDynPkIds.add(parentDyn.getLong("id"));
        }
        for (DynamicObject childDyn : childDynArray = BusinessDataServiceHelper.load((String)"mdr_goodsclass", (String)"id,name,fullname,level,parent", (QFilter[])new QFilter[]{new QFilter("parent", "in", parentDynPkIds)})) {
            String name = childDyn.getString("name");
            StringBuilder parentFullText = new StringBuilder();
            if (dynIdAndFullNameMap.get(childDyn.getLong("parent_id")) != null) {
                parentFullText.append(dynIdAndFullNameMap.get(childDyn.getLong("parent_id")));
            }
            childDyn.set("fullname", (Object)parentFullText.append(".").append(name).toString());
            childDynList.add(childDyn);
            dynIdAndFullNameMap.put(childDyn.getLong("id"), childDyn.getString("fullname"));
        }
        SaveServiceHelper.save((DynamicObject[])childDynArray);
    }

    private void updateGoodCatLongNumber(List<DynamicObject> levelThreeDynList) {
        ArrayList<Long> categoryIdList = new ArrayList<Long>(levelThreeDynList.size());
        HashMap<Long, String> categoryIdAndLongNumberMap = new HashMap<Long, String>(levelThreeDynList.size() << 2);
        for (DynamicObject dynamicObject : levelThreeDynList) {
            categoryIdList.add(dynamicObject.getLong("id"));
            categoryIdAndLongNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("fullname"));
        }
        if (ECServiceSwitch.isOpened()) {
            Throwable throwable = null;
            try (TXHandle h = TX.required();){
                CommonParam commonParam = new CommonParam();
                commonParam.put((Object)"categoryIdList", categoryIdList);
                commonParam.put((Object)"categoryIdAndLongNumberMap", categoryIdAndLongNumberMap);
                ECServiceHelper.execute((String)"mdr_goodsclass_save", (String)"updateGoodsLongText", (String)"scm", (String)"pmm", (String)"PmmGoodsClassUpdateGoodInfoService", (Param)commonParam);
            }
            catch (Throwable commonParam) {
                Throwable throwable2 = commonParam;
                throw commonParam;
            }
        } else {
            DynamicObject proManageDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodmanage");
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id", (QFilter[])new QFilter[]{new QFilter("category", "in", categoryIdList)});
            ArrayList<Long> pkIds = new ArrayList<Long>(dynamicObjectArray.length);
            for (DynamicObject dynamicObject : dynamicObjectArray) {
                pkIds.add(dynamicObject.getLong("id"));
            }
            DynamicObject[] dynamicObjectArray2 = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)proManageDyn.getDynamicObjectType());
            for (DynamicObject good : dynamicObjectArray2) {
                good.set("catlongnumber", categoryIdAndLongNumberMap.get(good.getDynamicObject("category").getPkValue()));
            }
            if (dynamicObjectArray2.length > 0) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])dynamicObjectArray2);
                if (operationResult.isSuccess()) {
                    log.info("@@@PbdGoodClassSaveOp:\u5546\u54c1\u5206\u7c7b\u66f4\u65b0\u5546\u54c1\u957f\u540d\u79f0\u6210\u529f");
                } else {
                    StringBuilder messageError = new StringBuilder();
                    messageError.append(operationResult.getMessage()).append("\n\t");
                    operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
                    log.info("@@@PbdGoodClassSaveOp:\u5546\u54c1\u5206\u7c7b\u66f4\u65b0\u5546\u54c1\u957f\u540d\u79f0\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + messageError);
                }
            }
        }
    }
}

