/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PbdSupGradeImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billdata = iterator.next();
            JSONObject data = billdata.getData();
            if (Objects.isNull(data)) continue;
            JSONObject org = (JSONObject)data.getObject("org", JSONObject.class);
            if (Objects.isNull(org)) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u8bc4\u4f30\u7ec4\u7ec7\u4e3a\u7a7a", (String)"PbdSupGradeImportPlugin_1", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                logger.fail();
                iterator.remove();
                continue;
            }
            Boolean validBdsupplieriResult = this.validBdsupplier(data, logger, org);
            Boolean validCategoryResult = this.validCategory(data, logger, org);
            Boolean validEvagradeResult = this.validEvagrade(data, logger, org);
            if (validBdsupplieriResult.booleanValue() && validCategoryResult.booleanValue() && validEvagradeResult.booleanValue()) continue;
            logger.fail();
            iterator.remove();
        }
    }

    private Boolean validEvagrade(JSONObject data, ImportLogger logger, JSONObject org) {
        JSONArray entryentity = (JSONArray)data.getObject("entryentity", JSONArray.class);
        Boolean issuccess = Boolean.TRUE;
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            List entrJsonObjects = entryentity.toJavaList(JSONObject.class);
            ArrayList<String> evagradeNums = new ArrayList<String>(12);
            for (JSONObject entry : entrJsonObjects) {
                JSONObject evagrade = entry.getJSONObject("evagrade");
                if (!Objects.nonNull(evagrade)) continue;
                evagradeNums.add(evagrade.getString("number"));
            }
            if (evagradeNums.size() == 0) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u6838\u51c6\u7b49\u7ea7\u4e3a\u7a7a", (String)"PbdSupGradeImportPlugin_2", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                issuccess = Boolean.FALSE;
                return issuccess;
            }
            DynamicObjectCollection evagradeDb = QueryServiceHelper.query((String)"bd_evagrade", (String)"id,number,evatype.number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", evagradeNums).and(new QFilter("enable", "=", (Object)"1").and(new QFilter("evatype.number", "=", (Object)"B0110")))});
            if (CollectionUtils.isEmpty((Collection)evagradeDb)) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u6838\u51c6\u7b49\u7ea7\u5728\u8bc4\u4f30\u7b49\u7ea7\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9", (String)"PbdSupGradeImportPlugin_3", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                issuccess = Boolean.FALSE;
                return issuccess;
            }
            List evagradeDbNumber = evagradeDb.stream().map(x -> x.getString("number")).collect(Collectors.toList());
            for (String evagradeNum : evagradeNums) {
                if (evagradeDbNumber.contains(evagradeNum)) continue;
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u6838\u51c6\u7b49\u7ea7\u5728\u8bc4\u4f30\u7b49\u7ea7\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9", (String)"PbdSupGradeImportPlugin_4", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                issuccess = Boolean.FALSE;
                return issuccess;
            }
        }
        return issuccess;
    }

    private Boolean validCategory(JSONObject data, ImportLogger logger, JSONObject org) {
        JSONArray entryentity = (JSONArray)data.getObject("entryentity", JSONArray.class);
        Boolean issuccess = Boolean.TRUE;
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u8bc4\u4f30\u4fe1\u606f\u4e3a\u7a7a", (String)"PbdSupGradeImportPlugin_5", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            issuccess = Boolean.FALSE;
            return issuccess;
        }
        List entrJsonObjects = entryentity.toJavaList(JSONObject.class);
        ArrayList<String> catecoryNums = new ArrayList<String>(12);
        for (JSONObject entry : entrJsonObjects) {
            JSONObject category = entry.getJSONObject("category");
            if (!Objects.nonNull(category)) continue;
            catecoryNums.add(category.getString("number"));
        }
        if (catecoryNums.size() > 0) {
            DynamicObjectCollection bd_materialgroups = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,createorg,createorg.number,standard.number", (QFilter[])new QFilter[]{new QFilter("number", "in", catecoryNums).and(new QFilter("standard.number", "=", (Object)"JBFLBZ")).and(new QFilter("createorg.number", "=", (Object)org.getString("number")))});
            if (CollectionUtils.isEmpty((Collection)bd_materialgroups)) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u54c1\u7c7b\u5728\u7ec4\u7ec7\u7684\u57fa\u672c\u5206\u7c7b\u6807\u51c6\u4e0b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"PbdSupGradeImportPlugin_6", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                issuccess = Boolean.FALSE;
                return issuccess;
            }
            List bd_materialgroup_nums = bd_materialgroups.stream().map(x -> x.getString("number")).collect(Collectors.toList());
            for (String catecoryNum : catecoryNums) {
                if (bd_materialgroup_nums.contains(catecoryNum)) continue;
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u54c1\u7c7b\u5728\u7ec4\u7ec7\u7684\u57fa\u672c\u5206\u7c7b\u6807\u51c6\u4e0b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"PbdSupGradeImportPlugin_7", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                issuccess = Boolean.FALSE;
                return issuccess;
            }
        }
        return issuccess;
    }

    private Boolean validBdsupplier(JSONObject data, ImportLogger logger, JSONObject org) {
        JSONObject bdsupplier = (JSONObject)data.getObject("bdsupplier", JSONObject.class);
        DynamicObject orgDb = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)org.getString("number"))});
        Boolean isSuccess = Boolean.TRUE;
        if (Objects.isNull(orgDb)) {
            logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadResFormat((String)"\u5f15\u5165\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801 %1 \u7684\u8bc4\u4f30\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"PbdSupGradeImportPlugin_10", (String)"bd-pbd-opplugin", (Object[])new Object[]{org.getString("number")}));
            isSuccess = Boolean.FALSE;
        }
        if (Objects.nonNull(bdsupplier)) {
            DynamicObjectCollection bd_supplier = QueryServiceHelper.query((String)"bd_supplier", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bdsupplier.getString("number"))});
            if (CollectionUtils.isEmpty((Collection)bd_supplier)) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadResFormat((String)"\u5f15\u5165\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u7f16\u7801 %1 \u7684\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u3002", (String)"PbdSupGradeImportPlugin_11", (String)"bd-pbd-opplugin", (Object[])new Object[]{bdsupplier.getString("number")}));
                isSuccess = Boolean.FALSE;
            }
            if (!isSuccess.booleanValue()) {
                return isSuccess;
            }
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgDb.getLong("id"));
            DynamicObjectCollection bd_suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,number", (QFilter[])new QFilter[]{baseDataFilter});
            if (CollectionUtils.isEmpty((Collection)bd_suppliers)) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u8bc4\u4f30\u7ec4\u7ec7\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u4f9b\u5e94\u5546", (String)"PbdSupGradeImportPlugin_8", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            List numbers = bd_suppliers.stream().map(x -> x.getString("number")).collect(Collectors.toList());
            if (!numbers.contains(bdsupplier.getString("number"))) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u8bc4\u4f30\u7ec4\u7ec7\u6ca1\u6709\u4f7f\u7528\u4f9b\u5e94\u5546\u6743\u9650", (String)"PbdSupGradeImportPlugin_9", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        } else {
            logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728", (String)"PbdSupGradeImportPlugin_12", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

