/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DrpCustomerValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(DrpCustomerValidator.class);

    public void validate() {
        String key;
        switch (key = this.getOperateKey()) {
            case "save": {
                this.saveValidator(this.dataEntities);
                break;
            }
            case "submit": {
                this.submitValidator(this.dataEntities);
                break;
            }
            case "delete": 
            case "dodel": {
                this.deleteValidator(this.dataEntities);
                break;
            }
        }
    }

    private void deleteValidator(ExtendedDataEntity[] dataEntities) {
        int length = dataEntities.length;
        for (int i = 0; i < length; ++i) {
            boolean enable = dataEntities[i].getDataEntity().getBoolean("enable");
            if (!enable) continue;
            this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"DrpCustomerValidator_0", (String)"bd-pbd-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private void submitValidator(ExtendedDataEntity[] dataEntities) {
        this.saveValidator(dataEntities);
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject customer;
            String[] customerTypes;
            DynamicObject obj = dataEntity.getDataEntity();
            String customerType = obj.getString("type");
            for (String type : customerTypes = customerType.split(",")) {
                if (StringUtils.isEmpty((CharSequence)type) || "2".equals(type) || "4".equals(type)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e20\u9053\u4eba\u5458\u7684\u7c7b\u578b\u5fc5\u987b\u4e3a\uff1a\u5ba2\u6237-2 \u6216 \u7ecf\u9500\u5546-4\u3002\n", (String)"DrpCustomerValidator_1", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
            }
            DynamicObject customerinfo = obj.getDynamicObject("customerinfo");
            if (null == customerinfo || null == (customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"status,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)customerinfo.getLong("id"))})) || !"0".equals(customer.getString("enable")) && "C".equalsIgnoreCase(customer.getString("status"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e20\u9053\u4eba\u5458\u6240\u5c5e\u6e20\u9053\uff0c\u5fc5\u987b\u662f\u5ba1\u6838\u4e14\u53ef\u7528\u72b6\u6001\u7684\u6570\u636e\u3002\n", (String)"DrpCustomerValidator_2", (String)"bd-pbd-opplugin", (Object[])new Object[0]));
        }
    }
}

