/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.validator.category;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CategoryDuplicateValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        HashMap<String, ExtendedDataEntity> baseDataMap = new HashMap<String, ExtendedDataEntity>(16);
        HashSet<Long> categoryIdSets = new HashSet<Long>(16);
        HashSet<Long> materialIdSets = new HashSet<Long>(16);
        HashSet<Long> createOrgSets = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject row = dataEntity.getDataEntity();
            String type = row.getString("type");
            String billName = row.getDataEntityType().getDisplayName().getLocaleValue();
            String dumpCheck = this.makeRowKey(row.getLong("createorg_id"), row.getLong("category_id"), row.getLong("material_id"));
            if (baseDataMap.containsKey(dumpCheck)) {
                this.addErrorMessage(type, row, dataEntity, billName);
                continue;
            }
            categoryIdSets.add(row.getLong("category_id"));
            materialIdSets.add(row.getLong("material_id"));
            createOrgSets.add(row.getLong("createorg_id"));
            baseDataMap.put(dumpCheck, dataEntity);
        }
        if (baseDataMap.size() > 0) {
            QFilter qFilter = new QFilter("status", "in", (Object)new String[]{"C", "B"});
            qFilter.and("createorg", "in", createOrgSets);
            qFilter.and("category", "in", categoryIdSets);
            qFilter.and("material", "in", materialIdSets);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.getEntityKey(), (String)"id,type,category,material,createorg", (QFilter[])new QFilter[]{qFilter}, null);){
                for (DynamicObject row : dataSet) {
                    String dumpCheck = this.makeRowKey(row.getLong("createorg"), row.getLong("category"), row.getLong("material"));
                    ExtendedDataEntity entity = (ExtendedDataEntity)baseDataMap.get(dumpCheck);
                    if (entity == null) continue;
                    DynamicObject dataEntity = entity.getDataEntity();
                    String type = dataEntity.getString("type");
                    String billName = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
                    Long id = row.getLong("id");
                    long id1 = dataEntity.getLong("id");
                    if (id == id1) continue;
                    this.addErrorMessage(type, dataEntity, entity, billName);
                }
            }
        }
    }

    private void addErrorMessage(String type, DynamicObject row, ExtendedDataEntity dataEntity, String billName) {
        String categoryName = row.getString("category.name");
        String materialName = row.getString("material.name");
        if ("1".equals(type) && StringUtils.isNotBlank((CharSequence)categoryName)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u54c1\u7c7b:\u201d%1$s\u201d\u5df2\u5b58\u5728%2$s\u4e2d,\u4e0d\u5141\u8bb8\u91cd\u590d%3$s\u3002", (String)"PbdStrategySubmitValidator_0", (String)"bd-pbd-opplugin", (Object[])new Object[0]), categoryName, billName, this.getOperationName()));
        } else if ("2".equals(type) && StringUtils.isNotBlank((CharSequence)materialName)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599:\u201d%1$s\u201d\u5df2\u5b58\u5728%2$s\u4e2d,\u4e0d\u5141\u8bb8\u91cd\u590d%3$s\u3002", (String)"PbdStrategySubmitValidator_1", (String)"bd-pbd-opplugin", (Object[])new Object[0]), materialName, billName, this.getOperationName()));
        }
    }

    private String makeRowKey(long createorgId, long categoryId, long materialId) {
        return createorgId + "-" + categoryId + "-" + materialId;
    }
}

