/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.utils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CommonUtils {
    private static final Log log = LogFactory.getLog(CommonUtils.class);

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static boolean isRealChanged(ChangeData changeSet) {
        if (changeSet == null) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        return CommonUtils.isRealChanged(oldObject, newObject);
    }

    public static boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else if (newObject instanceof OrmLocaleValue && oldObject instanceof OrmLocaleValue) {
                if (((OrmLocaleValue)newObject).getLocaleValue() == null) {
                    return true;
                }
                if (((OrmLocaleValue)oldObject).getLocaleValue() == null) {
                    return true;
                }
                if (!((OrmLocaleValue)oldObject).getLocaleValue().equals(((OrmLocaleValue)newObject).getLocaleValue())) {
                    return true;
                }
            } else {
                return !oldObject.equals(newObject);
            }
        }
        return false;
    }
}

