/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.utils.pdm.impl;

import java.util.Date;
import kd.bd.sbd.utils.pdm.mftbom.IBomVersionQuery;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.ext.mmc.business.query.impl.MmcBizQueryImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BomVersionQueryImpl
extends MmcBizQueryImpl
implements IBomVersionQuery {
    public String getSelectProperties() {
        StringBuilder sf = new StringBuilder();
        sf.append("id,");
        sf.append("number,");
        sf.append("name,");
        sf.append("bomversionrule,");
        sf.append("enable,");
        sf.append("type,");
        sf.append("material,");
        sf.append("effectdate,");
        sf.append("invaliddate");
        return sf.toString();
    }

    public String getKeyEntityID() {
        return "bd_bomversion_new";
    }

    @Override
    public Long getBomVersionByMaterial(Long orgID, Long materialID) {
        return this.getBomVersionByMaterial(orgID, materialID, 0L);
    }

    private QFilter[] buildQFilter(Long orgID, Long materialID, Long versionRuleId) {
        Date date = new Date();
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)this.getKeyEntityID(), (Long)orgID);
        QFilter qFilterMater = new QFilter("material", "=", (Object)materialID);
        qFilterMater.and(new QFilter("enable", "=", (Object)"1"));
        qFilterMater.and(new QFilter("status", "=", (Object)"C"));
        qFilterMater.and(new QFilter("effectdate", "<=", (Object)date));
        qFilterMater.and(new QFilter("invaliddate", ">", (Object)date));
        qFilterMater.and(new QFilter("type", "=", (Object)"A"));
        if (versionRuleId != null && !versionRuleId.equals(0L)) {
            qFilterMater.and(new QFilter("bomversionrule", "=", (Object)versionRuleId));
        }
        return new QFilter[]{qFilterMater, qFilterOrg};
    }

    @Override
    public Long getBomVersionByMaterial(Long orgID, Long materialID, Long versionRuleId) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-bomversionImpl-getBomVersionByMaterial", (String)this.getKeyEntityID(), (String)"id,name", (QFilter[])this.buildQFilter(orgID, materialID, versionRuleId), (String)"name desc").top(1);){
            if (ds.hasNext()) {
                Row arow = ds.next();
                Long l = arow.getLong("id");
                return l;
            }
        }
        return 0L;
    }
}

