/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.util;

import java.util.ArrayList;
import java.util.List;
import kd.bd.assistant.plugin.util.AssociatedTableModel;
import kd.bd.assistant.plugin.util.AutoPushUtil;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AutoPushOperation {
    private static final Log LOG = LogFactory.getLog(AutoPushOperation.class);
    private PushArgs pushArgs;
    private Object srcBillPk;
    private String sourceBill;
    private String targetBill;
    private List<AssociatedTableModel> associatedTableModels;
    private static final String action_save = "save";
    private static final String action_submit = "submit";

    public AutoPushOperation(Object srcBillPk, String sourceBill, String targetBill, String appId, String ruleId, List<AssociatedTableModel> associatedTableModels) {
        this.initPushArgs(srcBillPk, sourceBill, targetBill, appId, ruleId, associatedTableModels);
    }

    public AutoPushOperation(Object srcBillPk, String sourceBill, String targetBill, String appId, List<AssociatedTableModel> associatedTableModels) {
        this.initPushArgs(srcBillPk, sourceBill, targetBill, appId, null, associatedTableModels);
    }

    public AutoPushOperation(PushArgs pushArgs, Object srcBillPk) {
        this.pushArgs = pushArgs;
        this.srcBillPk = srcBillPk;
        this.sourceBill = pushArgs.getSourceEntityNumber();
        this.targetBill = pushArgs.getTargetEntityNumber();
    }

    public void initPushArgs(PushArgs pushArgs) {
        this.pushArgs = pushArgs;
    }

    private void initPushArgs(Object srcBillPk, String sBill, String tBill, String appId, String ruleId, List<AssociatedTableModel> associatedTableModels) {
        if (srcBillPk == null || StringUtils.isEmpty((CharSequence)sBill) || StringUtils.isEmpty((CharSequence)tBill) || CollectionUtils.isEmpty(associatedTableModels)) {
            throw new IllegalArgumentException("auto push operation lose necessary param");
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sBill);
        pushArgs.setTargetEntityNumber(tBill);
        pushArgs.setHasRight(true);
        pushArgs.setAppId(appId);
        if (ruleId != null) {
            pushArgs.setRuleId(ruleId);
        }
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow srcBill = new ListSelectedRow(srcBillPk);
        selectedRows.add(srcBill);
        pushArgs.setSelectedRows(selectedRows);
        this.pushArgs = pushArgs;
        this.srcBillPk = srcBillPk;
        this.sourceBill = sBill;
        this.targetBill = tBill;
        this.associatedTableModels = associatedTableModels;
    }

    public DynamicObject pushAction(String endAction) {
        if (this.targetBill == null) {
            throw new KDBizException("AutoPushOperation.pushAction error:targetBill is null.");
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.targetBill);
        String billName = targetMainType.getDisplayName().getLocaleValue();
        if (this.pushArgs == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%s\u65f6\uff0c\u4e0b\u63a8\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AutoPushOperation_0", (String)"bd-assistant-common", (Object[])new Object[0]), billName));
        }
        ConvertOperationResult pushResult = this.push(billName);
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs == null) {
            return null;
        }
        DynamicObject proObject = (DynamicObject)targetBillObjs.get(0);
        OperationResult saveResult = this.saveOperate(billName, targetBillObjs, proObject);
        if (endAction.equals(action_save)) {
            return proObject;
        }
        String exceptionMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u63d0\u4ea4\u5931\u8d25\uff1a%2$s\u3002", (String)"AutoPushOperation_8", (String)"bd-assistant-common", (Object[])new Object[0]);
        this.executeOperate(billName, proObject, saveResult, action_submit, exceptionMsg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e91\u4e3b\u6570\u636e\u9879\u76ee\u63d0\u4ea4\u6210\u529f\u3002", (String)"AutoPushOperation_2", (String)"bd-assistant-common", (Object[])new Object[0]));
        if (endAction.equals(action_submit)) {
            return proObject;
        }
        exceptionMsg = ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u5ba1\u6838\u5931\u8d25\uff1a%2$s\u3002", (String)"AutoPushOperation_9", (String)"bd-assistant-common", (Object[])new Object[0]);
        this.executeOperate(billName, proObject, saveResult, "audit", exceptionMsg, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e91\u4e3b\u6570\u636e\u9879\u76ee\u5ba1\u6838\u6210\u529f\u3002", (String)"AutoPushOperation_4", (String)"bd-assistant-common", (Object[])new Object[0]));
        return proObject;
    }

    private ConvertOperationResult push(String billName) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)this.pushArgs);
            if (!pushResult.isSuccess()) {
                StringBuilder errMessage = this.pushErrorMsgHandle(pushResult);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u4e0b\u63a8\u5931\u8d25\uff1a%2$s\u3002", (String)"AutoPushOperation_10", (String)"bd-assistant-common", (Object[])new Object[0]), billName, errMessage.toString()));
            }
            ConvertOperationResult convertOperationResult = pushResult;
            return convertOperationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected OperationResult saveOperate(String billName, List<DynamicObject> targetBillObjs, DynamicObject proObject) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("ignorewarn", String.valueOf(true));
            saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            saveOption.setVariableValue("strictvalidation", String.valueOf(true));
            saveOption.setVariableValue("ishasright", String.valueOf(true));
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)this.targetBill, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResult.isSuccess()) {
                StringBuilder errMessage = this.errorMsgHandle(saveResult);
                this.deletePushObject(proObject);
                LOG.error(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u9879\u76ee\u4fdd\u5b58\u5931\u8d25\uff1a%2$s\u3002", (String)"AutoPushOperation_11", (String)"bd-assistant-common", (Object[])new Object[0]), billName, errMessage.toString()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5355\u636e/\u57fa\u7840\u8d44\u6599\uff1a%1$s\u65f6\uff0c\u9879\u76ee\u4fdd\u5b58\u5931\u8d25\uff1a%2$s\u3002", (String)"AutoPushOperation_11", (String)"bd-assistant-common", (Object[])new Object[0]), billName, errMessage.toString()));
            }
            this.updateProFieldValue(proObject);
            LOG.info(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e91\u4e3b\u6570\u636e\u9879\u76ee\u4fdd\u5b58\u6210\u529f\u3002", (String)"AutoPushOperation_7", (String)"bd-assistant-common", (Object[])new Object[0]));
            OperationResult operationResult = saveResult;
            return operationResult;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void executeOperate(String billName, DynamicObject proObject, OperationResult saveResult, String operateKey, String exceptionMsg, String logMsg) {
        try (TXHandle h = TX.requiresNew();){
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ignorewarn", String.valueOf(true));
                operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
                operateOption.setVariableValue("strictvalidation", String.valueOf(true));
                operateOption.setVariableValue("ishasright", String.valueOf(true));
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)operateKey, (String)this.targetBill, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
                if (!submitResult.isSuccess()) {
                    StringBuilder errMessage = this.errorMsgHandle(submitResult);
                    this.deletePushObject(proObject);
                    LOG.error(String.format(exceptionMsg, billName, errMessage.toString()));
                    throw new KDBizException(String.format(exceptionMsg, billName, errMessage.toString()));
                }
                LOG.info(logMsg);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private StringBuilder pushErrorMsgHandle(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            LOG.error(billMessage);
            errMessage.append(billMessage);
        }
        return errMessage;
    }

    private StringBuilder errorMsgHandle(OperationResult auditResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(auditResult.getMessage());
        for (IOperateInfo errInfo : auditResult.getAllErrorOrValidateInfo()) {
            String detailMessage = errInfo.getMessage();
            LOG.error(detailMessage);
            errMessage.append(detailMessage);
        }
        return errMessage;
    }

    protected void updateProFieldValue(DynamicObject proObject) {
        Object createOrg = proObject.get("createorg");
        Long orgCU = null;
        if (createOrg instanceof Long) {
            orgCU = (Long)createOrg;
        } else if (createOrg instanceof DynamicObject) {
            orgCU = (Long)((DynamicObject)createOrg).getPkValue();
        }
        if (orgCU != null) {
            String bdCtrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)this.targetBill, (String)orgCU.toString());
            proObject.set("ctrlstrategy", (Object)bdCtrlStrgy);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{proObject});
        }
    }

    public DynamicObject pushActionTx(String endAction) {
        return this.pushAction(endAction);
    }

    protected void deletePushObject(DynamicObject pushObj) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.targetBill), (Object[])new Object[]{pushObj.getPkValue()});
                AutoPushUtil.deleteAssociation(Long.valueOf(this.srcBillPk.toString()), this.associatedTableModels);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

