/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public final class BizPartnerUtil {
    public static final Map<String, Map<String, Object>> assembleBizPartner() {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, HashSet<Long>> map = new HashMap<String, HashSet<Long>>(1);
        HashSet<Long> bizPartnerIds = BizPartnerUtil.getBizPartnerId();
        map.put("in", bizPartnerIds);
        filterMap.put("bizpartner", map);
        return filterMap;
    }

    private static boolean isEnableChangeSupplier() {
        Object publicValue = SystemParamServiceHelper.loadPublicParameterFromCache((String)"enable_switch_bizpartner");
        boolean enable_switch_bizpartner = false;
        if (null != publicValue) {
            enable_switch_bizpartner = Boolean.parseBoolean(publicValue.toString());
        }
        return enable_switch_bizpartner;
    }

    private static long getCurBizPartner() {
        RequestContext rc = RequestContext.get();
        long bizPartnerId = 0L;
        if (null != rc.getBizPartnerId()) {
            bizPartnerId = rc.getBizPartnerId();
        }
        return bizPartnerId;
    }

    public static final QFilter assembleQFilterBizPartner() {
        HashSet<Long> idSet = BizPartnerUtil.getBizPartnerId();
        return null != idSet && idSet.size() > 0 ? new QFilter("bizpartner", "in", idSet) : new QFilter("bizpartner", "=", (Object)-1);
    }

    public static final boolean bizPartnerIsAdmin() {
        ArrayList pkIds = new ArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner,user", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerIds())).and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"user");){
            dataSet.forEach(row -> pkIds.add(row.getLong("user")));
        }
        return pkIds.size() > 0;
    }

    public static final boolean bizPartnerIsAdmin(Object supplierUserId) {
        DynamicObject supplierUser = BusinessDataServiceHelper.loadSingle((Object)supplierUserId, (String)"bos_bizpartneruser");
        ArrayList pkIds = new ArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner,user", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", (Object)supplierUser.getLong("bizpartner_id"))).and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"user");){
            dataSet.forEach(row -> pkIds.add(row.getLong("user")));
        }
        return pkIds.size() > 0;
    }

    public static final List<Long> getAdminUserOfOrgIds() {
        ArrayList<Long> pkIds = new ArrayList<Long>();
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getAdminUserOfOrgIds", (String)"bos_bizpartneruser", (String)"org", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)BizPartnerUtil.getCurBizPartner()).and(new QFilter("isadmin", "=", (Object)"1")).and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"org");){
                dataSet.forEach(row -> pkIds.add(row.getLong("org")));
            }
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getAdminUserOfOrgIds", (String)"bos_bizpartneruser", (String)"org", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"org");){
            dataSet.forEach(row -> pkIds.add(row.getLong("org")));
        }
        return pkIds;
    }

    public static final List<Long> getAdminOfUser() {
        Throwable throwable;
        DataSet dataSet;
        ArrayList pkIds = new ArrayList();
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            dataSet = QueryServiceHelper.queryDataSet((String)"getAdminOfUser", (String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)BizPartnerUtil.getCurBizPartner()).and(new QFilter("isadmin", "=", (Object)"1")).and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"bizpartner");
            throwable = null;
            try {
                dataSet.forEach(row -> pkIds.add(row.getLong("bizpartner")));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)"getAdminOfUser", (String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"bizpartner");
        throwable = null;
        try {
            dataSet.forEach(row -> pkIds.add(row.getLong("bizpartner")));
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (dataSet != null) {
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"getAdminOfUser", (String)"bos_bizpartneruser", (String)"user", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", pkIds)}, (String)"user");){
            dataSet2.forEach(row -> userIds.add(row.getLong("user")));
        }
        return userIds;
    }

    public static final Set<Long> getBizPartnerIds() {
        HashSet<Long> pkIds = new HashSet<Long>();
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            pkIds.add(BizPartnerUtil.getCurBizPartner());
        } else {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))}, (String)"bizpartner");){
                dataSet.forEach(row -> pkIds.add(row.getLong("bizpartner")));
            }
        }
        return pkIds;
    }

    public static final DynamicObjectCollection getSupplierAdminUser(String selects) {
        QFilter filter = null;
        filter = BizPartnerUtil.isEnableChangeSupplier() ? new QFilter("bizpartner", "=", (Object)BizPartnerUtil.getCurBizPartner()) : new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter isAdmin = new QFilter("isadmin", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{filter, isAdmin};
        DynamicObjectCollection bizPartnerUsers = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)selects, (QFilter[])qFilters);
        return bizPartnerUsers;
    }

    public static final DynamicObjectCollection getBizPartners() {
        QFilter[] qFilters = null;
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            QFilter id = new QFilter("bizpartner", "=", (Object)BizPartnerUtil.getCurBizPartner());
            qFilters = new QFilter[]{id};
        } else {
            QFilter user = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
            qFilters = new QFilter[]{user};
        }
        String selectFields = "bizpartner.id bizpartner,bizpartner.number bizpartnernumber";
        DynamicObjectCollection bizPartnerUsers = QueryServiceHelper.query((String)"bos_bizpartneruser", (String)selectFields, (QFilter[])qFilters);
        return null != bizPartnerUsers ? bizPartnerUsers : null;
    }

    public static final HashSet<String> getBizPartnerNumber() {
        DynamicObjectCollection bizPartnerUsers = BizPartnerUtil.getBizPartners();
        if (null != bizPartnerUsers && bizPartnerUsers.size() > 0) {
            HashSet<String> numberSet = new HashSet<String>(bizPartnerUsers.size());
            for (DynamicObject dynamicObject : bizPartnerUsers) {
                String number = dynamicObject.getString("bizpartnernumber");
                if (null == number) continue;
                numberSet.add(number);
            }
            return numberSet;
        }
        return null;
    }

    public static final HashSet<Long> getBizPartnerId() {
        DynamicObjectCollection bizPartnerUsers = BizPartnerUtil.getBizPartners();
        if (null != bizPartnerUsers && bizPartnerUsers.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>(bizPartnerUsers.size());
            for (DynamicObject dynamicObject : bizPartnerUsers) {
                Long id = dynamicObject.getLong("bizpartner");
                if (null == id) continue;
                idSet.add(id);
            }
            return idSet;
        }
        return null;
    }

    public static final Long getBizPartnerBySupplier(long supplierId) {
        String selectFields = "bizpartner.id bizpartner";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)supplierId)};
        DynamicObject bizPartnerUser = QueryServiceHelper.queryOne((String)"bd_supplier2", (String)selectFields, (QFilter[])qFilters);
        return null != bizPartnerUser ? Long.valueOf(bizPartnerUser.getLong("bizpartner")) : null;
    }

    public static final ArrayList<Long> getSupplierByBizPartner() {
        String selectFields = "id,bizpartner.id bizpartner";
        QFilter[] qFilters = new QFilter[]{new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerId())};
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier2", (String)selectFields, (QFilter[])qFilters);
        if (suppliers != null && suppliers.size() > 0) {
            ArrayList<Long> idSet = new ArrayList<Long>(suppliers.size());
            for (DynamicObject dynamicObject : suppliers) {
                Long id = dynamicObject.getLong("id");
                if (id == null) continue;
                idSet.add(id);
            }
            return idSet;
        }
        return null;
    }

    public static final DynamicObjectCollection getSupplierCollByBizPartner() {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerId())};
        StringBuilder selectFields = new StringBuilder().append("id").append(",").append("bizpartner").append(",").append("paycond").append(",").append("settlementtypeid").append(",").append("settlementcyid");
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier2", (String)selectFields.toString(), (QFilter[])qFilters);
        return suppliers;
    }

    public static DynamicObjectCollection getUserOfAdminSupUser(String selects) {
        QFilter[] qFilters = null;
        qFilters = BizPartnerUtil.isEnableChangeSupplier() ? new QFilter[]{new QFilter("bizpartner", "=", (Object)BizPartnerUtil.getCurBizPartner()).and(new QFilter("isadmin", "=", (Object)"1")).and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))} : new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))};
        DynamicObjectCollection purUser = QueryServiceHelper.query((String)"pur_supuser", (String)selects, (QFilter[])qFilters, (String)"user");
        return purUser;
    }
}

