/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.action.common;

import java.io.Serializable;
import kd.bos.ext.occ.action.common.CodeMsg;

public class ActionResult<T>
implements Serializable {
    private static final long serialVersionUID = 1538478481881610816L;
    private String code;
    private String msg;
    private T data;

    public ActionResult() {
    }

    public ActionResult(CodeMsg codeMsg, T data) {
        this.code = String.valueOf(codeMsg.getCode());
        this.msg = codeMsg.getMsg();
        this.data = data;
    }

    public ActionResult(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <T> ActionResult<T> success(String msg, T data) {
        return new ActionResult<T>("200", msg, data);
    }

    public static <T> ActionResult<T> fail(String msg, T data) {
        return new ActionResult<T>("500", msg, data);
    }

    public static <T> ActionResult<T> fail(CodeMsg codeMsg, String msg, T data) {
        return new ActionResult<T>("" + codeMsg.getCode(), msg, data);
    }

    public static <T> ActionResult<T> complete(String msg, T data) {
        return new ActionResult<T>("300", msg, data);
    }

    public static <T> ActionResult<T> success(CodeMsg codeMsg, T data) {
        return new ActionResult<T>(codeMsg, data);
    }

    public static <T> ActionResult<T> error(CodeMsg codeMsg, T data) {
        return new ActionResult<T>(codeMsg, data);
    }

    public static <T> ActionResult<T> complete(CodeMsg codeMsg, T data) {
        return new ActionResult<T>(codeMsg, data);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

