/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.operation.bizrule;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.ext.occ.operation.bizrule.Lock;
import kd.bos.ext.occ.util.DynamicObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class BalanceService {
    private static final Log logger = LogFactory.getLog(BalanceService.class);
    public static final String P_occpic_rebatestatement = "occpic_rebatestatement";

    private Map<String, Object> tryLock(String entityKey, String operateKey, DynamicObject balUpdateRule, List<Map<String, Object>> dataList, Lock lock, List<Map<String, Object>> resultList) {
        HashMap<String, Object> checkResult = null;
        String updateType = DynamicObjectUtils.getString(balUpdateRule, "updatetype");
        DynamicObjectCollection dimColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "dimdataentity");
        DynamicObjectCollection updateColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "updatedataentity");
        ArrayList<String> localKeys = new ArrayList<String>(0);
        for (Map<String, Object> dataRow : dataList) {
            Object dimension2;
            String billNo = this.convertObjectToString(dataRow.get("billno"));
            StringBuilder dimensionValue = new StringBuilder();
            for (Object dimension2 : dimColl) {
                String dimBillCol = DynamicObjectUtils.getString((DynamicObject)dimension2, "dimbillcol");
                String dimValType = DynamicObjectUtils.getString((DynamicObject)dimension2, "dimvaltype");
                if (StringUtils.equals((CharSequence)dimValType, (CharSequence)"0") || !dataRow.containsKey(dimBillCol)) continue;
                dimensionValue.append(dimBillCol).append(":").append(dataRow.get(dimBillCol)).append(";");
            }
            StringBuilder updateValue = new StringBuilder();
            dimension2 = updateColl.iterator();
            while (dimension2.hasNext()) {
                DynamicObject updateItem = (DynamicObject)dimension2.next();
                String updateBalCol = DynamicObjectUtils.getString(updateItem, "updatebalcol");
                String updateValType = DynamicObjectUtils.getString(updateItem, "updatevaltype");
                if (StringUtils.equals((CharSequence)updateValType, (CharSequence)"0") || !dataRow.containsKey(updateBalCol)) continue;
                updateValue.append(updateBalCol).append(":").append(dataRow.get(updateBalCol)).append(";");
            }
            String lockKey = dimensionValue.toString();
            if (!localKeys.contains(lockKey)) {
                if (!lock.tryLock(lockKey)) {
                    checkResult = new HashMap<String, Object>(0);
                    checkResult.put("success", false);
                    checkResult.put("billno", billNo);
                    String messageTemplate = "\u5355\u636e\u5bf9\u5e94\u7684\u8d44\u91d1\u6c60\u4f59\u989d\u5b58\u5728\u5e76\u53d1\u9501\uff08%s\uff09\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002";
                    checkResult.put("message", String.format(messageTemplate, lockKey));
                    logger.info("BalanceService.tryLock\u83b7\u53d6\u9501\u5931\u8d25: {}", (Object)messageTemplate);
                    logger.info("BalanceService.tryLock\u5b58\u5728\u5e76\u53d1\u9501\uff0c\u6392\u9664\u6b64\u5355\u66f4\u65b0\u8d44\u91d1\u6c60\u64cd\u4f5c--\u5355\u636e\u7c7b\u578b\uff1a{} , \u5355\u636e\u7f16\u53f7 \uff1a{} ", (Object)entityKey, (Object)billNo);
                    break;
                }
                logger.info("BalanceService.tryLock\u4e0d\u5b58\u5728\u5e76\u53d1\u9501\uff0c\u5355\u636e\u4fe1\u606f\u5982\u4e0b\uff1a");
                logger.info("\u5355\u636e\u7c7b\u578b\uff1a{} \uff0c\u5355\u636e\u7f16\u53f7\uff1a{} \uff0c\u64cd\u4f5c\uff1a{} \uff0c\u66f4\u65b0\u65b9\u5411\uff1a{} \uff0c\u672c\u6b21\u8d44\u91d1\u6c60\u66f4\u65b0\u6570\u636e\uff1a{} ", new Object[]{entityKey, billNo, operateKey, updateType, updateValue.toString()});
                logger.info("BalanceService.tryLock\u6784\u9020lockkey\u7528\u4e8e\u5224\u65ad\u662f\u5426\u5b58\u5728\u5e76\u53d1\u9501\uff0clockkey(billno:dimensionvalue) \uff1a {}:{}", (Object)billNo, (Object)lockKey);
                localKeys.add(lockKey);
            }
            resultList.add(dataRow);
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> update(DynamicObject[] bills, String operateKey, Map<String, Object> params) {
        long beginUpdateTime = System.currentTimeMillis();
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(0);
        logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989dupdate begin:" + beginUpdateTime);
        if (bills == null || bills.length == 0) {
            return results;
        }
        String entityKey = bills[0].getDataEntityType().getName();
        Lock lock = new Lock();
        try {
            if (params != null && !params.isEmpty()) {
                this.updateRollbackEx(params);
            } else {
                HashSet<Long> billIds = new HashSet<Long>(0);
                HashSet<DynamicObject> billDatas = new HashSet<DynamicObject>(0);
                for (DynamicObject bill : bills) {
                    billDatas.add(bill);
                    billIds.add(DynamicObjectUtils.getPkValue(bill));
                    if (billIds.size() != 3) continue;
                    logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d update billIds: {}", (Object)StringUtils.join((Object[])billIds.toArray(), (String)","));
                    this.update(entityKey, operateKey, billIds, billDatas, lock, results);
                    billIds.clear();
                    billDatas.clear();
                }
                if (billIds.size() > 0 && billDatas.size() > 0) {
                    logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d update billIds: {}", (Object)StringUtils.join((Object[])billIds.toArray(), (String)","));
                    this.update(entityKey, operateKey, billIds, billDatas, lock, results);
                }
            }
        }
        finally {
            lock.close();
            long closeUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d update-- end \u8017\u65f6 \uff1a {} ms\u3002", (Object)(closeUpdateTime - beginUpdateTime));
        }
        return results;
    }

    private void update(String entityKey, String operateKey, Set<Long> billIds, Set<DynamicObject> billDatas, Lock lock, List<Map<String, Object>> results) {
        try {
            long currentUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u83b7\u53d6\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u89c4\u5219 begin\uff1a{}", (Object)currentUpdateTime);
            List<DynamicObject> balUpdateRuleColl = this.getBalUpdateRule(entityKey, operateKey);
            long closeUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u83b7\u53d6\u8d44\u91d1\u6c60\u4f59\u989d\u66f4\u65b0\u89c4\u5219 end\uff1a{} \u8017\u65f6\uff1a{} ms", (Object)closeUpdateTime, (Object)(closeUpdateTime - currentUpdateTime));
            currentUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u83b7\u53d6\u66f4\u65b0\u8d44\u91d1\u6c60\u6d41\u6c34 begin\uff1a{}", (Object)currentUpdateTime);
            DynamicObjectCollection flowRecordColl = this.getFlowRecordData(billIds, "", entityKey, 0L);
            closeUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u83b7\u53d6\u66f4\u65b0\u8d44\u91d1\u6c60\u6d41\u6c34 end\uff1a{} \u8017\u65f6\uff1a{} ms", (Object)closeUpdateTime, (Object)(closeUpdateTime - currentUpdateTime));
            HashMap<Long, Map<String, Map<String, String>>> hasFieldMap = new HashMap<Long, Map<String, Map<String, String>>>(0);
            currentUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u6309\u7167\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u83b7\u53d6\u6e90\u5355\u6570\u636e begin\uff1a{}", (Object)currentUpdateTime);
            List<Map<String, Object>> resultList = this.getDataList(billIds, billDatas.toArray(new DynamicObject[0]), entityKey, balUpdateRuleColl, flowRecordColl, operateKey, hasFieldMap, results);
            closeUpdateTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u6309\u7167\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u83b7\u53d6\u6e90\u5355\u6570\u636e end\uff1a{} \u8017\u65f6\uff1a{} ms", (Object)closeUpdateTime, (Object)(closeUpdateTime - currentUpdateTime));
            if (resultList.size() == 0) {
                return;
            }
            String operateName = this.getOperationItem(entityKey, operateKey);
            try (TXHandle handle = TX.requiresNew();){
                for (DynamicObject bill : billDatas) {
                    long billId = DynamicObjectUtils.getPkValue(bill);
                    String billNo = DynamicObjectUtils.getString(bill, "billno");
                    logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u5355\u636e\u7f16\u7801\uff1a%s,\u5355\u636eID:%d", billNo, billId));
                    for (DynamicObject balUpdateRule : balUpdateRuleColl) {
                        long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
                        String updateOpVal = DynamicObjectUtils.getString(balUpdateRule, "updateopval");
                        List<String> updateOps = Arrays.asList(updateOpVal.split(","));
                        String rollbackOpVal = DynamicObjectUtils.getString(balUpdateRule, "rollbackopval");
                        List<String> rollbackOps = Arrays.asList(rollbackOpVal.split(","));
                        List<Map<String, Object>> dataList = resultList.stream().filter(x -> this.stringToLong(x.get("id")) == billId && this.stringToLong(x.get("balupdateruleid")) == balUpdateRuleId).collect(Collectors.toList());
                        if (dataList.size() == 0) continue;
                        ArrayList<Map<String, Object>> dataResultList = new ArrayList<Map<String, Object>>(0);
                        currentUpdateTime = System.currentTimeMillis();
                        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s update---tryLock begin : %s(%s)", billNo, currentUpdateTime, new Date(currentUpdateTime)));
                        Map<String, Object> checkResult = this.tryLock(entityKey, operateKey, balUpdateRule, dataList, lock, dataResultList);
                        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s update---tryLock end : %s", billNo, System.currentTimeMillis()));
                        if (checkResult != null) {
                            results.add(checkResult);
                            resultList.clear();
                            continue;
                        }
                        if (dataResultList.size() == 0) continue;
                        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && StringUtils.equals((CharSequence)rollbackOpVal, (CharSequence)"delete")) {
                            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u8fdb\u5165\u5220\u9664\u56de\u6eda\u64cd\u4f5c");
                            boolean isSuccess = this.deleteRollback(handle, entityKey, operateKey, operateName, billId, billNo, balUpdateRule, results);
                            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u5220\u9664\u56de\u6eda\u64cd\u4f5c\u5b8c\u6210");
                            if (isSuccess) continue;
                            return;
                        }
                        boolean isUpdateOp = updateOps.contains(operateKey);
                        boolean isRollbackOp = rollbackOps.contains(operateKey);
                        if (!isUpdateOp && !isRollbackOp) continue;
                        List<DynamicObject> flowRecords = flowRecordColl.stream().filter(x -> DynamicObjectUtils.getLong(x, "sourcebillid") == billId && updateOps.contains(DynamicObjectUtils.getString(x, "operation")) && DynamicObjectUtils.getString(x, "billentity").equals(entityKey) && DynamicObjectUtils.getLong(x, "balupdaterule") == balUpdateRuleId).collect(Collectors.toList());
                        boolean isSuccess = this.updateRebateAccount(handle, entityKey, billId, billNo, dataResultList, flowRecords, hasFieldMap, operateKey, operateName, balUpdateRule, isUpdateOp, isRollbackOp, results);
                        if (isSuccess) continue;
                        return;
                    }
                }
                handle.commit();
            }
        }
        catch (Exception ex) {
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:\u66f4\u65b0\u5f02\u5e38,\u5f02\u5e38\u6d88\u606f\uff1a{}", (Object)ex.getMessage());
        }
    }

    private boolean updateRebateAccount(TXHandle handle, String entityKey, Long billId, String billNo, List<Map<String, Object>> dataResultList, List<DynamicObject> flowRecords, Map<Long, Map<String, Map<String, String>>> hasFieldMap, String operateKey, String operateName, DynamicObject balUpdateRule, boolean isUpdateOp, boolean isRollbackOp, List<Map<String, Object>> results) {
        try {
            List<Map<String, Object>> checkResults;
            long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
            Map<String, Map<String, String>> hasFields = hasFieldMap.get(balUpdateRuleId);
            if (hasFields == null || hasFields.isEmpty()) {
                logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u83b7\u53d6\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            Map hasDimFieldMap = hasFields.getOrDefault("hasdimfield", new HashMap(0));
            if (hasDimFieldMap.size() == 0) {
                logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s hasdimfield\u83b7\u53d6\u7ef4\u5ea6\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            Map hasUpdateFieldMap = hasFields.getOrDefault("hasupdatefield", new HashMap(0));
            if (hasUpdateFieldMap.size() == 0) {
                logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s hasupdatefield\u83b7\u53d6\u66f4\u65b0\u6570\u636e\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            Map hasFlowFieldMap = hasFields.getOrDefault("hasflowfield", new HashMap(0));
            if (hasFlowFieldMap.size() == 0) {
                logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s hasflowfield\u83b7\u53d6\u6d41\u6c34\u5b57\u6bb5\u914d\u7f6e\u5931\u8d25", billNo));
                return false;
            }
            boolean autoReOpRollback = DynamicObjectUtils.getBoolean(balUpdateRule, "autoreoprollback");
            if (flowRecords != null && flowRecords.size() > 0 && (isRollbackOp || isUpdateOp && autoReOpRollback)) {
                Object[] flowRecordIds = flowRecords.stream().map(x -> DynamicObjectUtils.getLong(x, "id")).distinct().toArray();
                String updateType = "";
                updateType = isUpdateOp && autoReOpRollback ? "1" : "2";
                checkResults = this.rollbackRebateAccount(entityKey, billId, billNo, balUpdateRule, flowRecordIds, isUpdateOp, updateType, operateKey, operateName);
                results.addAll(checkResults);
                if (checkResults.size() == 0 || checkResults.stream().anyMatch(x -> (Boolean)x.get("success") == false)) {
                    handle.markRollback();
                    return false;
                }
            }
            if (isUpdateOp) {
                checkResults = this.saveRebateAccount(billId, entityKey, balUpdateRule, dataResultList, hasDimFieldMap, hasUpdateFieldMap, hasFlowFieldMap, operateKey, operateName);
                results.addAll(checkResults);
                if (checkResults.size() == 0 || checkResults.stream().anyMatch(x -> (Boolean)x.get("success") == false)) {
                    handle.markRollback();
                    return false;
                }
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            results.add(result);
            logger.error(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s update---updateRebateAccount catch error :%s", billNo, ex.getMessage()));
            handle.markRollback();
            return false;
        }
        return true;
    }

    private void updateRollbackEx(Map<String, Object> params) {
        HashSet flowRecordIdSet = new HashSet(0);
        HashSet rollbackFlowRecordIdSet = new HashSet(0);
        if (params.containsKey("flowrecordids")) {
            Set flowRecordIds = (Set)params.get("flowrecordids");
            flowRecordIdSet.addAll(flowRecordIds);
        }
        if (params.containsKey("rollbackflowrecordids")) {
            Set rollbackFlowRecordIds = (Set)params.get("rollbackflowrecordids");
            rollbackFlowRecordIdSet.addAll(rollbackFlowRecordIds);
        }
        HashSet allFlowRecordId = new HashSet(0);
        allFlowRecordId.addAll(flowRecordIdSet);
        allFlowRecordId.addAll(rollbackFlowRecordIdSet);
        if (allFlowRecordId.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                MainEntityType flowRecordType = EntityMetadataCache.getDataEntityType((String)"occba_flowrecord");
                DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])allFlowRecordId.toArray(), (DynamicObjectType)flowRecordType);
                if (flowRecordData == null || flowRecordData.length == 0) {
                    return;
                }
                boolean isSuccess = this.saveRollbackRebateAccountEx(flowRecordData);
                if (!isSuccess) {
                    handle.markRollback();
                    return;
                }
                QFilter qFilter = new QFilter("id", "in", (Object)flowRecordIdSet.toArray());
                DeleteServiceHelper.delete((String)"occba_flowrecord", (QFilter[])qFilter.toArray());
                DynamicObject[] rollbackFlowRecords = (DynamicObject[])Arrays.stream(flowRecordData).filter(x -> rollbackFlowRecordIdSet.contains(DynamicObjectUtils.getPkValue(x))).distinct().toArray(DynamicObject[]::new);
                this.saveFlowRecord(rollbackFlowRecords, "A");
                handle.commit();
            }
        }
    }

    private boolean deleteRollback(TXHandle handle, String entityKey, String operateKey, String rollbackOpName, long billId, String billNo, DynamicObject balUpdateRule, List<Map<String, Object>> results) {
        try {
            long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
            DynamicObjectCollection flowRecordColl = this.getFlowRecordData(Collections.singleton(billId), null, entityKey, balUpdateRuleId);
            if (flowRecordColl != null && flowRecordColl.size() > 0) {
                logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:rollbackRebateAccount\u8fdb\u5165\u56de\u6eda\u5904\u7406");
                List<Map<String, Object>> checkResults = this.rollbackRebateAccount(entityKey, billId, billNo, balUpdateRule, flowRecordColl, operateKey, rollbackOpName);
                if (checkResults.size() > 0 && checkResults.stream().anyMatch(x -> (Boolean)x.get("success") == false)) {
                    results.addAll(checkResults);
                    handle.markRollback();
                    return false;
                }
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            results.add(result);
            logger.error(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s update---deleteRollback catch error : %s", billNo, ex.getMessage()));
            handle.markRollback();
            return false;
        }
        return true;
    }

    private List<Map<String, Object>> getDataList(Set<Long> billIds, DynamicObject[] bills, String entityKey, List<DynamicObject> balUpdateRuleColl, DynamicObjectCollection flowRecordColl, String operateKey, Map<Long, Map<String, Map<String, String>>> hasFieldMap, List<Map<String, Object>> results) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(0);
        String strBillId = StringUtils.join((Object[])billIds.toArray(), (String)",");
        for (DynamicObject balUpdateRule : balUpdateRuleColl) {
            try {
                boolean isRollbackOp;
                long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
                String updateOpVal = DynamicObjectUtils.getString(balUpdateRule, "updateopval");
                List<String> updateOps = Arrays.asList(updateOpVal.split(","));
                String rollbackOpVal = DynamicObjectUtils.getString(balUpdateRule, "rollbackopval");
                List<String> rollbackOps = Arrays.asList(rollbackOpVal.split(","));
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"delete") && rollbackOps.contains("delete")) {
                    List<Map<String, Object>> dataList = this.getBillData(balUpdateRule, bills, entityKey);
                    if (dataList.size() <= 0) continue;
                    resultList.addAll(dataList);
                    continue;
                }
                boolean isUpdateOp = updateOps.contains(operateKey);
                boolean bl = isRollbackOp = rollbackOps.contains(operateKey) || StringUtils.equals((CharSequence)"rollback", (CharSequence)operateKey);
                if (!isUpdateOp && !isRollbackOp) continue;
                boolean isRollback = !isUpdateOp;
                HashMap<String, String> hasDimFieldMap = new HashMap<String, String>(0);
                HashMap<String, String> hasUpdateFieldMap = new HashMap<String, String>(0);
                HashMap<String, String> hasUpdateFieldNameMap = new HashMap<String, String>(0);
                HashMap<String, String> hasFlowFieldMap = new HashMap<String, String>(0);
                HashMap<String, String> hasFlowFieldNameMap = new HashMap<String, String>(0);
                HashSet<Long> updateBillIds = new HashSet<Long>(0);
                updateBillIds.addAll(billIds);
                if (isRollback) {
                    for (Long billId : billIds) {
                        boolean isUpdate = flowRecordColl.stream().anyMatch(x -> DynamicObjectUtils.getLong(x, "sourcebillid") == billId && updateOps.contains(DynamicObjectUtils.getString(x, "operation")));
                        if (isUpdate) continue;
                        updateBillIds.remove(billId);
                    }
                }
                if (updateBillIds.size() == 0) continue;
                DataSet billData = this.getBillData(balUpdateRule, operateKey, updateBillIds, hasDimFieldMap, hasUpdateFieldMap, hasUpdateFieldNameMap, hasFlowFieldMap, hasFlowFieldNameMap, isRollback);
                HashMap<String, HashMap<String, String>> hasFields = new HashMap<String, HashMap<String, String>>(0);
                hasFields.put("hasdimfield", hasDimFieldMap);
                hasFields.put("hasupdatefield", hasUpdateFieldMap);
                hasFields.put("hasupdatefieldname", hasUpdateFieldNameMap);
                hasFields.put("hasflowfield", hasFlowFieldMap);
                hasFields.put("hasflowfieldname", hasFlowFieldNameMap);
                hasFieldMap.put(balUpdateRuleId, hasFields);
                if (billData == null || billData.isEmpty()) continue;
                List<Map<String, Object>> dataList = this.getDataList(billData, balUpdateRuleId);
                resultList.addAll(dataList);
            }
            catch (Exception ex) {
                HashMap<String, Object> result = new HashMap<String, Object>(0);
                result.put("success", false);
                result.put("billno", strBillId);
                result.put("message", ex.getMessage());
                result.put("messagetype", "fail");
                results.add(result);
                logger.error(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s update---getDataList catch error : %s", strBillId, ex.getMessage()));
            }
        }
        return resultList;
    }

    public List<Map<String, Object>> rollbackRebateAccount(String entityKey, long billId, String billNo, DynamicObject balUpdateRule, Object[] flowRecordIds, boolean isUpdate, String updateType, String operateKey, String operateName) {
        List<Object> checkResults = new ArrayList(0);
        if (isUpdate) {
            operateName = operateName + "\u56de\u6eda";
        }
        try {
            DynamicObject[] flowRecordData = this.loadFlowRecord(flowRecordIds);
            checkResults = this.saveRollbackRebateAccount(entityKey, billId, balUpdateRule, flowRecordData, operateKey, operateName, updateType);
            if (checkResults.size() > 0 && checkResults.stream().anyMatch(x -> (Boolean)x.get("success"))) {
                this.saveFlowRecord(flowRecordData, "B");
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            logger.error("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d update---rollbackRebateAccount catch error : " + ex.getMessage());
            checkResults.add(result);
        }
        return checkResults;
    }

    private DynamicObject[] loadFlowRecord(Object[] flowRecordIds) {
        ArrayList<DynamicObject> flowRecords = new ArrayList<DynamicObject>(0);
        if (flowRecordIds == null || flowRecordIds.length == 0) {
            return flowRecords.toArray(new DynamicObject[0]);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"occba_flowrecord");
        HashSet<Object> flowRecordIdSet = new HashSet<Object>(0);
        for (Object flowRecordId : flowRecordIds) {
            flowRecordIdSet.add(flowRecordId);
            if (flowRecordIdSet.size() != 5000) continue;
            DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])flowRecordIdSet.toArray(), (DynamicObjectType)entityType);
            flowRecords.addAll(Arrays.asList(flowRecordData));
            flowRecordIdSet.clear();
        }
        if (flowRecordIdSet.size() > 0) {
            DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])flowRecordIdSet.toArray(), (DynamicObjectType)entityType);
            flowRecords.addAll(Arrays.asList(flowRecordData));
        }
        return flowRecords.toArray(new DynamicObject[0]);
    }

    private DynamicObjectCollection queryBalFlowType(Set<Long> balFlowTypeIds) {
        DynamicObjectCollection flowTypes = null;
        if (balFlowTypeIds.size() > 0) {
            String selectFields = "id,updatetrans,rollbackflowtype,rollbacktrans";
            QFilter qFilter = new QFilter("id", "in", balFlowTypeIds);
            flowTypes = QueryServiceHelper.query((String)"ocdbd_balflowtype", (String)selectFields, (QFilter[])qFilter.toArray());
        }
        return flowTypes;
    }

    public List<Map<String, Object>> rollbackRebateAccount(String entityKey, long billId, String billNo, DynamicObject balUpdateRule, DynamicObjectCollection flowRecordColl, String operateKey, String operateName) {
        List<Object> checkResults = new ArrayList(0);
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"occba_flowrecord");
            Object[] flowRecordIds = flowRecordColl.stream().map(x -> DynamicObjectUtils.getLong(x, "id")).distinct().toArray();
            DynamicObject[] flowRecordData = BusinessDataServiceHelper.load((Object[])flowRecordIds, (DynamicObjectType)entityType);
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:saveRollbackRebateAccount\u8fdb\u5165\u56de\u6eda\u5904\u7406");
            checkResults = this.saveRollbackRebateAccount(entityKey, billId, balUpdateRule, flowRecordData, operateKey, operateName, "3");
            logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:saveRollbackRebateAccount\u56de\u6eda\u5904 \u7406\u5b8c\u6210" + this.convertObjectToString(checkResults));
            if (checkResults.size() > 0 && checkResults.stream().anyMatch(x -> (Boolean)x.get("success"))) {
                logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:saveFlowRecord\u8fdb\u5165\u4fdd\u5b58\u6d41\u6c34\u5904\u7406");
                this.saveFlowRecord(flowRecordData, "B");
            }
        }
        catch (Exception ex) {
            HashMap<String, Object> result = new HashMap<String, Object>(0);
            result.put("success", false);
            result.put("billno", billNo);
            result.put("message", ex.getMessage());
            result.put("messagetype", "fail");
            logger.error("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d update---rollbackRebateAccount catch error : " + ex.getMessage());
            checkResults.add(result);
        }
        return checkResults;
    }

    private DataSet getBillData(DynamicObject balUpdateRule, String operateKey, Set<Long> billIds, Map<String, String> hasDimFieldMap, Map<String, String> hasUpdateFieldMap, Map<String, String> hasUpdateFieldNameMap, Map<String, String> hasFlowFieldMap, Map<String, String> hasFlowFieldNameMap, boolean isRollback) {
        Object[] qFilters;
        long beginUpdateLockTime = System.currentTimeMillis();
        long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
        String strBillIds = StringUtils.join((Object[])billIds.toArray(), (String)",");
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u4f59\u989d:%s update lock begin time: %s", strBillIds, new Date(beginUpdateLockTime)));
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u4f59\u989d:%s update loop rule id : %s -----\u672c\u6b21\u66f4\u65b0\u64cd\u4f5c :%s", strBillIds, balUpdateRuleId, operateKey));
        DynamicObject srcBill = DynamicObjectUtils.getDynamicObject(balUpdateRule, "srcbill");
        if (srcBill == null) {
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u4f59\u989d:%s srcbill is null", strBillIds));
            return null;
        }
        String srcBillKey = srcBill.getString("id");
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u83b7\u53d6\u6e90\u5355\u6807\u8bc6 : %s", strBillIds, srcBillKey));
        DynamicObject balObj = DynamicObjectUtils.getDynamicObject(balUpdateRule, "balobj");
        if (balObj == null) {
            logger.info("\u66f4\u65b0\u8d44\u91d1\u4f59\u989d balobj is null");
            return null;
        }
        String balObjKey = balObj.getString("id");
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d \u83b7\u53d6\u4f59\u989d\u8868\u6807\u8bc6 : %s", balObjKey));
        String updateType = DynamicObjectUtils.getString(balUpdateRule, "updatetype");
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d \u4f59\u989d\u66f4\u65b0\u89c4\u5219\u66f4\u65b0\u65b9\u5411 : %s", updateType));
        if (!isRollback) {
            String dataFilterFormula = DynamicObjectUtils.getString(balUpdateRule, "datafilterformula");
            QFilter dataFilter = this.filterStringToQFilter(srcBillKey, dataFilterFormula);
            QFilter billIdQFilter = new QFilter("id", "in", billIds);
            qFilters = new QFilter[]{billIdQFilter, dataFilter};
        } else {
            QFilter billIdQFilter = new QFilter("id", "in", billIds);
            qFilters = new QFilter[]{billIdQFilter};
        }
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d \u6570\u636e\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", Arrays.toString(qFilters)));
        DynamicObjectCollection dimDataColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "dimdataentity");
        if (dimDataColl == null || dimDataColl.size() == 0) {
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u7ef4\u5ea6\u6620\u5c04\u914d\u7f6e\u4e3a\u7a7a", strBillIds));
            return null;
        }
        MainEntityType srcEntity = MetadataServiceHelper.getDataEntityType((String)srcBillKey);
        StringBuilder dimFullColKeys = new StringBuilder();
        dimFullColKeys.append("id,billno");
        dimFullColKeys.append(",").append((CharSequence)this.getDimensionConfig(srcEntity, balObjKey, dimDataColl, hasDimFieldMap));
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u7ef4\u5ea6\u914d\u7f6e dimFullColKeys\uff1a%s", strBillIds, dimFullColKeys));
        DynamicObjectCollection updateDataColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "updatedataentity");
        if (updateDataColl == null || updateDataColl.size() == 0) {
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u66f4\u65b0\u6570\u636e\u914d\u7f6e\u4e3a\u7a7a", strBillIds));
            return null;
        }
        String updateFullColKeys = this.getUpdateFieldConfig(srcEntity, updateDataColl, hasUpdateFieldMap, hasUpdateFieldNameMap);
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d%s \u66f4\u65b0\u6570\u636e\u914d\u7f6e updateFullColKeys\uff1a%s", strBillIds, updateFullColKeys));
        DynamicObjectCollection flowDataColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "flowdataentity");
        if (flowDataColl == null || flowDataColl.size() == 0) {
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u6d41\u6c34\u6570\u636e\u914d\u7f6e\u4e3a\u7a7a", strBillIds));
            return null;
        }
        String flowFullColKeys = this.getFlowFieldConfig(srcEntity, flowDataColl, hasFlowFieldMap, hasFlowFieldNameMap);
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u6d41\u6c34\u6570\u636e\u914d\u7f6e updateFullColKeys\uff1a%s", strBillIds, updateFullColKeys));
        if (StringUtils.isNotEmpty((CharSequence)updateFullColKeys)) {
            dimFullColKeys.append(",").append(updateFullColKeys);
        }
        if (StringUtils.isNotEmpty((CharSequence)flowFullColKeys)) {
            dimFullColKeys.append(",").append(flowFullColKeys);
        }
        String fullColKeyStr = dimFullColKeys.toString();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%s \u67e5\u8be2\u5b57\u6bb5 fullColKey\uff1a%s", fullColKeyStr, strBillIds));
        return QueryServiceHelper.queryDataSet((String)("algo_" + srcBillKey), (String)srcBillKey, (String)fullColKeyStr, (QFilter[])qFilters, (String)"");
    }

    private StringBuilder getDimensionConfig(MainEntityType srcEntity, String balObjKey, DynamicObjectCollection dimDataColl, Map<String, String> hasDimFieldMap) {
        StringBuilder dimFullColKeys = new StringBuilder();
        ArrayList<String> dimBillCols = new ArrayList<String>(0);
        MainEntityType balEntity = MetadataServiceHelper.getDataEntityType((String)balObjKey);
        for (DynamicObject dimData : dimDataColl) {
            String dimFixedValue;
            String dimValType = DynamicObjectUtils.getString(dimData, "dimvaltype");
            String dimBalCol = DynamicObjectUtils.getString(dimData, "dimbalcol");
            if (StringUtils.equals((CharSequence)dimValType, (CharSequence)"1")) {
                String colFullColKey;
                String dimBillCol = DynamicObjectUtils.getString(dimData, "dimbillcol");
                if (StringUtils.isEmpty((CharSequence)dimBalCol) || StringUtils.isEmpty((CharSequence)(colFullColKey = this.getColFullColKey(srcEntity, dimBillCol)))) continue;
                hasDimFieldMap.put(dimBalCol, dimBillCol);
                if (dimBillCols.contains(dimBillCol)) continue;
                if (!dimBillCol.equals("id") && !dimBillCol.equals("billno")) {
                    if (StringUtils.isEmpty((CharSequence)dimFullColKeys)) {
                        dimFullColKeys.append(colFullColKey).append(" as ").append(dimBillCol);
                    } else {
                        dimFullColKeys.append(",").append(colFullColKey).append(" as ").append(dimBillCol);
                    }
                }
                dimBillCols.add(dimBillCol);
                continue;
            }
            if (!StringUtils.equals((CharSequence)dimValType, (CharSequence)"4") || StringUtils.isEmpty((CharSequence)(dimFixedValue = DynamicObjectUtils.getString(dimData, "dimfixedvalue")))) continue;
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)dimFixedValue, CRFormula.class);
            String expression = formula.getExpression();
            hasDimFieldMap.put(dimBalCol, dimBalCol);
            if (dimBillCols.contains(dimBalCol)) continue;
            if (StringUtils.isEmpty((CharSequence)dimFullColKeys)) {
                dimFullColKeys.append("'").append(expression).append("' as ").append(dimBalCol);
            } else {
                dimFullColKeys.append(",'").append(expression).append("' as ").append(dimBalCol);
            }
            dimBillCols.add(dimBalCol);
        }
        return dimFullColKeys;
    }

    private String getUpdateFieldConfig(MainEntityType srcEntity, DynamicObjectCollection updateDataColl, Map<String, String> hasUpdateFieldMap, Map<String, String> hasUpdateFieldNameMap) {
        StringBuilder updateFullColKeys = new StringBuilder();
        ArrayList<String> updateBillCols = new ArrayList<String>(0);
        for (DynamicObject updateData : updateDataColl) {
            String updateValType = DynamicObjectUtils.getString(updateData, "updatevaltype");
            if (!StringUtils.equals((CharSequence)updateValType, (CharSequence)"1")) continue;
            String updateBalCol = DynamicObjectUtils.getString(updateData, "updatebalcol");
            String updateBalColName = DynamicObjectUtils.getString(updateData, "updatebalcolname");
            String updateBillCol = DynamicObjectUtils.getString(updateData, "updatebillcol");
            if (StringUtils.isEmpty((CharSequence)updateBalCol)) continue;
            hasUpdateFieldMap.put(updateBalCol, updateBillCol);
            hasUpdateFieldNameMap.put(updateBalCol, updateBalColName);
            if (updateBillCols.contains(updateBillCol)) continue;
            String colFullColKey = this.getColFullColKey(srcEntity, updateBillCol);
            updateBillCols.add(updateBillCol);
            if (StringUtils.isEmpty((CharSequence)colFullColKey)) continue;
            if (StringUtils.isEmpty((CharSequence)updateFullColKeys)) {
                updateFullColKeys.append(colFullColKey).append(" as ").append(updateBillCol);
                continue;
            }
            updateFullColKeys.append(",").append(colFullColKey).append(" as ").append(updateBillCol);
        }
        return updateFullColKeys.toString();
    }

    private String getFlowFieldConfig(MainEntityType srcEntity, DynamicObjectCollection flowDataColl, Map<String, String> hasFlowFieldMap, Map<String, String> hasFlowFieldNameMap) {
        StringBuilder flowFullColKeys = new StringBuilder();
        ArrayList<String> flowBillCols = new ArrayList<String>(0);
        for (DynamicObject flowData : flowDataColl) {
            String flowFixedValue;
            String colKey;
            String flowCol = DynamicObjectUtils.getString(flowData, "flowcol");
            String flowColName = DynamicObjectUtils.getString(flowData, "flowcolname");
            String flowBillCol = DynamicObjectUtils.getString(flowData, "flowbillcol");
            if (StringUtils.isEmpty((CharSequence)flowCol)) continue;
            hasFlowFieldNameMap.put(flowCol, flowColName);
            String flowValType = DynamicObjectUtils.getString(flowData, "flowvaltype");
            if (StringUtils.equals((CharSequence)flowValType, (CharSequence)"1")) {
                String colFullColKey = this.getColFullColKey(srcEntity, flowBillCol);
                if (StringUtils.isEmpty((CharSequence)colFullColKey)) continue;
                if (StringUtils.isEmpty((CharSequence)flowFullColKeys)) {
                    if (StringUtils.equals((CharSequence)flowCol, (CharSequence)"entry")) {
                        colKey = flowCol + "_flow";
                        hasFlowFieldMap.put(flowCol, colKey);
                        if (flowBillCols.contains(colKey)) continue;
                        flowBillCols.add(colKey);
                        flowFullColKeys.append(colFullColKey).append(" as ").append(colKey);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)flowBillCol)) continue;
                    colKey = flowBillCol + "_flow";
                    hasFlowFieldMap.put(flowCol, colKey);
                    if (flowBillCols.contains(colKey)) continue;
                    flowBillCols.add(colKey);
                    flowFullColKeys.append(colFullColKey).append(" as ").append(flowBillCol).append("_flow");
                    continue;
                }
                if (StringUtils.equals((CharSequence)flowCol, (CharSequence)"entry")) {
                    colKey = flowCol + "_flow";
                    hasFlowFieldMap.put(flowCol, colKey);
                    if (flowBillCols.contains(colKey)) continue;
                    flowBillCols.add(colKey);
                    flowFullColKeys.append(",").append(colFullColKey).append(" as ").append(flowCol).append("_flow");
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)flowBillCol)) continue;
                colKey = flowBillCol + "_flow";
                hasFlowFieldMap.put(flowCol, colKey);
                if (flowBillCols.contains(colKey)) continue;
                flowBillCols.add(colKey);
                flowFullColKeys.append(",").append(colFullColKey).append(" as ").append(colKey);
                continue;
            }
            if (!StringUtils.equals((CharSequence)flowValType, (CharSequence)"2") || StringUtils.isEmpty((CharSequence)(flowFixedValue = DynamicObjectUtils.getString(flowData, "flowfixedvalue")))) continue;
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)flowFixedValue, CRFormula.class);
            String expression = formula.getExpression();
            if (!StringUtils.equals((CharSequence)flowCol, (CharSequence)"balflowtype")) {
                colKey = flowCol + "_fixed";
                hasFlowFieldMap.put(flowCol, colKey);
                if (flowBillCols.contains(colKey)) continue;
                flowBillCols.add(colKey);
                if (StringUtils.isEmpty((CharSequence)flowFullColKeys)) {
                    flowFullColKeys.append("'").append(expression).append("' as ").append(colKey);
                    continue;
                }
                flowFullColKeys.append(",'").append(expression).append("' as ").append(colKey);
                continue;
            }
            hasFlowFieldMap.put(flowCol, flowCol);
            if (flowBillCols.contains(flowCol)) continue;
            flowBillCols.add(flowCol);
            if (StringUtils.isEmpty((CharSequence)flowFullColKeys)) {
                flowFullColKeys.append("'").append(expression).append("' as ").append(flowCol);
                continue;
            }
            flowFullColKeys.append(",'").append(expression).append("' as ").append(flowCol);
        }
        return flowFullColKeys.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Object>> saveRebateAccount(long billId, String entityKey, DynamicObject balUpdateRule, List<Map<String, Object>> resultList, Map<String, String> hasDimFieldMap, Map<String, String> hasUpdateFieldMap, Map<String, String> hasFlowFieldMap, String operateKey, String operateName) {
        ArrayList<Map<String, Object>> checkResults = new ArrayList<Map<String, Object>>(0);
        long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
        String updateType = DynamicObjectUtils.getString(balUpdateRule, "updatetype");
        String negativeCtrl = DynamicObjectUtils.getString(balUpdateRule, "negativectrl");
        String positiveCtrl = DynamicObjectUtils.getString(balUpdateRule, "positivectrl");
        HashMap<String, Long> rebateAccountIdMap = new HashMap<String, Long>(0);
        ArrayList<DynamicObject> rebateAccountList = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> rebateStatementList = new ArrayList<DynamicObject>(0);
        HashMap<String, DynamicObject> rebateAccountMap = new HashMap<String, DynamicObject>(0);
        ArrayList<DynamicObject> saveFlowRecordList = new ArrayList<DynamicObject>(0);
        long beginUpdateTime = System.currentTimeMillis();
        HashSet<Long> balFlowTypeIds = new HashSet<Long>(0);
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u6309\u7ef4\u5ea6\u5339\u914d\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        for (Map<String, Object> dataRow : resultList) {
            DynamicObject rebateAccount;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            String rebateAccountType = "";
            if (hasDimFieldMap.containsKey("type")) {
                String srcFieldKey = hasDimFieldMap.get("type");
                rebateAccountType = this.convertObjectToString(dataRow.get(srcFieldKey));
            }
            for (Map.Entry entry : hasDimFieldMap.entrySet()) {
                String balFieldKey = (String)entry.getKey();
                String srcFieldKey = (String)entry.getValue();
                if (rebateAccountType.equals("A") && balFieldKey.equals("receivechannel") || rebateAccountType.equals("B") && (balFieldKey.equals("org") || balFieldKey.equals("customer"))) continue;
                QFilter qFilter = new QFilter(balFieldKey, "=", dataRow.get(srcFieldKey));
                String dimValue = this.convertObjectToString(dataRow.get(srcFieldKey));
                if (StringUtils.isEmpty((CharSequence)dimValue) || StringUtils.equals((CharSequence)dimValue, (CharSequence)"0")) {
                    qFilter.or(balFieldKey, "is null", null);
                }
                qFilters.add(qFilter);
            }
            long balFlowTypeId = this.stringToLong(dataRow.get("balflowtype"));
            balFlowTypeIds.add(balFlowTypeId);
            String filterKey = ((Object)qFilters).toString();
            if (rebateAccountIdMap.containsKey(filterKey) || (rebateAccount = QueryServiceHelper.queryOne((String)"ocdbd_rebateaccount", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]))) == null) continue;
            long rebateAccountId = DynamicObjectUtils.getLong(rebateAccount, "id");
            rebateAccountIdMap.put(filterKey, rebateAccountId);
        }
        long closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u6309\u7ef4\u5ea6\u5339\u914d\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d load\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        if (rebateAccountIdMap.size() > 0) {
            MainEntityType rebateAccountType = EntityMetadataCache.getDataEntityType((String)"ocdbd_rebateaccount");
            DynamicObject[] rebateAccounts = BusinessDataServiceHelper.load((Object[])rebateAccountIdMap.values().toArray(), (DynamicObjectType)rebateAccountType);
            rebateAccountList.addAll(Arrays.asList(rebateAccounts));
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d load\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d query\u6d41\u6c34\u7c7b\u578b begin:%d", billId, beginUpdateTime));
        DynamicObjectCollection flowTypes = this.queryBalFlowType(balFlowTypeIds);
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d query\u6d41\u6c34\u7c7b\u578b end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u66f4\u65b0\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        for (Map<String, Object> dataRow : resultList) {
            Map<String, Object> checkResult;
            DynamicObject rebateAccount;
            void var30_35;
            String string = "";
            if (hasDimFieldMap.containsKey("type")) {
                String srcFieldKey = hasDimFieldMap.get("type");
                String string2 = this.convertObjectToString(dataRow.get(srcFieldKey));
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(0);
            for (Map.Entry<String, String> dimField : hasDimFieldMap.entrySet()) {
                String balFieldKey = dimField.getKey();
                String srcFieldKey = dimField.getValue();
                if (var30_35.equals("A") && balFieldKey.equals("receivechannel") || var30_35.equals("B") && (balFieldKey.equals("org") || balFieldKey.equals("customer"))) continue;
                QFilter qFilter = new QFilter(balFieldKey, "=", dataRow.get(srcFieldKey));
                String dimValue = this.convertObjectToString(dataRow.get(srcFieldKey));
                if (StringUtils.isEmpty((CharSequence)dimValue) || StringUtils.equals((CharSequence)dimValue, (CharSequence)"0")) {
                    qFilter.or(balFieldKey, "is null", null);
                }
                qFilters.add(qFilter);
            }
            boolean bIsNew = false;
            String filterKey = ((Object)qFilters).toString();
            if (rebateAccountMap.containsKey(filterKey)) {
                rebateAccount = (DynamicObject)rebateAccountMap.get(filterKey);
            } else if (rebateAccountIdMap.get(filterKey) == null) {
                rebateAccount = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
                rebateAccount.set("number", (Object)this.getRebateAccountCode());
                for (Map.Entry entry : hasDimFieldMap.entrySet()) {
                    String balFieldKey = (String)entry.getKey();
                    String srcFieldKey = (String)entry.getValue();
                    if (var30_35.equals("A") && balFieldKey.equals("receivechannel") || var30_35.equals("B") && (balFieldKey.equals("org") || balFieldKey.equals("customer"))) continue;
                    Object dimValue = dataRow.get(srcFieldKey);
                    rebateAccount.set(balFieldKey, dimValue);
                }
                bIsNew = true;
            } else {
                long rebateAccountId = (Long)rebateAccountIdMap.get(filterKey);
                rebateAccount = rebateAccountList.stream().filter(x -> DynamicObjectUtils.getPkValue(x) == rebateAccountId).findFirst().orElse(null);
            }
            if (rebateAccount == null) continue;
            JSONObject amountValue = new JSONObject();
            BigDecimal bigDecimal = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
            this.getRebateAccount(dataRow, hasUpdateFieldMap, rebateAccount, updateType, amountValue);
            BigDecimal afterAmount = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
            String billNo = this.convertObjectToString(dataRow.get("billno"));
            if (StringUtils.equals((CharSequence)negativeCtrl, (CharSequence)"1") && (checkResult = this.checkNegativeRebateAccount(rebateAccount, billNo)) != null) {
                checkResults.add(checkResult);
                break;
            }
            if (StringUtils.equals((CharSequence)positiveCtrl, (CharSequence)"1") && (checkResult = this.checkPositiveRebateAccount(rebateAccount, billNo)) != null) {
                checkResults.add(checkResult);
                break;
            }
            if (bIsNew) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateAccount});
            }
            long rebateAccountId = DynamicObjectUtils.getPkValue(rebateAccount);
            DynamicObject flowRecord = this.getFlowRecord(dataRow, balUpdateRuleId, rebateAccountId, hasFlowFieldMap, operateKey, operateName, bigDecimal, afterAmount, amountValue, flowTypes, (String)var30_35);
            saveFlowRecordList.add(flowRecord);
            DynamicObject rebateStatement = this.writeOffRebateStatement(rebateAccount, entityKey, billId);
            if (rebateStatement != null) {
                rebateStatementList.add(rebateStatement);
            }
            rebateAccountMap.put(filterKey, rebateAccount);
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u66f4\u65b0\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        if (rebateAccountMap.size() > 0) {
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d begin:%d", billId, beginUpdateTime));
            SaveServiceHelper.update((DynamicObject[])rebateAccountMap.values().toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            if (rebateStatementList.size() > 0) {
                beginUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 begin:%d", billId, beginUpdateTime));
                SaveServiceHelper.update((DynamicObject[])rebateStatementList.toArray(new DynamicObject[0]));
                closeUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            }
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 begin:%d", billId, beginUpdateTime));
            beginUpdateTime = System.currentTimeMillis();
            SaveServiceHelper.save((DynamicObject[])saveFlowRecordList.toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            for (DynamicObject flowRecord : saveFlowRecordList) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(0);
                hashMap.put("success", true);
                hashMap.put("messagetype", "success");
                hashMap.put("message", "\u66f4\u65b0\u6210\u529f");
                hashMap.put("rebateaccountid", DynamicObjectUtils.getPkValue(flowRecord, "rebateaccount"));
                hashMap.put("flowtype", "new");
                hashMap.put("flowrecordid", DynamicObjectUtils.getPkValue(flowRecord));
                checkResults.add(hashMap);
            }
        }
        return checkResults;
    }

    private DynamicObject writeOffRebateStatement(DynamicObject rebateAccount, String entityKey, long billId) {
        DynamicObject rebateStatement = null;
        long beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 begin:%d", billId, beginUpdateTime));
        try {
            DynamicObject entryItem;
            DynamicObjectCollection entryEntity;
            String sourceBill = "";
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 \u89e3\u6790\u524dsourcebill:%s", billId, rebateAccount.get("sourcebill") != null ? rebateAccount.get("sourcebill").toString() : null));
            if (entityKey.equals(P_occpic_rebatestatement) || rebateAccount.get("sourcebill") == null) {
                return null;
            }
            if (rebateAccount.get("sourcebill") instanceof DynamicObject) {
                DynamicObject sourceBillObj = DynamicObjectUtils.getDynamicObject(rebateAccount, "sourcebill");
                if (sourceBillObj != null) {
                    sourceBill = this.convertObjectToString(sourceBillObj.getPkValue());
                }
            } else {
                sourceBill = this.convertObjectToString(rebateAccount.get("sourcebill"));
            }
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 \u89e3\u6790\u540esourcebill:%s", billId, sourceBill));
            long sourceBillId = DynamicObjectUtils.getLong(rebateAccount, "sourcebillid");
            long sourceEntryId = DynamicObjectUtils.getLong(rebateAccount, "sourceentryid");
            if (sourceBill.equals(P_occpic_rebatestatement) && sourceBillId > 0L && sourceEntryId > 0L && (entryEntity = DynamicObjectUtils.getDynamicObjectCollection(rebateStatement = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)P_occpic_rebatestatement), "entryentity")) != null && (entryItem = (DynamicObject)entryEntity.stream().filter(x -> DynamicObjectUtils.getPkValue(x) == sourceEntryId).findFirst().orElse(null)) != null) {
                entryItem.set("availablebalance", (Object)DynamicObjectUtils.getBigDecimal(rebateAccount, "availablebalance"));
                entryItem.set("occupyamount", (Object)DynamicObjectUtils.getBigDecimal(rebateAccount, "occupyamount"));
                entryItem.set("hasbudgetamount", (Object)DynamicObjectUtils.getBigDecimal(entryItem, "rebateamount").subtract(DynamicObjectUtils.getBigDecimal(rebateAccount, "balance")));
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355\u5931\u8d25\uff0c\u8d44\u91d1\u6c60\uff1a%s,\u5931\u8d25\u539f\u56e0:%s", DynamicObjectUtils.getString(rebateAccount, "number"), ex.getMessage()));
        }
        long closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u7ed3\u7b97\u5355 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        return rebateStatement;
    }

    private void getRebateAccount(Map<String, Object> dataRow, Map<String, String> hasUpdateFieldMap, DynamicObject rebateAccount, String updateType, JSONObject amountValue) {
        for (Map.Entry<String, String> updateField : hasUpdateFieldMap.entrySet()) {
            BigDecimal value;
            String balFieldKey = updateField.getKey();
            String srcFieldKey = updateField.getValue();
            BigDecimal balValue = DynamicObjectUtils.getBigDecimal(rebateAccount, balFieldKey);
            BigDecimal updateValue = BigDecimal.ZERO;
            if (dataRow.get(srcFieldKey) != null) {
                updateValue = (BigDecimal)dataRow.get(srcFieldKey);
            }
            if (StringUtils.equals((CharSequence)updateType, (CharSequence)"0")) {
                value = balValue.add(updateValue);
                amountValue.put(balFieldKey, (Object)updateValue);
            } else {
                value = balValue.subtract(updateValue);
                amountValue.put(balFieldKey, (Object)BigDecimal.ZERO.subtract(updateValue));
            }
            rebateAccount.set(balFieldKey, (Object)value);
        }
        BigDecimal balance = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
        BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal(rebateAccount, "occupyamount");
        rebateAccount.set("availablebalance", (Object)balance.subtract(occupyAmount));
        rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
    }

    private DynamicObject getFlowRecord(Map<String, Object> dataRow, long balUpdateRuleId, long rebateAccountId, Map<String, String> hasFlowFieldMap, String operateKey, String operateName, BigDecimal beforeAmount, BigDecimal afterAmount, JSONObject amountValue, DynamicObjectCollection flowTypes, String rebateAccountType) {
        DynamicObject flowType;
        DynamicObject flowRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_flowrecord");
        flowRecord.set("balupdaterule", (Object)balUpdateRuleId);
        for (Map.Entry<String, String> flowField : hasFlowFieldMap.entrySet()) {
            String flowFieldKey = flowField.getKey();
            String srcFieldKey = flowField.getValue();
            if (rebateAccountType.equals("A") && flowFieldKey.equals("receivechannel") || rebateAccountType.equals("B") && (flowFieldKey.equals("org") || flowFieldKey.equals("customer"))) continue;
            Object flowValue = dataRow.get(srcFieldKey);
            flowRecord.set(flowFieldKey, flowValue);
        }
        flowRecord.set("beforeamount", (Object)beforeAmount);
        flowRecord.set("afteramount", (Object)afterAmount);
        flowRecord.set("amountvalue", (Object)amountValue.toJSONString());
        flowRecord.set("createtime", (Object)TimeServiceHelper.now());
        flowRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        long balFlowTypeId = this.stringToLong(dataRow.get("balflowtype"));
        if (balFlowTypeId > 0L && flowTypes != null && (flowType = (DynamicObject)flowTypes.stream().filter(x -> DynamicObjectUtils.getLong(x, "id") == balFlowTypeId).findFirst().orElse(null)) != null) {
            BigDecimal changeAmt;
            String updateTrans = this.convertObjectToString(flowType.get("updatetrans"));
            flowRecord.set("transaction", (Object)updateTrans);
            if (updateTrans.equals("I") && (changeAmt = DynamicObjectUtils.getBigDecimal(flowRecord, "changeamount")).compareTo(BigDecimal.ZERO) > 0) {
                flowRecord.set("changeamount", (Object)changeAmt.multiply(new BigDecimal(-1)));
            }
        }
        flowRecord.set("flowstatus", (Object)"A");
        flowRecord.set("operation", (Object)operateKey);
        flowRecord.set("operationname", (Object)operateName);
        flowRecord.set("rebateaccount", (Object)rebateAccountId);
        return flowRecord;
    }

    private DynamicObject getFlowRecord(DynamicObject originFlowRecord, long rebateAccountId, String operateKey, String operateName, BigDecimal beforeAmount, BigDecimal afterAmount, JSONObject newAmountValue, DynamicObjectCollection flowTypes) {
        DynamicObject flowType;
        DynamicObject flowRecord = BusinessDataServiceHelper.newDynamicObject((String)"occba_flowrecord");
        DataEntityPropertyCollection flowProperties = flowRecord.getDynamicObjectType().getProperties();
        for (IDataEntityProperty flowProperty : flowProperties) {
            String colKey = flowProperty.getName();
            if (StringUtils.equals((CharSequence)colKey, (CharSequence)"id")) continue;
            flowRecord.set(colKey, originFlowRecord.get(colKey));
        }
        flowRecord.set("beforeamount", (Object)beforeAmount);
        flowRecord.set("afteramount", (Object)afterAmount);
        flowRecord.set("amountvalue", (Object)newAmountValue.toJSONString());
        flowRecord.set("createtime", (Object)TimeServiceHelper.now());
        flowRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        long balFlowTypeId = DynamicObjectUtils.getPkValue(originFlowRecord, "balflowtype");
        if (balFlowTypeId > 0L && flowTypes != null && (flowType = (DynamicObject)flowTypes.stream().filter(x -> DynamicObjectUtils.getLong(x, "id") == balFlowTypeId).findFirst().orElse(null)) != null) {
            Object rollbackTrans = flowType.get("rollbacktrans");
            Long rollbackFlowTypeId = (Long)flowType.get("rollbackflowtype");
            if (rollbackFlowTypeId > 0L) {
                flowRecord.set("balflowtype", (Object)rollbackFlowTypeId);
            }
            flowRecord.set("transaction", rollbackTrans);
            BigDecimal changeAmount = DynamicObjectUtils.getBigDecimal(flowRecord, "changeamount");
            flowRecord.set("changeamount", (Object)changeAmount.multiply(new BigDecimal(-1)));
        }
        flowRecord.set("flowstatus", (Object)"B");
        flowRecord.set("operation", (Object)operateKey);
        flowRecord.set("operationname", (Object)operateName);
        flowRecord.set("rebateaccount", (Object)rebateAccountId);
        return flowRecord;
    }

    private List<Map<String, Object>> saveRollbackRebateAccount(String entityKey, long billId, DynamicObject balUpdateRule, DynamicObject[] flowRecordData, String operateKey, String operateName, String updateType) {
        long beginRollbackTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d begin:%d", billId, beginRollbackTime));
        ArrayList<Map<String, Object>> checkResults = new ArrayList<Map<String, Object>>(0);
        String negativeCtrl = DynamicObjectUtils.getString(balUpdateRule, "negativectrl");
        String positiveCtrl = DynamicObjectUtils.getString(balUpdateRule, "positivectrl");
        HashSet<Long> rebateAccountIds = new HashSet<Long>(0);
        HashSet<Long> balFlowTypeIds = new HashSet<Long>(0);
        for (DynamicObject flowRecordItem : flowRecordData) {
            long rebateAccountId = DynamicObjectUtils.getPkValue(flowRecordItem, "rebateaccount");
            rebateAccountIds.add(rebateAccountId);
            long balFlowTypeId = DynamicObjectUtils.getPkValue(flowRecordItem, "balflowtype");
            balFlowTypeIds.add(balFlowTypeId);
        }
        long beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d load\u8d44\u91d1\u6c60\u4f59\u989d begin:%d", billId, beginUpdateTime));
        ArrayList<DynamicObject> rebateAccountList = new ArrayList<DynamicObject>(0);
        if (rebateAccountIds.size() > 0) {
            MainEntityType rebateAccountType = EntityMetadataCache.getDataEntityType((String)"ocdbd_rebateaccount");
            DynamicObject[] rebateAccounts = BusinessDataServiceHelper.load((Object[])rebateAccountIds.toArray(), (DynamicObjectType)rebateAccountType);
            rebateAccountList.addAll(Arrays.asList(rebateAccounts));
        }
        long closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d load\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d query\u8d44\u91d1\u6c60\u6d41\u6c34\u7c7b\u578b begin:%d", billId, beginUpdateTime));
        DynamicObjectCollection flowTypes = this.queryBalFlowType(balFlowTypeIds);
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d query\u8d44\u91d1\u6c60\u6d41\u6c34\u7c7b\u578b end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        beginUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u66f4\u65b0\u8d44\u91d1\u6c60 begin:%d", billId, beginUpdateTime));
        ArrayList<DynamicObject> flowRecordList = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> rebateStatementList = new ArrayList<DynamicObject>(0);
        DynamicObjectCollection updateEntryColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "updatedataentity");
        for (DynamicObject flowRecordItem : flowRecordData) {
            Map<String, Object> checkResult;
            long rebateAccountId = DynamicObjectUtils.getPkValue(flowRecordItem, "rebateaccount");
            DynamicObject rebateAccount = rebateAccountList.stream().filter(x -> DynamicObjectUtils.getPkValue(x) == rebateAccountId).findFirst().orElse(null);
            if (rebateAccount == null) {
                return checkResults;
            }
            DataEntityPropertyCollection properties = rebateAccount.getDynamicObjectType().getProperties();
            BigDecimal beforeAmount = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
            String amountValueStr = DynamicObjectUtils.getString(flowRecordItem, "amountvalue");
            JSONObject amountValue = JSONObject.parseObject((String)amountValueStr);
            JSONObject newAmountValue = new JSONObject();
            if (amountValue == null || amountValue.isEmpty()) continue;
            for (String amountKey : amountValue.keySet()) {
                boolean isRollback;
                DynamicObject updateEntry;
                if (!properties.containsKey((Object)amountKey)) continue;
                if (updateType.equals("2") && (updateEntry = (DynamicObject)updateEntryColl.stream().filter(x -> amountKey.equals(DynamicObjectUtils.getString(x, "updatebalcol"))).findFirst().orElse(null)) != null && !(isRollback = DynamicObjectUtils.getBoolean(updateEntry, "isrollback"))) {
                    logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d %s\u4e0d\u652f\u6301\u56de\u6eda", billId, amountKey));
                    continue;
                }
                BigDecimal amount = DynamicObjectUtils.getBigDecimal(rebateAccount, amountKey);
                BigDecimal updateAmount = new BigDecimal(this.convertObjectToString(amountValue.get((Object)amountKey)));
                if (updateAmount.compareTo(BigDecimal.ZERO) >= 0) {
                    rebateAccount.set(amountKey, (Object)amount.subtract(updateAmount.abs()));
                    newAmountValue.put(amountKey, (Object)BigDecimal.ZERO.subtract(updateAmount.abs()));
                    continue;
                }
                rebateAccount.set(amountKey, (Object)amount.add(updateAmount.abs()));
                newAmountValue.put(amountKey, (Object)updateAmount.abs());
            }
            if (newAmountValue.isEmpty()) continue;
            BigDecimal balance = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
            BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal(rebateAccount, "occupyamount");
            rebateAccount.set("availablebalance", (Object)balance.subtract(occupyAmount));
            BigDecimal afterAmount = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
            rebateAccount.set("updatedatetime", (Object)TimeServiceHelper.now());
            String billNo = DynamicObjectUtils.getString(flowRecordItem, "sourcebillno");
            if (StringUtils.equals((CharSequence)negativeCtrl, (CharSequence)"1") && (checkResult = this.checkNegativeRebateAccount(rebateAccount, billNo)) != null) {
                checkResults.add(checkResult);
                continue;
            }
            if (StringUtils.equals((CharSequence)positiveCtrl, (CharSequence)"1") && (checkResult = this.checkPositiveRebateAccount(rebateAccount, billNo)) != null) {
                checkResults.add(checkResult);
                continue;
            }
            DynamicObject flowRecord = this.getFlowRecord(flowRecordItem, rebateAccountId, operateKey, operateName, beforeAmount, afterAmount, newAmountValue, flowTypes);
            flowRecordList.add(flowRecord);
            DynamicObject rebateStatement = this.writeOffRebateStatement(rebateAccount, entityKey, billId);
            if (rebateStatement == null) continue;
            rebateStatementList.add(rebateStatement);
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u66f4\u65b0\u8d44\u91d1\u6c60 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
        if (rebateAccountList.size() > 0) {
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d begin:%d", billId, beginUpdateTime));
            SaveServiceHelper.update((DynamicObject[])rebateAccountList.toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            if (rebateStatementList.size() > 0) {
                beginUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 begin:%d", billId, beginUpdateTime));
                SaveServiceHelper.update((DynamicObject[])rebateStatementList.toArray(new DynamicObject[0]));
                closeUpdateTime = System.currentTimeMillis();
                logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u53cd\u5199\u8fd4\u5229\u8ba1\u7b97\u5355 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            }
            beginUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 begin:%d", billId, beginUpdateTime));
            SaveServiceHelper.save((DynamicObject[])flowRecordList.toArray(new DynamicObject[0]));
            closeUpdateTime = System.currentTimeMillis();
            logger.info(String.format("\u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d:%d \u4fdd\u5b58\u8d44\u91d1\u6c60\u6d41\u6c34 end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginUpdateTime));
            for (DynamicObject flowRecord : flowRecordList) {
                HashMap<String, Object> result = new HashMap<String, Object>(0);
                long rollbackFlowRecordId = 0L;
                long rebateAccountId = DynamicObjectUtils.getPkValue(flowRecord, "rebateaccount");
                long entryId = DynamicObjectUtils.getLong(flowRecord, "entry");
                DynamicObject rollbackFlowRecord = Arrays.stream(flowRecordData).filter(x -> DynamicObjectUtils.getLong(x, "entry") == entryId).findFirst().orElse(null);
                if (rollbackFlowRecord != null) {
                    rollbackFlowRecordId = DynamicObjectUtils.getLong(rollbackFlowRecord, "id");
                }
                result.put("success", true);
                result.put("messagetype", "success");
                result.put("message", "\u66f4\u65b0\u6210\u529f");
                result.put("rebateaccountid", rebateAccountId);
                result.put("flowtype", "new");
                result.put("flowrecordid", DynamicObjectUtils.getPkValue(flowRecord));
                result.put("rollbackflowrecordid", rollbackFlowRecordId);
                checkResults.add(result);
            }
        }
        closeUpdateTime = System.currentTimeMillis();
        logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:%d \u56de\u6eda\u8d44\u91d1\u6c60\u4f59\u989d end:%d \u8017\u65f6:%d ms", billId, closeUpdateTime, closeUpdateTime - beginRollbackTime));
        return checkResults;
    }

    private boolean saveRollbackRebateAccountEx(DynamicObject[] flowRecordData) {
        try {
            Object[] balUpdateRuleIds = Arrays.stream(flowRecordData).map(x -> DynamicObjectUtils.getPkValue(x, "balupdaterule")).distinct().toArray();
            MainEntityType balUpdateRuleType = EntityMetadataCache.getDataEntityType((String)"ocdbd_balupdaterule");
            DynamicObject[] balUpdateRuleData = BusinessDataServiceHelper.load((Object[])balUpdateRuleIds, (DynamicObjectType)balUpdateRuleType);
            if (balUpdateRuleData == null || balUpdateRuleData.length == 0) {
                return false;
            }
            for (DynamicObject flowRecordItem : flowRecordData) {
                boolean exist;
                long rebateAccountId = DynamicObjectUtils.getPkValue(flowRecordItem, "rebateaccount");
                long balUpdateRuleId = DynamicObjectUtils.getPkValue(flowRecordItem, "balupdaterule");
                DynamicObject balUpdateRule = Arrays.stream(balUpdateRuleData).filter(x -> DynamicObjectUtils.getPkValue(x) == balUpdateRuleId).findFirst().orElse(null);
                if (balUpdateRule == null || !(exist = QueryServiceHelper.exists((String)"ocdbd_rebateaccount", (Object)rebateAccountId))) continue;
                DynamicObject rebateAccount = BusinessDataServiceHelper.loadSingle((Object)rebateAccountId, (String)"ocdbd_rebateaccount");
                DataEntityPropertyCollection properties = rebateAccount.getDynamicObjectType().getProperties();
                String amountValueStr = DynamicObjectUtils.getString(flowRecordItem, "amountvalue");
                JSONObject amountValue = JSONObject.parseObject((String)amountValueStr);
                if (amountValue == null || amountValue.isEmpty()) continue;
                for (String amountKey : amountValue.keySet()) {
                    if (!properties.containsKey((Object)amountKey)) continue;
                    BigDecimal amount = DynamicObjectUtils.getBigDecimal(rebateAccount, amountKey);
                    BigDecimal updateAmount = new BigDecimal(this.convertObjectToString(amountValue.get((Object)amountKey)));
                    if (updateAmount.compareTo(BigDecimal.ZERO) >= 0) {
                        rebateAccount.set(amountKey, (Object)amount.subtract(updateAmount.abs()));
                        continue;
                    }
                    rebateAccount.set(amountKey, (Object)amount.add(updateAmount));
                }
                BigDecimal balance = DynamicObjectUtils.getBigDecimal(rebateAccount, "balance");
                BigDecimal occupyAmount = DynamicObjectUtils.getBigDecimal(rebateAccount, "occupyamount");
                rebateAccount.set("availablebalance", (Object)balance.subtract(occupyAmount));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rebateAccount});
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d saveRollbackRebateAccountEx \uff1a %s", ex.getMessage()));
            return false;
        }
        return true;
    }

    private void saveFlowRecord(DynamicObject[] flowRecords, String flowStatus) {
        if (flowRecords != null && flowRecords.length > 0) {
            for (DynamicObject flowRecordItem : flowRecords) {
                flowRecordItem.set("flowstatus", (Object)flowStatus);
            }
            SaveServiceHelper.save((DynamicObject[])flowRecords);
        }
    }

    private Map<String, Object> checkNegativeRebateAccount(DynamicObject rebateAccount, String billNo) {
        HashMap<String, Object> checkResult = null;
        BigDecimal availableBalance = DynamicObjectUtils.getBigDecimal(rebateAccount, "availablebalance");
        if (availableBalance.compareTo(BigDecimal.ZERO) < 0) {
            checkResult = new HashMap<String, Object>(0);
            checkResult.put("success", false);
            checkResult.put("billno", billNo);
            String message = String.format("\u8d44\u91d1\u6c60\u4f59\u989d\u8868-\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u53ef\u7528\u4f59\u989d\u77ed\u7f3a\uff1a%s", availableBalance);
            checkResult.put("message", message);
            checkResult.put("messagetype", "error");
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d checkNegativeRebateAccount \uff1a %s", message));
        }
        return checkResult;
    }

    private Map<String, Object> checkPositiveRebateAccount(DynamicObject rebateAccount, String billNo) {
        HashMap<String, Object> checkResult = null;
        BigDecimal availableBalance = DynamicObjectUtils.getBigDecimal(rebateAccount, "availablebalance");
        if (availableBalance.compareTo(BigDecimal.ZERO) > 0) {
            checkResult = new HashMap<String, Object>(0);
            checkResult.put("success", false);
            checkResult.put("billno", billNo);
            String message = "\u4e0d\u5141\u8bb8\u66f4\u65b0\u540e\u7684\u53ef\u7528\u4f59\u989d\u4e3a\u6b63\u6570\u3002";
            checkResult.put("message", message);
            checkResult.put("messagetype", "error");
            logger.info(String.format("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d checkPositiveRebateAccount \uff1a %s", message));
        }
        return checkResult;
    }

    private DynamicObjectCollection getFlowRecordData(Set<Long> billIds, String updateOpKey, String entityKey, long balUpdateRuleId) {
        QFilter qFilter = new QFilter("sourcebillid", "in", billIds);
        qFilter.and("flowstatus", "=", (Object)"A");
        qFilter.and("billentity", "=", (Object)entityKey);
        if (StringUtils.isNotEmpty((CharSequence)updateOpKey)) {
            qFilter.and("operation", "=", (Object)updateOpKey);
        }
        if (balUpdateRuleId > 0L) {
            qFilter.and("balupdaterule", "=", (Object)balUpdateRuleId);
        }
        String selectFields = "id,operation,operationname,sourcebillid,billentity,flowstatus,balupdaterule,rebateaccount,balflowtype,entry";
        logger.info("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d:getFlowRecordData\u67e5\u8be2\u8d44\u91d1\u6c60\u6d41\u6c34");
        return QueryServiceHelper.query((String)"occba_flowrecord", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection getCheckUpdateFlowRecord(Set<Long> billIds, String updateOpKey, String entityKey) {
        QFilter qFilter = new QFilter("sourcebillid", "in", billIds);
        if (StringUtils.isNotEmpty((CharSequence)updateOpKey)) {
            qFilter.and("operation", "=", (Object)updateOpKey);
        }
        qFilter.and("billentity", "=", (Object)entityKey);
        qFilter.and("flowstatus", "=", (Object)"A");
        return QueryServiceHelper.query((String)"occba_flowrecord", (String)"id,billentity,sourcebillid,operation,flowstatus", (QFilter[])qFilter.toArray());
    }

    private Map<String, Object> getDataRowMap(List<String> fieldKeys, Row row, long balUpdateRuleId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(0);
        try {
            for (String fieldKey : fieldKeys) {
                resultMap.put(fieldKey, row.get(fieldKey));
            }
            resultMap.put("balupdateruleid", balUpdateRuleId);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0\u8d44\u91d1\u6c60\u4f59\u989d getDataRowMap\uff0c\u9519\u8bef\u539f\u56e0:" + ex.getMessage());
        }
        return resultMap;
    }

    private List<Map<String, Object>> getDataList(DataSet data, long balUpdateRuleId) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(0);
        List<String> fieldKeys = Arrays.asList(data.getRowMeta().getFieldNames());
        for (Row row : data) {
            dataList.add(this.getDataRowMap(fieldKeys, row, balUpdateRuleId));
        }
        return dataList;
    }

    private void getConfigCol(MainEntityType srcEntityType, DynamicObjectCollection dataColl, Set<String> headCol, Set<String> entryCol, Set<String> subEntryCol, Map<String, String> entryKeySet, String billColKey, String valTypeKey) {
        for (DynamicObject data : dataColl) {
            IDataEntityType proParent;
            String[] proCols;
            IDataEntityProperty pro;
            String billCol = DynamicObjectUtils.getString(data, billColKey);
            String valType = DynamicObjectUtils.getString(data, valTypeKey);
            if (!StringUtils.equals((CharSequence)valType, (CharSequence)"1") || !StringUtils.isNotEmpty((CharSequence)billCol) || (pro = srcEntityType.findProperty((proCols = billCol.split("\\."))[0])) == null || (proParent = pro.getParent()) == null) continue;
            String proName = proParent.getName();
            if (pro instanceof EntryProp) {
                entryCol.add(billCol);
                entryKeySet.put("entry", pro.getName());
                continue;
            }
            if (proParent instanceof MainEntityType) {
                headCol.add(billCol);
                continue;
            }
            if (proParent instanceof SubEntryType) {
                subEntryCol.add(billCol);
                entryKeySet.put("subentry", proName);
                continue;
            }
            if (!(proParent instanceof EntryType)) continue;
            entryCol.add(billCol);
            entryKeySet.put("entry", proName);
        }
    }

    private void getColValue(IDataEntityProperty pro, Map<String, Object> map, DynamicObject data, String colKey, String fullColKey) {
        if (pro instanceof BasedataProp) {
            DynamicObject baseDyn = data.getDynamicObject(colKey);
            if (baseDyn == null) {
                map.put(colKey, 0L);
            } else {
                map.put(colKey, baseDyn.getPkValue());
            }
        } else {
            map.put(fullColKey, data.get(colKey));
        }
    }

    private Map<String, Object> getEntryValue(Set<String> entryCol, DynamicObject data, DataEntityPropertyCollection properties) {
        HashMap<String, Object> mapData = new HashMap<String, Object>(0);
        for (String fullCol : entryCol) {
            String[] cols;
            for (String col : cols = StringUtils.split((String)fullCol, (String)".")) {
                IDataEntityProperty entryProperty = properties.stream().filter(x -> StringUtils.equals((CharSequence)x.getName(), (CharSequence)col)).findFirst().orElse(null);
                if (entryProperty == null) continue;
                this.getColValue(entryProperty, mapData, data, col, fullCol);
            }
        }
        return mapData;
    }

    private void getBalUpdateBillData(MainEntityType srcEntityType, DynamicObject bill, Map<String, Object> mapHead, List<Map<String, Object>> mapEntry, List<Map<String, Object>> mapSubEntry, Set<String> headCol, Set<String> entryCol, Set<String> subEntryCol, String entryKey, String subEntryKey) {
        DynamicObjectCollection entryData;
        mapHead.put("id", bill.getPkValue());
        for (String col : headCol) {
            IDataEntityProperty property = srcEntityType.findProperty(col);
            if (property == null) continue;
            this.getColValue(property, mapHead, bill, col, col);
        }
        if (StringUtils.isNotEmpty((CharSequence)entryKey) && (entryData = DynamicObjectUtils.getDynamicObjectCollection(bill, entryKey)) != null) {
            DataEntityPropertyCollection entryProperties = entryData.getDynamicObjectType().getProperties();
            for (DynamicObject entryItem : entryData) {
                DynamicObjectCollection subEntryData;
                Map<String, Object> dimEntryItem = this.getEntryValue(entryCol, entryItem, entryProperties);
                dimEntryItem.put("id", bill.getPkValue());
                dimEntryItem.put("entryid", entryItem.getPkValue());
                mapEntry.add(dimEntryItem);
                if (!StringUtils.isNotEmpty((CharSequence)subEntryKey) || (subEntryData = DynamicObjectUtils.getDynamicObjectCollection(entryItem, subEntryKey)) == null) continue;
                DataEntityPropertyCollection subEntryProperties = subEntryData.getDynamicObjectType().getProperties();
                for (DynamicObject subEntryItem : subEntryData) {
                    Map<String, Object> dimSubItem = this.getEntryValue(subEntryCol, subEntryItem, subEntryProperties);
                    dimSubItem.put("id", entryItem.getPkValue());
                    dimSubItem.put("entryid", entryItem.getPkValue());
                    dimSubItem.put("detailid", subEntryItem.getPkValue());
                    mapSubEntry.add(dimSubItem);
                }
            }
        }
    }

    private void getBalUpdateBillData(List<Map<String, Object>> resultList, DynamicObject bill, DynamicObjectCollection dataColl, String entityKey, String valTypeKey, String balColKey, String billColKey, String fixedValueKey) {
        HashSet<String> headCol = new HashSet<String>(0);
        HashSet<String> entryCol = new HashSet<String>(0);
        HashSet<String> subEntryCol = new HashSet<String>(0);
        HashMap<String, Object> mapHead = new HashMap<String, Object>(0);
        HashMap<String, String> entryKeySet = new HashMap<String, String>(0);
        ArrayList<Map<String, Object>> mapEntry = new ArrayList<Map<String, Object>>(0);
        ArrayList<Map<String, Object>> mapSubEntry = new ArrayList<Map<String, Object>>(0);
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        if (dataColl != null && dataColl.size() > 0) {
            this.getConfigCol(srcEntityType, dataColl, headCol, entryCol, subEntryCol, entryKeySet, billColKey, valTypeKey);
            String entryKey = null;
            if (entryKeySet.containsKey("entry")) {
                entryKey = (String)entryKeySet.get("entry");
            }
            String subEntryKey = null;
            if (entryKeySet.containsKey("subentry")) {
                subEntryKey = (String)entryKeySet.get("subentry");
            }
            this.getBalUpdateBillData(srcEntityType, bill, mapHead, mapEntry, mapSubEntry, headCol, entryCol, subEntryCol, entryKey, subEntryKey);
            this.getBillData(resultList, dataColl, mapHead, mapEntry, mapSubEntry, valTypeKey, balColKey, billColKey, fixedValueKey);
        }
    }

    private void getBillData(List<Map<String, Object>> resultList, DynamicObjectCollection cfgColl, Map<String, Object> mapHead, List<Map<String, Object>> mapEntry, List<Map<String, Object>> mapSubEntry, String valTypeKey, String balColKey, String billColKey, String fixedValueKey) {
        if (!mapSubEntry.isEmpty()) {
            for (Map<String, Object> mapSubItem : mapSubEntry) {
                Map mapEntryItem;
                if (mapEntry.isEmpty()) continue;
                Object billId = mapSubItem.get("id");
                Object entryId = mapSubItem.get("entryid");
                Object detailId = mapSubItem.get("detailid");
                HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("detailid").equals(detailId)).findFirst().orElse(null);
                if (dataItem == null) {
                    dataItem = new HashMap<String, Object>(0);
                }
                if ((mapEntryItem = (Map)mapEntry.stream().filter(x -> x.get("entryid").equals(entryId)).findFirst().orElse(null)) == null) continue;
                this.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, valTypeKey, balColKey, billColKey, fixedValueKey);
                if (!resultList.stream().noneMatch(x -> x.get("detailid").equals(detailId))) continue;
                dataItem.put("id", billId);
                dataItem.put("entryid", entryId);
                dataItem.put("detailid", detailId);
                resultList.add(dataItem);
            }
        } else if (!mapEntry.isEmpty()) {
            for (Map<String, Object> mapEntryItem : mapEntry) {
                HashMap<String, Object> mapSubItem = new HashMap<String, Object>(0);
                Object billId = mapEntryItem.get("id");
                Object entryId = mapEntryItem.get("entryid");
                HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("entryid").equals(entryId)).findFirst().orElse(null);
                if (dataItem == null) {
                    dataItem = new HashMap<String, Object>(0);
                }
                this.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, valTypeKey, balColKey, billColKey, fixedValueKey);
                if (!resultList.stream().noneMatch(x -> x.get("entryid").equals(entryId))) continue;
                dataItem.put("id", billId);
                dataItem.put("entryid", entryId);
                resultList.add(dataItem);
            }
        } else if (!mapHead.isEmpty()) {
            HashMap<String, Object> mapEntryItem = new HashMap<String, Object>(0);
            HashMap<String, Object> mapSubItem = new HashMap<String, Object>(0);
            Object id = mapHead.get("id");
            HashMap<String, Object> dataItem = resultList.stream().filter(x -> x.get("id").equals(id)).findFirst().orElse(null);
            if (dataItem == null) {
                dataItem = new HashMap<String, Object>(0);
            }
            this.setDataItem(cfgColl, dataItem, mapHead, mapEntryItem, mapSubItem, valTypeKey, balColKey, billColKey, fixedValueKey);
            if (resultList.stream().noneMatch(x -> x.get("id").equals(id))) {
                dataItem.put("id", id);
                resultList.add(dataItem);
            }
        }
    }

    private List<Map<String, Object>> getBillData(DynamicObject balUpdateRule, DynamicObject[] bills, String entityKey) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(0);
        for (DynamicObject bill : bills) {
            long billId = DynamicObjectUtils.getPkValue(bill);
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)billId);
            if (!QueryServiceHelper.exists((String)"occba_flowrecord", (QFilter[])qFilter.toArray())) {
                return resultList;
            }
            long balUpdateRuleId = DynamicObjectUtils.getPkValue(balUpdateRule);
            DynamicObjectCollection dimDataColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "dimdataentity");
            this.getBalUpdateBillData(resultList, bill, dimDataColl, entityKey, "dimvaltype", "dimbalcol", "dimbillcol", "dimfixedvalue");
            DynamicObjectCollection updateDataColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "updatedataentity");
            this.getBalUpdateBillData(resultList, bill, updateDataColl, entityKey, "updatevaltype", "updatebalcol", "updatebillcol", null);
            DynamicObjectCollection flowDataColl = DynamicObjectUtils.getDynamicObjectCollection(balUpdateRule, "flowdataentity");
            this.getBalUpdateBillData(resultList, bill, flowDataColl, entityKey, "flowvaltype", "flowcol", "flowbillcol", "flowfixedvalue");
            for (Map map : resultList) {
                map.put("balupdateruleid", balUpdateRuleId);
            }
        }
        return resultList;
    }

    private void setDataItem(Map<String, Object> mapData, Map<String, Object> dataItem, String colName, String billCol) {
        if (!mapData.isEmpty() && mapData.containsKey(billCol)) {
            dataItem.put(colName, mapData.get(billCol));
        }
    }

    private void setDataItem(DynamicObjectCollection cfgColl, Map<String, Object> dataItem, Map<String, Object> billHead, Map<String, Object> billEntry, Map<String, Object> billSubEntry, String valTypeKey, String colKey, String billColKey, String fixedValueKey) {
        String entryName = cfgColl.getDynamicObjectType().getName();
        for (DynamicObject cfg : cfgColl) {
            String valType = DynamicObjectUtils.getString(cfg, valTypeKey);
            String colName = DynamicObjectUtils.getString(cfg, colKey);
            String billCol = DynamicObjectUtils.getString(cfg, billColKey);
            if (StringUtils.equals((CharSequence)valType, (CharSequence)"1")) {
                this.setDataItem(billHead, dataItem, colName, billCol);
                this.setDataItem(billEntry, dataItem, colName, billCol);
                this.setDataItem(billSubEntry, dataItem, colName, billCol);
                continue;
            }
            if ((!StringUtils.equals((CharSequence)valType, (CharSequence)"4") || !StringUtils.isNotEmpty((CharSequence)fixedValueKey)) && (!StringUtils.equals((CharSequence)valType, (CharSequence)"2") || !StringUtils.isNotEmpty((CharSequence)fixedValueKey) || !StringUtils.equals((CharSequence)entryName, (CharSequence)"flowdataentity"))) continue;
            String fixedValue = DynamicObjectUtils.getString(cfg, fixedValueKey);
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)fixedValue, CRFormula.class);
            String expression = formula.getExpression();
            dataItem.put(colName, expression);
        }
    }

    private QFilter filterStringToQFilter(String entityKey, String filterString) {
        if (StringUtils.isEmpty((CharSequence)filterString)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterString, CRCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityKey), condition.getFilterCondition());
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb.getQFilter();
    }

    private List<DynamicObject> getBalUpdateRule(String entityKey, String operateKey) {
        QFilter qFilter = new QFilter("srcbill", "=", (Object)entityKey);
        qFilter.and("status", "=", (Object)BillStatus.C);
        qFilter.and("enable", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("updateopval", "like", (Object)("%," + operateKey + ",%"));
        qFilter1.or("rollbackopval", "like", (Object)("%," + operateKey + ",%"));
        qFilter.and(qFilter1);
        List<String> fieldsKeys = this.getBalUpdateRuleFieldKeys();
        String selectFields = StringUtils.join((Object[])fieldsKeys.toArray(), (String)",");
        DynamicObject[] updateRules = BusinessDataServiceHelper.load((String)"ocdbd_balupdaterule", (String)selectFields, (QFilter[])qFilter.toArray());
        return Arrays.stream(updateRules).sorted(Comparator.comparing(x -> x.getInt("priority"))).collect(Collectors.toList());
    }

    private String getRebateAccountCode() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_rebateaccount");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, null);
        if (codeRule != null) {
            return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
        }
        throw new KDBizException("\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219");
    }

    private String getColFullColKey(MainEntityType entity, String col) {
        if (StringUtils.isBlank((CharSequence)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        if (pro == null) {
            return "";
        }
        return this.getFullColKey(pro.getParent(), col);
    }

    private String getFullColKey(IDataEntityType parent, String colKey) {
        if (parent instanceof MainEntityType) {
            return colKey;
        }
        return this.getFullColKey(parent.getParent(), parent.getName() + "." + colKey);
    }

    private String convertObjectToString(Object obj) {
        try {
            return String.valueOf(obj);
        }
        catch (Exception e) {
            return "";
        }
    }

    private long stringToLong(Object obj) {
        try {
            return Long.parseLong(String.valueOf(obj));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private List<String> getBalUpdateRuleFieldKeys() {
        ArrayList<String> fieldKeys = new ArrayList<String>(0);
        fieldKeys.add("id");
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("srcbill");
        fieldKeys.add("balobj");
        fieldKeys.add("updatetype");
        fieldKeys.add("updateopval");
        fieldKeys.add("updateopname");
        fieldKeys.add("rollbackopval");
        fieldKeys.add("rollbackopname");
        fieldKeys.add("status");
        fieldKeys.add("enable");
        fieldKeys.add("negativectrl");
        fieldKeys.add("positivectrl");
        fieldKeys.add("datafilterformula");
        fieldKeys.add("priority");
        fieldKeys.add("autoreoprollback");
        fieldKeys.add("dimdataentity.id");
        fieldKeys.add("dimdataentity.seq");
        fieldKeys.add("dimdataentity.dimbalcol");
        fieldKeys.add("dimdataentity.dimbalcolname");
        fieldKeys.add("dimdataentity.dimvaltype");
        fieldKeys.add("dimdataentity.dimbillcolname");
        fieldKeys.add("dimdataentity.dimbillcol");
        fieldKeys.add("dimdataentity.dimfixedvalue");
        fieldKeys.add("dimdataentity.dimfixedvaluetext");
        fieldKeys.add("updatedataentity.id");
        fieldKeys.add("updatedataentity.seq");
        fieldKeys.add("updatedataentity.updatebalcol");
        fieldKeys.add("updatedataentity.updatebalcolname");
        fieldKeys.add("updatedataentity.updatevaltype");
        fieldKeys.add("updatedataentity.updatebillcolname");
        fieldKeys.add("updatedataentity.updatebillcol");
        fieldKeys.add("updatedataentity.isrollback");
        fieldKeys.add("flowdataentity.id");
        fieldKeys.add("flowdataentity.seq");
        fieldKeys.add("flowdataentity.flowcol");
        fieldKeys.add("flowdataentity.flowcolname");
        fieldKeys.add("flowdataentity.flowvaltype");
        fieldKeys.add("flowdataentity.flowbillcolname");
        fieldKeys.add("flowdataentity.flowbillcol");
        fieldKeys.add("flowdataentity.flowfixedvalue");
        fieldKeys.add("flowdataentity.flowfixedvaluetext");
        return fieldKeys;
    }

    private String getOperationItem(String entityKey, String opValue) {
        String opName = null;
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            return null;
        }
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        for (Map op : ops) {
            Map map;
            String opType;
            if (!op.containsKey("type") || !OperationTypeCache.isEntityOperation((String)(opType = (String)op.get("type")))) continue;
            String opItemKey = (String)op.get("key");
            if (!op.containsKey("name") || !opItemKey.equals(opValue) || (map = (Map)op.get("name")) == null) continue;
            opName = LocaleString.fromMap((Map)map).getLocaleValue();
        }
        return opName;
    }
}

