/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.operation.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.ext.occ.operation.bizrule.BalanceService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.EnableEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class UpdateBalanceOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(UpdateBalanceOpAction.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String entityKey = this.billEntityType.getName();
        String opKey = (String)this.operateMeta.get("key");
        e.getFieldKeys().addAll(this.getSelectors(entityKey, opKey));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length == 0 && this.operateOption.getVariables().containsKey(e.getOperationKey())) {
            bills = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)this.operateOption.getVariableValue(e.getOperationKey()));
        }
        logger.info("occ: begin to update balance.");
        logger.info("occ: bizbills length is " + bills.length);
        String operationKey = (String)this.operateMeta.get("key");
        if (bills.length > 0) {
            if (this.operationContext == null) {
                this.operationContext = new OperationContext();
            }
            this.balanceUpdate(bills, operationKey);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        boolean isRollback;
        super.rollbackOperation(e);
        DynamicObject[] bills = e.getDataEntitys();
        if (bills == null || bills.length == 0) {
            return;
        }
        logger.info("occ: begin to rollback.");
        Map param = null;
        if (this.operationContext != null && (param = this.operationContext.getParameter()) != null && param.containsKey("rollback") && !(isRollback = ((Boolean)param.get("rollback")).booleanValue())) {
            return;
        }
        String operationKey = (String)this.operateMeta.get("key");
        this.invokeBalanceService(bills, operationKey, param);
        logger.info("occ: rollback finished.");
    }

    private void balanceUpdate(DynamicObject[] bills, String operationKey) {
        List<Map<String, Object>> results = this.invokeBalanceService(bills, operationKey, new HashMap<String, Object>(0));
        HashMap successMap = new HashMap(0);
        HashSet<Long> newFlowRecordIds = new HashSet<Long>(0);
        HashSet<Long> rollbackFlowRecordIds = new HashSet<Long>(0);
        for (Map<String, Object> result : results) {
            Boolean success = (Boolean)result.get("success");
            String messageType = (String)result.get("messagetype");
            String message = (String)result.get("message");
            if (!success.booleanValue() && "fail".equals(messageType)) {
                String billno = (String)result.get("billno");
                HashMap<String, Boolean> param = new HashMap<String, Boolean>(0);
                param.put("rollback", false);
                this.operationContext.setParameter(param);
                throw new KDBizException(billno + ":" + message);
            }
            if (!success.booleanValue() && "error".equals(messageType)) {
                this.throwBalanceException(message);
            }
            if (result.containsKey("flowrecordid")) {
                newFlowRecordIds.add((Long)result.get("flowrecordid"));
            }
            if (!result.containsKey("rollbackflowrecordid")) continue;
            rollbackFlowRecordIds.add((Long)result.get("rollbackflowrecordid"));
        }
        successMap.put("flowrecordids", newFlowRecordIds);
        successMap.put("rollbackflowrecordids", rollbackFlowRecordIds);
        this.operationContext.setParameter(successMap);
    }

    private List<Map<String, Object>> invokeBalanceService(DynamicObject[] bills, String operationKey, Map<String, Object> params) {
        List<Map<String, Object>> results = new ArrayList<Map<String, Object>>(0);
        HashMap<String, Object> result = new HashMap<String, Object>(0);
        if (bills == null || bills.length == 0) {
            result.put("success", Boolean.FALSE);
            result.put("messagetype", "fail");
            results.add(result);
            return results;
        }
        result.put("success", Boolean.TRUE);
        result.put("messagetype", "success");
        result.put("billno", bills[0].getString("billno"));
        results.add(result);
        ArrayList<Long> billIds = new ArrayList<Long>(0);
        for (DynamicObject entity : bills) {
            billIds.add(entity.getLong("id"));
        }
        logger.info("\u4f59\u989d\u66f4\u65b0\u89c4\u5219,\u5355\u636eId:" + StringUtils.join((Object[])billIds.toArray(), (String)","));
        BalanceService balService = new BalanceService();
        results = balService.update(bills, operationKey, params);
        return results;
    }

    private void throwBalanceException(String message) {
        InteractionContext ctx = new InteractionContext();
        ctx.setCustShowFormId("ocdbd_bal_opresult");
        ctx.getCustShowParameter().put("msg", message);
        ctx.setSimpleMessage(message);
        HashMap<String, Boolean> param = new HashMap<String, Boolean>(0);
        param.put("rollback", false);
        if (this.operationContext == null) {
            this.operationContext = new OperationContext();
        }
        this.operationContext.setParameter(param);
        throw new KDInteractionException("", ctx);
    }

    public Set<String> getSelectors(String entityKey, String opKey) {
        HashSet<String> selectors = new HashSet<String>(0);
        selectors.add("billno");
        QFilter qFilter = new QFilter("srcbill", "=", (Object)entityKey);
        qFilter.and("status", "=", (Object)BillStatus.C);
        qFilter.and("enable", "=", (Object)EnableEnum.Enable);
        QFilter opFilter = new QFilter("updateopval", "=", (Object)opKey);
        opFilter.or("rollbackopval", "=", (Object)opKey);
        qFilter.and(opFilter);
        String selectFields = "id,dimdataentity.dimbillcol as dimbillcol,updatedataentity.updatebillcol as updatebillcol,flowdataentity.flowbillcol as flowbillcol";
        DynamicObjectCollection billCols = QueryServiceHelper.query((String)"ocdbd_balupdaterule", (String)selectFields, (QFilter[])qFilter.toArray());
        if (billCols != null && billCols.size() > 0) {
            for (DynamicObject selectorRow : billCols) {
                String dimBillCol = selectorRow.getString("dimbillcol");
                String updateBillCol = selectorRow.getString("dimbillcol");
                String flowBillCol = selectorRow.getString("flowbillcol");
                if (StringUtils.isNotEmpty((CharSequence)dimBillCol)) {
                    selectors.add(dimBillCol);
                }
                if (StringUtils.isNotEmpty((CharSequence)updateBillCol)) {
                    selectors.add(updateBillCol);
                }
                if (!StringUtils.isNotEmpty((CharSequence)flowBillCol)) continue;
                selectors.add(flowBillCol);
            }
        }
        return selectors;
    }
}

