/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.elasticsearch.dts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.mapping.ESFullTextMapper;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PurMalESFullTextMapper
extends ESFullTextMapper {
    private static final Log log = LogFactory.getLog(PurMalESFullTextMapper.class);
    private static final Set<String> filterRowSet = new HashSet<String>(16);
    private static final String filterRowStr = "fdisabledate,fmasterid,fmodifytime,fmodifierid,fcreatetime,fdisablerid,funitid,fcreatorid,fenable";
    private static final String MALLGOODS_SELECTFIELDS = "id,name,number,group.id,group.name,group.number,group.longnumber,brandid.id,brandid.number,brandid.name,model,source,mainpic";

    public List<RowInfo> preHandle(List<RowInfo> rowInfos) {
        Iterator<RowInfo> dataIterator = rowInfos.iterator();
        while (dataIterator.hasNext()) {
            RowInfo rowInfo = dataIterator.next();
            if (!rowInfo.getTable().equalsIgnoreCase("t_mal_goods")) {
                dataIterator.remove();
                continue;
            }
            if (null != rowInfo.getData() && null != rowInfo.getData().get("fid") && null != rowInfo.getType() && rowInfo.getType().equalsIgnoreCase("insert")) continue;
            dataIterator.remove();
        }
        if (!CollectionUtils.isEmpty(rowInfos)) {
            HashSet<Long> goodsIds = new HashSet<Long>();
            for (RowInfo rowInfo : rowInfos) {
                if (rowInfo.getTable().equalsIgnoreCase("t_mal_goods")) {
                    if (null == rowInfo.getData().get("fid")) {
                        log.error("\u65b0\u7248\u5546\u57ce\u7535\u5546\u5546\u54c1\u540c\u6b65\u5168\u6587\u68c0\u7d22\u5e93\u3002fid\u5f02\u5e38\uff1adata: key= " + rowInfo.getKey() + " ,type=" + rowInfo.getType() + " ,rowInfo.data=" + rowInfo.getData());
                        continue;
                    }
                    goodsIds.add(Long.valueOf(rowInfo.getData().get("fid").toString()));
                    rowInfo.getData().entrySet().removeIf(entry -> filterRowSet.contains(entry.getKey()));
                    if (null != rowInfo.getData().get("fid")) {
                        rowInfo.getData().put("id", rowInfo.getData().remove("fid"));
                    }
                    if (null != rowInfo.getData().get("fbrandid")) {
                        rowInfo.getData().put("brandid", rowInfo.getData().remove("fbrandid").toString());
                    }
                    if (null != rowInfo.getData().get("fmodel")) {
                        rowInfo.getData().put("model", rowInfo.getData().remove("fmodel").toString());
                    }
                    if (null != rowInfo.getData().get("fclassid")) {
                        rowInfo.getData().put("classid", rowInfo.getData().remove("fclassid").toString());
                    }
                    if (null != rowInfo.getData().get("fnumber")) {
                        rowInfo.getData().put("number", rowInfo.getData().remove("fnumber").toString());
                    }
                    if (null != rowInfo.getData().get("fsource")) {
                        rowInfo.getData().put("source", rowInfo.getData().remove("fsource").toString());
                    }
                    if (null != rowInfo.getData().get("fmainpic")) {
                        rowInfo.getData().put("mainpic", rowInfo.getData().remove("fmainpic"));
                    }
                }
                if (!rowInfo.getTable().equalsIgnoreCase("t_mal_goods_l")) continue;
                rowInfo.getData().remove("fid");
                rowInfo.getData().remove("fpkid");
                rowInfo.getData().remove("fname");
                rowInfo.getData().remove("flocaleid");
            }
            DynamicObjectCollection goodsArray = QueryServiceHelper.query((String)"pbd_mallgoods", (String)MALLGOODS_SELECTFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIds)});
            DynamicObjectCollection statusArray = QueryServiceHelper.query((String)"pbd_mallgoods_status", (String)"id,mallgoods.id,mallstatus", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", goodsIds)});
            DynamicObjectCollection priceArray = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"id,mallgoods.id,price", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", goodsIds)});
            block2: for (RowInfo rowInfo : rowInfos) {
                String goodsId;
                if (!rowInfo.getTable().equalsIgnoreCase("t_mal_goods")) continue;
                String id = rowInfo.getData().get("id").toString();
                for (DynamicObject goods : goodsArray) {
                    goodsId = goods.getString("id");
                    if (!goodsId.equalsIgnoreCase(id)) continue;
                    rowInfo.getData().put("centralpurtype", "1");
                    rowInfo.getData().put("name_" + RequestContext.get().getLang().getLocale().toString().toLowerCase(), goods.get("name"));
                    rowInfo.getData().put("classnumber", goods.getString("group.number"));
                    rowInfo.getData().put("classlongnumber", goods.getString("group.longnumber"));
                    rowInfo.getData().put("classname", goods.getString("group.name"));
                    rowInfo.getData().put("brandnumber", goods.getString("brandid.number"));
                    rowInfo.getData().put("brandname", goods.getString("brandid.name"));
                    break;
                }
                for (DynamicObject status : statusArray) {
                    goodsId = status.getString("mallgoods.id");
                    if (!goodsId.equalsIgnoreCase(id)) continue;
                    rowInfo.getData().put("mallstatus", status.getString("mallstatus"));
                    break;
                }
                for (DynamicObject price : priceArray) {
                    goodsId = price.getString("mallgoods.id");
                    if (!goodsId.equalsIgnoreCase(id)) continue;
                    rowInfo.getData().put("price", Float.valueOf(price.getBigDecimal("price").toString()));
                    continue block2;
                }
            }
            return rowInfos;
        }
        return rowInfos;
    }

    public Map<String, Object> convert2Es(String tableName, RowInfo row) {
        Map dataMap = row.getData();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : dataMap.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("price")) {
                result.put((String)entry.getKey() + "_" + FTDataType.FLOAT, entry.getValue());
                continue;
            }
            result.put((String)entry.getKey() + "_" + FTDataType.STRING, entry.getValue());
        }
        ArrayList<FieldValue> fvList = new ArrayList<FieldValue>();
        String pkId = row.getKey();
        FieldValue fvPkId = new FieldValue("pkid", (Object)String.valueOf(pkId));
        fvList.add(fvPkId);
        FieldValue fvEntityName = new FieldValue("entityname", (Object)"pbd_mallgoods");
        fvList.add(fvEntityName);
        for (Map.Entry entry : dataMap.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase("name_zh_cn")) continue;
            String filedName = (String)entry.getKey();
            Object pyValue = entry.getValue();
            try {
                pyValue = PinYinUtil.getMergePinyin((String)(pyValue + ""));
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                log.error("\u65b0\u7248\u5546\u57ce\u7535\u5546\u5546\u54c1\u540c\u6b65\u5168\u6587\u68c0\u7d22\u5e93\u3002trans py error\uff1a" + (Object)((Object)e));
            }
            FieldValue fvFieldNamePY = new FieldValue(filedName.replace("_zh_cn", "") + "_py_string", pyValue);
            fvList.add(fvFieldNamePY);
        }
        fvList.forEach(v -> result.put(v.getName(), v.getValue()));
        return result;
    }

    static {
        String[] split = filterRowStr.split(",");
        filterRowSet.addAll(Arrays.asList(split));
    }
}

