/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.ricc.form.listext;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.imsc.ricc.form.listext.DynamicListPlugin;
import kd.bos.ext.imsc.ricc.util.FormOpenUtil;
import kd.bos.ext.imsc.ricc.util.SysParamHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.metadata.form.control.BarItemAp;

public class DynamicBdListPlugin
extends DynamicListPlugin {
    public static final String RICC_ONCE_KEY = "ricconcekey";
    private static final String TOOLBAR = "toolbarap";
    private static final String SYNC_KEY = "ricc_sync";
    private static final String FASTTRANSFER_KEY = "fasttransfer";
    private static final String ADDPACKET_KEY = "addpacket";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{SYNC_KEY, FASTTRANSFER_KEY, ADDPACKET_KEY});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean isRiccItems;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        boolean bl = isRiccItems = FASTTRANSFER_KEY.equals(itemKey) || ADDPACKET_KEY.equals(itemKey);
        if (isRiccItems) {
            boolean isOverPackLimit;
            if (listSelectedRows == null || listSelectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u6570\u636e\uff01", (String)"DynamicBdListPlugin_0", (String)"bos-ext-imsc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int packDataLimit = SysParamHelper.getPackDataLimit();
            boolean bl2 = isOverPackLimit = listSelectedRows.size() > packDataLimit;
            if (isOverPackLimit) {
                String msgTpl = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\u6027\uff0c\u5355\u6b21\u6dfb\u52a0\u4f20\u8f93\u6570\u636e\u6570\u91cf\u4e0d\u5f97\u8d85\u8fc7%d\u6761\uff0c\u8bf7\u5206\u6279\u6dfb\u52a0\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4e2d\u8c03\u6574\u9650\u5236", (String)"DynamicBdListPlugin_1", (String)"bos-ext-imsc", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msgTpl, packDataLimit));
                evt.setCancel(true);
                return;
            }
            if (!SysParamHelper.isOpenImportTemplateId()) {
                this.getView().showErrorNotification(SysParamHelper.getImportTemplateTips());
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection listSelectedRows = this.getSelectedRows();
        if (SYNC_KEY.equalsIgnoreCase(itemKey)) {
            this.showBdSyncConfirm();
        } else if (ADDPACKET_KEY.equals(itemKey)) {
            FormOpenUtil.openAddPacketForm(listSelectedRows, this.getView().getPageId(), null, this.getView(), this.getPluginName());
        } else if (FASTTRANSFER_KEY.equals(itemKey)) {
            FormOpenUtil.openAddTransferForm(listSelectedRows, this.getView().getPageId(), null, this.getView(), this.getPluginName());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Container toolbar = (Container)this.getView().getControl(TOOLBAR);
        if (!Objects.isNull(toolbar)) {
            ArrayList<Map> items = new ArrayList<Map>();
            BarItemAp addDataPacket = new BarItemAp();
            addDataPacket.setId(ADDPACKET_KEY);
            addDataPacket.setKey(ADDPACKET_KEY);
            addDataPacket.setOperationStyle(Integer.valueOf(1));
            addDataPacket.setName(new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"DynamicBdListPlugin_2", (String)"bos-ext-imsc", (Object[])new Object[0])));
            BarItemAp fastTransfer = new BarItemAp();
            fastTransfer.setId(FASTTRANSFER_KEY);
            fastTransfer.setKey(FASTTRANSFER_KEY);
            fastTransfer.setOperationStyle(Integer.valueOf(1));
            fastTransfer.setName(new LocaleString(ResManager.loadKDString((String)"\u5feb\u901f\u4f20\u8f93", (String)"DynamicBdListPlugin_3", (String)"bos-ext-imsc", (Object[])new Object[0])));
            boolean canAddPacket = this.canAddPacket();
            if (!canAddPacket) {
                Tips tips = new Tips();
                tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\uff0c\u6309\u94ae\u88ab\u9501\u5b9a\uff0c\u5982\u9700\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u8bf7\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4fee\u6539\u73af\u5883\u7ba1\u63a7\u914d\u7f6e\u7b56\u7565\u3002", (String)"DynamicBdListPlugin_4", (String)"bos-ext-imsc", (Object[])new Object[0])));
                tips.setType("bos-ext-imsc");
                tips.setShowIcon(false);
                tips.setTriggerType("hover");
                addDataPacket.setCtlTips(tips);
            }
            Map addPacketControl = addDataPacket.createControl();
            Map fastTransferControl = fastTransfer.createControl();
            items.add(addPacketControl);
            items.add(fastTransferControl);
            toolbar.addControls(items);
            this.getView().setEnable(Boolean.valueOf(canAddPacket), new String[]{ADDPACKET_KEY, FASTTRANSFER_KEY});
        }
    }

    private boolean canAddPacket() {
        Object canAddPacket = this.getView().getFormShowParameter().getCustomParam("canAddPacket");
        if (canAddPacket != null) {
            return (Boolean)canAddPacket;
        }
        return false;
    }

    private void showBdSyncConfirm() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5728\u57fa\u7840\u914d\u7f6e\u4e2d\u5fc3\u8fdb\u884c\u6570\u636e\u7684\u6253\u5305\u4f20\u8f93", (String)"DynamicBdListPlugin_8", (String)"bos-ext-imsc", (Object[])new Object[0]));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("addPacketClose".equalsIgnoreCase(actionId) && "success".equals(returnData = event.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f\u3002", (String)"DynamicBdListPlugin_5", (String)"bos-ext-imsc", (Object[])new Object[0]));
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("riccFormId");
        DynamicObject[] queryValues = e.getQueryValues();
        if (queryValues != null && queryValues.length != 0 && "bd_exrate_tree".equals(entityNumber)) {
            for (DynamicObject exrate : queryValues) {
                exrate.set("indirectexrate", null);
            }
        }
    }
}

