/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.api.storage.highlevel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.es.api.common.BosEsErrorCode;
import kd.bos.ext.hr.es.api.storage.EsResultVo;
import kd.bos.ext.hr.es.api.storage.SortField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class EsAccess {
    private static final Log logger = LogFactory.getLog(EsAccess.class);
    private static final String RETRY_ON_CONFLICT_KEY = "fulltext.retryonconflict";
    private static final ErrorCode ioError = new ErrorCode("bos.dts IoError", "%s io error");
    private static final long MAX_BULK_SIZE = 10000000L;

    private EsAccess() {
    }

    public static RestHighLevelClient createRestHighLevelClient(String ip, int port, String username, String password) {
        if (username != null && password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, port)}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            }));
        }
        return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, port, "http")}));
    }

    public static RestHighLevelClient createRestHighLevelClient(Map<String, String> connConfig) {
        String username = connConfig.get("username");
        String password = connConfig.get("password");
        List<HttpHost> httpHosts = EsAccess.getHttpHosts(connConfig);
        if (username != null && password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts.toArray(new HttpHost[0])).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            }));
        }
        return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts.toArray(new HttpHost[0])));
    }

    private static List<HttpHost> getHttpHosts(Map<String, String> connConfig) {
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(10);
        int port = Integer.parseInt(connConfig.get("port"));
        String ip = connConfig.get("ip");
        String urls = connConfig.get("urls");
        String schema = connConfig.get("schema");
        logger.info("connect to es:ip{},urls:{}", (Object)ip, (Object)urls);
        if (StringUtils.isNotEmpty((CharSequence)urls)) {
            String[] urlArr;
            for (String url : urlArr = urls.split(",")) {
                try {
                    httpHosts.add(HttpHost.create((String)url));
                }
                catch (Exception exception) {
                    logger.warn("HttpHost.create exception:url:{}", (Object)url);
                }
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(httpHosts)) {
            httpHosts.add(new HttpHost(ip, port, schema));
        }
        return httpHosts;
    }

    public static boolean isIndexExist(RestHighLevelClient client, String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        try {
            return client.indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    public static void createIndex(RestHighLevelClient client, String index, Map<String, Object> settings) {
        CreateIndexRequest req = new CreateIndexRequest(index);
        req.settings(settings);
        try {
            client.indices().create(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    public static void createIndexMapping(RestHighLevelClient client, String index, String type, XContentBuilder fieldsMapping) {
        PutMappingRequest req = new PutMappingRequest(new String[]{index});
        req.type(type);
        req.source(fieldsMapping);
        AcknowledgedResponse res = null;
        try {
            res = client.indices().putMapping(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"Failed to create index:" + index + res.toString()});
        }
    }

    public static void updateIndexSettings(RestHighLevelClient client, String[] indexs, Map<String, Object> indexSettings) {
        String shardsNum = "number_of_shards";
        if (indexSettings.containsKey(shardsNum)) {
            indexSettings.remove(shardsNum);
        }
        UpdateSettingsRequest req = new UpdateSettingsRequest(indexs);
        req.settings(indexSettings);
        AcknowledgedResponse res = null;
        try {
            res = client.indices().putSettings(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"failed to update indexs settings:" + res.toString()});
        }
    }

    public static List<BulkItemResponse> batchSave(RestHighLevelClient client, String index, String type, List<Map<String, Object>> listMap) {
        if (CollectionUtils.isEmpty(listMap)) {
            return null;
        }
        BulkRequest req = new BulkRequest();
        req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ArrayList<BulkRequest> listBulkRequest = new ArrayList<BulkRequest>();
        int count = 0;
        Object id = null;
        for (Map<String, Object> map : listMap) {
            id = map.get("_id");
            map.remove("_id", id);
            IndexRequest indexRequest = new IndexRequest(index, type, String.valueOf(id)).source(map);
            UpdateRequest updateRequest = new UpdateRequest(index, type, String.valueOf(id)).upsert(indexRequest);
            updateRequest.doc(indexRequest);
            updateRequest.retryOnConflict(Integer.parseInt(System.getProperty(RETRY_ON_CONFLICT_KEY, "5")));
            req.add(updateRequest);
            long size = req.estimatedSizeInBytes();
            ++count;
            if (size < 10000000L) continue;
            listBulkRequest.add(req);
            count = 0;
            req = new BulkRequest();
            req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        if (count > 0) {
            listBulkRequest.add(req);
        }
        ArrayList<BulkItemResponse> failureRes = new ArrayList<BulkItemResponse>();
        BulkResponse res = null;
        for (BulkRequest bulkRequest : listBulkRequest) {
            try {
                res = client.bulk(bulkRequest, RequestOptions.DEFAULT);
                logger.info("ES batch save data success! index name: {}, last line of batch data id: {}, batch size: {}", new Object[]{index, String.valueOf(id), String.valueOf(listMap.size())});
            }
            catch (IOException e) {
                logger.error("ES batch save data failure! index name: {}, last line of batch data id: {}, batch size: {}", new Object[]{index, String.valueOf(id), String.valueOf(listMap.size())});
                throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
            }
            if (!res.hasFailures()) continue;
            for (BulkItemResponse resp : res.getItems()) {
                if (!resp.isFailed()) continue;
                failureRes.add(resp);
            }
        }
        return failureRes;
    }

    public static long updateByQuery(RestHighLevelClient client, String index, String type, QueryBuilder filterQb, Map<String, Object> updateData) {
        BulkByScrollResponse res;
        UpdateByQueryRequest req = new UpdateByQueryRequest(new String[]{index});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        queryBuilder.must(filterQb);
        req.setQuery((QueryBuilder)queryBuilder);
        int upFlag = 0;
        int upSize = updateData.size();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : updateData.entrySet()) {
            String key = entry.getKey();
            sb.append("ctx._source.").append(key).append(" = params.").append(key);
            if (++upFlag >= upSize) continue;
            sb.append(";");
        }
        ((UpdateByQueryRequest)((UpdateByQueryRequest)req.setScript(new Script(ScriptType.INLINE, "painless", sb.toString(), updateData))).setRefresh(true)).indices(new String[]{index});
        try {
            res = client.updateByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        return res.getUpdated();
    }

    public static long deleteByQuery(RestHighLevelClient client, String index, String type, QueryBuilder filterQb) {
        DeleteByQueryRequest req = new DeleteByQueryRequest(new String[]{index});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        queryBuilder.must(filterQb);
        ((DeleteByQueryRequest)req.setQuery((QueryBuilder)queryBuilder).setRefresh(true)).indices(new String[]{index});
        BulkByScrollResponse res = null;
        try {
            res = client.deleteByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        return res.getDeleted();
    }

    public static void refreshIndex(RestHighLevelClient client, String index) {
        RefreshRequest req = new RefreshRequest(new String[]{index});
        try {
            RefreshResponse refreshResponse = client.indices().refresh(req, RequestOptions.DEFAULT);
            if (refreshResponse.getFailedShards() > 0) {
                throw new KDException(BosEsErrorCode.esException, new Object[]{"refresh failed:" + refreshResponse.toString()});
            }
        }
        catch (IOException e) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
    }

    public static List<Map<String, Object>> queryAll(RestHighLevelClient client, String indexName, String typeName) {
        SearchRequest req = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (StringUtils.isNotEmpty((CharSequence)typeName)) {
            req.types(new String[]{typeName});
        }
        builder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        req.source(builder);
        SearchResponse res = null;
        try {
            res = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        SearchHit[] hits = res.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return result;
    }

    public static EsResultVo query(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, SortField[] sortFields, boolean score, int start, int size, Object[] objSortValues) {
        SearchHit[] hits = EsAccess.querySearchHits(client, index, type, selectFields, filterQb, sortFields, score, start, size, objSortValues);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        Object[] objSortValuesResult = null;
        if (hits != null && hits.length > 0) {
            objSortValuesResult = hits[hits.length - 1].getSortValues();
        }
        EsResultVo esResultVo = new EsResultVo();
        esResultVo.setResultData(result);
        esResultVo.setObjSortValues(objSortValuesResult);
        return esResultVo;
    }

    private static SearchHit[] querySearchHits(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, SortField[] sortFields, boolean score, int start, int size, Object[] objSortValues) {
        Object queryBuilder = null;
        queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : QueryBuilders.constantScoreQuery((QueryBuilder)filterQb);
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        if (objSortValues != null) {
            sourceBuilder.searchAfter(objSortValues);
        }
        EsAccess.sort(sortFields, sourceBuilder);
        req.source(sourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        SearchHit[] hits = searchResponse.getHits().getHits();
        return hits;
    }

    private static void sort(SortField[] sortFields, SearchSourceBuilder builder) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        for (SortField info : sortFields) {
            FieldSortBuilder sortBuilderOrder;
            FieldSortBuilder sortBuilderOrder2;
            NestedSortBuilder nestedSort;
            if (null == info) continue;
            if (info.isAsc()) {
                if (StringUtils.isNotBlank((CharSequence)info.getPath())) {
                    nestedSort = new NestedSortBuilder(info.getPath());
                    sortBuilderOrder2 = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.ASC)).setNestedSort(nestedSort).missing((Object)"_first");
                    builder.sort((SortBuilder)sortBuilderOrder2);
                    continue;
                }
                sortBuilderOrder = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.ASC)).missing((Object)"_first");
                builder.sort((SortBuilder)sortBuilderOrder);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)info.getPath())) {
                nestedSort = new NestedSortBuilder(info.getPath());
                sortBuilderOrder2 = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.DESC)).setNestedSort(nestedSort).missing((Object)"_last");
                builder.sort((SortBuilder)sortBuilderOrder2);
                continue;
            }
            sortBuilderOrder = ((FieldSortBuilder)SortBuilders.fieldSort((String)info.getName()).order(SortOrder.DESC)).missing((Object)"_last");
            builder.sort((SortBuilder)sortBuilderOrder);
        }
    }

    public static List<Map<String, Object>> queryHighLight(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQB, SortField[] sortFields, boolean score, String preTag, String postTag, int start, int size) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)filterQB);
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        EsAccess.sort(sortFields, ssb);
        List<String> highLightFields = EsAccess.highLighMatch(selectFields, preTag, postTag, ssb);
        req.source(ssb);
        SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{e});
        }
        return EsAccess.queryResult(type, highLightFields, searchResponse);
    }

    private static List<Map<String, Object>> queryResult(String type, List<String> highLightFields, SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (String field : highLightFields) {
                HighlightField nameField = (HighlightField)highlightFields.get(field);
                if (nameField == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text.toString());
                }
                source.put(field, nameTmp);
            }
            result.add(source);
        }
        return result;
    }

    private static List<String> highLighMatch(String[] selectFields, String preTag, String postTag, SearchSourceBuilder ssb) {
        ArrayList<String> highLightFields = new ArrayList<String>();
        for (String field : selectFields) {
            if (field.equalsIgnoreCase("entityname") && field.equalsIgnoreCase("pkid")) continue;
            highLightFields.add(field);
        }
        HighlightBuilder hb = new HighlightBuilder();
        ((HighlightBuilder)hb.preTags(new String[]{preTag})).postTags(new String[]{postTag});
        for (String field : highLightFields) {
            hb.field(field);
        }
        ssb.highlighter(hb);
        return highLightFields;
    }

    public static long getCount(RestHighLevelClient client, String index, String type, QueryBuilder filterQb) {
        Object queryBuilder = null;
        queryBuilder = null == filterQb ? QueryBuilders.matchAllQuery() : QueryBuilders.constantScoreQuery((QueryBuilder)filterQb);
        SearchRequest req = new SearchRequest(new String[]{index});
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.query((QueryBuilder)queryBuilder).size(0);
        req.source(builder);
        try {
            SearchResponse searchResponse = client.search(req, RequestOptions.DEFAULT);
            return searchResponse.getHits().getTotalHits();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    public static boolean deleteIndex(RestHighLevelClient client, String indexName) {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        request.timeout(TimeValue.timeValueMinutes((long)5L));
        request.masterNodeTimeout(TimeValue.timeValueMinutes((long)1L));
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        try {
            AcknowledgedResponse deleteIndexResponse = client.indices().delete(request, RequestOptions.DEFAULT);
            boolean acknowledged = deleteIndexResponse.isAcknowledged();
            return acknowledged;
        }
        catch (ElasticsearchException exception) {
            if (exception.status() == RestStatus.NOT_FOUND) {
                logger.warn("HighLevelAccess not found deleteIndex: " + indexName);
            }
            throw new KDException((Throwable)exception, ioError, new Object[]{"deleteIndex error"});
        }
        catch (IOException exception) {
            throw new KDException((Throwable)exception, ioError, new Object[]{"deleteIndex error"});
        }
        return false;
    }
}

