/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.multientity.MultiEntity;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.es.me.constants.EnumDataChangeType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class SearchObjESSyncMapper
implements Mapper {
    private static final Log LOGGER = LogFactory.getLog(SearchObjESSyncMapper.class);
    private String searchObjNumber;
    private String searchObjMainEntityNumber;

    public String getSearchObjMainEntityNumber() {
        if (StringUtils.isEmpty((CharSequence)this.searchObjMainEntityNumber)) {
            this.searchObjMainEntityNumber = (String)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrss", (String)"IHRSSService", (String)"querySearchObjMainEntity", (Object[])new Object[]{this.searchObjNumber});
        }
        return this.searchObjMainEntityNumber;
    }

    public List<RowInfo> preHandle(List<RowInfo> rowInfoList) {
        MainEntityType dataEntityType;
        String tableName;
        if (CollectionUtils.isEmpty(rowInfoList) || StringUtils.isEmpty((CharSequence)this.searchObjNumber)) {
            return null;
        }
        RowInfo firstRowInfo = rowInfoList.get(0);
        if (firstRowInfo == null) {
            return null;
        }
        String dataChangeType = firstRowInfo.getType();
        String entityNumber = firstRowInfo.getEntityNumber();
        if (entityNumber == null) {
            entityNumber = this.getMultiEntity().getMainEntityNumber(null);
        }
        if (!(tableName = firstRowInfo.getTable()).equals((dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)).getAlias())) {
            return null;
        }
        boolean isBatchImportData = true;
        ArrayList<Object> idList = new ArrayList<Object>(10);
        for (RowInfo rowInfo : rowInfoList) {
            if (isBatchImportData && !EnumDataChangeType.NEW.getType().equals(dataChangeType)) {
                isBatchImportData = false;
            }
            idList.add(rowInfo.getKeyObject());
        }
        try {
            if (CollectionUtils.isNotEmpty(idList)) {
                if (isBatchImportData && idList.size() > 1 && this.getMultiEntity().isMainEntity(entityNumber)) {
                    LOGGER.info("SO_DTS_SYNC batchImportData! searchObjNumber:{}, datachangetype:{}, batch size:{}", new Object[]{this.searchObjNumber, dataChangeType, idList.size()});
                    DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrss", (String)"IHRSSDataSyncService", (String)"batchImportData", (Object[])new Object[]{this.searchObjNumber, idList});
                } else {
                    LOGGER.info("SO_DTS_SYNC deltaUpdateDate! searchObjNumber:{}, datachangetype:{}, entitynumber:{}, id:{}", new Object[]{this.searchObjNumber, dataChangeType, entityNumber, idList.get(0)});
                    DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrss", (String)"IHRSSDataSyncService", (String)"deltaUpdateDate", (Object[])new Object[]{this.searchObjNumber, entityNumber, dataChangeType, idList});
                }
            }
        }
        catch (Exception exc) {
            LOGGER.error("SO_DTS_SYNC importData Exception,searchObjNumber:{}, isBatchImportData{}, error:{}", new Object[]{this.searchObjNumber, isBatchImportData, exc.getMessage()});
            throw new KDBizException(exc.getMessage());
        }
        return null;
    }

    public MultiEntity getMultiEntity() {
        return new SearchObjMulEntity();
    }

    public void endInit(String opType, String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)this.searchObjNumber) || StringUtils.isEmpty((CharSequence)opType)) {
            return;
        }
        if (!opType.equals("insert")) {
            return;
        }
        LOGGER.info("SO_DTS_SYNC batchImport finish! searchObjNumber:{}, opType:{}, entitynumber:{}", new Object[]{this.searchObjNumber, opType, entityNumber});
        DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrss", (String)"IHRSSDataSyncService", (String)"resetEsIndexAlias", (Object[])new Object[]{this.searchObjNumber});
    }

    public Map<?, ?> convert2Es(String s, RowInfo rowInfo) {
        return null;
    }

    public String getKeyId(RowInfo rowInfo) {
        return null;
    }

    public String getIndexName(String s) {
        return null;
    }

    public String getESDataType() {
        return null;
    }

    public void setRegion(String s) {
    }

    public String getFieldStoredName(String s, String s1) {
        return null;
    }

    class SearchObjMulEntity
    implements MultiEntity {
        SearchObjMulEntity() {
        }

        public String getMainEntityNumber(String entityNumber) {
            String mainEntityNumber = SearchObjESSyncMapper.this.getSearchObjMainEntityNumber();
            if (StringUtils.isEmpty((CharSequence)mainEntityNumber)) {
                throw new KDBizException("mainEntityNumber error");
            }
            return mainEntityNumber;
        }

        public boolean isMainEntity(String entityNumber) {
            String mainEntityNumber = SearchObjESSyncMapper.this.getSearchObjMainEntityNumber();
            if (StringUtils.isEmpty((CharSequence)mainEntityNumber)) {
                throw new KDBizException("mainEntityNumber error");
            }
            return entityNumber.equals(mainEntityNumber);
        }
    }
}

