/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.form.operate;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.svc.util.OpExistChecker;
import org.apache.commons.collections4.CollectionUtils;

public abstract class HIESTaskInfoPage
extends DefaultDynamicFormOperate {
    private static final Log log = LogFactory.getLog(HIESTaskInfoPage.class);

    public boolean needSelectData() {
        return false;
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        long orgId = 0L;
        if (this.getView() instanceof IListView) {
            List mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
            mainOrgIds.removeIf(Objects::isNull);
            if (CollectionUtils.isNotEmpty((Collection)mainOrgIds)) {
                this.doPermission(result, this.getPermissionItemId(), mainOrgIds);
                return 1;
            }
        } else {
            orgId = this.mainOrgId != null ? this.mainOrgId : 0L;
        }
        this.doPermission(result, this.getPermissionItemId(), orgId);
        return 1;
    }

    public OperationResult invokeOperation() {
        Boolean opExist = OpExistChecker.check((String)this.getEntityId(), (String)this.getType(), (IFormView)this.getView());
        if (!opExist.booleanValue()) {
            return null;
        }
        this.showHistory();
        return null;
    }

    public void showHistory() {
        String billFormId;
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hies_taskinfo");
        showParameter.setFormId("bos_list");
        showParameter.setLookUp(false);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("oprtype", (Object)this.getPageType());
        showParameter.setCustomParam("isHyperlink4Oprtype", (Object)Boolean.FALSE);
        showParameter.setCustomParam("checkRightAppId", (Object)"15NPDX/GJFOO");
        IFormView view = this.getView();
        String queryEntityId = null;
        if (view instanceof ListView) {
            MainEntityType mainType;
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            if ("list".equalsIgnoreCase(config.getModelType()) && (mainType = EntityMetadataCache.getDataEntityType((String)billFormId)) instanceof QueryEntityType) {
                QueryEntityType queryType = (QueryEntityType)mainType;
                billFormId = queryType.getMainEntityType().getName();
                queryEntityId = ((ListView)view).getEntityTypeId();
            }
        } else {
            billFormId = view.getEntityId();
        }
        showParameter.setCustomParam("oprFormId", (Object)billFormId);
        view.showForm((FormShowParameter)showParameter);
    }

    protected abstract String getPageType();
}

