/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.form.operate;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.form.operate.helper.HRHiesHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListController;
import kd.bos.svc.util.OpExistChecker;

public class HREntryExport
extends DefaultDynamicFormOperate
implements ICloseCallBack {
    private static Log LOGGER = LogFactory.getLog(HREntryExport.class);

    public OperationResult invokeOperation() {
        Boolean opExist = OpExistChecker.check((String)this.getEntityId(), (String)this.getType(), (IFormView)this.getView());
        if (!opExist.booleanValue()) {
            return null;
        }
        FormShowParameter showParameter = this.createShowParameter();
        String entryKey = HRHiesHelper.getEntryKey(showParameter.getCustomParams());
        int totalRow = this.getView().getModel().getEntryRowCount(entryKey);
        if (totalRow == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u65e0\u6570\u636e\u65e0\u9700\u5bfc\u51fa\u3002", (String)"HREntryExport_1", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else {
            this.getView().showForm(showParameter);
        }
        HRHiesHelper.sendGetGridInfo(this.getView(), entryKey);
        return null;
    }

    private FormShowParameter createShowParameter() {
        List plugins;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hies_entry_exportstart");
        Map parameter = this.getParameter();
        String billFormId = null;
        String listName = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            listName = config.getCaption().toString();
            showParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)formShowParameter).getBillTypeId());
        } else if (view instanceof IBillView || view instanceof FormView) {
            billFormId = view.getEntityId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        ArrayList listPlugins = new ArrayList();
        Map paramMap = new HashMap();
        if (parameter != null && !parameter.isEmpty()) {
            paramMap = (Map)JSONObject.parseObject((String)((String)parameter.get("parameter")), Map.class);
        }
        if ((plugins = (List)JSONObject.parseObject((String)((String)paramMap.get("plugins")), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0])) != null && plugins.size() > 0) {
            listPlugins.addAll(plugins.stream().filter(plugin -> Boolean.TRUE.equals(plugin.get("Enabled"))).map(plugin -> (String)plugin.get("ClassName")).collect(Collectors.toList()));
        }
        showParameter.setCustomParam("exportPlugin", (Object)listPlugins.stream().collect(Collectors.joining(",")));
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("formId", (Object)billFormId);
        showParameter.setCustomParam("ListName", (Object)listName);
        showParameter.setCustomParam("OperateKey", (Object)this.getOperateKey());
        showParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("PermissionItemId", (Object)this.getPermissionItemId());
        showParameter.setCustomParam("RealPermissionEntityId", (Object)this.getRealPermissionEntityId());
        showParameter.setCustomParam("RealPermissionEntityId", (Object)this.getRealPermissionEntityId());
        showParameter.setCustomParam("OperateName", (Object)this.getOperateName().toString());
        Map map = new HashMap();
        if (parameter != null && !parameter.isEmpty()) {
            map = (Map)JSONObject.parseObject((String)((String)parameter.get("parameter")), Map.class);
            showParameter.setCustomParam("hr_entryId", map.get("operateparam"));
        }
        LOGGER.info("before-show-import-data------billformid=" + billFormId + ", appid=" + formShowParameter.getAppId() + ", service_appid=" + formShowParameter.getServiceAppId() + "hr_entryId:" + map.get("operateparam"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        Object controller = closedcallbackevent.getSource();
        if (controller instanceof ListController) {
            ((IListView)((ListController)closedcallbackevent.getSource()).getView()).refresh();
        } else if (controller instanceof FormController) {
            ((FormController)controller).getView().updateView();
        }
    }
}

