/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.form.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.constants.BosExtHrRes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListController;
import kd.bos.mvc.list.ListView;
import kd.bos.svc.util.OpExistChecker;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class HRExport
extends DefaultDynamicFormOperate
implements ICloseCallBack {
    private static Log log = LogFactory.getLog(HRExport.class);
    private static final String EXPORT_PARAMETER = "ExportParameter";
    private static final String TWO_PLACEHOLDER = "%s_%s";
    private final Map<String, Object> opParameter = new HashMap<String, Object>(16);

    public boolean needSelectData() {
        return this.isSelectedRows();
    }

    protected abstract String getExportModule();

    protected abstract String getOprCategory();

    protected String tplType() {
        return "";
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        this.checkPermission(result);
        return 1;
    }

    public OperationResult invokeOperation() {
        Boolean opExist = OpExistChecker.check((String)this.getEntityId(), (String)this.getType(), (IFormView)this.getView());
        if (!opExist.booleanValue()) {
            return null;
        }
        if (this.isBillView()) {
            return this.billViewExport();
        }
        if (this.isListView()) {
            return this.listViewExport();
        }
        if (this.getView() instanceof FormView) {
            this.saveCacheForPermission(this.getView().getPageCache());
            this.getView().getPageCache().put(EXPORT_PARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
            this.getView().getPageCache().put("EntityNumber", this.getEntityId());
            Pair<String, String> showMsg = this.getExportConfirmMsg(1, false);
            this.showExportStartPage(showMsg);
        }
        return null;
    }

    private OperationResult listViewExport() {
        IListView listview = (IListView)this.getView();
        IPageCache pageCache = listview.getPageCache();
        AbstractListViewPluginProxy listViewPluginProxy = (AbstractListViewPluginProxy)listview.getService(FormViewPluginProxy.class);
        List listPlugins = listViewPluginProxy.getPlugIns().stream().map(plugin -> plugin.getPluginName()).collect(Collectors.toList());
        pageCache.put("listPlugins", String.join((CharSequence)",", listPlugins));
        pageCache.put(EXPORT_PARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
        BillList billList = (BillList)listview.getControl("billlistap");
        Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
        int billNum = primaryKeyValues.length;
        if (billNum == 0) {
            if (this.isDefaultExportListAll()) {
                FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
                if ("list".equalsIgnoreCase(config.getModelType())) {
                    billList.queryBillDataCount();
                    try {
                        billNum = billList.getListModel().getRealCount();
                    }
                    catch (Throwable e) {
                        String listDataCountPrefix = String.format(TWO_PLACEHOLDER, billList.getKey(), "bdc");
                        String listDataCount = this.getView().getPageCache().get(listDataCountPrefix);
                        String lineCountCountPrefix = String.format(TWO_PLACEHOLDER, billList.getKey(), "dc");
                        String lineCount = this.getView().getPageCache().get(lineCountCountPrefix);
                        log.info("[\u5bfc\u51fa\u9650\u6d41\uff1a\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u5355\u636e\u6570\uff1a]" + listDataCount + "\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684\u5355\u636e\u6570\uff1a" + lineCount);
                        if (StringUtils.isNotEmpty((CharSequence)lineCount)) {
                            billNum = Integer.parseInt(lineCount);
                        }
                    }
                } else {
                    billNum = billList.queryBillDataCount();
                }
            }
            pageCache.put("isSelect", Boolean.toString(false));
        } else {
            pageCache.put("isSelect", Boolean.toString(true));
        }
        if (billNum > 0) {
            this.saveCacheForPermission(pageCache);
            Pair<String, String> showMsg = this.getExportConfirmMsg(billNum, false);
            this.showExportStartPage(showMsg);
            return null;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)BosExtHrRes.HRExport_1.resId(), (String)"bos-ext-hr", (Object[])new Object[0]));
        return null;
    }

    private void showExportStartPage(Pair<String, String> showMsg) {
        String billFormId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hies_exportplugin");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = this.getView();
        showParameter.setCustomParam("content", showMsg.getLeft());
        showParameter.setCustomParam("displayName", showMsg.getRight());
        String queryEntityId = null;
        if (view instanceof ListView) {
            MainEntityType mainType;
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            if ("list".equalsIgnoreCase(config.getModelType()) && (mainType = EntityMetadataCache.getDataEntityType((String)billFormId)) instanceof QueryEntityType) {
                QueryEntityType queryType = (QueryEntityType)mainType;
                billFormId = queryType.getMainEntityType().getName();
                queryEntityId = ((ListView)view).getEntityTypeId();
            }
        } else {
            billFormId = view.getEntityId();
        }
        this.putCustomParams(billFormId, queryEntityId, showParameter.getCustomParams());
        view.showForm(showParameter);
    }

    private OperationResult billViewExport() {
        IBillView billView = (IBillView)this.getView();
        boolean isFormDB = billView.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (isFormDB) {
            this.saveCacheForPermission(billView.getPageCache());
            billView.getPageCache().put(EXPORT_PARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
            billView.getPageCache().put("EntityNumber", this.getEntityId());
            boolean isChange = billView.getModel().getDataChanged();
            Pair<String, String> showMsg = this.getExportConfirmMsg(1, isChange);
            this.showExportStartPage(showMsg);
        } else {
            billView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u540e\u518d\u5bfc\u51fa\u3002", (String)BosExtHrRes.HRExport_2.resId(), (String)"bos-ext-hr", (Object[])new Object[0]));
        }
        return null;
    }

    private Pair<String, String> getExportConfirmMsg(int billNum, boolean isChanged) {
        String message = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u5f20%2$s\uff0c\u786e\u8ba4\u8981\u7ee7\u7eed\u5417\uff1f", (String)BosExtHrRes.HRExport_3.resId(), (String)"bos-ext-hr", (Object[])new Object[0]);
        String displayName = ResManager.loadKDString((String)"\u5355\u636e", (String)BosExtHrRes.HRExport_4.resId(), (String)"bos-ext-hr", (Object[])new Object[0]);
        IFormView view = this.getView();
        if (this.isBillView()) {
            IBillView billView = (IBillView)view;
            MainEntityType entityType = billView.getModel().getDataEntityType();
            displayName = entityType.getDisplayName().toString();
            if (isChanged) {
                return Pair.of((Object)String.format(ResManager.loadKDString((String)"\u5f53\u524d%1$s\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u786e\u8ba4\u662f\u5426\u5bfc\u51fa?", (String)BosExtHrRes.HRExport_5.resId(), (String)"bos-ext-hr", (Object[])new Object[0]), displayName), (Object)displayName);
            }
        } else if (this.isListView()) {
            IListView listview = (IListView)view;
            EntityType entityType = listview.getListModel().getDataEntityType();
            displayName = entityType.getDisplayName().toString();
        } else if (view instanceof FormView) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            String caption = formShowParameter.getCaption();
            displayName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        return Pair.of((Object)String.format(message, billNum, "%1$s"), (Object)displayName);
    }

    protected boolean isSelectedRows() {
        IFormView view = this.getView();
        if (view instanceof IListView) {
            BillList billList = this.getBillList();
            if (billList != null) {
                AbstractGrid.GridState state = billList.getEntryState();
                if (state != null && state.isSelectAllRows()) {
                    return true;
                }
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                return selectedRows != null && !selectedRows.isEmpty();
            }
            return false;
        }
        return true;
    }

    private boolean isDefaultExportListAll() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            ListUserOption listOption = listShowParameter.getListUserOption();
            if (listOption == null) {
                listOption = new ListUserOption();
            }
            return listOption.isDefaultExportListAll();
        }
        return false;
    }

    private void putCustomParams(String billFormId, String queryEntityId, Map<String, Object> params) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        params.put("requestContext", RequestContext.get());
        params.put("sourceIp", NetAddressUtils.getLocalIpAddress());
        params.put("userStartTime", new Date().getTime());
        params.put("ServiceAppId", formShowParameter.getServiceAppId());
        params.put("appId", formShowParameter.getAppId());
        params.put("formId", billFormId);
        params.put("queryEntityId", queryEntityId);
        params.put("pageId", view.getPageId());
        String entityName = StringUtils.isBlank((CharSequence)formShowParameter.getCaption()) ? formShowParameter.getFormConfig().getCaption().getLocaleValue() : formShowParameter.getCaption();
        params.put("entityname", entityName);
        params.put("isBillViewExport", view instanceof IBillView);
        boolean isSelect = Boolean.parseBoolean(view.getPageCache().get("isSelect"));
        params.put("exportType", isSelect ? "Select" : "Filter");
        params.put("exportModle", this.getExportModule());
        params.put("tmpltype", this.tplType());
        params.put("oprtype", "export");
        params.put("OprCategory", this.getOprCategory());
        params.put("isFillParent", String.valueOf(true));
        Map map = (Map)JSONObject.parseObject((String)((String)this.getParameter().get("parameter")), Map.class);
        StringBuilder opPlugins = new StringBuilder();
        if (map != null) {
            String pluginstr = (String)map.get("plugins");
            List plugins = (List)JSONObject.parseObject((String)pluginstr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            if (plugins != null && plugins.size() > 0) {
                for (Map p : plugins) {
                    if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                    opPlugins.append((String)p.get("ClassName")).append(",");
                }
            }
            params.put("opPlugins", opPlugins.toString());
        }
        params.put("listPlugins", view.getPageCache().get("listPlugins"));
    }

    private void checkPermission(OperationResult result) {
        if (this.isListView()) {
            List mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
            mainOrgIds.removeIf(Objects::isNull);
            if (mainOrgIds.isEmpty()) {
                this.doPermission(result, this.getPermissionItemId(), 0L);
            } else {
                this.doPermission(result, this.getPermissionItemId(), mainOrgIds);
            }
        } else {
            this.doPermission(result, this.getPermissionItemId(), this.mainOrgId != null ? this.mainOrgId : 0L);
        }
    }

    private void saveCacheForPermission(IPageCache pageCache) {
        String billFormId = null;
        String listName = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (this.isListView()) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            listName = config.getCaption().getLocaleValue();
            pageCache.put("BillTypeId", String.valueOf(((ListShowParameter)formShowParameter).getBillTypeId()));
        } else if (this.isBillView() || view instanceof FormView) {
            billFormId = view.getEntityId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().getLocaleValue() : "");
            pageCache.put("BillTypeId", String.valueOf(view.getEntityId()));
        }
        pageCache.put("ServiceAppId", formShowParameter.getServiceAppId());
        pageCache.put("CheckRightAppId", formShowParameter.getCheckRightAppId());
        pageCache.put("BillFormId", billFormId);
        pageCache.put("ListName", listName);
        pageCache.put("OperateKey", this.getOperateKey());
        pageCache.put("PermissionItemId", this.getPermissionItemId());
        pageCache.put("RealPermissionEntityId", this.getRealPermissionEntityId());
        ArrayList<Long> mainOrgIds = null;
        if (this.isListView()) {
            mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
        } else if (this.mainOrgId != null) {
            mainOrgIds = new ArrayList<Long>();
            mainOrgIds.add(this.mainOrgId);
        }
        if (mainOrgIds != null && !mainOrgIds.isEmpty()) {
            pageCache.put("MainOrgIds", JSONArray.toJSONString(mainOrgIds));
        }
        pageCache.put("OperateName", this.getOperateName().toString());
    }

    protected boolean isBillView() {
        return this.getView() instanceof IBillView;
    }

    private boolean isListView() {
        return this.getView() instanceof IListView;
    }

    private BillList getBillList() {
        return (BillList)this.getView().getControl("billlistap");
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        Object controller = closedcallbackevent.getSource();
        if (controller instanceof ListController) {
            ((IListView)((ListController)closedcallbackevent.getSource()).getView()).refresh();
        } else if (controller instanceof FormController) {
            ((FormController)controller).getView().updateView();
        }
    }

    public void initialize(Map<String, Object> opMeta) {
        String parameterString;
        Map jsonMap;
        super.initialize(opMeta);
        Map parameters = (Map)opMeta.get("parameter");
        if (parameters != null && !parameters.isEmpty() && (jsonMap = (Map)SerializationUtils.fromJsonString((String)(parameterString = (String)parameters.get("parameter")), Map.class)) != null && !jsonMap.isEmpty()) {
            this.opParameter.putAll(jsonMap);
        }
    }
}

