/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class HOMSMenuPlugin
implements IPortalAppMenuExtService {
    private static final Log LOG = LogFactory.getLog(HOMSMenuPlugin.class);
    private static String HOMS_APP_ID = "217WYC/L9U7E";
    private static final String OTHER_ORG_MENU_ID = "1802202898084539392";
    private static final String APP_KEY_HOMS = "homs";
    private static String HR_ORG_VIEW_TYPE = "21";
    private static final String HAOS_STRUCTPROJECTTAB = "haos_structprojecttab";
    private static final String HAOS_CUSTOMSTRUCTPROJECT = "haos_customstructproject";
    private static Set<String> NEW_CHART_NEED_HIDE_SET;
    private static Set<String> OLD_CHART_NEED_HIDE_SET;
    private static String[] BASE_META_PAGE;

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        try {
            Set<String> menuIdSet = appIdAndMenuIdMap.get(HOMS_APP_ID);
            if (CollectionUtils.isEmpty(menuIdSet)) {
                return null;
            }
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            result.put(HOMS_APP_ID, this.getHideMenu());
            return result;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    private Set<String> getHideMenu() {
        DynamicObject odcConfigParam = QueryServiceHelper.queryOne((String)"haos_odcconfigparam", (String)"value", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"isUseNewStructureChart"})});
        boolean isNew = odcConfigParam != null && "1".equals(odcConfigParam.getString("value"));
        Set<String> needHideSet = isNew ? NEW_CHART_NEED_HIDE_SET : OLD_CHART_NEED_HIDE_SET;
        List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)HOMS_APP_ID);
        Set<String> sets = appMenusInfoByAppId.stream().filter(appMenusInfo -> needHideSet.contains(appMenusInfo.getFormId())).map(AppMenuInfo::getId).collect(Collectors.toSet());
        Set<String> hideMenus = this.hideCusProject(appMenusInfoByAppId);
        if (hideMenus != null && hideMenus.size() > 0) {
            if (sets != null) {
                sets.addAll(hideMenus);
            } else {
                sets = hideMenus;
            }
        }
        return sets;
    }

    private Set<String> hideCusProject(List<AppMenuInfo> menuInfos) {
        HashSet<String> hideMenus = new HashSet<String>(16);
        HashSet<String> secMenus = new HashSet<String>();
        HashSet<String> endMenus = new HashSet<String>();
        HashMap<String, List> parentRelateMap = new HashMap<String, List>(16);
        for (AppMenuInfo appMenuInfo : menuInfos) {
            if (OTHER_ORG_MENU_ID.equals(appMenuInfo.getParentId())) {
                secMenus.add(appMenuInfo.getId());
                continue;
            }
            if (!HAOS_STRUCTPROJECTTAB.equals(appMenuInfo.getFormId())) continue;
            endMenus.add(appMenuInfo.getId());
            List childs = parentRelateMap.computeIfAbsent(appMenuInfo.getParentId(), val -> new ArrayList());
            childs.add(appMenuInfo.getId());
        }
        LOG.info("secMenus.size\uff1a{}", (Object)secMenus.size());
        if (secMenus.size() > 0) {
            Set typeIds = secMenus.stream().map(val -> Long.valueOf(val)).collect(Collectors.toSet());
            DynamicObjectCollection prefixs = QueryServiceHelper.query((String)"hbss_numberprefix", (String)"id,numberprefix", (QFilter[])new QFilter[]{new QFilter("id", "in", typeIds)});
            if (prefixs == null || prefixs.size() == 0) {
                LOG.warn("prefixs is null");
                return hideMenus;
            }
            HashMap<String, String> prefixMap = new HashMap<String, String>(prefixs.size());
            for (Object dy : prefixs) {
                String numberprefix = dy.getString("numberprefix");
                if (numberprefix == null || numberprefix.length() <= 0) continue;
                prefixMap.put(dy.getString("id"), numberprefix.toLowerCase(Locale.ROOT));
            }
            HashMap<String, List> dataPermMap = new HashMap<String, List>(secMenus.size());
            for (String secMenu : secMenus) {
                try {
                    String pref = (String)prefixMap.get(secMenu);
                    String metaPerm = null;
                    for (String meta : BASE_META_PAGE) {
                        meta = meta + "_" + pref;
                        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)APP_KEY_HOMS, (String)meta, (String)"47150e89000000ac")) continue;
                        metaPerm = meta;
                        break;
                    }
                    if (metaPerm == null) {
                        hideMenus.add(secMenu);
                        continue;
                    }
                    HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)HR_ORG_VIEW_TYPE, (String)APP_KEY_HOMS, metaPerm, (String)"47150e89000000ac", (boolean)true);
                    if (result.hasAllOrgPerm()) {
                        dataPermMap.put(secMenu, null);
                        continue;
                    }
                    List permOrgs = result.getHasPermOrgs();
                    if (permOrgs == null || permOrgs.size() == 0) {
                        hideMenus.add(secMenu);
                        continue;
                    }
                    dataPermMap.put(secMenu, permOrgs);
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
            }
            Set projectIds = endMenus.stream().map(val -> Long.valueOf(val)).collect(Collectors.toSet());
            DynamicObjectCollection projectDys = QueryServiceHelper.query((String)HAOS_CUSTOMSTRUCTPROJECT, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", projectIds)});
            if (projectDys == null || projectDys.size() == 0) {
                LOG.warn("projectDys is null");
                return hideMenus;
            }
            HashMap<String, Long> projectMap = new HashMap<String, Long>(prefixs.size());
            for (DynamicObject dy : projectDys) {
                projectMap.put(dy.getString("id"), dy.getLong("org"));
            }
            for (AppMenuInfo appMenuInfo : menuInfos) {
                Long org;
                String parentMenuId;
                List permOrgs;
                String menuId = appMenuInfo.getId();
                if (menuId == null || hideMenus.contains(menuId) || !HAOS_STRUCTPROJECTTAB.equals(appMenuInfo.getFormId()) || (permOrgs = (List)dataPermMap.get(parentMenuId = appMenuInfo.getParentId())) == null || permOrgs.contains(org = (Long)projectMap.get(menuId))) continue;
                hideMenus.add(menuId);
                String parentId = appMenuInfo.getParentId();
                List list = (List)parentRelateMap.get(parentId);
                if (list.size() == 1) {
                    hideMenus.add(parentId);
                    continue;
                }
                list.remove(menuId);
            }
        }
        if (secMenus.isEmpty() || hideMenus.containsAll(secMenus)) {
            hideMenus.add(OTHER_ORG_MENU_ID);
            LOG.info("hide secMenus:{}", secMenus);
        }
        LOG.info("customesPoject hideMenus:{}", hideMenus);
        return hideMenus;
    }

    static {
        OLD_CHART_NEED_HIDE_SET = new HashSet<String>(Arrays.asList("homs_cardstyle_new", "homs_orgchart_new"));
        NEW_CHART_NEED_HIDE_SET = new HashSet<String>(Arrays.asList("homs_cardstyle", "homs_adminorgchartwait"));
        BASE_META_PAGE = new String[]{"haos_cusempposorgrel", "haos_customorole", "haos_cusadminorgteam"};
    }
}

