/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.menu;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class HSBSAppMenuExtPlugin
implements IPortalAppMenuExtService {
    private static final Log logger = LogFactory.getLog(HSBSAppMenuExtPlugin.class);
    public static final String HSBS_APPID = "/UHLXNRR9KPZ";
    public static final Long WTC_INTE_ID = 1629883639565276160L;
    public static final Set<String> HIDE_MENU_ID_FOR_SCHEME_ONE = Sets.newHashSet((Object[])new String[]{"1499352555044498432"});
    public static final Set<String> HIDE_MENU_ID_FOR_SCHEME_TWO = Sets.newHashSet((Object[])new String[]{"1499352555044498432", "1947393900196945920"});
    public static final Set<String> HIDE_MENU_ID_FOR_SCHEME_THREE = Sets.newHashSet((Object[])new String[]{"1936369669376162816", "1947393900196945920"});
    public static final Set<String> HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE = new HashSet<String>(HIDE_MENU_ID_FOR_SCHEME_ONE.size() + HIDE_MENU_ID_FOR_SCHEME_TWO.size() + HIDE_MENU_ID_FOR_SCHEME_THREE.size());

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        HashMap hideAppMenuMap = Maps.newHashMapWithExpectedSize((int)HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE.size());
        if (appIdAndMenuIdMap == null || !appIdAndMenuIdMap.containsKey(HSBS_APPID)) {
            return hideAppMenuMap;
        }
        HashSet<String> hideMenuSet = new HashSet<String>(HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE.size());
        Set<String> hideMenuSetForWtcInteParam = this.getHideMenuByWtcInteParam();
        hideMenuSet.addAll(hideMenuSetForWtcInteParam);
        hideAppMenuMap.put(HSBS_APPID, hideMenuSet);
        return hideAppMenuMap;
    }

    public Set<String> getHideMenuByWtcInteParam() {
        Set<String> hideMenuSetForWtcInteParam;
        try {
            Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"IHSBSSalaryParameterService", (String)"getSalaryParam", (Object[])new Object[]{WTC_INTE_ID});
            if (paramMap == null || paramMap.size() == 0) {
                Set<String> hideMenuSetForWtcInteParam2 = HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE;
                return hideMenuSetForWtcInteParam2;
            }
            Boolean enableWtcInte = (Boolean)paramMap.get("enableWtcInte");
            if (!enableWtcInte.booleanValue()) {
                Set<String> hideMenuSetForWtcInteParam3 = HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE;
                return hideMenuSetForWtcInteParam3;
            }
            int attScheme = paramMap.getOrDefault("scheme", 3);
            hideMenuSetForWtcInteParam = attScheme == 3 ? HIDE_MENU_ID_FOR_SCHEME_THREE : (attScheme == 1 ? HIDE_MENU_ID_FOR_SCHEME_ONE : (attScheme == 2 ? HIDE_MENU_ID_FOR_SCHEME_TWO : HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE));
        }
        catch (Exception e) {
            logger.error("HSBSAppMenuExtPlugin hideMenuByWtcInteParam error:", (Throwable)e);
            hideMenuSetForWtcInteParam = HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE;
        }
        return hideMenuSetForWtcInteParam;
    }

    static {
        HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE.addAll(HIDE_MENU_ID_FOR_SCHEME_ONE);
        HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE.addAll(HIDE_MENU_ID_FOR_SCHEME_TWO);
        HIDE_MENU_ID_FOR_UNENABLE_WTC_INTE.addAll(HIDE_MENU_ID_FOR_SCHEME_THREE);
    }
}

