/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.plugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.ext.hr.metadata.prop.MulQueryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.MasterIdField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;
import kd.bos.metadata.entity.operation.OperationParameter;

public class HRImportParaEditPlugin
extends CustOpParameterPlugin {
    private static final String PLUGINS = "plugins";
    private static final String FIELD_MAIN_ENTITY_UNIQUE = "mainentityuniqueval";

    public void initialize() {
        this.addClickListeners(new String[]{PLUGINS});
    }

    public void afterCreateNewData(EventObject e) {
        Map parameter = (Map)this.getView().getFormShowParameter().getCustomParams().get("Parameter");
        if (StringUtils.isNotBlank((Object)parameter)) {
            IDataModel model = this.getModel();
            String parameter2 = parameter.get("Parameter") == null ? "[]" : parameter.get("Parameter").toString();
            Map map = (Map)JSONObject.parseObject((String)parameter2, Map.class);
            model.setValue(PLUGINS, map.get(PLUGINS));
            model.setValue("cusstartpage", map.get("cusstartpage"));
            model.setValue(FIELD_MAIN_ENTITY_UNIQUE, map.get(FIELD_MAIN_ENTITY_UNIQUE));
            this.resetMainEntityUQVal();
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "plugins": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("ide_plugins");
                Object plugins = this.getModel().getValue(PLUGINS);
                parameter.setCustomParam("value", plugins == null || StringUtils.isBlank((CharSequence)plugins.toString()) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)plugins.toString(), Map.class));
                parameter.setCustomParam("formId", this.getView().getFormShowParameter().getCustomParam("formId"));
                parameter.setCustomParam("showeventtab", (Object)Boolean.FALSE);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectServicePlugins"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectServicePlugins".equalsIgnoreCase(actionId)) {
            Map ret = (Map)evt.getReturnData();
            List plugins = (List)ret.get("value");
            this.getModel().setValue(PLUGINS, (Object)SerializationUtils.toJsonString((Object)plugins));
        }
    }

    public OperationParameter get() {
        CustOperationParameter parameter = new CustOperationParameter();
        String pluginsJSON = (String)this.getModel().getValue(PLUGINS);
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put(PLUGINS, pluginsJSON);
        map.put("cusstartpage", this.getModel().getValue("cusstartpage"));
        map.put(FIELD_MAIN_ENTITY_UNIQUE, this.getModel().getValue(FIELD_MAIN_ENTITY_UNIQUE));
        parameter.setParameter(JSONObject.toJSONString(map));
        return parameter;
    }

    private void resetMainEntityUQVal() {
        String entityNumber = this.getMainEntity().getKey();
        ComboEdit combo = (ComboEdit)this.getControl(FIELD_MAIN_ENTITY_UNIQUE);
        combo.setComboItems(Collections.emptyList());
        this.loadImportField4Combo(entityNumber, combo);
    }

    public void loadImportField4Combo(String billFormId, ComboEdit combo) {
        ArrayList keyFieldItems = Lists.newArrayListWithCapacity((int)16);
        AbstractMetadata readMeta = MetadataDao.readMeta((String)this.getMainEntity().getId(), (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isNotEmpty((CharSequence)readMeta.getMasterId())) {
            EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)readMeta.getMasterId(), (MetaCategory)MetaCategory.Entity);
            billFormId = metadata.getKey();
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        List<EntityItem<?>> newItems = entityItems.stream().filter(item -> {
            boolean valid = item instanceof Field;
            if (valid) {
                valid = HRImportParaEditPlugin.isValid((Field)item);
            }
            return valid;
        }).collect(Collectors.toList());
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (this.ignoreUniqueValField(prop) || !HRImportParaEditPlugin.isPropertyImport(newItems, prop)) continue;
            keyFieldItems.add(new ComboItem(prop.getDisplayName(), prop.getName()));
        }
        if (!keyFieldItems.isEmpty()) {
            HRImportParaEditPlugin.sortKeyFieldItems(keyFieldItems, entityType);
            combo.setComboItems((List)keyFieldItems);
        }
    }

    public static boolean isValid(Field field) {
        return StringUtils.isNotEmpty((CharSequence)field.getFieldName()) && field.getFeatures().isImportable() && !(field instanceof BillStatusField) && !(field instanceof CheckBoxField) && !(field instanceof RadioField) && !(field instanceof RadioGroupField) && !(field instanceof ModifierField) && !(field instanceof UserAvatarField) && !(field instanceof PrintCountField) && !(field instanceof PictureField) && !(field instanceof IconField) && !(field instanceof AttachmentCountField) && !(field instanceof AttachmentField) && !(field instanceof MasterIdField);
    }

    public static boolean isPropertyImport(List<EntityItem<?>> newItems, IDataEntityProperty prop) {
        EntityItem<?> entityItem;
        Iterator<EntityItem<?>> var2 = newItems.iterator();
        do {
            DateRangeField field;
            if (!var2.hasNext()) {
                return false;
            }
            entityItem = var2.next();
            if (!(entityItem instanceof DateRangeField) || !StringUtils.equals((CharSequence)(field = (DateRangeField)entityItem).getStartDateFieldKey(), (CharSequence)prop.getName()) && !StringUtils.equals((CharSequence)field.getEndDateFieldKey(), (CharSequence)prop.getName())) continue;
            return true;
        } while (!StringUtils.equals((CharSequence)prop.getName(), (CharSequence)entityItem.getKey()));
        return true;
    }

    private static void sortKeyFieldItems(List<ComboItem> keyFieldItems, MainEntityType entityType) {
        String orgKey = "";
        if (entityType != null && entityType.getMainOrg() != null) {
            orgKey = entityType.getMainOrg();
        }
        int orgIndex = 0;
        int billNoIndex = 0;
        boolean hasOrg = false;
        boolean hasBillNo = false;
        for (int i = 0; i < keyFieldItems.size(); ++i) {
            ComboItem comboItem = keyFieldItems.get(i);
            if (StringUtils.isNotEmpty((CharSequence)orgKey) && StringUtils.equals((CharSequence)orgKey, (CharSequence)comboItem.getValue())) {
                orgIndex = i;
                hasOrg = true;
                continue;
            }
            if (!StringUtils.equals((CharSequence)"billno", (CharSequence)comboItem.getValue())) continue;
            billNoIndex = i;
            hasBillNo = true;
        }
        if (hasOrg) {
            keyFieldItems.add(1, keyFieldItems.get(orgIndex));
            keyFieldItems.remove(orgIndex + 1);
        }
        if (hasBillNo) {
            keyFieldItems.add(hasOrg ? 2 : 1, keyFieldItems.get(billNoIndex));
            keyFieldItems.remove(billNoIndex + 1);
        }
    }

    private boolean ignoreUniqueValField(IDataEntityProperty prop) {
        if (prop instanceof BigIntProp || prop instanceof IntegerProp || prop instanceof DateProp) {
            return false;
        }
        return prop instanceof MulBasedataProp || prop instanceof MulQueryProp || prop instanceof MulComboProp || prop instanceof BigDecimal || prop instanceof DecimalProp || prop instanceof TimeProp || prop instanceof DateTimeProp || prop instanceof ItemClassProp || prop instanceof ItemClassTypeProp || prop instanceof AdminDivisionProp || prop instanceof RefBillProp;
    }
}

