/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.lang.Lang;

public class OptUtils {
    private static Map<String, Map<String, List<Map<String, String>>>> optMap = Maps.newConcurrentMap();

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMapNoCache() {
        HashMap comparisonOperatorsMap = Maps.newHashMapWithExpectedSize((int)16);
        comparisonOperatorsMap.put(ParamTypeEnum.DATE.getValue(), OptUtils.getDateComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.NUMBER.getValue(), OptUtils.getNumberComparisonOperators());
        comparisonOperatorsMap.put(ParamTypeEnum.DYNAMICOBJECT.getValue(), OptUtils.getObjectComparisonOperators());
        return comparisonOperatorsMap;
    }

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMap() {
        Map<String, List<Map<String, String>>> comparisonOperatorsMap = optMap.get(Lang.get().getLangTag());
        if (null != comparisonOperatorsMap) {
            return comparisonOperatorsMap;
        }
        comparisonOperatorsMap = OptUtils.getComparisonOperatorsMapNoCache();
        optMap.put(Lang.get().getLangTag(), comparisonOperatorsMap);
        return comparisonOperatorsMap;
    }

    public static List<Map<String, String>> getDateComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)32);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_OR_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_OR_EQUALS_TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_OR_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_OR_EQUALS_TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.YESTERDAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.TOMORROW.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_WEEK.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_WEEK.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_WEEK.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST1MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST3MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT1MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT3MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_QUARTER.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_QUARTER.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_QUARTER.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_YEAR.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_YEAR.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_YEAR.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST3DAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST7DAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST15DAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST60DAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_MONTH_TO_DAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_YEAR_TO_DAY.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getObjectComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.CONTAINS.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_CONTAINS.getOperatorMap());
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getNumberComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_OR_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_OR_EQUAL.getOperatorMap());
        return paramList;
    }

    static {
        optMap.put(Lang.get().getLangTag(), OptUtils.getComparisonOperatorsMapNoCache());
    }
}

