/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.helper.RuleEngineHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;

public class ParamsUtil {
    private static final Log LOGGER = LogFactory.getLog(ParamsUtil.class);
    private static final String ID = "id";
    private static final String TEXT = "text";
    private static final String CHILDREN = "children";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String LEVEL = "level";
    private static final String TYPE = "type";
    private static final String TYPE_DETAIL = "typeDetail";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String CATEGORY = "category";
    private static final String CATEGORY_ADMINORG = "adminOrg";
    private static final String ENUM_LIST = "enumList";
    private static final String PARAM_MULTIPLE = "multiple";
    private static final String MULTIPLE_TRUE = "1";
    private static final String INPUTOBJECT = "inputobject";
    private static final String INPUT_PARAMNUMBER = "inputnumber";
    private static final String INPUT_NAME = "inputname";
    private static final String INPUT_PARAMSTYPE = "inputparamstype";
    private static final String INPUT_COMBO = "inputcombo";
    private static final String INPUT_MULTIPLE = "inputmultiple";
    private static final String INPUT_DATE_FORMAT = "inputdateformat";
    private static final String INPUT_DYN_PROP = "inputdynprop";
    private static final String OUTPUTOBJECT = "outputobject";
    private static final String OUTPUT_PARAMSTYPE = "outputparamstype";
    private static final String OUTPUT_NAME = "outputname";
    private static final String OUTPUT_PARAMNUMBER = "outputnumber";
    private static final String OUTPUT_COMBO = "outputcombo";
    private static final String OUTPUT_MULTIPLE = "outputmultiple";
    private static final String OUTPUT_DATE_FORMAT = "outputdateformat";
    private static final String OUTPUT_DYN_PROP = "outputdynprop";

    private ParamsUtil() {
    }

    public static List<Map<String, String>> getInputParam(Long sceneId) {
        DynamicObjectCollection inputParams = RuleEngineHelper.getInputParams(sceneId);
        return ParamsUtil.getParamIdList(inputParams, INPUT_PARAMSTYPE, INPUTOBJECT, INPUT_NAME, INPUT_PARAMNUMBER, INPUT_COMBO, INPUT_MULTIPLE, INPUT_DATE_FORMAT, INPUT_DYN_PROP);
    }

    public static List<Map<String, String>> getOutputParam(Long sceneId) {
        DynamicObjectCollection outputParams = RuleEngineHelper.getOutputParams(sceneId);
        return ParamsUtil.getParamIdList(outputParams, OUTPUT_PARAMSTYPE, OUTPUTOBJECT, OUTPUT_NAME, OUTPUT_PARAMNUMBER, OUTPUT_COMBO, OUTPUT_MULTIPLE, OUTPUT_DATE_FORMAT, OUTPUT_DYN_PROP);
    }

    public static List<Map<String, String>> getParamIdList(DynamicObjectCollection params, String paramsType, String object, String name, String number, String combo, String multiple, String dateFormat, String dynProp) {
        ArrayList rootList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList baseFiledList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList baseDataList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject obj : params) {
            if (ParamTypeEnum.DYNAMICOBJECT.getValue().equals(obj.getString(paramsType))) {
                if (null == obj.get(object)) {
                    throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"ParamsUtil_0", (String)"bos-ext-hr", (Object[])new Object[0]), obj.get(number)));
                }
                String entityNumber = ((DynamicObject)obj.get(object)).get(NUMBER).toString();
                MainEntityType mainEntityType = ParamsUtil.getDataEntityType(entityNumber);
                if (mainEntityType == null) continue;
                HashMap rootMap = Maps.newHashMapWithExpectedSize((int)2);
                rootMap.put(TEXT, obj.getString(name));
                rootMap.put(CHILDREN, SerializationUtils.toJsonString(ParamsUtil.initParamAndType(mainEntityType, obj.getString(name), obj.getString(number), obj.getString(dynProp))));
                rootMap.put(LEVEL, MULTIPLE_TRUE);
                dynamicObjectList.add(rootMap);
                continue;
            }
            if (ParamTypeEnum.BASEDATA.getValue().equals(obj.getString(paramsType))) {
                baseDataList.add(ParamsUtil.getBaseDataMap(obj, object, name, number, multiple));
                continue;
            }
            if (ParamTypeEnum.ENUM.getValue().equals(obj.getString(paramsType))) {
                baseFiledList.add(ParamsUtil.getEnumMap(obj, name, number, combo, multiple));
                continue;
            }
            baseFiledList.add(ParamsUtil.getParamMap(obj, paramsType, name, number, dateFormat));
        }
        if (!baseFiledList.isEmpty()) {
            rootList.add(ParamsUtil.getBaseFieldMap(baseFiledList));
        }
        if (!baseDataList.isEmpty()) {
            rootList.add(ParamsUtil.getBaseDataMap(baseDataList));
        }
        if (!dynamicObjectList.isEmpty()) {
            rootList.addAll(dynamicObjectList);
        }
        return rootList;
    }

    public static List<Map<String, String>> getInputParamData(Long sceneId) {
        DynamicObjectCollection inputParams = RuleEngineHelper.getInputParams(sceneId);
        return ParamsUtil.getParamNumberList(inputParams, INPUT_PARAMSTYPE, INPUTOBJECT, INPUT_NAME, INPUT_PARAMNUMBER, INPUT_COMBO, INPUT_MULTIPLE, INPUT_DATE_FORMAT, INPUT_DYN_PROP);
    }

    public static List<Map<String, String>> getOutputParamData(Long sceneId) {
        DynamicObjectCollection outputParams = RuleEngineHelper.getOutputParams(sceneId);
        return ParamsUtil.getParamNumberList(outputParams, OUTPUT_PARAMSTYPE, OUTPUTOBJECT, OUTPUT_NAME, OUTPUT_PARAMNUMBER, OUTPUT_COMBO, OUTPUT_MULTIPLE, OUTPUT_DATE_FORMAT, OUTPUT_DYN_PROP);
    }

    public static List<Map<String, String>> getParamNumberList(DynamicObjectCollection params, String paramsType, String object, String name, String number, String combo, String multiple, String dateFormat, String dynProp) {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject param : params) {
            if (ParamTypeEnum.DYNAMICOBJECT.getValue().equals(param.getString(paramsType))) {
                String entityNumber = ((DynamicObject)param.get(object)).get(NUMBER).toString();
                MainEntityType mainEntityType = ParamsUtil.getDataEntityType(entityNumber);
                if (mainEntityType == null) continue;
                paramList.addAll(ParamsUtil.initParamAndType(mainEntityType, param.getString(name), param.getString(number), param.getString(dynProp)));
                continue;
            }
            if (ParamTypeEnum.BASEDATA.getValue().equals(param.getString(paramsType))) {
                paramList.add(ParamsUtil.getBaseDataMap(param, object, name, number, multiple));
                continue;
            }
            if (ParamTypeEnum.ENUM.getValue().equals(param.getString(paramsType))) {
                paramList.add(ParamsUtil.getEnumMap(param, name, number, combo, multiple));
                continue;
            }
            paramList.add(ParamsUtil.getParamMap(param, paramsType, name, number, dateFormat));
        }
        return paramList;
    }

    private static Map<String, String> getParamMap(DynamicObject param, String paramsType, String name, String number, String dateFormat) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
        paramMap.put(ID, param.getString(number));
        paramMap.put(NUMBER, param.getString(number));
        paramMap.put(TEXT, param.getString(name));
        paramMap.put(NAME, param.getString(name));
        paramMap.put(TYPE, param.getString(paramsType));
        paramMap.put(TYPE_DETAIL, param.getString(paramsType));
        paramMap.put(DATE_FORMAT, param.getString(dateFormat));
        paramMap.put(LEVEL, "2");
        return paramMap;
    }

    private static Map<String, String> getEnumMap(DynamicObject param, String name, String number, String combo, String multiple) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
        paramMap.put(ID, param.getString(number));
        paramMap.put(NUMBER, param.getString(number));
        paramMap.put(TEXT, param.getString(name));
        paramMap.put(NAME, param.getString(name));
        paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
        paramMap.put(TYPE_DETAIL, ParamTypeEnum.ENUM.getValue());
        paramMap.put(ENUM_LIST, param.getString(combo));
        paramMap.put(LEVEL, "2");
        String multipleValue = param.getString(multiple);
        if (StringUtils.isNotEmpty((CharSequence)multipleValue)) {
            paramMap.put(PARAM_MULTIPLE, multipleValue);
            paramMap.put(TYPE_DETAIL, ParamsUtil.isMultiple(multipleValue) ? ParamTypeEnum.MUL_ENUM.getValue() : ParamTypeEnum.ENUM.getValue());
        }
        return paramMap;
    }

    private static Map<String, String> getBaseDataMap(DynamicObject param, String object, String name, String number, String multiple) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        if (null == param.get(object)) {
            return paramMap;
        }
        String entityNumber = ((DynamicObject)param.get(object)).get(NUMBER).toString();
        String category = ParamsUtil.getCategory(entityNumber);
        paramMap.put(ID, param.getString(number) + "." + entityNumber + ".id");
        paramMap.put(NUMBER, param.getString(number) + "." + entityNumber + ".id");
        paramMap.put(NAME, param.getString(name));
        paramMap.put(TEXT, param.getString(name));
        paramMap.put(TYPE, ParamTypeEnum.DYNAMICOBJECT.getValue());
        paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.ADMINORG.getValue() : ParamTypeEnum.DYNAMICOBJECT.getValue());
        paramMap.put(ENTITY_NUMBER, entityNumber);
        paramMap.put(CATEGORY, category);
        paramMap.put(LEVEL, "2");
        String multipleValue = param.getString(multiple);
        if (StringUtils.isNotEmpty((CharSequence)multipleValue)) {
            paramMap.put(PARAM_MULTIPLE, multipleValue);
            if (ParamsUtil.isMultiple(multipleValue)) {
                paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.MUL_ADMINORG.getValue() : ParamTypeEnum.MUL_DYNAMICOBJECT.getValue());
            }
        }
        return paramMap;
    }

    private static boolean isMultiple(String multiple) {
        return MULTIPLE_TRUE.equals(multiple);
    }

    private static MainEntityType getDataEntityType(String entityNumber) {
        try {
            return EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception e) {
            LOGGER.error("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private static List<Map<String, String>> initParamAndType(MainEntityType mainEntityType, String name, String number, String dynProp) {
        return ParamsUtil.initParamAndType(mainEntityType, name, number, dynProp, null);
    }

    private static List<Map<String, String>> initParamAndType(MainEntityType mainEntityType, String name, String number, String dynProp, DynamicProperty parentProp) {
        HashMap dateFormatMap = Maps.newHashMapWithExpectedSize((int)16);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        for (ControlAp control : formMeta.getItems()) {
            String mask;
            if (!(control instanceof FieldAp) || !StringUtils.isNotEmpty((CharSequence)(mask = ((FieldAp)control).getMask()))) continue;
            dateFormatMap.put(control.getKey(), mask.replaceAll("Y", "y").replaceAll("D", "d"));
        }
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        if (null != parentProp) {
            ParamsUtil.initParamType(mainEntityType, name, number + ".id", paramList, dynProp, dateFormatMap, parentProp);
        }
        for (String key : mainEntityType.getAllFields().keySet()) {
            ParamsUtil.initParamType(mainEntityType, name, number + "." + mainEntityType.getName() + "." + key, paramList, dynProp, dateFormatMap, parentProp);
        }
        return paramList;
    }

    private static String getPropertyName(DynamicProperty property, String field, String name) {
        String fName = "";
        if (null != property.getDisplayName()) {
            fName = property.getDisplayName().getLocaleValue();
        } else if (property instanceof JoinProperty) {
            fName = ((JoinProperty)property).getDynamicComplexPropertyType().getDisplayName().getLocaleValue();
        }
        if (ID.equals(field)) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return StringUtils.isEmpty((CharSequence)fName) ? field : fName;
    }

    private static boolean isConfigProp(DynamicProperty property, String dynProp, String key, Map<String, Object> resultMap) {
        if (StringUtils.isEmpty((CharSequence)dynProp)) {
            return true;
        }
        boolean queryChildren = false;
        String displayName = "";
        List dynPropList = SerializationUtils.fromJsonStringToList((String)dynProp, Map.class);
        List dynPropNumberList = dynPropList.stream().map(map -> (String)map.get("Name")).collect(Collectors.toList());
        String[] keys = key.split("\\.");
        int keyLv = keys.length;
        if (keyLv > 5) {
            return false;
        }
        if (keyLv > 3) {
            String propNumber = keys[2] + "." + keys[keyLv - 1];
            if (!dynPropNumberList.contains(propNumber)) {
                return false;
            }
        } else {
            if (property instanceof BasedataProp) {
                queryChildren = dynPropNumberList.stream().anyMatch(str -> str.startsWith(property.getName() + "."));
                if (!dynPropNumberList.contains(property.getName()) && !queryChildren) {
                    return false;
                }
            } else if (!dynPropNumberList.contains(property.getName())) {
                return false;
            }
            for (Map dynPropMap : dynPropList) {
                if (!property.getName().equals(dynPropMap.get("Name")) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)dynPropMap.get("fDName")))) continue;
                displayName = (String)dynPropMap.get("fDName");
                try {
                    displayName = LocaleString.fromMap((Map)((Map)SerializationUtils.fromJsonString((String)displayName, Map.class))).getLocaleValue();
                }
                catch (Exception exception) {}
            }
        }
        resultMap.put("queryChildren", queryChildren);
        resultMap.put("displayName", displayName);
        return true;
    }

    private static String getText(String displayName, DynamicProperty property, String field, String name) {
        String fName = ParamsUtil.getPropertyName(property, field, name);
        return StringUtils.isNotEmpty((CharSequence)displayName) ? displayName : fName;
    }

    private static String getName(String displayName, DynamicProperty property, String field, String name) {
        String fName = ParamsUtil.getPropertyName(property, field, name);
        return StringUtils.isNotEmpty((CharSequence)displayName) ? displayName : name + "." + fName;
    }

    private static void initParamType(MainEntityType mainEntityType, String name, String key, List<Map<String, String>> paramList, String dynProp, Map<String, String> dateFormatMap, DynamicProperty parentProp) {
        String field = key.substring(key.lastIndexOf(46) + 1);
        DynamicProperty property = mainEntityType.getProperty(field);
        if (null == property) {
            return;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!ParamsUtil.isConfigProp(property, dynProp, key, resultMap)) {
            return;
        }
        boolean queryChildren = (Boolean)resultMap.getOrDefault("queryChildren", false);
        String displayName = (String)resultMap.getOrDefault("displayName", "");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
        paramMap.put(ID, key);
        paramMap.put(NUMBER, key);
        paramMap.put(LEVEL, "3");
        String text = ParamsUtil.getText(displayName, property, field, name);
        name = ParamsUtil.getName(displayName, property, field, name);
        paramMap.put(TEXT, text);
        paramMap.put(NAME, name);
        String type = property.getPropertyType().getTypeName();
        if (ID.equals(field)) {
            String entityNumber = ParamsUtil.getEntityNumber(parentProp);
            String category = ParamsUtil.getCategory(entityNumber);
            paramMap.put(ID, key);
            paramMap.put(NUMBER, key);
            paramMap.put(TYPE, ParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.ADMINORG.getValue() : ParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put(ENTITY_NUMBER, entityNumber);
            paramMap.put(CATEGORY, category);
            if (parentProp instanceof MulBasedataProp) {
                paramMap.put(PARAM_MULTIPLE, MULTIPLE_TRUE);
                paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.MUL_ADMINORG.getValue() : ParamTypeEnum.MUL_DYNAMICOBJECT.getValue());
            }
        } else if ("java.lang.String".equals(type) || "java.lang.Byte".equals(type) || "java.lang.Character".equals(type) || "kd.bos.dataentity.entity.ILocaleString".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.STRING.getValue());
            ParamsUtil.setEnumList(property, paramMap);
        } else if ("java.util.Date".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.DATE.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.DATE.getValue());
            if (StringUtils.isNotEmpty((CharSequence)dateFormatMap.get(property.getName()))) {
                paramMap.put(DATE_FORMAT, dateFormatMap.get(property.getName()));
            }
        } else if ("java.lang.Short".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Long".equals(type) || "java.lang.Float".equals(type) || "java.lang.Double".equals(type) || "java.math.BigDecimal".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.NUMBER.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.NUMBER.getValue());
        } else if ("java.util.Boolean".equals(type) || "boolean".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.BOOLEAN.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.BOOLEAN.getValue());
            paramMap.put(ENUM_LIST, SerializationUtils.toJsonString(ParamsUtil.getBoolean()));
        } else if ("kd.bos.dataentity.entity.DynamicObject".equals(type)) {
            String entityNumber = ParamsUtil.getEntityNumber(property);
            if (queryChildren) {
                MainEntityType childMainEntityType = ParamsUtil.getDataEntityType(entityNumber);
                if (childMainEntityType == null) {
                    return;
                }
                paramMap.put(LEVEL, "2");
                paramMap.put(CHILDREN, SerializationUtils.toJsonString(ParamsUtil.initParamAndType(childMainEntityType, name, key, dynProp, property)));
                paramMap.remove(ID);
            } else {
                String category = ParamsUtil.getCategory(entityNumber);
                paramMap.put(ID, key + ".id");
                paramMap.put(NUMBER, key + ".id");
                paramMap.put(TYPE, ParamTypeEnum.DYNAMICOBJECT.getValue());
                paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.ADMINORG.getValue() : ParamTypeEnum.DYNAMICOBJECT.getValue());
                paramMap.put(ENTITY_NUMBER, entityNumber);
                paramMap.put(CATEGORY, category);
                if (property instanceof MulBasedataProp) {
                    paramMap.put(PARAM_MULTIPLE, MULTIPLE_TRUE);
                    paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.MUL_ADMINORG.getValue() : ParamTypeEnum.MUL_DYNAMICOBJECT.getValue());
                }
            }
        } else {
            paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.STRING.getValue());
        }
        paramList.add(paramMap);
    }

    public static boolean isAdminOrg(String entityNumber) {
        return "haos_adminorghr".equals(entityNumber);
    }

    private static boolean isPerson(String entityNumber) {
        return "hsas_personhr".equals(entityNumber) || "bos_user".equals(entityNumber);
    }

    private static String getCategory(String entityNumber) {
        if (ParamsUtil.isAdminOrg(entityNumber)) {
            return CATEGORY_ADMINORG;
        }
        if (ParamsUtil.isPerson(entityNumber)) {
            return "person";
        }
        return "";
    }

    private static String getEntityNumber(Object property) {
        String entityNumber = "";
        if (property instanceof BasedataProp) {
            entityNumber = ((BasedataProp)property).getBaseEntityId();
        } else if (property instanceof MulBasedataProp) {
            entityNumber = ((MulBasedataProp)property).getBaseEntityId();
        } else if (property instanceof String) {
            entityNumber = (String)property;
        }
        return entityNumber;
    }

    private static List<Map<String, Object>> getBoolean() {
        ArrayList booleanList = Lists.newArrayListWithExpectedSize((int)2);
        HashMap trueMap = Maps.newHashMapWithExpectedSize((int)2);
        LocaleString trueString = new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"ParamsUtil_1", (String)"bos-ext-hr", (Object[])new Object[0]));
        trueMap.put(NAME, trueString);
        trueMap.put("value", Boolean.TRUE);
        booleanList.add(trueMap);
        HashMap falseMap = Maps.newHashMapWithExpectedSize((int)2);
        LocaleString falseString = new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"ParamsUtil_2", (String)"bos-ext-hr", (Object[])new Object[0]));
        falseMap.put(NAME, falseString);
        falseMap.put("value", Boolean.FALSE);
        booleanList.add(falseMap);
        return booleanList;
    }

    public static Map<String, List<Map<String, String>>> getInputValueParamMap(Long sceneId) {
        DynamicObjectCollection inputParams = RuleEngineHelper.getInputParams(sceneId);
        return ParamsUtil.getParamIdMap(inputParams);
    }

    private static Map<String, List<Map<String, String>>> getParamIdMap(DynamicObjectCollection params) {
        List typeList;
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)100);
        HashMap dynamicObjectMap = Maps.newHashMapWithExpectedSize((int)100);
        HashMap baseObjectParamMap = Maps.newHashMapWithExpectedSize((int)100);
        HashMap baseDataParamMap = Maps.newHashMapWithExpectedSize((int)100);
        for (DynamicObject obj : params) {
            List typeList2;
            String type = obj.getString(INPUT_PARAMSTYPE);
            if (ParamTypeEnum.DYNAMICOBJECT.getValue().equals(type)) {
                HashMap dynamicObjectParamMap = Maps.newHashMapWithExpectedSize((int)100);
                String entityNumber = ((DynamicObject)obj.get(INPUTOBJECT)).get(NUMBER).toString();
                MainEntityType mainEntityType = ParamsUtil.getDataEntityType(entityNumber);
                if (mainEntityType == null) continue;
                ParamsUtil.initParamAndTypeMap(mainEntityType, obj.getString(INPUT_NAME), obj.getString(INPUT_PARAMNUMBER), dynamicObjectParamMap, obj.getString(INPUT_DYN_PROP), null);
                for (String key : dynamicObjectParamMap.keySet()) {
                    HashMap rootMap = Maps.newHashMapWithExpectedSize((int)2);
                    rootMap.put(TEXT, obj.getString(INPUT_NAME));
                    rootMap.put(CHILDREN, SerializationUtils.toJsonString(dynamicObjectParamMap.get(key)));
                    List typeList3 = dynamicObjectMap.getOrDefault(key, Lists.newArrayListWithCapacity((int)100));
                    typeList3.add(rootMap);
                    dynamicObjectMap.put(key, typeList3);
                }
                continue;
            }
            if (ParamTypeEnum.BASEDATA.getValue().equals(type)) {
                Map<String, String> paramMap2 = ParamsUtil.getBaseDataMap(obj, INPUTOBJECT, INPUT_NAME, INPUT_PARAMNUMBER, INPUT_MULTIPLE);
                String typeKey = paramMap2.get(TYPE_DETAIL) + "_" + paramMap2.get(ENTITY_NUMBER);
                typeList2 = baseDataParamMap.getOrDefault(typeKey, Lists.newArrayListWithCapacity((int)100));
                typeList2.add(paramMap2);
                baseDataParamMap.put(typeKey, typeList2);
                if (ParamsUtil.isMultiple(obj.getString(INPUT_MULTIPLE))) continue;
                typeKey = "mul_" + typeKey;
                typeList2 = baseDataParamMap.getOrDefault(typeKey, Lists.newArrayListWithCapacity((int)100));
                typeList2.add(paramMap2);
                baseDataParamMap.put(typeKey, typeList2);
                continue;
            }
            if (ParamTypeEnum.ENUM.getValue().equals(type)) {
                String typeDetail = ParamsUtil.isMultiple(obj.getString(INPUT_MULTIPLE)) ? ParamTypeEnum.MUL_ENUM.getValue() : ParamTypeEnum.ENUM.getValue();
                HashMap map = Maps.newHashMapWithExpectedSize((int)5);
                map.put(ID, obj.getString(INPUT_PARAMNUMBER));
                map.put(NUMBER, obj.getString(INPUT_PARAMNUMBER));
                map.put(TEXT, obj.getString(INPUT_NAME));
                map.put(NAME, obj.getString(INPUT_NAME));
                map.put(TYPE, ParamTypeEnum.STRING.getValue());
                map.put(TYPE_DETAIL, typeDetail);
                typeList2 = baseObjectParamMap.getOrDefault(typeDetail, Lists.newArrayListWithCapacity((int)100));
                typeList2.add(map);
                baseObjectParamMap.put(typeDetail, typeList2);
                if (!ParamTypeEnum.ENUM.getValue().equals(typeDetail)) continue;
                typeDetail = "mul_" + typeDetail;
                typeList2 = baseObjectParamMap.getOrDefault(typeDetail, Lists.newArrayListWithCapacity((int)100));
                typeList2.add(map);
                baseObjectParamMap.put(typeDetail, typeList2);
                continue;
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)5);
            map.put(ID, obj.getString(INPUT_PARAMNUMBER));
            map.put(NUMBER, obj.getString(INPUT_PARAMNUMBER));
            map.put(TEXT, obj.getString(INPUT_NAME));
            map.put(NAME, obj.getString(INPUT_NAME));
            map.put(TYPE, type);
            map.put(TYPE_DETAIL, type);
            map.put(DATE_FORMAT, obj.getString(INPUT_DATE_FORMAT));
            List typeList4 = baseObjectParamMap.getOrDefault(type, Lists.newArrayListWithCapacity((int)100));
            typeList4.add(map);
            baseObjectParamMap.put(type, typeList4);
        }
        if (!baseObjectParamMap.isEmpty()) {
            for (String key : baseObjectParamMap.keySet()) {
                typeList = paramMap.getOrDefault(key, Lists.newArrayListWithCapacity((int)100));
                typeList.add(ParamsUtil.getBaseFieldMap((List)baseObjectParamMap.get(key)));
                paramMap.put(key, typeList);
            }
        }
        if (!baseDataParamMap.isEmpty()) {
            for (String key : baseDataParamMap.keySet()) {
                typeList = paramMap.getOrDefault(key, Lists.newArrayListWithCapacity((int)100));
                typeList.add(ParamsUtil.getBaseDataMap((List)baseDataParamMap.get(key)));
                paramMap.put(key, typeList);
            }
        }
        if (!dynamicObjectMap.isEmpty()) {
            for (String key : dynamicObjectMap.keySet()) {
                typeList = paramMap.getOrDefault(key, Lists.newArrayListWithCapacity((int)100));
                typeList.addAll((Collection)dynamicObjectMap.get(key));
                paramMap.put(key, typeList);
            }
        }
        return paramMap;
    }

    private static Map<String, String> getBaseFieldMap(List<Map<String, String>> childRen) {
        HashMap baseFieldMap = Maps.newHashMapWithExpectedSize((int)2);
        baseFieldMap.put(TEXT, ResManager.loadKDString((String)"\u57fa\u672c\u5c5e\u6027", (String)"ParamsUtil_3", (String)"bos-ext-hr", (Object[])new Object[0]));
        baseFieldMap.put(CHILDREN, SerializationUtils.toJsonString(childRen));
        baseFieldMap.put(LEVEL, MULTIPLE_TRUE);
        return baseFieldMap;
    }

    private static Map<String, String> getBaseDataMap(List<Map<String, String>> childRen) {
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)2);
        baseDataMap.put(TEXT, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ParamsUtil_4", (String)"bos-ext-hr", (Object[])new Object[0]));
        baseDataMap.put(CHILDREN, SerializationUtils.toJsonString(childRen));
        baseDataMap.put(LEVEL, MULTIPLE_TRUE);
        return baseDataMap;
    }

    private static void initParamAndTypeMap(MainEntityType mainEntityType, String name, String number, Map<String, List<Map<String, String>>> paramMap, String dynProp, DynamicProperty parentProp) {
        ParamsUtil.initParamTypeMap(mainEntityType, name, number + ".id", paramMap, dynProp, parentProp);
        for (String key : mainEntityType.getAllFields().keySet()) {
            ParamsUtil.initParamTypeMap(mainEntityType, name, number + "." + mainEntityType.getName() + "." + key, paramMap, dynProp, parentProp);
        }
    }

    private static void initParamTypeMap(MainEntityType mainEntityType, String name, String key, Map<String, List<Map<String, String>>> paramMap2, String dynProp, DynamicProperty parentProp) {
        String category;
        String entityNumber;
        String field = key.substring(key.lastIndexOf(46) + 1);
        DynamicProperty property = mainEntityType.getProperty(field);
        if (null == property) {
            return;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!ParamsUtil.isConfigProp(property, dynProp, key, resultMap)) {
            return;
        }
        boolean queryChildren = (Boolean)resultMap.getOrDefault("queryChildren", false);
        String displayName = (String)resultMap.getOrDefault("displayName", "");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        paramMap.put(ID, key);
        paramMap.put(NUMBER, key);
        String text = ParamsUtil.getText(displayName, property, field, name);
        name = ParamsUtil.getName(displayName, property, field, name);
        paramMap.put(TEXT, text);
        paramMap.put(NAME, name);
        String type = property.getPropertyType().getTypeName();
        if (ID.equals(field)) {
            entityNumber = ParamsUtil.getEntityNumber(parentProp);
            category = ParamsUtil.getCategory(entityNumber);
            paramMap.put(ID, key);
            paramMap.put(NUMBER, key);
            paramMap.put(TYPE, ParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.ADMINORG.getValue() : ParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put(ENTITY_NUMBER, entityNumber);
            paramMap.put(CATEGORY, category);
            if (parentProp instanceof MulBasedataProp) {
                paramMap.put(PARAM_MULTIPLE, MULTIPLE_TRUE);
                paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.MUL_ADMINORG.getValue() : ParamTypeEnum.MUL_DYNAMICOBJECT.getValue());
            }
        } else if ("java.lang.String".equals(type) || "java.lang.Byte".equals(type) || "java.lang.Character".equals(type) || "kd.bos.dataentity.entity.ILocaleString".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.STRING.getValue());
            ParamsUtil.setEnumList(property, paramMap);
        } else if ("java.util.Date".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.DATE.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.DATE.getValue());
        } else if ("java.lang.Short".equals(type) || "java.lang.Integer".equals(type) || "java.lang.Long".equals(type) || "java.lang.Float".equals(type) || "java.lang.Double".equals(type) || "java.math.BigDecimal".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.NUMBER.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.NUMBER.getValue());
        } else if ("java.util.Boolean".equals(type) || "boolean".equals(type)) {
            paramMap.put(TYPE, ParamTypeEnum.BOOLEAN.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.BOOLEAN.getValue());
            paramMap.put(ENUM_LIST, SerializationUtils.toJsonString(ParamsUtil.getBoolean()));
        } else if ("kd.bos.dataentity.entity.DynamicObject".equals(type)) {
            entityNumber = ParamsUtil.getEntityNumber(property);
            if (queryChildren) {
                MainEntityType childMainEntityType = ParamsUtil.getDataEntityType(entityNumber);
                if (childMainEntityType == null) {
                    return;
                }
                ParamsUtil.initParamAndTypeMap(childMainEntityType, name, key, paramMap2, dynProp, property);
                return;
            }
            category = ParamsUtil.getCategory(entityNumber);
            paramMap.put(ID, key + ".id");
            paramMap.put(NUMBER, key + ".id");
            paramMap.put(TYPE, ParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.ADMINORG.getValue() : ParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put(ENTITY_NUMBER, entityNumber);
            paramMap.put(CATEGORY, category);
            if (property instanceof MulBasedataProp) {
                paramMap.put(PARAM_MULTIPLE, MULTIPLE_TRUE);
                paramMap.put(TYPE_DETAIL, CATEGORY_ADMINORG.equals(category) ? ParamTypeEnum.MUL_ADMINORG.getValue() : ParamTypeEnum.MUL_DYNAMICOBJECT.getValue());
            }
        } else {
            paramMap.put(TYPE, ParamTypeEnum.STRING.getValue());
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.STRING.getValue());
        }
        String typeDetail = (String)paramMap.get(TYPE_DETAIL);
        String typeKey = StringUtils.isNotEmpty((CharSequence)((CharSequence)paramMap.get(ENTITY_NUMBER))) ? typeDetail + "_" + (String)paramMap.get(ENTITY_NUMBER) : typeDetail;
        List<Map<String, String>> typeList = paramMap2.getOrDefault(typeKey, Lists.newArrayListWithCapacity((int)100));
        typeList.add(paramMap);
        paramMap2.put(typeKey, typeList);
        if (ParamTypeEnum.ENUM.getValue().equals(typeDetail) || ParamTypeEnum.DYNAMICOBJECT.getValue().equals(typeDetail) || ParamTypeEnum.ADMINORG.getValue().equals(typeDetail)) {
            typeKey = "mul_" + typeKey;
            List<Map<String, String>> typeList2 = paramMap2.getOrDefault(typeKey, Lists.newArrayListWithCapacity((int)100));
            typeList2.add(paramMap);
            paramMap2.put(typeKey, typeList2);
        }
    }

    private static void setEnumList(DynamicProperty property, Map<String, String> paramMap) {
        String controlType = ((FieldProp)property).getFilterControlType();
        if ("enum".equals(controlType)) {
            List mapItemList = ((ComboProp)property).getComboItems();
            paramMap.put(ENUM_LIST, SerializationUtils.toJsonString((Object)mapItemList));
            paramMap.put(TYPE_DETAIL, ParamTypeEnum.ENUM.getValue());
            if (property instanceof MulComboProp) {
                paramMap.put(PARAM_MULTIPLE, MULTIPLE_TRUE);
                paramMap.put(TYPE_DETAIL, ParamTypeEnum.MUL_ENUM.getValue());
            }
        }
    }

    public static Map<String, String> getAdminOrgParam(Long sceneId) {
        HashMap orgParamMap = Maps.newHashMapWithExpectedSize((int)8);
        List<Map<String, String>> inputParamList = ParamsUtil.getInputParamData(sceneId);
        ParamsUtil.getAdminOrgParam(inputParamList, orgParamMap);
        return orgParamMap;
    }

    private static void getAdminOrgParam(List<Map<String, String>> inputParamList, Map<String, String> orgParamMap) {
        for (Map<String, String> inputParam : inputParamList) {
            if (ParamTypeEnum.ADMINORG.getValue().equals(inputParam.get(TYPE_DETAIL))) {
                orgParamMap.put(inputParam.get(NUMBER), inputParam.get(NAME));
                continue;
            }
            if (!inputParam.containsKey(CHILDREN)) continue;
            List childrenMap = SerializationUtils.fromJsonStringToList((String)inputParam.get(CHILDREN), Map.class);
            ParamsUtil.getAdminOrgParam(childrenMap, orgParamMap);
        }
    }
}

