/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.util.CollectionUtils;

public class QueryEntityUtil {
    private static final IAppCache iAppCache = AppCache.get((String)"bos-ext-hr");

    public static List<String> getFieldNames(String baseEntityId) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId);
        return QueryEntityUtil.getFieldNames(queryEntityType, false);
    }

    public static List<String> getFieldNames(QueryEntityType queryEntityType, boolean isShowId) {
        List joinEntitys = queryEntityType.getJoinEntitys();
        Map joinEntityMap = joinEntitys.stream().collect(Collectors.toMap(JoinEntity::getEntityName, Function.identity(), (x, y) -> y));
        ArrayList fieldNames = Lists.newArrayListWithExpectedSize((int)queryEntityType.getSelectFields().size());
        for (QuerySelectField querySelectField : queryEntityType.getSelectFields()) {
            String[] aliass = querySelectField.getAlias().split("\\.", 2);
            JoinEntity joinEntity = (JoinEntity)joinEntityMap.get(aliass[0]);
            if (null != joinEntity) {
                if (isShowId && !fieldNames.contains(joinEntity.getFKProperty() + ".id")) {
                    fieldNames.add(joinEntity.getFKProperty() + ".id");
                }
                if (!"name".equalsIgnoreCase(aliass[1]) && !"number".equalsIgnoreCase(aliass[1])) continue;
                fieldNames.add(querySelectField.getAlias().replaceFirst(aliass[0], joinEntity.getFKProperty()));
                continue;
            }
            fieldNames.add(querySelectField.getAlias());
        }
        return fieldNames;
    }

    public static List<QuerySelectField> getDisplayFieldNames(String baseEntityId) {
        List displayFieldNamesCache;
        String cache = (String)iAppCache.get("displayFieldNames_" + baseEntityId, String.class);
        if (StringUtils.isNotEmpty((CharSequence)cache) && CollectionUtils.isNotEmpty((Collection)(displayFieldNamesCache = SerializationUtils.fromJsonStringToList((String)cache, QuerySelectField.class)))) {
            return displayFieldNamesCache;
        }
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)baseEntityId);
        ArrayList fieldNames = Lists.newArrayListWithExpectedSize((int)queryEntityType.getSelectFields().size());
        Map<String, JoinEntity> joinEntityMap = queryEntityType.getJoinEntitys().stream().collect(Collectors.toMap(JoinEntity::getEntityName, Function.identity(), (x, y) -> y));
        QueryEntityUtil.handerFieldNames(queryEntityType.getSelectFields(), fieldNames, joinEntityMap, queryEntityType.getEntityName());
        fieldNames.sort(Comparator.comparing(QuerySelectField::getAlias));
        iAppCache.put("displayFieldNames_" + baseEntityId, (Object)SerializationUtils.toJsonString((Object)fieldNames));
        return fieldNames;
    }

    public static List<QuerySelectField> getDisplayFieldNames4Designer(String baseEntityId) {
        List displayFieldNamesCache;
        String cache = (String)iAppCache.get("displayFieldNames_" + baseEntityId, String.class);
        if (StringUtils.isNotEmpty((CharSequence)cache) && CollectionUtils.isNotEmpty((Collection)(displayFieldNamesCache = SerializationUtils.fromJsonStringToList((String)cache, QuerySelectField.class)))) {
            return displayFieldNamesCache;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)baseEntityId, (MetaCategory)MetaCategory.Entity);
        QueryEntity queryEntity = (QueryEntity)entityMetadata.getItems().get(0);
        ArrayList fieldNames = Lists.newArrayListWithExpectedSize((int)queryEntity.getSelectFields().size());
        Map<String, JoinEntity> joinEntityMap = queryEntity.getJoinEntitys().stream().collect(Collectors.toMap(JoinEntity::getEntityName, Function.identity(), (x, y) -> y));
        QueryEntityUtil.handerFieldNames(queryEntity.getSelectFields(), fieldNames, joinEntityMap, queryEntity.getEntityName());
        fieldNames.sort(Comparator.comparing(QuerySelectField::getAlias));
        iAppCache.put("displayFieldNames_" + baseEntityId, (Object)SerializationUtils.toJsonString((Object)fieldNames));
        return fieldNames;
    }

    private static void handerFieldNames(List<QuerySelectField> selectFields, List<QuerySelectField> fieldNames, Map<String, JoinEntity> joinEntityMap, String entityName) {
        for (QuerySelectField querySelectField : selectFields) {
            DynamicProperty dynamicProperty;
            String alias = querySelectField.getAlias();
            if ("name".equalsIgnoreCase(alias) || "number".equalsIgnoreCase(alias)) {
                QuerySelectField field = new QuerySelectField();
                field.setAlias(querySelectField.getAlias());
                field.setDisplayName(querySelectField.getDisplayName());
                fieldNames.add(field);
                continue;
            }
            String[] aliass = querySelectField.getAlias().split("\\.", 2);
            JoinEntity joinEntity = joinEntityMap.get(aliass[0]);
            if (null == joinEntity || !"name".equalsIgnoreCase(aliass[1]) && !"number".equalsIgnoreCase(aliass[1]) || (dynamicProperty = EntityMetadataCache.getDataEntityType((String)entityName).getProperty(joinEntity.getFKProperty())) == null) continue;
            String displayName = null == dynamicProperty.getDisplayName() ? dynamicProperty.getName() : dynamicProperty.getDisplayName().getLocaleValue();
            QuerySelectField field = new QuerySelectField();
            field.setAlias(querySelectField.getAlias().replaceFirst(aliass[0], joinEntity.getFKProperty()));
            field.setDisplayName(querySelectField.getDisplayName().replaceFirst(joinEntity.getDisplayName(), displayName));
            fieldNames.add(field);
        }
    }

    public static TreeNode buildBillTreeNodes(EntityMetadata entityMetadata, boolean isShowId, String arg) {
        return QueryEntityUtil.buildBillTreeNodes(entityMetadata, isShowId);
    }

    public static TreeNode buildBillTreeNodes(EntityMetadata entityMetadata, boolean isShowId) {
        QueryEntity queryEntity = (QueryEntity)entityMetadata.getRootEntity();
        List<QueryEntityTreeNode> queryEntityList = QueryEntityUtil.getQueryEntityConditionRelation(queryEntity);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getKey());
        QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(mainEntityType, queryEntityList);
        parameter.setIncludePKField(true);
        return QueryEntityUtil.buildBillTreeNodes(parameter, isShowId);
    }

    private static TreeNode buildBillTreeNodes(QueryEntityTreeBuildParameter parameter, boolean isShowId) {
        QueryEntityType queryEntityType = (QueryEntityType)parameter.getMainType();
        List<String> fieldNames = QueryEntityUtil.getFieldNames(queryEntityType, isShowId);
        TreeNode billNode = new TreeNode("", queryEntityType.getName(), queryEntityType.getDisplayName().toString());
        billNode.setIsOpened(true);
        TreeNode entityNode = new TreeNode(queryEntityType.getName(), "_headNode_", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"QueryEntityUtil_0", (String)"bos-ext-hr", (Object[])new Object[0]));
        entityNode.setIsOpened(false);
        if (isShowId) {
            TreeNode idNode = new TreeNode(queryEntityType.getName(), "id", ResManager.loadKDString((String)"\u5185\u7801(id)", (String)"QueryEntityUtil_1", (String)"bos-ext-hr", (Object[])new Object[0]));
            entityNode.addChild(idNode);
        }
        List<TreeNode> refNodes = QueryEntityUtil.buildBDFldRefPropNodes((MainEntityType)queryEntityType, isShowId, null, null, billNode, null, parameter.isDynamicText(), fieldNames);
        entityNode.addChildren(refNodes);
        billNode.addChild(entityNode);
        return billNode;
    }

    private static List<TreeNode> buildBDFldRefPropNodes(MainEntityType bdType, boolean isShowId, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, List fieldNames) {
        ArrayList refNodes = Lists.newArrayListWithExpectedSize((int)16);
        for (IDataEntityProperty property : bdType.getFields().values()) {
            if ((!(bdType instanceof QueryEntityType) ? !fieldNames.contains(prefix + "." + property.getName()) : (property instanceof BasedataProp ? !fieldNames.contains(property.getName()) && !fieldNames.contains(property.getName() + ".name") && !fieldNames.contains(property.getName() + ".number") : !fieldNames.contains(property.getName()))) || !(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || StringUtils.isBlank((CharSequence)property.getAlias()) || property instanceof EntryProp || property instanceof MulBasedataProp) continue;
            TreeNode fldNode = QueryEntityUtil.buildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            if (property instanceof BasedataProp) {
                List<TreeNode> refNodes2;
                String prefix2;
                BasedataProp bdProp2;
                MainEntityType bdType2;
                if (fldNode == null) {
                    fldNode = QueryEntityUtil.buildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
                }
                if ((bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType()) == null) continue;
                String string = prefix2 = StringUtils.isBlank((CharSequence)prefix) ? property.getName() : prefix + "." + property.getName();
                if (isShowId) {
                    TreeNode idNode = new TreeNode(bdProp2.getName(), bdProp2.getName() + ".id", String.format(ResManager.loadKDString((String)"%s.\u5185\u7801(id)", (String)"QueryEntityUtil_2", (String)"bos-ext-hr", (Object[])new Object[0]), bdProp2.getDisplayName().getLocaleValue()));
                    fldNode.addChild(idNode);
                }
                if ((refNodes2 = QueryEntityUtil.buildBDFldRefPropNodes(bdType2, isShowId, matchedProperty, matchedClassType, fldNode, prefix2, isDynamicText, fieldNames)).size() > 0) {
                    fldNode.addChildren(refNodes2);
                }
                refNodes.add(fldNode);
                continue;
            }
            if (fldNode == null) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = QueryEntityUtil.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fldNodeName;
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String string = fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            if (fldNodeId.contains(".")) {
                String parentNodeText = parentNode.getText();
                String parentNodeName = parentNodeText.substring(0, parentNodeText.indexOf("("));
                fldNodeName = parentNodeName + "." + fldNodeName + "(" + prop.getName() + ")";
            } else {
                fldNodeName = fldNodeName + "(" + prop.getName() + ")";
            }
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp) {
                if (!((BasedataProp)matchedProperty).isFromSampleMaster(fldProperty)) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    private static List<QueryEntityTreeNode> getQueryEntityConditionRelation(QueryEntity queryEntity) {
        QueryEntityTreeNode mainEntityNode = new QueryEntityTreeNode();
        mainEntityNode.setEntityAlias(queryEntity.getEntityAlias());
        mainEntityNode.setEntityNumber(queryEntity.getEntityName());
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        list.add(mainEntityNode);
        List joinEntityList = queryEntity.getJoinEntitys();
        for (JoinEntity joinEntity : joinEntityList) {
            QueryEntityUtil.addChildQueryEntityToParentQuery(joinEntity, mainEntityNode);
        }
        return list;
    }

    private static void addChildQueryEntityToParentQuery(JoinEntity joinEntity, QueryEntityTreeNode parentNode) {
        QueryEntityTreeNode childNode = new QueryEntityTreeNode();
        childNode.setEntityAlias(joinEntity.getAlias());
        childNode.setEntityNumber(joinEntity.getEntityName());
        childNode.setParent(parentNode);
        if (parentNode.getChildList() == null) {
            ArrayList childList = Lists.newArrayListWithExpectedSize((int)16);
            parentNode.setChildList((List)childList);
        }
        parentNode.getChildList().add(childNode);
    }
}

