/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.ext.hr.web.dto.LoginConfigDTO;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.ext.hr.web.filter.HtmlFacadeFilter;
import kd.bos.ext.hr.web.filter.HtmlFitlerService;
import kd.bos.ext.hr.web.util.HrFilterUtil;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.ext.hr.web.vo.HrUserSessionVO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import org.eclipse.jetty.server.Request;

public abstract class AbstractHtmlFilter
implements Filter,
HtmlFitlerService {
    private static final Log LOGGER = LogFactory.getLog(AbstractHtmlFilter.class);
    private static final String ERROR_TIP_ILLEGALPARAM = "Illegal link parameter";
    private static final String ERROR_TIP_EMPTYACCOUNTID = "AccountId is necessary";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String userId;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String formId = HrFilterUtil.xssEncode(request.getParameter(HtmlFacadeFilter.getRequestMeta().formKey));
        LOGGER.info("Got formId: {}.", (Object)formId);
        if (StringUtils.isNotEmpty((String)formId) && StringUtils.isNotEmpty((String)(userId = request.getHeader("userId")))) {
            ((Request)request).getMetaData().getFields().remove("userId");
        }
        String accountId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"accountId");
        LOGGER.info("Got accountId: {}.", (Object)accountId);
        if (StringUtils.isEmpty((String)accountId)) {
            response.getWriter().write(ERROR_TIP_EMPTYACCOUNTID);
            response.getWriter().flush();
            return;
        }
        String bizUserId = HrFilterUtil.xssEncode(request.getParameter("bizUserId"));
        LOGGER.info("Got bizUserId: {}.", (Object)bizUserId);
        if (StringUtils.isEmpty((String)bizUserId)) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return;
        }
        this.createGuestRequestContext(request, null);
        String loginConfigNumber = HrFilterUtil.xssEncode(request.getParameter("loginConfigNumber"));
        LOGGER.info("Got loginConfigNumber: {}.", (Object)loginConfigNumber);
        LoginConfigDTO loginConfigDTO = (LoginConfigDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"getHrLoginConfig", (Object[])new Object[]{loginConfigNumber});
        LOGGER.info("Got loginConfigDTO: {}.", (Object)loginConfigDTO);
        if (loginConfigDTO == null) {
            response.getWriter().write("loginConfig not found,number=" + URLEncoder.encode(loginConfigNumber, StandardCharsets.UTF_8.toString()));
            response.getWriter().flush();
            return;
        }
        RequestContext.set(null);
        String url2 = this.getLoginPageUrl(request, loginConfigDTO);
        LOGGER.info("Got loginPageUrl: {}.", (Object)url2);
        String url3 = "";
        if (!this.isUserIdValid(request, response)) {
            LOGGER.info("User id is invalid.");
            return;
        }
        if (!this.isNeedResetValid(request, response)) {
            LOGGER.info("Need reset is invalid.");
            return;
        }
        if (formId.equals(this.getRequestCommonLoginFormId())) {
            String bizFormId = HrFilterUtil.xssEncode(request.getParameter("bizFormId"));
            if (StringUtils.isEmpty((String)bizFormId)) {
                response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
                response.getWriter().flush();
                return;
            }
            if (this.isLongUrlTimeout(request, response, accountId, loginConfigNumber)) {
                return;
            }
            Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
            LOGGER.info("Got hr user cookie: {}.", (Object)(null == hrUserCookie ? 1 : 0));
            if (hrUserCookie != null) {
                String cookieValue = hrUserCookie.getValue();
                HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, cookieValue);
                LOGGER.info("Got session vo:{} from cookie: {}.", (Object)(null == hrUserSessionVO ? 1 : 0), (Object)(null == cookieValue ? 1 : 0));
                if (hrUserSessionVO == null) {
                    HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                    if (HtmlFacadeFilter.getRequestMeta().isInterflow) {
                        LOGGER.info("Redirect loginPage with step 1.");
                        response.sendRedirect(url2);
                        return;
                    }
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                if (!(hrUserSessionVO.getAccountId().equals(accountId) && hrUserSessionVO.getLoginConfigNumber().equals(loginConfigNumber) && hrUserSessionVO.getBizUserId().equals(bizUserId))) {
                    HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                    if (HtmlFacadeFilter.getRequestMeta().isInterflow) {
                        LOGGER.info("Redirect loginPage with step 2.");
                        response.sendRedirect(url2);
                        return;
                    }
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                url3 = this.getBizFormPageUrl(request, accountId, loginConfigNumber, bizFormId, bizUserId);
                LOGGER.info("Redirect bizPage: {}.", (Object)url3);
                response.sendRedirect(url3);
                return;
            }
            if (HtmlFacadeFilter.getRequestMeta().isInterflow) {
                if (this.getClientType().equals("web")) {
                    HrFilterUtil.addClientCookie(request, response, "mobiletoindex", url2);
                }
                LOGGER.info("Redirect loginPage with step 3.");
                response.sendRedirect(url2);
                return;
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (this.isLongUrlTimeout(request, response, accountId, loginConfigNumber)) {
            return;
        }
        Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
        if (hrUserCookie != null) {
            String cookieValue = hrUserCookie.getValue();
            HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, hrUserCookie.getValue());
            LOGGER.info("Got session vo2:{} from cookie: {}.", (Object)(null == hrUserSessionVO ? 1 : 0), (Object)(null == cookieValue ? 1 : 0));
            if (hrUserSessionVO == null) {
                HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                LOGGER.info("Redirect loginPage with step 4.");
                response.sendRedirect(url2);
                return;
            }
            if (!(hrUserSessionVO.getAccountId().equals(accountId) && hrUserSessionVO.getLoginConfigNumber().equals(loginConfigNumber) && hrUserSessionVO.getBizUserId().equals(bizUserId))) {
                HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                LOGGER.info("Redirect loginPage with step 5.");
                response.sendRedirect(url2);
                return;
            }
            url3 = this.getBizFormPageUrl(request, accountId, loginConfigNumber, formId, bizUserId);
            if (HtmlFacadeFilter.getRequestMeta().isInterflow) {
                if (this.getClientType().equals("web")) {
                    HrFilterUtil.addClientCookie(request, response, "mobiletoindex", url3);
                }
                LOGGER.info("Redirect bizPage2: {}.", (Object)url3);
                response.sendRedirect(url3);
                return;
            }
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            LOGGER.info("Redirect loginPage with step 6.");
            response.sendRedirect(url2);
        }
    }

    private boolean isLongUrlTimeout(HttpServletRequest request, HttpServletResponse response, String accountId, String loginConfigNumber) throws IOException {
        if (this.isLongUrlTimeoutEnable(request)) {
            String expiryUrl = this.handleLongUrlTimeout(request, response, loginConfigNumber, accountId);
            LOGGER.info("Got expiryUrl: {}.", (Object)expiryUrl);
            if (StringUtils.isNotEmpty((String)expiryUrl)) {
                response.sendRedirect(expiryUrl);
                return true;
            }
        }
        return false;
    }

    private String getRequestCommonLoginFormId() {
        return HtmlFacadeFilter.getRequestMeta().commonLoginFormId;
    }

    private String handleLongUrlTimeout(HttpServletRequest request, HttpServletResponse response, String loginConfigNumber, String accountId) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(HrFilterUtil.getDomainContextUrl(request)).append(this.getHtmlPath()).append("?").append(this.getFormUriParamByGuest(accountId, this.getUrlExpiryFormId())).append("&").append("timeout=true");
        String safeuriExpiryUrl = sb.toString();
        SafeUrlDTO safeUrlDTO = this.getSafeUrlDTO(request, response, loginConfigNumber, accountId);
        Date expiryTime = safeUrlDTO.getExpiryTime();
        if (expiryTime == null) {
            return safeuriExpiryUrl;
        }
        if (safeUrlDTO.getExpiryTime().before(new Date())) {
            return safeuriExpiryUrl;
        }
        return null;
    }

    private String getBizFormPageUrl(HttpServletRequest request, String accountId, String loginConfigNumber, String formId, String bizUserId) {
        String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizUserId=" + bizUserId;
        String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        return HrFilterUtil.getDomainContextUrl(request) + this.getHtmlPath() + "?" + this.getFormUriParamByGuest(accountId, formId) + queryParam;
    }

    private boolean isNeedResetValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String needReset = LoginUtils.getParamerter((HttpServletRequest)request, (String)"needReset");
        if (StringUtils.isEmpty((String)needReset)) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        if (!needReset.equals("true")) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        return true;
    }

    private boolean isUserIdValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String userId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"userId");
        if (StringUtils.isEmpty((String)userId)) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        if (!userId.equals("Guest")) {
            response.getWriter().write(ERROR_TIP_ILLEGALPARAM);
            response.getWriter().flush();
            return false;
        }
        return true;
    }

    private SafeUrlDTO getSafeUrlDTO(HttpServletRequest request, HttpServletResponse response, String loginConfigNumber, String accountId) {
        if (RequestContext.get() == null) {
            this.createGuestRequestContext(request, response);
        }
        String bizUserId = HrFilterUtil.xssEncode(request.getParameter("bizUserId"));
        String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
        String htmlUriParam = HrFilterUtil.getHtmlUriParam(accountId, loginConfigNumber, bizUserId, bizCustomParam);
        LOGGER.info("Got html uri param: {}.", (Object)htmlUriParam);
        SafeUrlDTO safeUrlDTO = (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{htmlUriParam});
        LOGGER.info("Got safeUrlDTO: {}.", (Object)safeUrlDTO);
        if (StringUtils.isNotEmpty((String)safeUrlDTO.getOriginUrl())) {
            return safeUrlDTO;
        }
        String dbMobileHtmlUrl = HrGuestUrlUtil.getMobileHtmlUrl(accountId, loginConfigNumber, bizUserId, bizCustomParam);
        LOGGER.info("Got dbMobileHtmlUrl: {}.", (Object)dbMobileHtmlUrl);
        safeUrlDTO = (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{dbMobileHtmlUrl});
        LOGGER.info("Got dbMobileHtmlUrl safeUrlDTO: {}.", (Object)safeUrlDTO);
        return safeUrlDTO;
    }

    private boolean isLongUrlTimeoutEnable(HttpServletRequest request) {
        String longUrlTimeoutEnable = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.guest.longurltimeout.enable", (String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
        if (StringUtils.isEmpty((String)longUrlTimeoutEnable)) {
            longUrlTimeoutEnable = "true";
        }
        LOGGER.info("Got long url timeout enable: {}.", (Object)longUrlTimeoutEnable);
        return Boolean.parseBoolean(longUrlTimeoutEnable);
    }

    private String getLoginPageUrl(HttpServletRequest request, LoginConfigDTO loginConfigDTO) {
        String formId = this.getCommonLoginFormId();
        String loginConfigNumber = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("loginConfigNumber")));
        String bizUserId = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("bizUserId")));
        String redirectFormId = formId.equals("hbss_commonloginpc") ? loginConfigDTO.getPcRedirectFormId() : loginConfigDTO.getRedirectFormId();
        String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizFormId=" + redirectFormId + "&bizUserId=" + bizUserId;
        String bizCustomParam = HrFilterUtil.xssEncode(request.getParameter("bizCustomParam"));
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        Account currentCenter = HrFilterUtil.getCurrentAccount(request);
        String langCode = loginConfigDTO.getLangCode();
        String language = HrFilterUtil.xssEncode(request.getParameter("language"));
        if (StringUtils.isNotEmpty((String)language)) {
            langCode = LoginLangUtils.getLoginLanguage((HttpServletRequest)request).toString();
        }
        return HrFilterUtil.getDomainContextUrl(request) + this.getHtmlPath() + "?" + this.getFormUriParamByGuest(currentCenter.getAccountId(), formId) + queryParam + "&language=" + langCode;
    }

    private void createGuestRequestContext(HttpServletRequest request, HttpServletResponse response) {
        String globalSessionId = HrFilterUtil.getKDGlobalSessionId(request);
        LOGGER.info("Got globalSessionId: {}.", (Object)(null == globalSessionId ? 1 : 0));
        if (StringUtils.isEmpty((String)globalSessionId)) {
            Account currentCenter = HrFilterUtil.getCurrentAccount(request);
            LoginUtils.createGuestRequestContext((HttpServletRequest)request, (Account)currentCenter);
            globalSessionId = RequestContext.get().getGlobalSessionId();
            if (RequestContext.get() == null) {
                HrFilterUtil.createGuestRequestContext(request, globalSessionId);
            }
        } else {
            HrFilterUtil.createGuestRequestContext(request, globalSessionId);
        }
        RequestContext.get().setTraceId(TraceIdUtil.createTraceIdString());
    }

    private String getFormUriParamByGuest(String accountId, String formId) {
        StringBuilder sb = new StringBuilder();
        sb.append("userId=Guest&needReset=true").append("&accountId=").append(accountId).append("&kdcdc=").append(accountId).append("&").append(this.getFormKey()).append("=").append(formId);
        return sb.toString();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

